/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Spell Handler Module
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
// 
// -- UPDATES --
// July 13th 2006:
// -Fixed manacost bug
/////////////////////////////////////////////////////
// We are using the Basic spells "Core"
define USE_CORE_BSPELLS;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// Use the particle effects core
ifndef USE_SUBCORE_PARTICLEFUNCS;
	include <NHASC_partfuncs.wdl>;
endif;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_LOADSPELLS;
	include <NHASC_loadspells.wdl>;
endif;
/////////////////////////////////////////////////////
// Load the spellfunctions sub-core
ifndef USE_SUBCORE_SPELLFUNCS;
	include <NHASC_spellfuncs.wdl>;
endif;
/////////////////////////////////////////////////////
// Function pointer
function* NHAC_CSPELL_FUNCPTR;
/////////////////////////////////////////////////////
// Basic function to cast spells
function NHAC_CSPELL_CAST(spell)
{
	// Set the "my" pointer to the player, if it's null
	if(!my) {my = player;}
	// If the player is also null, return
	if(!my) {return(-1);}
	
	// If the spells aren't loaded, load them now
	if(!NHAC_CSPELLS_LOADED) {NHASC_CSPELLS_LOAD();while(!NHAC_CSPELLS_LOADED){wait(1);}}
	
	// If we got a bad spell number
	if(spell >= NHAC_MAX_SPELLS) {return(-2);}
	
	// Get a pointer to the spell function to use
	NHAC_CSPELL_FUNCPTR = ptr_for_handle(NHASC_CSPELL_FUNC[spell]);
	
	// If the pointer is null, return
	if(!NHAC_CSPELL_FUNCPTR) {return(-3);}
	
	// Mana check
	if(NHASC_CSPELL_MANACOST[spell] <= my.mana)
	{
		// Decrease mana
		my.mana -= NHASC_CSPELL_MANACOST[spell];
		
		// Make a little pause between casts
		my.cr_cdown = my.cast_rate;
		
		// Call the spell function
		NHAC_CSPELL_FUNCPTR(spell);
	}
	else
	{
		return(0);
	}
	
	// Successfully done
	return(1);
}
/////////////////////////////////////////////////////
// Function to cast a spell (player)
function NHAC_CSPELL_PLAYERCAST()
{
	// If the game is paused - return
	if(freeze_mode) {return;}
	
	// If the player doesn't exist
	if(!player) {return;}
	
	// Or if an item is  attached to the mouse
	if(NHAC_MOUSEITEM) {return;}
	
	// Or... If we haven't got the current spell yet
	if(!NHAC_CSPELL_OWNED[NHAC_CURSPELL]) {return;}
	
	// Set the 'my' pointer to the player
	my = player;
	
	// Needs a bigger pause...
	if(my.cr_cdown > 0) {return;}
		
	// Make a little pause between casts
	my.cr_cdown = my.cast_rate;
	
	// Don't move!
	NHAC_PLAYER_STANDSTILL = true;
	
	// Ready for animating
	my.anim_state = anim_state_special;
	
	//////////////////////////////////////////////////
	// Turn the player again the target
	// First we get the mouse coordinates (2D)
	temp.x = mouse_pos.x;
	temp.y = mouse_pos.y;
	temp.z = 0;
	
	// Set "target" to the same coordinates
	vec_set(target,temp);
	
	// Add some depth/dist. from screen, to "target"
	target.z = 10000;
	
	// Convert from 2D screen coordinates, to 3D world coordinates
	vec_for_screen(temp,camera);
	vec_for_screen(target,camera);
	
	// Trace from temp (mouse pos.) to target
	c_trace(temp,target,ignore_passable + ignore_passents + ignore_you);
	
	// Turn me against the target
	vec_sub(target,my.x);
	vec_to_angle(my.pan,target);
	my.tilt = 0;	// But only the pan value
	//////////////////////////////////////////////////
	
	// Animate attack
	my.skill46 = 0;
	while(my.skill46 < 100)
	{
		ent_animate(my,"attack",my.skill46,0);
		my.skill46 += my.anim_speed_attack * time;
		wait(1);
	}
	
	// Cast spell
	if(NHAC_CSPELL_CAST(NHAC_CURSPELL) == 0)
	{
		NHA_CORE_SHOWMSG(NHAC_CSPELL_NEEDMANA_STR,10);
	}
	
	// Wait 0.5 seconds
	sleep(0.5);
	
	// Player can walk
	NHAC_PLAYER_STANDSTILL = false;
	
	// Default animating
	my.anim_state = anim_state_stand;
}

on_mouse_right = NHAC_CSPELL_PLAYERCAST;
/////////////////////////////////////////////////////
function NHAC_CSPELL_RESET_ALL()
{
	// local var
	var i = NHAC_MAX_SPELLS;
	
	// 'Take' all the spells from the player
	while(i > 0)
	{
		i -= 1;
		NHAC_CSPELL_OWNED[i] = 0;
	}
	
	// No spells selected
	NHAC_CURSPELL = 0;
	
	// Don't show anything in the spell panel
	str_cpy(NHAC_HUDSPELL_STR,"");
}
/////////////////////////////////////////////////////
// Gets the spell, from a spell name string handle
function spellFromName(spell)
{
	// local var
	var i = NHAC_MAX_SPELLS;
	
	// While there are spells we haven't checked
	while(i > 0)
	{
		// Decrease 'i'
		i -= 1;
		
		// Get a string containing the name of the spell with number 'i'
		str_cpy(NHASC_SCSPELL_TMPSTR01,ptr_for_handle(NHASC_CSPELL_NAME[i]));
		
		// If it's the spell we were looking for
		if(str_cmpi(NHASC_SCSPELL_TMPSTR01,spell))
		{
			// Return the number of the spell
			return(i);
		}
	}
	
	// We haven't found it, return '0'.
	// Note: '0' is also a spell number
	return(0);
}
/////////////////////////////////////////////////////