/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Basic enemy AI script
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
//
// -- UPDATES --
//	July 11th 2006:
// Upgraded from A6.31.4 to A6.40.5
// 	- Changed "remove me;" to "ent_remove(me);"
// 
// July 12th 2006:
// -Enemies drops items, if NHAC_ENEMY_ITEMDROP is true
// 
// July 13th 2006:
// -Enemies got 'infinite' mana
/////////////////////////////////////////////////////
// We are using the enemy AI "Core"
define USE_CORE_ENEMYAI;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// And the animation "sub-core"
ifndef USE_SUBCORE_ANIMATION;
	include <NHASC_animation.wdl>;
endif;
/////////////////////////////////////////////////////
// Shows death animation and fades away
function NHAC_enemyAI_die()
{
	// Do not animate me anymore
	my.anim_state = anim_stop;
	
	//Don't block
	my.passable = true;
	
	// If we are lucky... (Or rather if was aren't unlucky :P)
	// And if we are allowed to do it
	if(random(1) > 0.1 && NHAC_ENEMY_ITEMDROP)
	{
		// Drop an item for us xD
		NHAC_CORE_ITEM_DROP(my,int(random(NHAC_CITEMS_TOTAL - 0.1)));
	}
	
	// Play death animation
	my.skill46 = 0;
	while(my.skill46 < 99)
	{
		ent_animate(my,"death",my.skill46,0);
		my.skill46 += my.anim_speed_death * time;
		wait(1);
	}
	
	// If AIs should fade away when they're death
	if(NHAC_AI_FADEAWAY)
	{
		// Wait a little before fading
		sleep(NHAC_AI_FADEDELAY);
		
		// Fade me away...
		my.alpha = 100;
		my.transparent = true;
		while(my.alpha > 0)
		{
			my.alpha -= NHAC_AI_FADESPEED * time;
			wait(1);
		}
		
		// Remove me
		wait(1);
		ent_remove(me);
	}
}
/////////////////////////////////////////////////////
// Check whether we have a chance to reach the enemy
function NHAC_enemyAI_check()
{
	// If not assigned
	if(my.enemy == 0) {return;}
	
	// If you doesn't exist
	you = ptr_for_handle(my.enemy);
	if(!you) {my.enemy = 0;return;}
	
	// If you're death
	if(you.health <= 0) {my.enemy = 0;return;}
	
	// If we're on the same team
	if(you.team == my.team) {my.enemy = 0;return;}
	
	// If you should not be a target
	if(you.isAITarget == false) {my.enemy = 0;return;}
	
	// If you're too far away
	if(vec_dist(my.x,you.x) > my.range * 1.5) {my.enemy = 0;return;}
}
/////////////////////////////////////////////////////
// Function to scan for enemies
function NHAC_enemyAI_scan()
{
	// Tell other entities, that we are just searching (not e.g. attacking)
	my.scan_mode = SCAN_SEARCH;
	
	// Setup the "area" to scan within
	temp.pan = my.scan_circle_pan;
	temp.tilt = my.scan_circle_tilt;
	temp.z = my.range;
	
	// Scan for enemies
	scan_entity(my.x,temp);
}
/////////////////////////////////////////////////////
// Uses scan_entity to attack enemies
function NHAC_enemyAI_scanAttack()
{
	// Tell other entities, that we attacking
	my.scan_mode = SCAN_ATTACK;
	
	// Setup the "area" to scan within
	temp.pan = 90;
	temp.tilt = 120;
	temp.z = 60;
	
	// Scan for enemies
	scan_entity(my.x,temp);
}
/////////////////////////////////////////////////////
// Movement function
function NHAC_enemyAI_movement()
{
	// We only use the X and Y position of the target
	// Z could cause stupid-looking "errors"
	my.ent_target_z = 0;
	
	// If we got a walkpoint
	if(vec_dist(my.ent_target,nullvector) > 1)
	{
		// If we haven't yet reached our target
		if(vec_dist(vector(my.ent_target_x,my.ent_target_y,my.z),my.x) > 40)
		{
			// Turn against the target
			vec_set(temp,my.ent_target);
			vec_sub(temp,my.x);
			vec_to_angle(my.pan,temp);
			
			// Don't bow
			my.tilt = 0;
			
			// Set our movement speed
			my.curSpeed = my.speed * (1 + my.run);
			
			// Move us
			c_move(my,vector(my.curSpeed * time,0,0),nullvector,ignore_passable + ignore_you + glide);
			
			// Set the animation to walk or run
			my.anim_state = anim_state_walk + my.run;
		}
		else
		{
			// If I'm below 10 quants away from my target
			// Reset my target
			vec_set(my.ent_target,nullvector);
			
			// Use the stand animation
			my.anim_state = anim_state_stand;
		}
	}
}
/////////////////////////////////////////////////////
// Enemy AI event
function NHAC_enemyAI_event()
{
	// If we'd been touched by the mouse
	if(event_type == event_touch)
	{
		// Store a pointer to me
		NHAC_MOUSEENT_PTR = handle(my);
		
		// If we should be highlighted, do it!
		if(NHAC_MOUSEENT_HIGHLIGHT) {my.ambient = 100;}
	}
	
	// If the mouse has been moved away from me...
	if(event_type == event_release)
	{
		// Remove the pointer
		NHAC_MOUSEENT_PTR = 0;
		
		// Don't highlight me anymore
		if(NHAC_MOUSEENT_HIGHLIGHT) {my.ambient = 0;}
	}
	
	// Scanned by another ent
	if(event_type == event_scan)
	{
		// If you exist
		if(you)
		{
			// If you're just searching for an enemy, we are not on the same team,
			// you haven't found an enemy yet, and you are not the player
			if(you.scan_mode == SCAN_SEARCH
				&& you.team != my.team
				&& you.enemy == 0
				&& you != player)
			{
				// I'm your enemy
				you.enemy = handle(my);
			}
			
			// Are you attacking me!?
			if(you.scan_mode == SCAN_ATTACK
				&& you.team != my.team)
			{
				// If you're the player
				if(you == player)
				{
					// Subtract health - also note that defense can usefull ;)
					my.health -= max(random((you.damage + NHAC_ITM_GET_DMG()) * 5) - random(my.defense * 5),1);
				}
				else
				{
					// Subtract health - also note that defense can usefull ;)
					my.health -= max(random(you.damage * 5) - random(my.defense * 5),1);
				}
				
				// If I got killed by the player
				if(my.health <= 0 && you == player)
				{
					NHAC_plExp += max(1,(my.max_health * my.damage * my.defense)*0.5) / NHAC_plExpDivider;
				}
			}
		}
	}
	
	// Clicked by the mouse
	if(event_type == event_click)
	{
		// If the player exists
		if(player)
		{
			// Set 'you' to point at the player
			you = player;
			
			// As long as the left mouse button is pressed
			while(mouse_left)
			{
				// Set your enemy to me
				you.enemy = handle(my);
				wait(1);
			}
		}
	}
}
/////////////////////////////////////////////////////
// Main enemy AI function
function NHAC_enemy_CAI()
{
	// Animate me, plz...
	std_animpack();
	
	// If we should use this function
	if(NHAC_ENTS_TO_GROUND)
	{
		// Then do it :)
		// Don't flow
		attach_to_ground();
	}
	
	// Initialize skills (same values as player)
	if(!my.max_health) {my.max_health = 100;}
	if(!my.health) {my.health = my.max_health;}
	if(!my.max_mana) {my.max_mana = 1100;}
	if(!my.mana) {my.mana = my.max_mana;}
	if(!my.damage) {my.damage = 5;}
	if(!my.defense) {my.defense = 5;}
	if(!my.speed) {my.speed = 6;}
	if(!my.cast_rate) {my.cast_rate = 20;}
	if(!my.anim_speed_stand) {my.anim_speed_stand = 2;}
	if(!my.anim_speed_walk) {my.anim_speed_walk = 8;}
	if(!my.anim_speed_run) {my.anim_speed_run = 12;}
	if(!my.anim_speed_attack) {my.anim_speed_attack = 10;}
	if(!my.anim_speed_death) {my.anim_speed_death = 5;}
	if(!my.scan_circle_pan) {my.scan_circle_pan = 270;}
	if(!my.scan_circle_tilt) {my.scan_circle_tilt = 360;}
	if(!my.range) {my.range = 300;}
	
	// Enable enemies to attack me (only if not same team of cause)
	my.isAITarget = true;
	
	// Event and triggers
	my.enable_scan = true;
	my.enable_click = true;
	my.enable_release = true;
	my.enable_touch = true;
	my.event = NHAC_enemyAI_event;
	
	// The main loop
	// As long as the AI exists, and is alive
	while(my && (my.health > 0))
	{
		// Setting this variable to true pauses the AI
		if(NHAC_PAUSEAI) {wait(1);continue;}
		
		// Reset my.enemy if enemy is death, doesn't exist, is too far away, etc.
		NHAC_enemyAI_check();
		
		// Scan for enemies
		NHAC_enemyAI_scan();
		
		// Do the movement
		NHAC_enemyAI_movement();
		
		// If I got an enemy
		if(my.enemy != 0)
		{
			// Retrieve a handle to the enemy
			you = ptr_for_handle(my.enemy);
			
			// If te handle is valid
			if(you)
			{
				// Set the walkpoint to your pos
				vec_set(my.ent_target,you.x);
				
				// If you're more than 40% of my.range away
				if(vec_dist(you.x,my.x) > 0.40 * my.range)
				{
					// Maybe we should cast a spell..?
					if(random(1) >= 0.995 && my.isWizardAI && my.cr_cdown <= 0)
					{
						// Set animation state
						my.anim_state = anim_state_special;
						
						// Animate attack
						my.skill46 = 0;
						while(my.skill46 < 100)
						{
							ent_animate(my,"attack",my.skill46,0);
							my.skill46 += my.anim_speed_attack * time;
							
							// Turn towards target
							vec_set(temp,you.x);
							vec_sub(temp,my.x);
							vec_to_angle(my.pan,temp);
							my.tilt = 0;
							
							wait(1);
						}
						
						// Give us some mana
						my.mana = my.max_mana;
						
						// Which spell to cast?
						if(random(1) < 0.75)
						{
							// Cast primary spell
							NHAC_enemyAI_castSpell(my.AISpellPrimary);
						}
						else
						{
							// Cast secondary spell
							NHAC_enemyAI_castSpell(my.AISpellSecondary);
						}
						
						// Set cast rate/pause between spells
						my.cr_cdown = my.cast_rate;
						
						// Handle animation
						my.anim_state = anim_state_stand;
					}
				}
				else
				{
					// If you're close, and ready to attack
					if(vec_dist(you.x,my.x) < 60 && my.cr_cdown <= 0)
					{
						// Set animation state
						my.anim_state = anim_state_special;
						
						// Animate attack
						my.skill46 = 0;
						while(my.skill46 < 100)
						{
							ent_animate(my,"attack",my.skill46,0);
							my.skill46 += my.anim_speed_attack * time;
							
							// Turn towards target
							vec_set(temp,you.x);
							vec_sub(temp,my.x);
							vec_to_angle(my.pan,temp);
							my.tilt = 0;
							
							wait(1);
						}
						
						// Attack!!
						NHAC_enemyAI_scanAttack();
						
						// We also use cast rate here
						my.cr_cdown = my.cast_rate;
						
						// Handle animation
						my.anim_state = anim_state_stand;
					}
				}
			}
		}
		
		// Handle cast rate
		my.cr_cdown = max(0,my.cr_cdown - 1 * time);
		
		// Avoid endless loops
		wait(1);
	}
	
	// Unable triggers and event
	my.enable_scan = false;
	my.event = null;
	
	// We should not be highlighted now
	if(NHAC_MOUSEENT_HIGHLIGHT) {my.ambient = 0;}
	
	// Show death animation, fade away, etc.
	NHAC_enemyAI_die();
}
/////////////////////////////////////////////////////
// Basic enemy script
// Title: NHA Core RPG Enemy
// Desc: NHA RPG/Adv. temp 2.0 Core Enemy
// Desc: (C) 2006 by Claus N. (www.nighthawk.dk)
// Section: Skills and Flags:
// Use: max_health, health, max_mana, mana, damage, defense, speed, anim_speed_stand
// Use: anim_speed_walk, anim_speed_run, anim_speed_attack, anim_speed_death
// Use: cast_rate, team, scan_circle_pan, scan_circle_tilt, range, run, isWizardAI
action NHAC_enemyAI
{
	NHAC_enemy_CAI();
}
/////////////////////////////////////////////////////