/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Inventory Module
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
//
// -- UPDATES --
//	July 11th 2006:
// -Upgraded from A6.31.4 to A6.40.5
//		- Changed "remove me;" to "ent_remove(me);"
// 	- Changed values for item description panel size
//
//	July 12th:
//	-Minor fixes
// -Added function itemFromName
// -Fixed a bug in the "item-to-ground" system
// -Added function NHAC_CITEM_DROP(ent,item)
// 
// July 14th 2006:
// -The position and angle of dropped items are a little random
// 
// July 16th 2006:
// -Added function NHAC_INVENTORY_REDRAW
// -Fixed bug - Now inventory description disappear when closing inventory
// 
// July 17th 2006:
// -Added some sound
/////////////////////////////////////////////////////
// We are using the Inventory "Core"
define USE_CORE_INVENTORY;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// And the Items "sub-core"
ifndef USE_SUBCORE_INVITEMS;
	include <NHASC_invitems.wdl>;
endif;
/////////////////////////////////////////////////////
// And the Bitmap "sub-core"
ifndef USE_SUBCORE_BITMAP;
	include <NHASC_bitmap.wdl>;
endif;
/////////////////////////////////////////////////////
// Bmaps
bmap NHAC_CITEMDESC_BG = <NHAC_CITEMDESC_BG.tga>;
/////////////////////////////////////////////////////
// The item description panel
panel NHAC_CPAN_INVDESC
{
	bmap = NHAC_CITEMDESC_BG;
	flags = refresh;
	layer = 3;
}
/////////////////////////////////////////////////////
// The item description text
text NHAC_CTXT_INVDESC
{
	layer = 4;
	string = NHAC_CPAN_INVDESCSTR;
	font = NHAC_CITEM_DESCFNT;
}
/////////////////////////////////////////////////////
// The inventory panel
panel NHAC_CPAN_INVENT
{
	bmap = NHAC_CINVENT_BG;
	layer = 2;
	flags = refresh;
	// First row
	button = 17,116,NHAC_CINV_CELL00,NHAC_CINV_CELL00,NHAC_CINV_CELL00,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	button = 17,167,NHAC_CINV_CELL01,NHAC_CINV_CELL01,NHAC_CINV_CELL01,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	button = 17,218,NHAC_CINV_CELL02,NHAC_CINV_CELL02,NHAC_CINV_CELL02,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	button = 17,269,NHAC_CINV_CELL03,NHAC_CINV_CELL03,NHAC_CINV_CELL03,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	button = 17,320,NHAC_CINV_CELL04,NHAC_CINV_CELL04,NHAC_CINV_CELL04,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	// Second row
	button = 78,116,NHAC_CINV_CELL05,NHAC_CINV_CELL05,NHAC_CINV_CELL05,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	button = 78,167,NHAC_CINV_CELL06,NHAC_CINV_CELL06,NHAC_CINV_CELL06,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	button = 78,218,NHAC_CINV_CELL07,NHAC_CINV_CELL07,NHAC_CINV_CELL07,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	button = 78,269,NHAC_CINV_CELL08,NHAC_CINV_CELL08,NHAC_CINV_CELL08,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	button = 78,320,NHAC_CINV_CELL09,NHAC_CINV_CELL09,NHAC_CINV_CELL09,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	// Third row
	button = 137,116,NHAC_CINV_CELL10,NHAC_CINV_CELL10,NHAC_CINV_CELL10,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	button = 137,167,NHAC_CINV_CELL11,NHAC_CINV_CELL11,NHAC_CINV_CELL11,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	button = 137,218,NHAC_CINV_CELL12,NHAC_CINV_CELL12,NHAC_CINV_CELL12,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	button = 137,269,NHAC_CINV_CELL13,NHAC_CINV_CELL13,NHAC_CINV_CELL13,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	button = 137,320,NHAC_CINV_CELL14,NHAC_CINV_CELL14,NHAC_CINV_CELL14,NHAC_CINV_CLICKED,null,NHAC_CINV_SHOWDESC;
	// The equipment cells
	button = 17,35,NHAC_CINV_CELL_E0,NHAC_CINV_CELL_E0,NHAC_CINV_CELL_E0,NHAC_CINV_EQ_CLICKED,null,NHAC_CINV_SHOWDESC_E;
	button = 78,35,NHAC_CINV_CELL_E1,NHAC_CINV_CELL_E1,NHAC_CINV_CELL_E1,NHAC_CINV_EQ_CLICKED,null,NHAC_CINV_SHOWDESC_E;
	button = 137,35,NHAC_CINV_CELL_E2,NHAC_CINV_CELL_E2,NHAC_CINV_CELL_E2,NHAC_CINV_EQ_CLICKED,null,NHAC_CINV_SHOWDESC_E;
}
/////////////////////////////////////////////////////
// Triggered when an inventory cell is clicked
function NHAC_CINV_CLICKED(but,pan)
{
	// The cell array is zero-based, so we need to subtract 1
	but -= 1;
	
	// local variable
	var tmp;
	
	// If no item is attached to the mouse
	if(!NHAC_MOUSEITEM)
	{
		// Stop playing
		if(snd_playing(snd_handle)) {snd_stop(snd_handle);}
		
		// If the cell isn't empty
		if(NHAC_CINVENT_CELLS[but])
		{
			// Play 'swing' sound
			snd_play(swing_snd,100,10);
		}
		else
		{
			// Play 'empty' sound
			snd_play(empty_snd,100,10);
		}
	}
	else
	{
		// Stop playing
		if(snd_playing(snd_handle)) {snd_stop(snd_handle);}
		
		// Play 'swing' sound
		snd_play(swing_snd,100,10);
	}
	
	// Swap items
	tmp = NHAC_MOUSEITEM;
	NHAC_MOUSEITEM = NHAC_CINVENT_CELLS[but];
	NHAC_CINVENT_CELLS[but] = tmp;
	
	// Create a command in a string...
	str_cpy(NHASC_SCINVITEM_TMPSTR01,"bmap_draw(NHAC_CINV_CELL");
	str_for_num(NHASC_SCINVITEM_TMPSTR02,but);
	if(but < 10) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
	str_cat(NHASC_SCINVITEM_TMPSTR01,NHASC_SCINVITEM_TMPSTR02);
	if(NHAC_CINVENT_CELLS[but] != 0)
	{
		str_cat(NHASC_SCINVITEM_TMPSTR01,",NHAC_CITEM_ITMBMAP_");
		str_for_num(NHASC_SCINVITEM_TMPSTR02,NHAC_CITEM_BMAP[NHAC_CINVENT_CELLS[but] - 1]);
		if(NHAC_CITEM_BMAP[NHAC_CINVENT_CELLS[but] - 1] < 100) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
		if(NHAC_CITEM_BMAP[NHAC_CINVENT_CELLS[but] - 1] < 10) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
		str_cat(NHASC_SCINVITEM_TMPSTR01,NHASC_SCINVITEM_TMPSTR02);
	}
	else
	{
		str_cat(NHASC_SCINVITEM_TMPSTR01,",NHAC_CITEM_EMPTY");
	}
	str_cat(NHASC_SCINVITEM_TMPSTR01,");");
	
	// ...And then execute it!
	execute(NHASC_SCINVITEM_TMPSTR01);
}
/////////////////////////////////////////////////////
// Triggered when an inventory equipment cell is clicked
function NHAC_CINV_EQ_CLICKED(but,pan)
{
	// Now, 1 = Weap. cell, 2 = Armor cell, and 3 = Helm
	but -= 15;
	
	// The equipment array is zero-based, so we need to subtract 1
	but -= 1;
	
	// If we are holding an item
	if(NHAC_MOUSEITEM != 0)
	{
		// Check whether the item is of the right type
		if(NHAC_CITEM_TYPE[NHAC_MOUSEITEM - 1] != 2 - but)
		{
			// Stop playing
			if(snd_playing(snd_handle)) {snd_stop(snd_handle);}
			
			// Play 'empty' sound
			snd_play(empty_snd,100,10);
			
			return;
		}
		
		// Check whether player's level is high enough (requires level system module)
		if(NHAC_REQLVL_CHECK(NHAC_MOUSEITEM - 1) == false)
		{
			// Stop playing
			if(snd_playing(snd_handle)) {snd_stop(snd_handle);}
			
			// Play 'empty' sound
			snd_play(empty_snd,100,10);
			
			return;
		}
	}
	
	// If no item is attached to the mouse
	if(!NHAC_MOUSEITEM)
	{
		// Stop playing
		if(snd_playing(snd_handle)) {snd_stop(snd_handle);}
		
		// If the cell isn't empty
		if(NHAC_CINVENT_EQUIP[but])
		{
			// Play 'swing' sound
			snd_play(swing_snd,100,10);
		}
		else
		{
			// Play 'empty' sound
			snd_play(empty_snd,100,10);
		}
	}
	else
	{
		// Stop playing
		if(snd_playing(snd_handle)) {snd_stop(snd_handle);}
		
		// Play 'swing' sound
		snd_play(swing_snd,100,10);
	}
	
	// local variable
	var tmp;
	
	// Swap items
	tmp = NHAC_MOUSEITEM;
	NHAC_MOUSEITEM = NHAC_CINVENT_EQUIP[but];
	NHAC_CINVENT_EQUIP[but] = tmp;
	
	// Create a command in a string...
	str_cpy(NHASC_SCINVITEM_TMPSTR01,"bmap_draw(NHAC_CINV_CELL_E");
	str_for_num(NHASC_SCINVITEM_TMPSTR02,but);
	str_cat(NHASC_SCINVITEM_TMPSTR01,NHASC_SCINVITEM_TMPSTR02);
	if(NHAC_CINVENT_EQUIP[but] != 0)
	{
		str_cat(NHASC_SCINVITEM_TMPSTR01,",NHAC_CITEM_ITMBMAP_");
		str_for_num(NHASC_SCINVITEM_TMPSTR02,NHAC_CITEM_BMAP[NHAC_CINVENT_EQUIP[but] - 1]);
		if(NHAC_CITEM_BMAP[NHAC_CINVENT_EQUIP[but] - 1] < 100) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
		if(NHAC_CITEM_BMAP[NHAC_CINVENT_EQUIP[but] - 1] < 10) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
		str_cat(NHASC_SCINVITEM_TMPSTR01,NHASC_SCINVITEM_TMPSTR02);
	}
	else
	{
		str_cat(NHASC_SCINVITEM_TMPSTR01,",NHAC_CITEM_EMPTY");
	}
	str_cat(NHASC_SCINVITEM_TMPSTR01,");");
	
	// ...And then execute it!
	execute(NHASC_SCINVITEM_TMPSTR01);
}
/////////////////////////////////////////////////////
// Function to show the inventory panel
function NHAC_CINVENT_SHOW()
{
	// Make it visible
	NHAC_CPAN_INVENT.visible = on;
	
	// Set the right position
	NHAC_CPAN_INVENT.pos_x = (screen_size.x - bmap_width(NHAC_CPAN_INVENT.bmap)) * NHAC_CINVENT_SIDERIGHT;
	NHAC_CPAN_INVENT.pos_y = 0;
	
	// Set some variables, used in other modules
	NHAC_CINV_VISIBLE = true;
	NHAC_CINV_POSX = NHAC_CPAN_INVENT.pos_x;
	NHAC_CINV_POSY = NHAC_CPAN_INVENT.pos_y;
	NHAC_CINV_BMAPWIDTH = bmap_width(NHAC_CPAN_INVENT.bmap);
	NHAC_CINV_BMAPHEIGHT = bmap_height(NHAC_CPAN_INVENT.bmap);
}
/////////////////////////////////////////////////////
// Function to hide the inventory panel
function NHAC_CINVENT_HIDE()
{
	// Make it invisible
	NHAC_CPAN_INVENT.visible = off;
	
	// Set a variable, used in other modules
	NHAC_CINV_VISIBLE = false;
	
	// Hide item description-panel and text
	NHAC_CPAN_INVDESC.visible = false;
	NHAC_CTXT_INVDESC.visible = false;
}
/////////////////////////////////////////////////////
// Function to toggle the inventory panel
function NHAC_CINVENT_TOGGLE()
{
	// Check whether it visible or not
	if(NHAC_CPAN_INVENT.visible == on)
	{
		// If visible, hide it
		NHAC_CINVENT_HIDE();
	}
	else
	{
		// If not visible, show it
		NHAC_CINVENT_SHOW();
	}
}

// Toggle the inventory on [I]
on_i = NHAC_CINVENT_TOGGLE;
/////////////////////////////////////////////////////
// Function to add an item to the inventory
function NHAC_CINV_ADD(itm)
{
	// If it's an undefined item, return
	if(itm >= NHAC_CITEMS_TOTAL) {return(false);}
	
	// The items in the inventory array are not zero-based
	itm += 1;
	
	var i = 0;
	
	// Cycle through all the cells
	while(i < NHAC_CINVCELLS)
	{
		// If the cell is empty
		if(!NHAC_CINVENT_CELLS[i])
		{
			// Put the item in the cell
			NHAC_CINVENT_CELLS[i] = itm;
			
			// Draw the item:
			// Create a command in a string...
			str_cpy(NHASC_SCINVITEM_TMPSTR01,"bmap_draw(NHAC_CINV_CELL");
			str_for_num(NHASC_SCINVITEM_TMPSTR02,i);
			if(i < 10) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
			str_cat(NHASC_SCINVITEM_TMPSTR01,NHASC_SCINVITEM_TMPSTR02);
			if(NHAC_CINVENT_CELLS[i] != 0)
			{
				str_cat(NHASC_SCINVITEM_TMPSTR01,",NHAC_CITEM_ITMBMAP_");
				str_for_num(NHASC_SCINVITEM_TMPSTR02,NHAC_CITEM_BMAP[itm - 1]);
				if(NHAC_CITEM_BMAP[itm - 1] < 100) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
				if(NHAC_CITEM_BMAP[itm - 1] < 10) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
				str_cat(NHASC_SCINVITEM_TMPSTR01,NHASC_SCINVITEM_TMPSTR02);
			}
			else
			{
				str_cat(NHASC_SCINVITEM_TMPSTR01,",NHAC_CITEM_EMPTY");
			}
			str_cat(NHASC_SCINVITEM_TMPSTR01,");");
			
			// ...And then execute it!
			execute(NHASC_SCINVITEM_TMPSTR01);
			
			// We're done!
			return(true);
		}
		
		// Cycle
		i += 1;
	}
	
	// We didn't make it :(
	return(false);
}
/////////////////////////////////////////////////////
// Function to remove items from the inventory
function NHAC_CINV_REMOVE(cell)
{
	// Delete the item
	NHAC_CINVENT_CELLS[cell] = 0;
	
	// As always, we build a command in a string...
	str_cpy(NHASC_SCINVITEM_TMPSTR01,"bmap_draw(NHAC_CINV_CELL");
	str_for_num(NHASC_SCINVITEM_TMPSTR02,cell);
	if(cell < 10) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
	str_cat(NHASC_SCINVITEM_TMPSTR01,NHASC_SCINVITEM_TMPSTR02);
	str_cat(NHASC_SCINVITEM_TMPSTR01,",NHAC_CITEM_EMPTY);");
	
	// ...And executes it
	execute(NHASC_SCINVITEM_TMPSTR01);
}
/////////////////////////////////////////////////////
// Function to show an item description, when the mouse is over the item
function NHAC_CINV_SHOWDESC(but,pan)
{
	// The cell array is zero-based
	but -= 1;
	
	// If the cell is empty, return
	if(!NHAC_CINVENT_CELLS[but])
	{
		// But first hide the description panel
		NHAC_CPAN_INVDESC.visible = off;
		NHAC_CTXT_INVDESC.visible = off;
		
		return;
	}
	
	// Only one instace of this function
	proc_kill(4);
	
	// Local array
	var mPos[2];
	
	// Wait 0.05 seconds
	sleep(0.05);
	
	// Capture mouse coordinates
	mPos[0] = mouse_pos.x;
	mPos[1] = mouse_pos.y;
	
	// Wait 0.2 seconds
	sleep(0.2);
	
	// If the cell is empty, return
	if(!NHAC_CINVENT_CELLS[but])
	{
		// But first hide the description panel
		NHAC_CPAN_INVDESC.visible = off;
		NHAC_CTXT_INVDESC.visible = off;
		
		return;
	}
	
	// If the mouse haven't been moved
	if(abs(mouse_pos.x - mPos[0]) < 20 && abs(mouse_pos.y == mPos[1]) < 20)
	{
		// Get a pointer to the name of the item
		NHASC_SCI_TMPPTR01 = ptr_for_handle(NHAC_CITEM_NAME[NHAC_CINVENT_CELLS[but] - 1]);
		
		// Set the scale of the item description panel
		NHAC_CPAN_INVDESC.scale_x = max(20 + str_len(NHASC_SCI_TMPPTR01) * 1,250);
		NHAC_CPAN_INVDESC.scale_y = 50;
		
		// Copy the name of the item into the description string
		str_cpy(NHAC_CPAN_INVDESCSTR,NHASC_SCI_TMPPTR01);
		
		// If it's a weapon
		if(NHAC_CITEM_TYPE[NHAC_CINVENT_CELLS[but] - 1] == NHAC_CITMTYPE_WEAPON)
		{
			// Show the item type
			str_cat(NHAC_CPAN_INVDESCSTR,"\nType: Weapon");
			
			// Show the damage
			str_cat(NHAC_CPAN_INVDESCSTR,"\nDamage: ");
			str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_DAMAGE[NHAC_CINVENT_CELLS[but] - 1]);
			str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
			
			// Add a little to the scale_y
			NHAC_CPAN_INVDESC.scale_y += 22;
			
			// It can add defense (e.g. magic item)
			// But only if the defense is above 0, we'll show it
			if(NHAC_CITEM_DEFENSE[NHAC_CINVENT_CELLS[but] - 1])
			{
				str_cat(NHAC_CPAN_INVDESCSTR,"\nAdds ");
				str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_DEFENSE[NHAC_CINVENT_CELLS[but] - 1]);
				str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
				str_cat(NHAC_CPAN_INVDESCSTR," to defense");
				
				// Add a little to the scale_y
				NHAC_CPAN_INVDESC.scale_y += 22;
				
				// The X scale might be greater
				NHAC_CPAN_INVDESC.scale_x = max(NHAC_CPAN_INVDESC.scale_x,350);
			}
		}
		else
		{
			if(NHAC_CITEM_TYPE[NHAC_CINVENT_CELLS[but] - 1] == NHAC_CITMTYPE_ARMOR)
			{
				// Show the item type
				str_cat(NHAC_CPAN_INVDESCSTR,"\nType: Armor");
			}
			else
			{
				// Show the item type
				str_cat(NHAC_CPAN_INVDESCSTR,"\nType: Helmet");
			}
			
			// If it's not a weapon, show the defense
			str_cat(NHAC_CPAN_INVDESCSTR,"\nDefense: ");
			str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_DEFENSE[NHAC_CINVENT_CELLS[but] - 1]);
			str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
			
			// Add a little to the scale_y
			NHAC_CPAN_INVDESC.scale_y += 22;
			
			// It can add damage (e.g. magic item)
			// But only if the damage is above 0, we'll show it
			if(NHAC_CITEM_DAMAGE[NHAC_CINVENT_CELLS[but] - 1])
			{
				str_cat(NHAC_CPAN_INVDESCSTR,"\nAdds ");
				str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_DAMAGE[NHAC_CINVENT_CELLS[but] - 1]);
				str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
				str_cat(NHAC_CPAN_INVDESCSTR," to damage");
				
				// Add a little to the scale_y
				NHAC_CPAN_INVDESC.scale_y += 22;
				
				// The X scale might be greater
				NHAC_CPAN_INVDESC.scale_x = max(NHAC_CPAN_INVDESC.scale_x,350);
			}
		}
		
		// Add other properties to the item description
		if(NHAC_CITEM_REQLEVEL[NHAC_CINVENT_CELLS[but] - 1])
		{
			str_cat(NHAC_CPAN_INVDESCSTR,"\nRequires level ");
			str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_REQLEVEL[NHAC_CINVENT_CELLS[but] - 1]);
			str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
			
			// Add a little to the scale_y
			NHAC_CPAN_INVDESC.scale_y += 22;
			
			// The X scale might be greater
			NHAC_CPAN_INVDESC.scale_x = max(NHAC_CPAN_INVDESC.scale_x,350);
		}
		if(NHAC_CITEM_ADDHEALTH[NHAC_CINVENT_CELLS[but] - 1])
		{
			str_cat(NHAC_CPAN_INVDESCSTR,"\nAdds ");
			str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_ADDHEALTH[NHAC_CINVENT_CELLS[but] - 1]);
			str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
			str_cat(NHAC_CPAN_INVDESCSTR," to health");
			
			// Add a little to the scale_y
			NHAC_CPAN_INVDESC.scale_y += 22;
		}
		if(NHAC_CITEM_ADDMANA[NHAC_CINVENT_CELLS[but] - 1])
		{
			str_cat(NHAC_CPAN_INVDESCSTR,"\nAdds ");
			str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_ADDMANA[NHAC_CINVENT_CELLS[but] - 1]);
			str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
			str_cat(NHAC_CPAN_INVDESCSTR," to mana");
			
			// Add a little to the scale_y
			NHAC_CPAN_INVDESC.scale_y += 22;
		}
		if(NHAC_CITEM_ADDSPEED[NHAC_CINVENT_CELLS[but] - 1])
		{
			str_cat(NHAC_CPAN_INVDESCSTR,"\nAdds ");
			str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_ADDSPEED[NHAC_CINVENT_CELLS[but] - 1]);
			str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
			str_cat(NHAC_CPAN_INVDESCSTR," to speed");
			
			// Add a little to the scale_y
			NHAC_CPAN_INVDESC.scale_y += 22;
		}
		
		// If the inventory is in the right side of the screen
		if(NHAC_CINVENT_SIDERIGHT)
		{
			NHAC_CPAN_INVDESC.pos_x = mouse_pos.x - str_len(NHASC_SCI_TMPPTR01) * 10;
		}
		else
		{
			// Or in the left side of the screen
			NHAC_CPAN_INVDESC.pos_x = mouse_pos.x + str_len(NHASC_SCI_TMPPTR01) * 10;
		}
		NHAC_CPAN_INVDESC.pos_y = mouse_pos.y + 15;
		
		// Set the position of the descrition text
		NHAC_CTXT_INVDESC.pos_x = NHAC_CPAN_INVDESC.pos_x + 10;
		NHAC_CTXT_INVDESC.pos_y = NHAC_CPAN_INVDESC.pos_y + 10;
		
		// Show the description panel
		NHAC_CPAN_INVDESC.visible = on;
		NHAC_CTXT_INVDESC.visible = on;
		
		// While the mouse haven't been moved or clicked
		while(abs(mouse_pos.x - mPos[0]) < 20 && abs(mouse_pos.y == mPos[1]) < 20 && !mouse_left) {wait(1);}
		
		// Hide the description panel
		NHAC_CPAN_INVDESC.visible = off;
		NHAC_CTXT_INVDESC.visible = off;
	}
}
/////////////////////////////////////////////////////
// Same as above, this is just for the equipment cells
function NHAC_CINV_SHOWDESC_E(but,pan)
{
	// Now, 1 = Weap. cell, 2 = Armor cell, and 3 = Helm
	but -= 15;
	
	// The cell array is zero-based
	but -= 1;
	
	// If the cell is empty, return
	if(!NHAC_CINVENT_EQUIP[but])
	{
		// But first hide the description panel
		NHAC_CPAN_INVDESC.visible = off;
		NHAC_CTXT_INVDESC.visible = off;
		
		return;
	}
	
	// Only one instace of this function
	proc_kill(4);
	
	// Local array
	var mPos[2];
	
	// Wait 0.05 seconds
	sleep(0.05);
	
	// Capture mouse coordinates
	mPos[0] = mouse_pos.x;
	mPos[1] = mouse_pos.y;
	
	// Wait 0.2 seconds
	sleep(0.2);
	
	// If the cell is empty, return
	if(!NHAC_CINVENT_EQUIP[but])
	{
		// But first hide the description panel
		NHAC_CPAN_INVDESC.visible = off;
		NHAC_CTXT_INVDESC.visible = off;
		
		return;
	}
	
	// If the mouse haven't been moved
	if(abs(mouse_pos.x - mPos[0]) < 20 && abs(mouse_pos.y == mPos[1]) < 20)
	{
		// Get a pointer to the name of the item
		NHASC_SCI_TMPPTR01 = ptr_for_handle(NHAC_CITEM_NAME[NHAC_CINVENT_EQUIP[but] - 1]);
		
		// Set the scale of the item description panel
		NHAC_CPAN_INVDESC.scale_x = max(20 + str_len(NHASC_SCI_TMPPTR01) * 1,250);
		NHAC_CPAN_INVDESC.scale_y = 50;
		
		// Copy the name of the item into the description string
		str_cpy(NHAC_CPAN_INVDESCSTR,NHASC_SCI_TMPPTR01);
		
		// If it's a weapon
		if(NHAC_CITEM_TYPE[NHAC_CINVENT_EQUIP[but] - 1] == NHAC_CITMTYPE_WEAPON)
		{
			// Show the item type
			str_cat(NHAC_CPAN_INVDESCSTR,"\nType: Weapon");
			
			// Show the damage
			str_cat(NHAC_CPAN_INVDESCSTR,"\nDamage: ");
			str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_DAMAGE[NHAC_CINVENT_EQUIP[but] - 1]);
			str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
			
			// Add a little to the scale_y
			NHAC_CPAN_INVDESC.scale_y += 22;
			
			// It can add defense (e.g. magic item)
			// But only if the defense is above 0, we'll show it
			if(NHAC_CITEM_DEFENSE[NHAC_CINVENT_EQUIP[but] - 1])
			{
				str_cat(NHAC_CPAN_INVDESCSTR,"\nAdds ");
				str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_DEFENSE[NHAC_CINVENT_EQUIP[but] - 1]);
				str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
				str_cat(NHAC_CPAN_INVDESCSTR," to defense");
				
				// Add a little to the scale_y
				NHAC_CPAN_INVDESC.scale_y += 22;
				
				// The X scale might be greater
				NHAC_CPAN_INVDESC.scale_x = max(NHAC_CPAN_INVDESC.scale_x,350);
			}
		}
		else
		{
			if(NHAC_CITEM_TYPE[NHAC_CINVENT_EQUIP[but] - 1] == NHAC_CITMTYPE_ARMOR)
			{
				// Show the item type
				str_cat(NHAC_CPAN_INVDESCSTR,"\nType: Armor");
			}
			else
			{
				// Show the item type
				str_cat(NHAC_CPAN_INVDESCSTR,"\nType: Helmet");
			}
			
			// If it's not a weapon, show the defense
			str_cat(NHAC_CPAN_INVDESCSTR,"\nDefense: ");
			str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_DEFENSE[NHAC_CINVENT_EQUIP[but] - 1]);
			str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
			
			// Add a little to the scale_y
			NHAC_CPAN_INVDESC.scale_y += 22;
			
			// It can add damage (e.g. magic item)
			// But only if the damage is above 0, we'll show it
			if(NHAC_CITEM_DAMAGE[NHAC_CINVENT_EQUIP[but] - 1])
			{
				str_cat(NHAC_CPAN_INVDESCSTR,"\nAdds ");
				str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_DAMAGE[NHAC_CINVENT_EQUIP[but] - 1]);
				str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
				str_cat(NHAC_CPAN_INVDESCSTR," to damage");
				
				// Add a little to the scale_y
				NHAC_CPAN_INVDESC.scale_y += 22;
				
				// The X scale might be greater
				NHAC_CPAN_INVDESC.scale_x = max(NHAC_CPAN_INVDESC.scale_x,350);
			}
		}
		
		// Add other properties to the item description
		if(NHAC_CITEM_REQLEVEL[NHAC_CINVENT_EQUIP[but] - 1])
		{
			str_cat(NHAC_CPAN_INVDESCSTR,"\nRequires level ");
			str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_REQLEVEL[NHAC_CINVENT_EQUIP[but] - 1]);
			str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
			
			// Add a little to the scale_y
			NHAC_CPAN_INVDESC.scale_y += 22;
			
			// The X scale might be greater
			NHAC_CPAN_INVDESC.scale_x = max(NHAC_CPAN_INVDESC.scale_x,350);
		}
		if(NHAC_CITEM_ADDHEALTH[NHAC_CINVENT_EQUIP[but] - 1])
		{
			str_cat(NHAC_CPAN_INVDESCSTR,"\nAdds ");
			str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_ADDHEALTH[NHAC_CINVENT_EQUIP[but] - 1]);
			str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
			str_cat(NHAC_CPAN_INVDESCSTR," to health");
			
			// Add a little to the scale_y
			NHAC_CPAN_INVDESC.scale_y += 22;
		}
		if(NHAC_CITEM_ADDMANA[NHAC_CINVENT_EQUIP[but] - 1])
		{
			str_cat(NHAC_CPAN_INVDESCSTR,"\nAdds ");
			str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_ADDMANA[NHAC_CINVENT_EQUIP[but] - 1]);
			str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
			str_cat(NHAC_CPAN_INVDESCSTR," to mana");
			
			// Add a little to the scale_y
			NHAC_CPAN_INVDESC.scale_y += 22;
		}
		if(NHAC_CITEM_ADDSPEED[NHAC_CINVENT_EQUIP[but] - 1])
		{
			str_cat(NHAC_CPAN_INVDESCSTR,"\nAdds ");
			str_for_num(NHASC_SCINVITEM_TMPSTR01,NHAC_CITEM_ADDSPEED[NHAC_CINVENT_EQUIP[but] - 1]);
			str_cat(NHAC_CPAN_INVDESCSTR,NHASC_SCINVITEM_TMPSTR01);
			str_cat(NHAC_CPAN_INVDESCSTR," to speed");
			
			// Add a little to the scale_y
			NHAC_CPAN_INVDESC.scale_y += 22;
		}
		
		// If the inventory is in the right side of the screen
		if(NHAC_CINVENT_SIDERIGHT)
		{
			NHAC_CPAN_INVDESC.pos_x = mouse_pos.x - str_len(NHASC_SCI_TMPPTR01) * 10;
		}
		else
		{
			// Or in the left side of the screen
			NHAC_CPAN_INVDESC.pos_x = mouse_pos.x + str_len(NHASC_SCI_TMPPTR01) * 10;
		}
		NHAC_CPAN_INVDESC.pos_y = mouse_pos.y + 15;
		
		// Set the position of the descrition text
		NHAC_CTXT_INVDESC.pos_x = NHAC_CPAN_INVDESC.pos_x + 10;
		NHAC_CTXT_INVDESC.pos_y = NHAC_CPAN_INVDESC.pos_y + 10;
		
		// Show the description panel
		NHAC_CPAN_INVDESC.visible = on;
		NHAC_CTXT_INVDESC.visible = on;
		
		// While the mouse haven't been moved or clicked
		while(abs(mouse_pos.x - mPos[0]) < 20 && abs(mouse_pos.y == mPos[1]) < 20 && !mouse_left) {wait(1);}
		
		// Hide the description panel
		NHAC_CPAN_INVDESC.visible = off;
		NHAC_CTXT_INVDESC.visible = off;
	}
}
/////////////////////////////////////////////////////
// Pick-up event for the core CITEM pickup action
function NHAC_CITEM_PICKUP_EVE()
{
	// The player need to exist
	if(!player) {return;}
	
	// If we touched it with the mouse
	if(event_type == event_touch)
	{
		// Lit the item
		my.ambient = 100;
	}
	
	// If we moved the mouse away from it
	if(event_type == event_release)
	{
		// Unlit the item
		my.ambient = my.skill3;
	}
	
	// If we clicked it with the mouse
	if(event_type == event_click)
	{
		// Wait till we released the left mouse button
		while(mouse_left) {wait(1);}
		
		// The player need to exist
		if(!player) {return;}
		
		// Set the walkpoint to my.x
		vec_set(player.ent_target,my.x);
		
		// While the player is too far away to pick it up
		while(player && (vec_dist(my.x,vector(player.x,player.y,my.z)) > 40))
		{
			// If we click somewhere else (e.g. changes walkpoint or clicks another item)
			if(mouse_left)
			{
				// We won't pickup this item
				return;
			}
			
			// Avoid "endless loop" errors
			wait(1);
		}
		
		// Unlit the item
		my.ambient = my.skill3;
		
		// Pickup the item
		my.skill2 = 1;
	}
}
/////////////////////////////////////////////////////
// Title: CItem Pick-up action
// Desc: Also used when an item is dropped.
// Desc: itemType: The number of the item (in the items.ilf)
// Use: itemType
action NHAC_CITEM_Pickup
{
	// Skills used in the action
	my.skill2 = 0;
	my.skill3 = my.ambient;
	
	// Set the triggers and the event
	my.enable_click = on;
	my.enable_touch = on;
	my.enable_release = on;
	my.event = NHAC_CITEM_PICKUP_EVE;
	
	// Get the size of the bounding box
	temp.x = abs(my.min_x) + abs(my.max_x);
	temp.y = abs(my.min_y) + abs(my.max_y);
	temp.z = abs(my.min_z) + abs(my.max_z);
	
	if(temp.z > temp.x && temp.z > temp.y)
	{
		if(temp.x > temp.y)
		{
			my.roll += 90;
		}
		else
		{
			my.tilt += 90;
		}
	}
	
	// Don't block other entities
	my.passable = on;
	
	// If we should use this function
	/*if(NHAC_ENTS_TO_GROUND)
	{
		// Then do it :)
		// Don't flow
		attach_to_ground();
	}*/
	
	// Label, to jumb back to, if the item couldn't be picked up
	readyForPickup:
	
	// Wait till I should be picked up
	while(!my.skill2) {wait(1);}
	
	// Checker whether the inventory is shown
	if(NHAC_CPAN_INVENT.visible)
	{
		// Set the mouse item to me
		NHAC_MOUSEITEM = my.itemType + 1;
	}
	else
	{
		// If the inventory is not visible, just add if to the inventory
		if(!NHAC_CINV_ADD(my.itemType))
		{
			// If there wasn't space for the item,
			// display an error message, and then make ready to be picked up again
			my.skill2 = 0;
			NHA_CORE_SHOWMSG("Couldn't pickup the item - no room in the inventory",5);
			goto(readyForPickup);
		}
	}
	
	// Wait a frame, and then remove me
	wait(1);
	ent_remove(me);
}
/////////////////////////////////////////////////////
// Function to drop items on the ground (Drops MI - Mouse Item)
function NHAC_CITEM_DROPMI()
{
	// If the player doesn't exist, or the mouse isn't holding an item
	if(!player || !NHAC_MOUSEITEM) {return;}
	
	// Get the string containing the model name
	NHASC_SCI_TMPPTR01 = ptr_for_handle(NHAC_CITEM_MODELS[NHAC_CITEM_MODEL[NHAC_MOUSEITEM - 1]]);
	
	// If the string pointer is invalid, return
	if(!NHASC_SCI_TMPPTR01) {return;}
	
	// Set the postion for the ent to create
	if(NHAC_ENTS_TO_GROUND)
	{
		vec_set(temp,vector(player.x,player.y,player.z + (player.min_z*0.5)));
	}
	else
	{
		vec_set(temp,player.x);
	}
	
	// Don't drop in the same spot
	temp.x += random(5) - random(5);
	temp.y += random(5) - random(5);
	
	// Create the entity
	You = ent_create(NHASC_SCI_TMPPTR01,temp,NHAC_CITEM_Pickup);
	
	// If the handle is valid
	if(you)
	{
		// Set the item, and remove it from the mouse
		You.itemType = NHAC_MOUSEITEM - 1;
		NHAC_MOUSEITEM = 0;
		
		// Set a random angle
		You.pan = random(360);
	}
}
/////////////////////////////////////////////////////
// Resets the inventory
function NHAC_CINV_RESET()
{
	// local var
	var i = NHAC_CINVCELLS;
	
	// Hide the inventory
	NHAC_CINVENT_HIDE();
	
	// Reset inventory cells
	while(i > 0)
	{
		// Decrease i
		i -= 1;
		
		// Remove it from the cell
		NHAC_CINVENT_CELLS[i] = 0;
		
		// purge the inv. cell bmaps, causing them to reload (as empty cells)
		str_cpy(NHASC_SCINVITEM_TMPSTR01,"bmap_purge(NHAC_CINV_CELL");
		str_for_num(NHASC_SCINVITEM_TMPSTR02,i);
		if(i < 10)
		{
			str_cat(NHASC_SCINVITEM_TMPSTR01,"0");
		}
		str_cat(NHASC_SCINVITEM_TMPSTR01,NHASC_SCINVITEM_TMPSTR02);
		str_cat(NHASC_SCINVITEM_TMPSTR01,");");
		
		// Execute it
		execute(NHASC_SCINVITEM_TMPSTR01);
		
		if(i >= max_loops) {wait(1);}
	}
	
	// Reset equipment cells
	NHAC_CINVENT_EQUIP[0] = 0;
	NHAC_CINVENT_EQUIP[1] = 0;
	NHAC_CINVENT_EQUIP[2] = 0;
	
	// Cause redraw
	bmap_purge(NHAC_CINV_CELL_E0);
	bmap_purge(NHAC_CINV_CELL_E1);
	bmap_purge(NHAC_CINV_CELL_E2);
	
	// Hide the item description panel
	NHAC_CPAN_INVDESC.visible = off;
	NHAC_CTXT_INVDESC.visible = off;
}
/////////////////////////////////////////////////////
// Redraws the inventory
function NHAC_INVENTORY_REDRAW()
{
	// Get a local var
	var i = NHAC_CINVCELLS;
	
	// While there are still inventory cells left
	while(i > 0)
	{
		// Decrease 'i'
		i -= 1;
		
		// Draw items/empty space
		// Create a command in a string...
		str_cpy(NHASC_SCINVITEM_TMPSTR01,"bmap_draw(NHAC_CINV_CELL");
		str_for_num(NHASC_SCINVITEM_TMPSTR02,i);
		if(i < 10) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
		str_cat(NHASC_SCINVITEM_TMPSTR01,NHASC_SCINVITEM_TMPSTR02);
		if(NHAC_CINVENT_CELLS[i] != 0)
		{
			str_cat(NHASC_SCINVITEM_TMPSTR01,",NHAC_CITEM_ITMBMAP_");
			str_for_num(NHASC_SCINVITEM_TMPSTR02,NHAC_CITEM_BMAP[NHAC_CINVENT_CELLS[i] - 1]);
			if(NHAC_CITEM_BMAP[NHAC_CINVENT_CELLS[i] - 1] < 100) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
			if(NHAC_CITEM_BMAP[NHAC_CINVENT_CELLS[i] - 1] < 10) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
			str_cat(NHASC_SCINVITEM_TMPSTR01,NHASC_SCINVITEM_TMPSTR02);
		}
		else
		{
			str_cat(NHASC_SCINVITEM_TMPSTR01,",NHAC_CITEM_EMPTY");
		}
		str_cat(NHASC_SCINVITEM_TMPSTR01,");");
		
		// ...And then execute it!
		execute(NHASC_SCINVITEM_TMPSTR01);
	}
	
	// Set the local var, 'i', to 3
	i = 3;
	
	// While there are still equipment cells left
	while(i > 0)
	{
		// Decrease 'i'
		i -= 1;
		
		// Draw items/empty space
		// Create a command in a string...
		str_cpy(NHASC_SCINVITEM_TMPSTR01,"bmap_draw(NHAC_CINV_CELL_E");
		str_for_num(NHASC_SCINVITEM_TMPSTR02,i);
		str_cat(NHASC_SCINVITEM_TMPSTR01,NHASC_SCINVITEM_TMPSTR02);
		if(NHAC_CINVENT_EQUIP[i] != 0)
		{
			str_cat(NHASC_SCINVITEM_TMPSTR01,",NHAC_CITEM_ITMBMAP_");
			str_for_num(NHASC_SCINVITEM_TMPSTR02,NHAC_CITEM_BMAP[NHAC_CINVENT_EQUIP[i] - 1]);
			if(NHAC_CITEM_BMAP[NHAC_CINVENT_EQUIP[i] - 1] < 100) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
			if(NHAC_CITEM_BMAP[NHAC_CINVENT_EQUIP[i] - 1] < 10) {str_cat(NHASC_SCINVITEM_TMPSTR01,"0");}
			str_cat(NHASC_SCINVITEM_TMPSTR01,NHASC_SCINVITEM_TMPSTR02);
		}
		else
		{
			str_cat(NHASC_SCINVITEM_TMPSTR01,",NHAC_CITEM_EMPTY");
		}
		str_cat(NHASC_SCINVITEM_TMPSTR01,");");
		
		// ...And then execute it!
		execute(NHASC_SCINVITEM_TMPSTR01);
	}
}
/////////////////////////////////////////////////////
// Gets the item, from an item name string handle
function itemFromName(item)
{
	// local var
	var i;
	i = NHAC_CITEMS_TOTAL;
	
	// While there are items we haven't checked
	while(i > 0)
	{
		// Decrease 'i'
		i -= 1;
		
		// Get a string containing the name of the item with number 'i'
		str_cpy(NHASC_SCINVITEM_TMPSTR01,ptr_for_handle(NHAC_CITEM_NAME[i]));
		
		// If it's the item we were looking for
		if(str_cmpi(NHASC_SCINVITEM_TMPSTR01,item))
		{
			// Return the number of the spell
			return(i);
		}
	}
	
	// We haven't found it, return '0'.
	// Note: '0' is also an item number
	return(0);
}
/////////////////////////////////////////////////////
// Function to drop items on the ground
function NHAC_CITEM_DROP(ent,item)
{
	// Store the entity in the 'you' pointer
	you = ent;
	
	// Ensure existance
	if(!you){return;}
	
	// Get the string containing the model name
	NHASC_SCI_TMPPTR01 = ptr_for_handle(NHAC_CITEM_MODELS[NHAC_CITEM_MODEL[item]]);
	
	// If the string pointer is invalid, return
	if(!NHASC_SCI_TMPPTR01) {return;}
	
	// Set the postion for the ent to create
	if(NHAC_ENTS_TO_GROUND)
	{
		vec_set(temp,vector(you.x,you.y,you.z + (you.min_z*0.5)));
	}
	else
	{
		vec_set(temp,you.x);
	}
	
	// Don't drop in the same spot
	temp.x += random(5) - random(5);
	temp.y += random(5) - random(5);
	
	// Create the entity
	You = ent_create(NHASC_SCI_TMPPTR01,temp,NHAC_CITEM_Pickup);
	
	// If the handle is valid
	if(you)
	{
		// Set the item
		You.itemType = item;
		
		// Set a random angle
		You.pan = random(360);
	}
}
/////////////////////////////////////////////////////