/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// This WDL file should always be included -BELOW-
// all the other core (NHAC) files.
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
//
// -- UPDATES --
//	Juli 12th 2006:
// -Floating bug in attach_to_ground has been fixed.
// -Function NHAC_CORE_ITEM_DROP(ent,item) has been added
// 
// July 13th 2006:
// -Fixed bug in attach_to_ground (thanks to Kabal458 at the GS forum)
// 
// July 16th 2006:
// -Added function NHA_CORE_INVENTORY_REDRAW
/////////////////////////////////////////////////////
// We are using the Basic spells "Core"
define USE_CORE_INTERFERENCE;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// Function to be executed on_mouse_left
function execute_on_mouse_left()
{
	// If the game is paused
	if(freeze_mode != 0) {return;}
	
	if(NHAC_CVAR_USE_CINVENTORY	// DO NOT MODIFY THIS VARIABLE!!!
		&& mouse_pos.x > NHAC_CINV_POSX
		&& mouse_pos.x < NHAC_CINV_POSX + NHAC_CINV_BMAPWIDTH
		&& mouse_pos.y > NHAC_CINV_POSY
		&& mouse_pos.y < NHAC_CINV_POSY + NHAC_CINV_BMAPHEIGHT
		&& NHAC_CINV_VISIBLE == true)
	{
		return;
	}
	
	if(NHAC_CVAR_USE_CDIA	// DO NOT MODIFY THIS VARIABLE!!!
		&& mouse_pos.x > NHAC_CDIA_POSX
		&& mouse_pos.x < NHAC_CDIA_POSX + NHAC_CDIA_BMAPWIDTH
		&& mouse_pos.y > NHAC_CDIA_POSY
		&& mouse_pos.y < NHAC_CDIA_POSY + NHAC_CDIA_BMAPHEIGHT
		&& NHAC_CDIA_VISIBLE == true)
	{
		return;
	}
	
	if(NHAC_CVAR_USE_CCHR	// DO NOT MODIFY THIS VARIABLE!!!
		&& mouse_pos.x > NHAC_CCHR_POSX
		&& mouse_pos.x < NHAC_CCHR_POSX + NHAC_CCHR_BMAPWIDTH
		&& mouse_pos.y > NHAC_CCHR_POSY
		&& mouse_pos.y < NHAC_CCHR_POSY + NHAC_CCHR_BMAPHEIGHT
		&& NHAC_CCHR_VISIBLE == true)
	{
		return;
	}
	
	// If the player core is used
	ifdef USE_CORE_PLAYER;
		set_player_walkpoint();
	endif;
	
	// If the inventory core is used
	ifdef USE_CORE_INVENTORY;
		NHAC_CITEM_DROPMI();
	endif;
}

on_mouse_left = execute_on_mouse_left;
/////////////////////////////////////////////////////
function NHAC_enemyAI_castSpell(spell)
{
	ifdef USE_CORE_BSPELLS;
		NHAC_CSPELL_CAST(spell);
	endif;
}
/////////////////////////////////////////////////////
// Used in the other core modules
function NHA_CORE_SHOWMSG(str,tme)
{
	ifdef USE_CORE_MISCMSG;
		msg_show(str,tme);
	ifelse;
		wait(1);
	endif;
}
/////////////////////////////////////////////////////
// Don't let the character panel block the msg
function NHA_CORE_CHECK_SHOWMSG()
{
	ifdef USE_CORE_LEVELSYS;
		ifdef USE_CORE_MISCMSG;
			NHAC_MSGSHOW_TXT.pos_x = 5 + (bmap_width(NHAC_charpan.bmap) * NHAC_charpan.visible);
		ifelse;
			wait(1);
		endif;
	ifelse;
		wait(1);
	endif;
}
/////////////////////////////////////////////////////
// Re-adjusts panels (e.g. if screen resolution has changed)
function NHA_CORE_READJUST_PANELS()
{
	// HUD panel
	ifdef USE_CORE_BASICHUD;
		NHAC_HUDPAN_SHOW();
	endif;
	
	// Inventory panel
	ifdef USE_CORE_INVENTORY;
		if(NHAC_CPAN_INVENT.visible == true)
		{
			NHAC_CINVENT_SHOW();
		}
	endif;
	
	// Main menu panel
	ifdef USE_CORE_MAINMENU;
		if(NHAC_mainmenu_pan.visible == true)
		{
			NHAC_mainMenu_show();
		}
	endif;
}
/////////////////////////////////////////////////////
// Don't flow
function attach_to_ground()
{
	// As long as I exists
	while(my)
	{
		vec_set(temp,vector(my.x,my.y,my.z + my.min_z));
		vec_set(target,vector(my.x,my.y,my.z - 5000));
		
		// Subtract the distance to the ground from my.z
		my.z -= c_trace(temp,target,ignore_passable + ignore_me + ignore_you) - 1;
		
		// If we got too long down...
		if(c_content(vector(my.x,my.y,my.z + my.min_z),0) == CONTENT_SOLID)
		{
			// Then move me a little upwards
			my.z += 3 * time;
		}
		wait(1);
	}
}
/////////////////////////////////////////////////////
// Check whether player's level is high enough for using an item
function NHAC_REQLVL_CHECK(itm)
{
	ifdef USE_CORE_LEVELSYS;
		if(NHAC_CITEM_REQLEVEL[itm] > NHAC_plLevel)
		{
			return(false);
		}
	endif;
	
	return(true);
}
/////////////////////////////////////////////////////
function NHA_CORE_INVENTORY_REDRAW()
{
	ifdef USE_CORE_INVENTORY;
		NHAC_INVENTORY_REDRAW();
	ifelse;
		wait(1);
	endif;
}
/////////////////////////////////////////////////////
// Calls function NHAC_CITEM_DROP(ent,item) if the inventory core is included
function NHAC_CORE_ITEM_DROP(ent,item)
{
	ifdef USE_CORE_INVENTORY;
		NHAC_CITEM_DROP(ent,item);
	endif;
	
	// Not an empty function, if inventory core isn't included
	wait(1);
}
/////////////////////////////////////////////////////
// Extra skills provided by items
function NHAC_ITM_GET_DMG()
{
	ifdef USE_CORE_INVENTORY;
		result = 0;
		
		if(NHAC_CINVENT_EQUIP[0] > 0)
		{
			result += NHAC_CITEM_DAMAGE[NHAC_CINVENT_EQUIP[0] - 1];
		}
		if(NHAC_CINVENT_EQUIP[1] > 0)
		{
			result += NHAC_CITEM_DAMAGE[NHAC_CINVENT_EQUIP[1] - 1];
		}
		if(NHAC_CINVENT_EQUIP[2] > 0)
		{
			result += NHAC_CITEM_DAMAGE[NHAC_CINVENT_EQUIP[2] - 1];
		}
		
		return(result);
	ifelse;
		return(0);
	endif;
}
function NHAC_ITM_GET_DFS()
{
	ifdef USE_CORE_INVENTORY;
		result = 0;
		
		if(NHAC_CINVENT_EQUIP[0] > 0)
		{
			result += NHAC_CITEM_DEFENSE[NHAC_CINVENT_EQUIP[0] - 1];
		}
		if(NHAC_CINVENT_EQUIP[1] > 0)
		{
			result += NHAC_CITEM_DEFENSE[NHAC_CINVENT_EQUIP[1] - 1];
		}
		if(NHAC_CINVENT_EQUIP[2] > 0)
		{
			result += NHAC_CITEM_DEFENSE[NHAC_CINVENT_EQUIP[2] - 1];
		}
		
		return(result);
	ifelse;
		return(0);
	endif;
}
function NHAC_ITM_GET_HLT()
{
	ifdef USE_CORE_INVENTORY;
		result = 0;
		
		if(NHAC_CINVENT_EQUIP[0] > 0)
		{
			result += NHAC_CITEM_ADDHEALTH[NHAC_CINVENT_EQUIP[0] - 1];
		}
		if(NHAC_CINVENT_EQUIP[1] > 0)
		{
			result += NHAC_CITEM_ADDHEALTH[NHAC_CINVENT_EQUIP[1] - 1];
		}
		if(NHAC_CINVENT_EQUIP[2] > 0)
		{
			result += NHAC_CITEM_ADDHEALTH[NHAC_CINVENT_EQUIP[2] - 1];
		}
		
		return(result);
	ifelse;
		return(0);
	endif;
}
function NHAC_ITM_GET_MAN()
{
	ifdef USE_CORE_INVENTORY;
		result = 0;
		
		if(NHAC_CINVENT_EQUIP[0] > 0)
		{
			result += NHAC_CITEM_ADDMANA[NHAC_CINVENT_EQUIP[0] - 1];
		}
		if(NHAC_CINVENT_EQUIP[1] > 0)
		{
			result += NHAC_CITEM_ADDMANA[NHAC_CINVENT_EQUIP[1] - 1];
		}
		if(NHAC_CINVENT_EQUIP[2] > 0)
		{
			result += NHAC_CITEM_ADDMANA[NHAC_CINVENT_EQUIP[2] - 1];
		}
		
		return(result);
	ifelse;
		return(0);
	endif;
}
function NHAC_ITM_GET_SPD()
{
	ifdef USE_CORE_INVENTORY;
		result = 0;
		
		if(NHAC_CINVENT_EQUIP[0] > 0)
		{
			result += NHAC_CITEM_ADDSPEED[NHAC_CINVENT_EQUIP[0] - 1];
		}
		if(NHAC_CINVENT_EQUIP[1] > 0)
		{
			result += NHAC_CITEM_ADDSPEED[NHAC_CINVENT_EQUIP[1] - 1];
		}
		if(NHAC_CINVENT_EQUIP[2] > 0)
		{
			result += NHAC_CITEM_ADDSPEED[NHAC_CINVENT_EQUIP[2] - 1];
		}
		
		return(result);
	ifelse;
		return(0);
	endif;
}
/////////////////////////////////////////////////////