/////////////////////////////////////////////////////
// RPG/Adv. Temp 2.0
// Animation functionality
//
// (C) 2006 by Claus N.
// www.nighthawk.dk
/////////////////////////////////////////////////////
// If we are using this file, don't include it twice
define USE_SUBCORE_ANIMATION;
/////////////////////////////////////////////////////
// We need the Defines "sub-core"
ifndef USE_SUBCORE_DEFINES;
	include <NHASC_defines.wdl>;
endif;
/////////////////////////////////////////////////////
// Standard animation function, used by e.g. the player
function std_animpack()
{
	// While I exist, and my animation state isn't set
	// to stop animating (e.g. on death)
	while(my && (my.anim_state != anim_stop))
	{
		// If I'm standing...
		if(my.anim_state == anim_state_stand)
		{
			// Animate me using the "stand" animation
			ent_animate(my,"stand",my.skill46,ANM_CYCLE);
			
			// Some models' stand animation is called idle,
			// so let's use both!
			ent_animate(my,"idle",my.skill46,ANM_CYCLE);
			
			// Cycle through the animations
			my.skill46 = (my.skill46 + my.anim_speed_stand * time) % 100;
		}
		
		// If I'm walking...
		if(my.anim_state == anim_state_walk)
		{
			// Animate me using the "walk" animation
			ent_animate(my,"walk",my.skill46,ANM_CYCLE);
			
			// Cycle through the animations
			my.skill46 = (my.skill46 + my.anim_speed_walk * time) % 100;
		}
		
		// If I'm... Yeah, what do ya think? :p
		if(my.anim_state == anim_state_run)
		{
			// Animate me using the "run" animation
			ent_animate(my,"run",my.skill46,ANM_CYCLE);
			
			// Cycle through the animations
			my.skill46 = (my.skill46 + my.anim_speed_run * time) % 100;
		}
		
		// Avoid endless loops
		wait(1);
	}
}
/////////////////////////////////////////////////////