//_________________________________Loads the menu___________________________________________________//

FUNCTION menu()
{
  start_menu();

  check_for_changes(menu_status);

  movement_menu(); 
}

//_________________________________Sets the positions of the buttons___________________________________________________//

FUNCTION start_menu()
{

    // Sets the positions of the buttons in main_menu:
    resume_game_normal_txt.pos_x = button_pos_x[0];  
    resume_game_normal_txt.pos_y = button_pos_y[0];

    resume_game_activated_txt.pos_x = button_pos_x[0];  
    resume_game_activated_txt.pos_y = button_pos_y[0];

    start_game_normal_txt.pos_x = button_pos_x[1];  
    start_game_normal_txt.pos_y = button_pos_y[1];

    start_game_activated_txt.pos_x = button_pos_x[1];  
    start_game_activated_txt.pos_y = button_pos_y[1];

    save_game_normal_txt.pos_x = button_pos_x[2];
    save_game_normal_txt.pos_y = button_pos_y[2];

    save_game_activated_txt.pos_x = button_pos_x[2];
    save_game_activated_txt.pos_y = button_pos_y[2];

    Load_game_normal_txt.pos_x = button_pos_x[3];
    Load_game_normal_txt.pos_y = button_pos_y[3];

    Load_game_activated_txt.pos_x = button_pos_x[3];
    Load_game_activated_txt.pos_y = button_pos_y[3];

    Options_normal_txt.pos_x = button_pos_x[4];
    Options_normal_txt.pos_y = button_pos_y[4];

    Options_activated_txt.pos_x = button_pos_x[4];
    Options_activated_txt.pos_y = button_pos_y[4];  

    Credits_normal_txt.pos_x = button_pos_x[5];
    Credits_normal_txt.pos_y = button_pos_y[5];

    Credits_activated_txt.pos_x = button_pos_x[5];
    Credits_activated_txt.pos_y = button_pos_y[5];

    Exit_normal_txt.pos_x = button_pos_x[6];
    Exit_normal_txt.pos_y = button_pos_y[6];

    Exit_activated_txt.pos_x = button_pos_x[6];
    Exit_activated_txt.pos_y = button_pos_y[6]; 



    // Sets the positions of the buttons in options menu:
    difficulty_options_txt.pos_x = options_pos_x[0];
    difficulty_options_txt.pos_y = options_pos_y[0];

    Eesy_normal_txt.pos_x = options_pos_x[0] + 300;
    Eesy_normal_txt.pos_y = options_pos_y[0];

    Eesy_activated_txt.pos_x = Eesy_normal_txt.pos_x;
    Eesy_activated_txt.pos_y = Eesy_normal_txt.pos_y;

    normal_normal_txt.pos_x = Eesy_normal_txt.pos_x + 100;
    normal_normal_txt.pos_y = options_pos_y[0];

    normal_activated_txt.pos_x = normal_normal_txt.pos_x;
    normal_activated_txt.pos_y = normal_normal_txt.pos_y;

    hard_normal_txt.pos_x = normal_normal_txt.pos_x + 120;
    hard_normal_txt.pos_y = options_pos_y[0];

    hard_activated_txt.pos_x = hard_normal_txt.pos_x;
    hard_activated_txt.pos_y = hard_normal_txt.pos_y;

    intro_options_txt.pos_x = options_pos_x[1];
    intro_options_txt.pos_y = options_pos_y[1];

    Intro_Yes_txt.pos_x = options_pos_x[1] + 300;
    Intro_Yes_txt.pos_y = options_pos_y[1];

    Intro_No_txt.pos_x = options_pos_x[1] + 300;
    Intro_No_txt.pos_y = options_pos_y[1];

    invert_mouse_options_txt.pos_x = options_pos_x[2];
    invert_mouse_options_txt.pos_y = options_pos_y[2];

    invert_mouse_Yes_txt.pos_x = options_pos_x[2] + 300;
    invert_mouse_Yes_txt.pos_y = options_pos_y[2];

    invert_mouse_no_txt.pos_x = options_pos_x[2] + 300;
    invert_mouse_no_txt.pos_y = options_pos_y[2];

    sound_options_txt.pos_x = options_pos_x[3];
    sound_options_txt.pos_y = options_pos_y[3];

    sound_number_options_txt.pos_x = options_pos_x[3] + 300;
    sound_number_options_txt.pos_y = options_pos_y[3];

    music_options_txt.pos_x = options_pos_x[4];
    music_options_txt.pos_y = options_pos_y[4];

    music_number_options_txt.pos_x = options_pos_x[4] + 300;
    music_number_options_txt.pos_y = options_pos_y[4];

    mouse_sensivity_options_txt.pos_x = options_pos_x[5];
    mouse_sensivity_options_txt.pos_y = options_pos_y[5];

    mouse_sens_back_panel.pos_x = options_pos_x[5] + 300;
    mouse_sens_back_panel.pos_y = options_pos_y[5];
    
    // The y of the front sensivity, no changes during the menu:
    mouse_sens_front_panel.pos_y = options_pos_y[5] - 3;

    default_normal_options_txt.pos_x = options_pos_x[6];
    default_normal_options_txt.pos_y = options_pos_y[6];

    default_activated_options_txt.pos_x = options_pos_x[6];
    default_activated_options_txt.pos_y = options_pos_y[6];

    return_normal_options_txt.pos_x = options_pos_x[7];
    return_normal_options_txt.pos_y = options_pos_y[7];

    return_activated_options_txt.pos_x = options_pos_x[7];
    return_activated_options_txt.pos_y = options_pos_y[7];


    // Sets the position of the cursor in main_menu:
    arrow_panel.pos_x = button_pos_x[activated_button - 1] - distance_arrow_button_X;
    arrow_panel.pos_y = button_pos_y[activated_button - 1] + distance_arrow_button_Y;


    // Displays the 1st, 2nd background panel and the arrow panel
    black_panel.alpha = 100;

    black_panel.visible = ON; 
    background_panel.visible = ON; 
    arrow_panel.visible = ON;
}


//_________________________________Closes the menu___________________________________________________//
// note: The black screen is on, after this function
// This function sets the grafics of the menu on off
// If mode is equal 1 then the whole menu is set on off. To go into ingame...
// mode is equal 2 --> Load Menu, equal 3 --> Save Menu, equal --> 4 options menu

FUNCTION close_menu(mode)
{
  resume_game_normal_txt.visible = OFF;
  start_game_normal_txt.visible = OFF;
  save_game_normal_txt.visible = OFF;
  Load_game_normal_txt.visible = OFF;
  Options_normal_txt.visible = OFF;
  Credits_normal_txt.visible = OFF;
  Exit_normal_txt.visible = OFF;

  resume_game_activated_txt.visible = OFF;
  start_game_activated_txt.visible = OFF;
  save_game_activated_txt.visible = OFF;
  load_game_activated_txt.visible = OFF;
  Options_activated_txt.visible = OFF;
  Credits_activated_txt.visible = OFF;
  Exit_activated_txt.visible = OFF;

  if(mode == 1)
  {
    background_panel.visible = OFF; 
    arrow_panel.visible = OFF;
  }

  if(mode == 2 || mode == 3)
  {
    save_pic_1_panel.visible = OFF;
    save_pic_2_panel.visible = OFF;
    save_pic_3_panel.visible = OFF;
    save_pic_4_panel.visible = OFF; 

    save_name_1_text.visible = OFF;
    save_name_2_text.visible = OFF;
    save_name_3_text.visible = OFF;
    save_name_4_text.visible = OFF;

    name_1_text.visible = OFF;
    name_2_text.visible = OFF;
    name_3_text.visible = OFF;
    name_4_text.visible = OFF;

    date_1_text.visible = OFF;
    date_2_text.visible = OFF;
    date_3_text.visible = OFF;
    date_4_text.visible = OFF;

    save_date_1_text.visible = OFF;
    save_date_2_text.visible = OFF;
    save_date_3_text.visible = OFF;
    save_date_4_text.visible = OFF;

    time_1_text.visible = OFF;
    time_2_text.visible = OFF;
    time_3_text.visible = OFF;
    time_4_text.visible = OFF;

    save_time_1_text.visible = OFF;
    save_time_2_text.visible = OFF;
    save_time_3_text.visible = OFF;
    save_time_4_text.visible = OFF;

    level_1_text.visible = OFF;
    level_2_text.visible = OFF;
    level_3_text.visible = OFF;
    level_4_text.visible = OFF;

    save_level_1_text.visible = OFF;
    save_level_2_text.visible = OFF;
    save_level_3_text.visible = OFF;
    save_level_4_text.visible = OFF; 
  }

  if(mode == 4)
  {
    difficulty_options_txt.visible = OFF;
    intro_options_txt.visible = OFF;
    invert_mouse_options_txt.visible = OFF;
    sound_options_txt.visible = OFF;
    sound_number_options_txt.visible = OFF;
    music_options_txt.visible = OFF;
    music_number_options_txt.visible = OFF;
    mouse_sensivity_options_txt.visible = OFF;
    mouse_sens_back_panel.visible = OFF;
    mouse_sens_front_panel.visible = OFF;
    Eesy_normal_txt.visible = OFF;
    normal_normal_txt.visible = OFF;
    hard_normal_txt.visible = OFF;
    Eesy_activated_txt.visible = OFF;
    normal_activated_txt.visible = OFF;
    hard_activated_txt.visible = OFF;

    Intro_Yes_txt.visible = OFF;
    Intro_No_txt.visible = OFF;

    invert_mouse_Yes_txt.visible = OFF;
    invert_mouse_No_txt.visible = OFF;

    sound_options_txt.visible = OFF;
    sound_number_options_txt.visible = OFF;

    music_options_txt.visible = OFF;
    music_number_options_txt.visible = OFF;

    default_normal_options_txt.visible = OFF;
    return_normal_options_txt.visible = OFF;

    default_activated_options_txt.visible = OFF;
    return_activated_options_txt.visible = OFF;

    // Save the settings:
    wait(1);
    game_save("options_settings", 0, SV_INFO);
  }

}

//_________________________________keyboard_event --> checks it___________________________________________________//

FUNCTION check_for_changes(mode)
{

  if(mode == 1)
  {
    if(ingame_now == 1)
    {
      resume_game_normal_txt.visible = ON;
    }

    start_game_normal_txt.visible = ON;
    save_game_normal_txt.visible = ON;
    Load_game_normal_txt.visible = ON;
    Options_normal_txt.visible = ON;
    Credits_normal_txt.visible = ON;
    Exit_normal_txt.visible = ON;

    if ( activated_button == 1 ) { resume_game_activated_txt.visible = ON; resume_game_normal_txt.visible = OFF; }
    if ( activated_button == 2 ) { start_game_activated_txt.visible = ON; start_game_normal_txt.visible = OFF; }
    if ( activated_button == 3 ) { save_game_activated_txt.visible = ON; save_game_normal_txt.visible = OFF; }
    if ( activated_button == 4 ) { load_game_activated_txt.visible = ON; load_game_normal_txt.visible = OFF; }
    if ( activated_button == 5 ) { Options_activated_txt.visible = ON; Options_normal_txt.visible = OFF; }
    if ( activated_button == 6 ) { Credits_activated_txt.visible = ON; Credits_normal_txt.visible = OFF; }
    if ( activated_button == 7 ) { Exit_activated_txt.visible = ON; Exit_normal_txt.visible = OFF; }
  }

  if(mode == 2 || mode == 3)
  {
    save_pic_1_panel.alpha = 30;
    save_pic_2_panel.alpha = 30;
    save_pic_3_panel.alpha = 30;
    save_pic_4_panel.alpha = 30;

    if (activated_button == 1) { save_pic_1_panel.alpha = 100; }
    if (activated_button == 2) { save_pic_2_panel.alpha = 100; }
    if (activated_button == 3) { save_pic_3_panel.alpha = 100; }
    if (activated_button == 4) { save_pic_4_panel.alpha = 100; }
  }

  if(mode == 4)
  {
    Eesy_normal_txt.visible = ON;
    normal_normal_txt.visible = ON;
    hard_normal_txt.visible = ON;

    default_normal_options_txt.visible = ON;
    return_normal_options_txt.visible = ON;
    mouse_sens_front_panel.visible = ON;

    mouse_sens_front_panel.pos_x = mouse_sens_back_panel.pos_x + (mouse_sensivity * 2);

    if(difficulty == 1) { Eesy_activated_txt.visible = ON; normal_activated_txt.visible = OFF; hard_activated_txt.visible = OFF; }
    if(difficulty == 2) { normal_activated_txt.visible = ON; Eesy_activated_txt.visible = OFF; hard_activated_txt.visible = OFF; }
    if(difficulty == 3) { hard_activated_txt.visible = ON; Eesy_activated_txt.visible = OFF; normal_activated_txt.visible = OFF; }

    if(intro == 1) { Intro_Yes_txt.visible = ON; Intro_No_txt.visible = OFF; }
    if(intro == 0) { Intro_Yes_txt.visible = OFF; Intro_No_txt.visible = ON; }

    if(invert_mouse == 1) { invert_mouse_Yes_txt.visible = OFF; invert_mouse_No_txt.visible = ON; }
    if(invert_mouse == -1) { invert_mouse_Yes_txt.visible = ON; invert_mouse_No_txt.visible = OFF; }

    str_for_num (sound_number_str, sound_fx);
    str_for_num (music_number_str, sound_music);

    if(activated_button == 7) { default_normal_options_txt.visible = OFF; default_activated_options_txt.visible = ON; }
    if(activated_button == 8) { return_normal_options_txt.visible = OFF; return_activated_options_txt.visible = ON; }
  }  
}

//_________________________________Controles the keyboard___________________________________________________//

FUNCTION movement_menu()
{ 
  VAR pressed_cud = 0;
  VAR pressed_cuu = 0;
  VAR pressed_cur = 0;
  VAR pressed_cul = 0;
  VAR pressed_enter = 0;
  VAR pressed_esc = 0;
  allow_menu = 1;
  automatic_scrolling_time = temp_scrolling_time;

  while(allow_menu)
  {

    if(key_cud && pressed_cud == 0)
    {
      snd_play(click_snd, sound_fx, 0);
      press_cud(menu_status);
      pressed_cud = 1;
      automatic_scrolling_time = temp_scrolling_time;
    }

    if(key_cuu && pressed_cuu == 0)
    {
      snd_play(click_snd, sound_fx, 0);
      press_cuu(menu_status);
      pressed_cuu = 1;
      automatic_scrolling_time = temp_scrolling_time;
    }

    if(key_cul && pressed_cul == 0)
    {
      snd_play(click_snd, sound_fx, 0);
      press_cul(menu_status);
      pressed_cul = 1;
      automatic_scrolling_time = temp_scrolling_time;
    }

    if(key_cur && pressed_cur == 0)
    {
      snd_play(click_snd, sound_fx, 0);
      press_cur(menu_status);
      pressed_cur = 1;
      automatic_scrolling_time = temp_scrolling_time;
    }

    if(key_enter && pressed_enter == 0)
    {
      while(key_enter == 1) { wait(1); }

      activate_button(menu_status);
      pressed_enter = 1;
    }

    // You are in normal main-Menu:
    if(key_esc && ingame_now && pressed_esc == 0 && menu_status == 1)
    {
      while(key_esc == 1) { wait(1); }

      close_menu(1);
      black_panel.visible = OFF;
      allow_player_movement = 1;
      allow_menu = 0;
    }

    // You are in Save-Menu:
    if((key_esc &&  pressed_esc == 0) && (menu_status == 2 || menu_status == 3 || menu_status == 4))
    {
      while(key_esc == 1) { wait(1); }

      close_menu(menu_status);

      if(menu_status == 2)
      {
        activated_button = 4;
      }

      if(menu_status == 3)
      {
        activated_button = 3;
      }

      if(menu_status == 4)
      {
        activated_button = 5;
      }

      menu_status = 1;

      arrow_panel.pos_x = button_pos_x[activated_button - 1] - distance_arrow_button_X;
      arrow_panel.pos_y = button_pos_y[activated_button - 1] + distance_arrow_button_Y;

      check_for_changes(menu_status);
    }

    if(key_cud == 0) { pressed_cud = 0;}
    if(key_cuu == 0) { pressed_cuu = 0;}
    if(key_cur == 0) { pressed_cur = 0;}
    if(key_cul == 0) { pressed_cul = 0;}
    if(key_enter == 0) { pressed_enter = 0; }
    if(key_esc == 0) { pressed_esc = 0; }

    if(key_cud == 1 && automatic_scrolling == 1) 
    { 
      automatic_scrolling_time -= 1 * TIME;
      if(automatic_scrolling_time <= 0)
      {
        pressed_cud = 0; 
      }
    }

    if(key_cuu == 1 && automatic_scrolling == 1) 
    { 
      automatic_scrolling_time -= 1 * TIME;
      if(automatic_scrolling_time <= 0)
      {
        pressed_cuu = 0; 
      }
    }

    if(key_cur == 1 && automatic_scrolling == 1) 
    { 
      automatic_scrolling_time -= 1 * TIME;
      if(automatic_scrolling_time <= 0)
      {
        pressed_cur = 0; 
      }
    }

    if(key_cul == 1 && automatic_scrolling == 1) 
    { 
      automatic_scrolling_time -= 1 * TIME;
      if(automatic_scrolling_time <= 0)
      {
        pressed_cul = 0; 
      }
    }

    wait(1);
  }
}

//_________________________________The event of the cursor up___________________________________________________//

FUNCTION press_cuu(mode)
{

  if(mode == 1)
  {
    if((activated_button == 1 && ingame_now) || (activated_button == 2 && ingame_now == 0)) 
    { 
      if(allow_new_scrolling == 1)
      {
          activated_button = 8; 
      }
      else
      {
        return;
      }
    }
  }

  if(mode == 2 || mode == 3)
  {
    if(activated_button == 1 || activated_button == 2) 
    { 
      if(allow_new_scrolling == 1)
      {
        activated_button += 4;
      }
      else
      {
        return;
      }
    }
  }

  if(mode == 4)
  {
    if(activated_button == 1) 
    { 
      if(allow_new_scrolling == 1)
      {
        activated_button = 9;
      }
      else
      {
        return;
      }
    }
  }

  if(mode == 1)
  {
    activated_button -= 1;
    arrow_panel.pos_x = button_pos_x[activated_button - 1] - distance_arrow_button_X;
    arrow_panel.pos_y = button_pos_y[activated_button - 1] + distance_arrow_button_Y;
  }

  if(mode == 2 || mode == 3)
  {
    activated_button -= 2;
    arrow_panel.pos_x = pic_pos_x[activated_button - 1] - distance_arrow_pic_x;
    arrow_panel.pos_y = pic_pos_y[activated_button - 1] + distance_arrow_pic_y;
  }

  if(mode == 4)
  { 
    activated_button -= 1;
    arrow_panel.pos_x = options_pos_x[activated_button - 1] - distance_arrow_options_x;
    arrow_panel.pos_y = options_pos_y[activated_button - 1] + distance_arrow_options_y; 
  }   

  check_for_changes(menu_status);
}

//_________________________________The event of the cursor down___________________________________________________//

FUNCTION press_cud(mode)
{

  if(mode == 1)
  {
    if(activated_button == 7) 
    { 
      if(allow_new_scrolling == 1)
      {
        if(ingame_now)
        {
          activated_button = 0;
        }
        else
        {
          activated_button = 1;
        }
      }
      else
      {
        return;
      }
    }
  }

  if(mode == 2 || mode == 3)
  {
    if(activated_button == 3 || activated_button == 4) 
    { 
      if(allow_new_scrolling == 1)
      {
        activated_button -= 4;
      }
      else
      {
        return;
      }
    }
  }

  if(mode == 4)
  {
    if(activated_button == 8) 
    { 
      if(allow_new_scrolling == 1)
      {
        activated_button = 0;
      }
      else
      {
        return;
      }
    }
  }

  if(mode == 1)
  {
    activated_button += 1;
    arrow_panel.pos_x = button_pos_x[activated_button - 1] - distance_arrow_button_X;
    arrow_panel.pos_y = button_pos_y[activated_button - 1] + distance_arrow_button_Y;
  }

  if(mode == 2 || mode == 3)
  {
    activated_button += 2;
    arrow_panel.pos_x = pic_pos_x[activated_button -1] - distance_arrow_pic_x;
    arrow_panel.pos_y = pic_pos_y[activated_button -1] + distance_arrow_pic_y;
  }

  if(mode == 4)
  { 
    activated_button += 1;
    arrow_panel.pos_x = options_pos_x[activated_button - 1] - distance_arrow_options_x;
    arrow_panel.pos_y = options_pos_y[activated_button - 1] + distance_arrow_options_y; 
  } 

  check_for_changes(menu_status);
}

//_________________________________The event of the cursor right___________________________________________________//

FUNCTION press_cur(mode)
{
  if(mode == 2 || mode == 3)
  {
    if(activated_button == 2 || activated_button == 4) 
    { 
      if(allow_new_scrolling == 1)
      {
        activated_button -= 2;
      }
      else
      {
        return;
      }
    }

    activated_button += 1;
    arrow_panel.pos_x = pic_pos_x[activated_button -1] - distance_arrow_pic_x;
    arrow_panel.pos_y = pic_pos_y[activated_button -1] + distance_arrow_pic_y;
  }

  if(mode == 4)
  {
    if(activated_button == 1)
    {
      if(difficulty >= 3 && allow_new_scrolling == 1) { difficulty = 0; }    
      if(difficulty >= 3 && allow_new_scrolling == 0) { return; }

      difficulty += 1;
    }

    if(activated_button == 2)
    {
      if(intro == 1) { intro = 0; } else { intro = 1; }
    }

    if(activated_button == 3)
    {
      if(invert_mouse == 1) { invert_mouse = -1; }
      else { invert_mouse = 1;}
    }

    if(activated_button == 4)
    {
      if(sound_fx <= 99) { sound_fx += 1; }
    }

    if(activated_button == 5)
    {
      if(sound_music <= 99) { sound_music += 1; }
    }

    if(activated_button == 6)
    {
      if(mouse_sensivity <= 63) { mouse_sensivity += 1; }
    }
  }

  check_for_changes(menu_status);
}

//_________________________________The event of the cursor left___________________________________________________//

FUNCTION press_cul(mode)
{
  if(mode == 2 || mode == 3)
  {
    if(activated_button == 1 || activated_button == 3) 
    { 
      if(allow_new_scrolling == 1)
      {
        activated_button += 2;
      }
      else
      {
        return;
      }
    }

    activated_button -= 1;
    arrow_panel.pos_x = pic_pos_x[activated_button -1] - distance_arrow_pic_x;
    arrow_panel.pos_y = pic_pos_y[activated_button -1] + distance_arrow_pic_y;
  }


  if(mode == 4)
  {
    if(activated_button == 1)
    {
      if(difficulty <= 1 && allow_new_scrolling == 1) { difficulty = 4; }    
      if(difficulty <= 1 && allow_new_scrolling == 0) { return; }

      difficulty -= 1;
    }

    if(activated_button == 2)
    {
      if(intro == 1) { intro = 0; } else { intro = 1; }
    }

    if(activated_button == 3)
    {
      if(invert_mouse == 1) { invert_mouse = -1; }
      else { invert_mouse = 1;}
    }

    if(activated_button == 4)
    {
      if(sound_fx >= 1) { sound_fx -= 1; }
    }

    if(activated_button == 5)
    {
      if(sound_music >= 1) { sound_music -= 1; }
    }

    if(activated_button == 6)
    {
      if(mouse_sensivity >= 1) { mouse_sensivity -= 1; }
    }

  }

  check_for_changes(menu_status);
}

//_________________________________This function loads first level___________________________________________________//

FUNCTION load_first_level()
{
  allow_menu = 0;  // don't allow to use the menu

  current_level = 1;

  close_menu(1);

  load_level(first_lvl);
  wait(2);  // had to remove it --> i don't know why
}

//_________________________________Opens the load or save menu___________________________________________________//

FUNCTION load_save_game(mode)
{ 
  close_menu(0);

  if(mode == 1)
  {
    menu_status = 2;
  }
  else
  {
    menu_status = 3;
  }

  activated_button = 1;

  check_for_changes(menu_status);
 
  save_pic_1_panel.visible = ON;
  save_pic_2_panel.visible = ON;
  save_pic_3_panel.visible = ON;
  save_pic_4_panel.visible = ON; 

  save_name_1_text.visible = ON;
  save_name_2_text.visible = ON;
  save_name_3_text.visible = ON;
  save_name_4_text.visible = ON;

  name_1_text.visible = ON;
  name_2_text.visible = ON;
  name_3_text.visible = ON;
  name_4_text.visible = ON;

  date_1_text.visible = ON;
  date_2_text.visible = ON;
  date_3_text.visible = ON;
  date_4_text.visible = ON;

  save_date_1_text.visible = ON;
  save_date_2_text.visible = ON;
  save_date_3_text.visible = ON;
  save_date_4_text.visible = ON;

  time_1_text.visible = ON;
  time_2_text.visible = ON;
  time_3_text.visible = ON;
  time_4_text.visible = ON;

  save_time_1_text.visible = ON;
  save_time_2_text.visible = ON;
  save_time_3_text.visible = ON;
  save_time_4_text.visible = ON; 

  level_1_text.visible = ON;
  level_2_text.visible = ON;
  level_3_text.visible = ON;
  level_4_text.visible = ON;

  save_level_1_text.visible = ON;
  save_level_2_text.visible = ON;
  save_level_3_text.visible = ON;
  save_level_4_text.visible = ON; 
 
  arrow_panel.pos_x = pic_pos_x[activated_button - 1] - distance_arrow_pic_x;
  arrow_panel.pos_y = pic_pos_y[activated_button - 1] + distance_arrow_pic_y;
}

//_________________________________Shows the credits___________________________________________________//

FUNCTION show_credits()
{
  allow_menu = 0;  // don't allow to use the menu

  close_menu(1);

  Credits_txt.pos_x = 200;
  Credits_txt.pos_y = 600;
  Credits_txt.Visible = ON;

  while(key_esc == 0)
  {

    if(Credits_txt.Pos_y <= -800) { Credits_txt.pos_y = 600; } // Repeat until the player escapes 

    Credits_txt.pos_y -= credits_speed * TIME;

    wait(1);
  }

  while(key_esc == 1) { Wait(1); }

  Credits_txt.Visible = OFF;

  menu();

}

//_________________________________Shows the options___________________________________________________//

FUNCTION show_options()
{
  menu_status = 4;

  close_menu(0);

  activated_button = 1;

  difficulty_options_txt.visible = ON;
  intro_options_txt.visible = ON;
  invert_mouse_options_txt.visible = ON;
  sound_options_txt.visible = ON;
  sound_number_options_txt.visible = ON;
  music_options_txt.visible = ON;
  music_number_options_txt.visible = ON;
  mouse_sensivity_options_txt.visible = ON;
  mouse_sens_back_panel.visible = ON;

  check_for_changes(menu_status);
  
  arrow_panel.pos_x = options_pos_x[activated_button - 1] - distance_arrow_options_x;
  arrow_panel.pos_y = options_pos_y[activated_button - 1] + distance_arrow_options_y;
}

//_________________________________Controls the enter event___________________________________________________//

FUNCTION activate_button(mode)
{
  if(activated_button == 1 && mode == 1 && ingame_now) 
  {       
    close_menu(1);
    black_panel.visible = OFF;
    allow_player_movement = 1;
    allow_menu = 0; 
  }        

  if(activated_button == 2 && mode == 1) { load_first_level(); }        // Include here your Function to start the first level  
  if(activated_button == 3 && mode == 1 && ingame_now) { load_save_game(2); }        // Save game       
  if(activated_button == 4 && mode == 1) { load_save_game(1); }          // Include here your Function to show a level load panel   
  if(activated_button == 5 && mode == 1) { show_options(); }                    // Include here your Function to show an Options panel 
  if(activated_button == 6 && mode == 1) { show_credits(); }            // Include here your Function to show the Credits panel 
  if(activated_button == 7 && mode == 1) { exit; }

  if(activated_button == 1 && mode == 2) { result = game_load("save_game",1); if (result <= 0) { return; } }
  if(activated_button == 2 && mode == 2) { result = game_load("save_game",2); if (result <= 0) { return; } }
  if(activated_button == 3 && mode == 2) { result = game_load("save_game",3); if (result <= 0) { return; } }
  if(activated_button == 4 && mode == 2) { result = game_load("save_game",4); if (result <= 0) { return; } }

  if(activated_button == 8 && mode == 4) 
  { 
    close_menu(4); 
    menu_status = 1;

    activated_button = 5;

    arrow_panel.pos_x = button_pos_x[activated_button - 1] - distance_arrow_button_X;
    arrow_panel.pos_y = button_pos_y[activated_button - 1] + distance_arrow_button_Y;

    check_for_changes(menu_status); 
  }

  if(activated_button == 7 && mode == 4) 
  { 
    difficulty = 2; 
    sound_fx = 50;
    sound_music = 50;
    intro = 0;
    invert_mouse = 1;
    mouse_sensivity = 8;
    check_for_changes(menu_status);
  }

  if(mode == 3) 
  {  

    if(activated_button == 1)
    {
      inkey(save_name_1);
      str_for_num(save_date_1, sys_month); 
      str_cat(save_date_1, "."); 
      str_for_num(temp_string, sys_day);
      str_cat(save_date_1,temp_string);
      str_cat(save_date_1, "."); 
      str_for_num(temp_string, sys_year);
      str_cat(save_date_1,temp_string);

      str_for_num(save_time_1, sys_hours); 
      str_cat(save_time_1, "."); 
      str_for_num(temp_string, sys_minutes);
      str_cat(save_time_1,temp_string);

      str_for_num(save_level_1, current_level); 
    }

    if(activated_button == 2)
    {
      inkey(save_name_2);
      str_for_num(save_date_2, sys_month); 
      str_cat(save_date_2, "."); 
      str_for_num(temp_string, sys_day);
      str_cat(save_date_2,temp_string);
      str_cat(save_date_2, "."); 
      str_for_num(temp_string, sys_year);
      str_cat(save_date_2,temp_string);

      str_for_num(save_time_2, sys_hours); 
      str_cat(save_time_2, "."); 
      str_for_num(temp_string, sys_minutes);
      str_cat(save_time_2,temp_string);

      str_for_num(save_level_2, current_level); 
    }

    if(activated_button == 3)
    {
      inkey(save_name_3);
      str_for_num(save_date_3, sys_month); 
      str_cat(save_date_3, "."); 
      str_for_num(temp_string, sys_day);
      str_cat(save_date_3,temp_string);
      str_cat(save_date_3, "."); 
      str_for_num(temp_string, sys_year);
      str_cat(save_date_3,temp_string);

      str_for_num(save_time_3, sys_hours); 
      str_cat(save_time_3, "."); 
      str_for_num(temp_string, sys_minutes);
      str_cat(save_time_3,temp_string);

      str_for_num(save_level_3, current_level); 
    }

    if(activated_button == 4)
    {
      inkey(save_name_4);
      str_for_num(save_date_4, sys_month); 
      str_cat(save_date_4, "."); 
      str_for_num(temp_string, sys_day);
      str_cat(save_date_4,temp_string);
      str_cat(save_date_4, "."); 
      str_for_num(temp_string, sys_year);
      str_cat(save_date_4,temp_string);

      str_for_num(save_time_4, sys_hours); 
      str_cat(save_time_4, "."); 
      str_for_num(temp_string, sys_minutes);
      str_cat(save_time_4,temp_string);

      str_for_num(save_level_4, current_level); 
    }



    if(result == 27)
    {
      return;
    }

    allow_menu = 0; 

    if(result == 13)
    {
      inkey_active = 0;
      close_menu(1);
      black_panel.visible = OFF;

      close_menu(2);

      wait(2);  
      allow_player_movement = 1;

      if(activated_button == 1)
      {
        bmap_for_screen(save_pic_1_pcx,5,0);
        wait(1);
        game_save("save_pic", 0, SV_BMAPS+SV_STRINGS);

        game_save("save_game",1,SV_ALL-SV_INFO);
      }

      if(activated_button == 2)
      {
        bmap_for_screen(save_pic_2_pcx,5,0);
        wait(1);
        game_save("save_pic", 0, SV_BMAPS+SV_STRINGS);

        game_save("save_game",2,SV_ALL-SV_INFO);
      }

      if(activated_button == 3)
      {
        bmap_for_screen(save_pic_3_pcx,5,0);
        wait(1);
        game_save("save_pic", 0, SV_BMAPS+SV_STRINGS);

        game_save("save_game",3,SV_ALL-SV_INFO);
      }

      if(activated_button == 4)
      {
        bmap_for_screen(save_pic_4_pcx,5,0);
        wait(1);
        game_save("save_pic", 0, SV_BMAPS+SV_STRINGS);

        game_save("save_game",4,SV_ALL-SV_INFO);
      }

    }
  }

}
