//_________________________________Fade out the black screen___________________________________________________//

FUNCTION fade_out_black()
{
  black_panel.Alpha = 100;

  while(black_panel.alpha >= 0)
  {
    black_panel.alpha -= fade_time * TIME;
    wait(1);
  }

  black_panel.visible = OFF;
  allow_player_movement = 1;  // now the player can move
}

//_________________________________This function controles the camera settings_________________________________//

FUNCTION check_player_cam()
{
  Camera.X = player.X;
  Camera.Y = player.Y;
  Camera.Z = player.Z;
  Camera.PAN = player.PAN;
  Camera.TILT += mouse_force.Y * mouse_sensivity * TIME * invert_mouse;
  Camera.ROLL = player.ROLL;
}

//_________________________________The Function of the player event(Level-Load)________________________________//

FUNCTION player_event()
{
  if(event_type == event_entity)
  {
    if(current_level == 1) { current_level = 2; }
    wait(1);

    load_level(sec_lvl);
    wait(2);
  }
}

//_________________________________The Function of the player itself__________________________________________//

ACTION the_player
{
  player = me;
  var force[3];

  my.enable_entity = ON;
  my.event = player_event;

  check_player_cam();
  
  fade_out_black();

  ingame_now = 1;

  while(1)
  {

    if(allow_player_movement)
    {

      PLAYER.PAN -= mouse_force.X * mouse_sensivity * TIME; 

      force.X = key_force.Y * player_force * TIME;
      force.Y = -key_force.X * player_force * TIME;
      force.Z = 0;

      move_mode = glide;
      ENT_MOVE(force,nullvector);

      check_player_cam();

      // activate the menu with esc:
      if(key_esc)
      {
        while(key_esc) { wait(1); }  

        allow_player_movement = 0;
        activated_button = 1;
        menu_status = 1;

        menu();
      }

    }

   wait(1);
   }
}

//_________________________________The Function of the entity to change the level_____________________________//

ACTION change_level
{
  while(1)
  {
    my.pan += 3 * TIME;
    
    wait(1);
  }
}