float4x4 matWorldViewProj;

struct VS_OUTPUT
{
	float4 Pos   : POSITION;
	float2 Tex   : TEXCOORD0;
};

VS_OUTPUT mainVS( float4 Pos      : POSITION,
float2 Tex      : TEXCOORD0 )
{
	VS_OUTPUT Out = (VS_OUTPUT) 0; 
	Out.Pos = mul(Pos,matWorldViewProj );
	Out.Tex = Tex;
	return Out;
}

texture mtlSkin1;

sampler basemap = sampler_state
{
   Texture = <mtlSkin1>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = clamp;
   AddressV  = clamp;
};


// Simple blur filter
float4 mainPS(float2 Tex: TEXCOORD0) : COLOR {

  //float4 darken={0.025,0.02,0.02,1};
  float4 darken={0.025,0.025,0.025,1};

  float4 Color=0;
  
  float2 tap1 = {Tex.x+0.008,Tex.y-0.008};
  float2 tap2 = {Tex.x-0.008,Tex.y+0.008};
  float2 tap3 = {Tex.x+0.008,Tex.y+0.008};
  float2 tap4 = {Tex.x-0.008,Tex.y-0.008};
  
  float2 tap5 = {Tex.x+0.008,Tex.y};
  float2 tap6 = {Tex.x-0.008,Tex.y};
  float2 tap7 = {Tex.x,Tex.y+0.008};
  float2 tap8 = {Tex.x,Tex.y-0.008};
  
  float2 tap9 = {Tex.x+0.016,Tex.y-0.016};
  float2 tap10 = {Tex.x-0.016,Tex.y+0.016};
  float2 tap11 = {Tex.x+0.016,Tex.y+0.016};
  float2 tap12 = {Tex.x-0.016,Tex.y-0.016};
  
  float2 tap13 = {Tex.x+0.016,Tex.y};
  float2 tap14 = {Tex.x-0.016,Tex.y};
  float2 tap15 = {Tex.x,Tex.y+0.016};
  float2 tap16 = {Tex.x,Tex.y-0.016};
  
  float2 tap17 = {Tex.x+0.032,Tex.y-0.032};
  float2 tap18 = {Tex.x-0.032,Tex.y+0.032};
  float2 tap19 = {Tex.x+0.032,Tex.y+0.032};
  float2 tap20 = {Tex.x-0.032,Tex.y-0.032};
  
  float2 tap21 = {Tex.x+0.032,Tex.y};
  float2 tap22 = {Tex.x-0.032,Tex.y};
  float2 tap23 = {Tex.x,Tex.y+0.032};
  float2 tap24 = {Tex.x,Tex.y-0.032};
  
  Color = tex2D( basemap, Tex.xy);

  Color += tex2D( basemap, tap1);
  Color += tex2D( basemap, tap2);
  Color += tex2D( basemap, tap3);
  Color += tex2D( basemap, tap4);
  
  Color += tex2D( basemap, tap5);
  Color += tex2D( basemap, tap6);
  Color += tex2D( basemap, tap7);
  Color += tex2D( basemap, tap8);
  
  Color += tex2D( basemap, tap9);
  Color += tex2D( basemap, tap10);
  Color += tex2D( basemap, tap11);
  Color += tex2D( basemap, tap12);
  
  Color += tex2D( basemap, tap13);
  Color += tex2D( basemap, tap14);
  Color += tex2D( basemap, tap15);
  Color += tex2D( basemap, tap16);
  
  Color += tex2D( basemap, tap17);
  Color += tex2D( basemap, tap18);
  Color += tex2D( basemap, tap19);
  Color += tex2D( basemap, tap20);
  
  Color += tex2D( basemap, tap21);
  Color += tex2D( basemap, tap22);
  Color += tex2D( basemap, tap23);
  Color += tex2D( basemap, tap24);
  
  float cutoff=8;

  if (Color.r < cutoff && Color.g < cutoff && Color.b < cutoff)
  		{Color-=((cutoff/Color))*0.3;}
  		
//  if (Color.r > cutoff && Color.g > cutoff && Color.b > cutoff)
//  		{Color+=((Color*0.1);}

 // return ((Color)*darken)*0.5; //0.6
 return ((Color)*darken)*0.5; 
 
}

technique blur
{

	pass Object
	{
		alphablendenable=true;
		srcblend=destalpha;
		destblend=srcalpha;
		ZENABLE = TRUE;
		VertexShader = compile vs_1_1 mainVS();
		PixelShader = compile ps_2_0 mainPS();
	}

}