// -------------------------------------------------------------
// Diffuse and specular shader for world geometry
// -------------------------------------------------------------
//this is a 3 pass shader  rendering 3 lights in each pass,3 rd pass has the last light

float4x4 matWorldViewProj;	
float4x4 matWorld;
float4 vecLightPos[8]; //light position
float4 vecLightColor[8]; //light position
float4 vecViewPos;

texture entSkin1; //this is the color map
texture mtlSkin1; //this is the normal map..define in your shader defs

sampler ColorMapSampler = sampler_state
{
   Texture = <entSkin1>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = wrap;
   AddressV  = wrap;
};


sampler BumpMapSampler = sampler_state
{
   Texture = <mtlSkin1>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = wrap;
   AddressV  = wrap;
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//first pass
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// -------------------------------------------------------------
// Output channels
// -------------------------------------------------------------
struct VS_OUTPUT0
{
    float4 Pos  : POSITION;
    float2 Tex : TEXCOORD0;
   
    float3 Light1 : TEXCOORD2;
    float3 View1 : TEXCOORD3;
    float3 Att1 : TEXCOORD4;
    
    float3 Light2 : TEXCOORD5;
    float3 View2 : TEXCOORD6;
    float3 Att2 : TEXCOORD7;
};

// -------------------------------------------------------------
// vertex shader function (input channels)
// -------------------------------------------------------------
VS_OUTPUT0 VS_PASS0(float4 Pos : POSITION, float2 texcoord0 : TEXCOORD0, float3 Normal : NORMAL, float3 Tangent : TEXCOORD0  )
{
    VS_OUTPUT0 Out = (VS_OUTPUT0)0;      
    Out.Pos = mul(Pos, matWorldViewProj);	// transform Position
    
    // compute the 3x3 tranform matrix 
    // to transform from world space to tangent space
    float3x3 worldToTangentSpace;
    worldToTangentSpace[0] = mul(Tangent, matWorld);
    worldToTangentSpace[1] = mul(cross(Tangent, Normal), matWorld);
    worldToTangentSpace[2] = mul(Normal, matWorld);
        
    Out.Tex = texcoord0.xy;

 	 float3 PosWorld = mul(Pos, matWorld);
	 float LightRange = 0.00001; 

	//light 1	 
    float3 Light1 = PosWorld - vecLightPos[1]  ; 
    Out.Light1.xyz = mul(worldToTangentSpace, -Light1);	// L

    float3 Viewer1 = PosWorld - vecViewPos;						
    Out.View1 = mul(worldToTangentSpace, -Viewer1);		// V
       
    Out.Att1 = Light1 * LightRange;				// Point light
    
    //light 2	 
    float3 Light2 = PosWorld - vecLightPos[2]  ; 
    Out.Light2.xyz = mul(worldToTangentSpace, -Light2);	// L

    float3 Viewer2 = PosWorld - vecViewPos;						
    Out.View2 = mul(worldToTangentSpace, -Viewer2);		// V
       
    Out.Att2 = Light2 * LightRange;				// Point light
   return Out;
}


struct PS_INPUT0
{
    float2 Tex : TEXCOORD0;
   
    float3 Light1 : TEXCOORD2;
    float3 View1 : TEXCOORD3;
    float3 Att1 : TEXCOORD4;
    
    float3 Light2 : TEXCOORD5;
    float3 View2 : TEXCOORD6;
    float3 Att2 : TEXCOORD7;
};

// -------------------------------------------------------------
// Pixel Shader (input channels):output channel
// -------------------------------------------------------------

 float4 PS_PASS0( PS_INPUT0 psInStruct ):COLOR
{
   
    float4 color = tex2D(ColorMapSampler, psInStruct.Tex);					// fetch color map
    float3 bumpNormal = 2 * (tex2D(BumpMapSampler, psInStruct.Tex) - 0.5); // fetch bump map
	 float4 gloss = tex2D( BumpMapSampler, psInStruct.Tex );
    
    //light1
    float3 LightDir1 = normalize(psInStruct.Light1);
    float3 ViewDir1 = normalize(psInStruct.View1);       
    float4 diff1 = saturate(dot(bumpNormal, LightDir1));    // diffuse component 
    float shadow1 = saturate(4 * diff1);
    float3 Reflect1 = normalize(2 * diff1 * bumpNormal - LightDir1);  // R
    float4 spec1 = pow(saturate(dot(Reflect1, ViewDir1)), 15); 
    float4 Attenuation1 = saturate(dot(psInStruct.Att1, psInStruct.Att1));
    
    //light2
    float3 LightDir2 = normalize(psInStruct.Light2);
    float3 ViewDir2 = normalize(psInStruct.View2);       
    float4 diff2 = saturate(dot(bumpNormal, LightDir2));    // diffuse component 
    float shadow2 = saturate(4 * diff2);
    float3 Reflect2 = normalize(2 * diff2 * bumpNormal - LightDir2);  // R
    float4 spec2 = pow(saturate(dot(Reflect2, ViewDir2)), 15); 
    float4 Attenuation2 = saturate(dot(psInStruct.Att2, psInStruct.Att2));

    return
    (  
       (0.3 * color) + //ambient
	    ((shadow1 * (color * diff1 + (spec1*gloss.w)) * (1 -Attenuation1))*vecLightColor[1])+ 
	    ((shadow2 * (color * diff2 + (spec2*gloss.w)) * (1 -Attenuation2))*vecLightColor[2])
	   
    );	    
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//second pass
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

// -------------------------------------------------------------
// Output channels
// -------------------------------------------------------------
struct VS_OUTPUT1
{
    float4 Pos  : POSITION;
    float2 Tex : TEXCOORD0;
   
    float3 Light3 : TEXCOORD2;
    float3 View3 : TEXCOORD3;
    float3 Att3 : TEXCOORD4;

    float3 Light4 : TEXCOORD5;
    float3 View4: TEXCOORD6;
    float3 Att4 : TEXCOORD7;
};

// -------------------------------------------------------------
// vertex shader function (input channels)
// -------------------------------------------------------------
VS_OUTPUT1 VS_PASS1(float4 Pos : POSITION, float2 texcoord0 : TEXCOORD0, float3 Normal : NORMAL, float3 Tangent : TEXCOORD0  )
{
    VS_OUTPUT1 Out = (VS_OUTPUT1)0;      
    Out.Pos = mul(Pos, matWorldViewProj);	// transform Position
    
    // compute the 3x3 tranform matrix 
    // to transform from world space to tangent space
    float3x3 worldToTangentSpace;
    worldToTangentSpace[0] = mul(Tangent, matWorld);
    worldToTangentSpace[1] = mul(cross(Tangent, Normal), matWorld);
    worldToTangentSpace[2] = mul(Normal, matWorld);
        
    Out.Tex = texcoord0.xy;

 	 float3 PosWorld = mul(Pos, matWorld);
	 float LightRange = 0.009; 
 
    //light 3	 
    float3 Light3 = PosWorld - vecLightPos[3]  ; 
    Out.Light3.xyz = mul(worldToTangentSpace, -Light3);	// L

    float3 Viewer3 = PosWorld - vecViewPos;						
    Out.View3 = mul(worldToTangentSpace, -Viewer3);		// V
       
    Out.Att3 = Light3 * LightRange;				// Point light
  
    
    //light 4	 
    float3 Light4 = PosWorld - vecLightPos[4]  ; 
    Out.Light4.xyz = mul(worldToTangentSpace, -Light4);	// L

    float3 Viewer4 = PosWorld - vecViewPos;						
    Out.View4 = mul(worldToTangentSpace, -Viewer4);		// V
       
    Out.Att4 = Light4 * LightRange;				// Point light
    return Out;
}


struct PS_INPUT1
{
    float2 Tex : TEXCOORD0;
   
    float3 Light3 : TEXCOORD2;
    float3 View3 : TEXCOORD3;
    float3 Att3 : TEXCOORD4;
    
    float3 Light4 : TEXCOORD5;
    float3 View4: TEXCOORD6;
    float3 Att4 : TEXCOORD7;
};

// -------------------------------------------------------------
// Pixel Shader (input channels):output channel
// -------------------------------------------------------------
 float4 PS_PASS1( PS_INPUT1 psInStruct ):COLOR
{
   
    float4 color = tex2D(ColorMapSampler, psInStruct.Tex);					// fetch color map
    float3 bumpNormal = 2 * (tex2D(BumpMapSampler, psInStruct.Tex) - 0.5); // fetch bump map
	 float4 gloss = tex2D( BumpMapSampler, psInStruct.Tex );
     
    //light3
    float3 LightDir3 = normalize(psInStruct.Light3);
    float3 ViewDir3 = normalize(psInStruct.View3);       
    float4 diff3 = saturate(dot(bumpNormal, LightDir3));    // diffuse component 
    float shadow3 = saturate(4 * diff3);
    float3 Reflect3 = normalize(2 * diff3 * bumpNormal - LightDir3);  // R
    float4 spec3 = pow(saturate(dot(Reflect3, ViewDir3)), 15); 
    float4 Attenuation3 = saturate(dot(psInStruct.Att3, psInStruct.Att3));
   
    //light4
    float3 LightDir4 = normalize(psInStruct.Light4);
    float3 ViewDir4 = normalize(psInStruct.View4);       
    float4 diff4 = saturate(dot(bumpNormal, LightDir4));    // diffuse component 
    float shadow4 = saturate(4 * diff4);
    float3 Reflect4 = normalize(2 * diff4 * bumpNormal - LightDir4);  // R
    float4 spec4 = pow(saturate(dot(Reflect4, ViewDir4)), 15); 
    float4 Attenuation4 = saturate(dot(psInStruct.Att4, psInStruct.Att4));

    return
    (  
	    ((shadow3 * (color * diff3 + (spec3*gloss.w)) * (1 -Attenuation3))*vecLightColor[3])+
	    ((shadow4 * (color * diff4 + (spec4*gloss.w)) * (1 -Attenuation4))*vecLightColor[4])
	   

    );	    
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//third pass
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// -------------------------------------------------------------
// Output channels
// -------------------------------------------------------------
struct VS_OUTPUT2
{
    float4 Pos  : POSITION;
    float2 Tex : TEXCOORD0;
   
    float3 Light5 : TEXCOORD2;
    float3 View5 : TEXCOORD3;
    float3 Att5 : TEXCOORD4;
    
    float3 Light6 : TEXCOORD5;
    float3 View6 : TEXCOORD6;
    float3 Att6 : TEXCOORD7;
};

// -------------------------------------------------------------
// vertex shader function (input channels)
// -------------------------------------------------------------
VS_OUTPUT2 VS_PASS2(float4 Pos : POSITION, float2 texcoord0 : TEXCOORD0, float3 Normal : NORMAL, float3 Tangent : TEXCOORD0  )
{
    VS_OUTPUT2 Out = (VS_OUTPUT2)0;      
    Out.Pos = mul(Pos, matWorldViewProj);	// transform Position
    
    // compute the 3x3 tranform matrix 
    // to transform from world space to tangent space
    float3x3 worldToTangentSpace;
    worldToTangentSpace[0] = mul(Tangent, matWorld);
    worldToTangentSpace[1] = mul(cross(Tangent, Normal), matWorld);
    worldToTangentSpace[2] = mul(Normal, matWorld);
        
    Out.Tex = texcoord0.xy;

 	 float3 PosWorld = mul(Pos, matWorld);
	 float LightRange = 0.009; 

	//light 5	 
    float3 Light5 = PosWorld - vecLightPos[5]  ; 
    Out.Light5.xyz = mul(worldToTangentSpace, -Light5);	// L

    float3 Viewer5 = PosWorld - vecViewPos;						
    Out.View5 = mul(worldToTangentSpace, -Viewer5);		// V
       
    Out.Att5 = Light5 * LightRange;				// Point light
    
    //light 6	 
    float3 Light6 = PosWorld - vecLightPos[6]  ; 
    Out.Light6.xyz = mul(worldToTangentSpace, -Light6);	// L

    float3 Viewer6 = PosWorld - vecViewPos;						
    Out.View6 = mul(worldToTangentSpace, -Viewer6);		// V
       
    Out.Att6 = Light6 * LightRange;				// Point light
   return Out;
}


struct PS_INPUT2
{
    float2 Tex : TEXCOORD0;
   
    float3 Light5 : TEXCOORD2;
    float3 View5 : TEXCOORD3;
    float3 Att5 : TEXCOORD4;
    
    float3 Light6 : TEXCOORD5;
    float3 View6 : TEXCOORD6;
    float3 Att6 : TEXCOORD7;
};

// -------------------------------------------------------------
// Pixel Shader (input channels):output channel
// -------------------------------------------------------------

 float4 PS_PASS2( PS_INPUT2 psInStruct ):COLOR
{
   
    float4 color = tex2D(ColorMapSampler, psInStruct.Tex);					// fetch color map
    float3 bumpNormal = 2 * (tex2D(BumpMapSampler, psInStruct.Tex) - 0.5); // fetch bump map
	 float4 gloss = tex2D( BumpMapSampler, psInStruct.Tex );
    
    //light5
    float3 LightDir5 = normalize(psInStruct.Light5);
    float3 ViewDir5 = normalize(psInStruct.View5);       
    float4 diff5 = saturate(dot(bumpNormal, LightDir5));    // diffuse component 
    float shadow5 = saturate(4 * diff5);
    float3 Reflect5 = normalize(2 * diff5 * bumpNormal - LightDir5);  // R
    float4 spec5 = pow(saturate(dot(Reflect5, ViewDir5)), 15); 
    float4 Attenuation5 = saturate(dot(psInStruct.Att5, psInStruct.Att5));
    
    //light2
    float3 LightDir6 = normalize(psInStruct.Light6);
    float3 ViewDir6 = normalize(psInStruct.View6);       
    float4 diff6 = saturate(dot(bumpNormal, LightDir6));    // diffuse component 
    float shadow6 = saturate(4 * diff6);
    float3 Reflect6 = normalize(2 * diff6 * bumpNormal - LightDir6);  // R
    float4 spec6 = pow(saturate(dot(Reflect6, ViewDir6)), 15); 
    float4 Attenuation6 = saturate(dot(psInStruct.Att6, psInStruct.Att6));

    return
    (  
	    ((shadow5 * (color * diff5 + (spec5*gloss.w)) * (1 -Attenuation5))*vecLightColor[5])+ 
	    ((shadow6 * (color * diff6 + (spec6*gloss.w)) * (1 -Attenuation6))*vecLightColor[6])
	   
    );	    
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//fourth pass
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// -------------------------------------------------------------
// Output channels
// -------------------------------------------------------------
struct VS_OUTPUT3
{
    float4 Pos  : POSITION;
    float2 Tex : TEXCOORD0;
   
    float3 Light7 : TEXCOORD2;
    float3 View7 : TEXCOORD3;
    float3 Att7 : TEXCOORD4;

};

// -------------------------------------------------------------
// vertex shader function (input channels)
// -------------------------------------------------------------
VS_OUTPUT3 VS_PASS3(float4 Pos : POSITION, float2 texcoord0 : TEXCOORD0, float3 Normal : NORMAL, float3 Tangent : TEXCOORD0  )
{
    VS_OUTPUT3 Out = (VS_OUTPUT3)0;      
    Out.Pos = mul(Pos, matWorldViewProj);	// transform Position
    
    // compute the 3x3 tranform matrix 
    // to transform from world space to tangent space
    float3x3 worldToTangentSpace;
    worldToTangentSpace[0] = mul(Tangent, matWorld);
    worldToTangentSpace[1] = mul(cross(Tangent, Normal), matWorld);
    worldToTangentSpace[2] = mul(Normal, matWorld);
        
    Out.Tex = texcoord0.xy;

 	 float3 PosWorld = mul(Pos, matWorld);
	 float LightRange = 0.009; 

	//light 7	 
    float3 Light7 = PosWorld - vecLightPos[7]  ; 
    Out.Light7.xyz = mul(worldToTangentSpace, -Light7);	// L

    float3 Viewer7 = PosWorld - vecViewPos;						
    Out.View7 = mul(worldToTangentSpace, -Viewer7);		// V
       
    Out.Att7 = Light7 * LightRange;				// Point light

   return Out;
}


struct PS_INPUT3
{
    float2 Tex : TEXCOORD0;
   
    float3 Light7 : TEXCOORD2;
    float3 View7 : TEXCOORD3;
    float3 Att7 : TEXCOORD4;
};

// -------------------------------------------------------------
// Pixel Shader (input channels):output channel
// -------------------------------------------------------------

 float4 PS_PASS3( PS_INPUT3 psInStruct ):COLOR
{
   
    float4 color = tex2D(ColorMapSampler, psInStruct.Tex);					// fetch color map
    float3 bumpNormal = 2 * (tex2D(BumpMapSampler, psInStruct.Tex) - 0.5); // fetch bump map
	 float4 gloss = tex2D( BumpMapSampler, psInStruct.Tex );
    
    //light7
    float3 LightDir7 = normalize(psInStruct.Light7);
    float3 ViewDir7 = normalize(psInStruct.View7);       
    float4 diff7 = saturate(dot(bumpNormal, LightDir7));    // diffuse component 
    float shadow7 = saturate(4 * diff7);
    float3 Reflect7 = normalize(2 * diff7 * bumpNormal - LightDir7);  // R
    float4 spec7 = pow(saturate(dot(Reflect7, ViewDir7)), 15); 
    float4 Attenuation7 = saturate(dot(psInStruct.Att7, psInStruct.Att7));
    
    return
    (  
	    ((shadow7 * (color * diff7 + (spec7*gloss.w)) * (1 -Attenuation7))*vecLightColor[7])
	 );	    
}


// -------------------------------------------------------------
// techniques//
// -------------------------------------------------------------
technique three_pass
{
    pass P0
    {
    	 alphablendenable=false;
   	 srcblend=zero;
        // compile shaders
        VertexShader = compile vs_2_0 VS_PASS0();
        PixelShader  = compile ps_2_0 PS_PASS0();
    }
   
    pass P1
    {
    	 //blend second pass additively with first 
    	 alphablendenable=true;
   	 srcblend=one;
    	 destblend=one;
    	 
       // compile shaders
       VertexShader = compile vs_2_0 VS_PASS1();
       PixelShader  = compile ps_2_0 PS_PASS1();
    } 
    
        pass P2
    {
    	 //blend second pass additively with first and second 
    	 alphablendenable=true;
   	 srcblend=one;
    	 destblend=one;
    	 
       // compile shaders
       VertexShader = compile vs_2_0 VS_PASS2();
       PixelShader  = compile ps_2_0 PS_PASS2();
    } 
       
        pass P3
    {
    	 //blend second pass additively with first and second 
    	 alphablendenable=true;
   	 srcblend=one;
    	 destblend=one;
    	 
       // compile shaders
       VertexShader = compile vs_2_0 VS_PASS3();
       PixelShader  = compile ps_2_0 PS_PASS3();
    } 
}
  