float4x4 matWorldViewProj; 
float4x4 matWorld; 
float4x4 matViewInv;

float3x3 WldToTan;

float4 vecViewPos;
float4 vecViewDir;

float4 vecLight;
float4 vecLightPos[8];
float4 vecLightColor[8];

texture entSkin1;
texture mtlSkin2;
texture mtlSkin3;

sampler sColorMap = sampler_state
{
Texture = <entSkin1>;
MinFilter = Linear;
MagFilter = Linear;
MipFilter = Linear; 
AddressU = Wrap;
AddressV = Wrap;
};


sampler sBumpMap = sampler_state
{
Texture = <mtlSkin2>;
MinFilter = Linear;
MagFilter = Linear;
MipFilter = Linear; 
AddressU = Wrap;
AddressV = Wrap;
};


sampler sHeightMap = sampler_state
{
Texture = <mtlSkin3>;
MinFilter = Linear;
MagFilter = Linear;
MipFilter = Linear; 
AddressU = Wrap;
AddressV = Wrap;
};



struct VS_OUTPUT
{
float4 oPosition : POSITION;
float2 Tex : TEXCOORD0;
float3 Light1 : TEXCOORD2;
float3 View1 : TEXCOORD3;
float3 Att1 : TEXCOORD4;

float3 Light2 : TEXCOORD5;
float3 View2 : TEXCOORD6;
float3 Att2 : TEXCOORD7;
};


VS_OUTPUT main_vs(float4 inPosition : POSITION, float2 inTex : TEXCOORD0, float3 inNormal : NORMAL, float3 inTangent : TEXCOORD2 )
{
VS_OUTPUT Out ; 

Out.oPosition = mul(inPosition, matWorldViewProj); 

WldToTan[0] = mul(inTangent, matWorld);
WldToTan[1] = mul(cross(inTangent, inNormal), matWorld);
WldToTan[2] = mul(inNormal, matWorld);

Out.Tex = inTex.xy * 1; //Scale the texture UV's


float4 Pos_World = mul( inPosition, matWorld);

float LightRange1 = 0.003;
float LightRange2 = 0.003; 

//light 1 
float3 Light1 = Pos_World - vecLightPos[1]; 
Out.Light1.xyz = mul(WldToTan, -Light1); 

float3 Viewer1 = Pos_World - vecViewDir; 
Out.View1.xzy = mul(WldToTan, -Viewer1); 

Out.Att1 = Light1 * LightRange1; 
//light 2 
float3 Light2 = Pos_World - vecLightPos[2]; 
Out.Light2.xyz = mul(WldToTan, -Light2); 

float3 Viewer2 = Pos_World - vecViewDir; 
Out.View2.xzy = mul(WldToTan, -Viewer2); 

Out.Att2 = Light2 * LightRange2; 

return Out;
}

struct PS_INPUT0
{
float2 Tex : TEXCOORD0;
float3 Light1 : TEXCOORD2;
float3 View1 : TEXCOORD3;
float3 Att1 : TEXCOORD4;
float3 Light2 : TEXCOORD5;
float3 View2 : TEXCOORD6;
float3 Att2 : TEXCOORD7;

}; 

float4 main_ps(PS_INPUT0 IN): COLOR
{
const float HeightScale = {0.030000f};
const float BiasFilter = {0.025000f};



float3 ViewDir = normalize(IN.View1);
float4 color;
float3 bumpNormal; 

float Height = HeightScale * tex2D(sHeightMap, IN.Tex) - BiasFilter; 
float2 OffsetTex = Height * ViewDir + IN.Tex; 
color = tex2D(sColorMap, OffsetTex); 
bumpNormal =(2 * (tex2D(sBumpMap, OffsetTex )))- 1.0; 
float4 gloss = tex2D( sBumpMap, OffsetTex);

//light1
float3 LightDir1 = normalize(IN.Light1);
float3 ViewDir1 = normalize(IN.View1); 
float4 diff1 = saturate(dot(bumpNormal, LightDir1)); 
float shadow1 = saturate(2 * diff1);
float3 Reflect1 = normalize(2 * diff1 * bumpNormal - LightDir1); 
float4 spec1 = pow(saturate(dot(Reflect1, ViewDir1)), 8); 
float4 Attenuation1 = saturate(dot(IN.Att1, IN.Att1));

//light2
float3 LightDir2 = normalize(IN.Light2);
float3 ViewDir2 = normalize(IN.View2); 
float4 diff2 = saturate(dot(bumpNormal, LightDir2)); 
float shadow2 = saturate(2 * diff2);
float3 Reflect2 = normalize(2 * diff2 * bumpNormal - LightDir2); 
float4 spec2 = pow(saturate(dot(Reflect2,ViewDir2)), 8); 
float4 Attenuation2 = saturate(dot(IN.Att2, IN.Att2));

return ( 
(0.2 * color) + //ambient
((shadow1 * (color * diff1 + (spec1)) * (1 -Attenuation1))*vecLightColor[1])+ 
((shadow2 * (color * diff2 + (spec2)) * (1 -Attenuation2))*vecLightColor[2])
);

//return (0.2 * color + color* diff1 * vecLightColor[1]+diff2 * vecLightColor[2]);

}


technique Parallax
{
pass P0
{

VertexShader = compile vs_2_0 main_vs();
PixelShader = compile ps_2_0 main_ps();
}
}