 /////////////////////////////////////////////////
 //multipass shader for "blurring the shadow
 //based on the WIKI fur shader example
 /////////////////////////////////////////////////
 
        texture mtlSkin1; //should be light grey
        matrix matWorldViewProj;
        matrix matWorld;
        matrix matWorldView;
        vector vecSkill1;
        vector vecSkill41;
        vector vecFog;
			vector vecSunDir;

        technique shadowblur
        {
                pass p0
                {
                        texture[0]=<mtlSkin1>;


                        zWriteEnable=false;
                        alphaBlendEnable=true;
                        
								srcblend=destcolor;
						   	destblend=zero;

                        vertexShaderConstant[0]=<matWorldViewProj>;
                        vertexShaderConstant[4]=<matWorld>;
                        vertexShaderConstant[8]=<matWorldView>;
                        vertexShaderConstant[16]=<vecSkill41>;          // shell_distance, 0, fur_u_scale, fur_v_scale
                        vertexShaderConstant[17]={0.0,0.0,0.0,0.0};     // shell_number
                        vertexShaderConstant[19]=<vecSunDir>;
                        vertexShaderConstant[20]=<vecFog>;
                        vertexShaderConstant[94]=<vecSkill1>;           // first_shell_brightness, brightness_increment, 0, 0
                        vertexShaderConstant[95]={0.5,1.0,2.0,0.0};

                        vertexShader =
   
                        asm
                        {
                                vs.1.1

										  dcl_position  v0
										  dcl_normal    v3
										  dcl_texcoord1 v7 //color uv
                  
                                mov r0,v0
                                mov r1,c16
                                mul r1,r1.x,c17.x               // shell distance * shell number
                                mul r1,r1,v3                    // scale normal
                                add r0.xyz,r0.xyz,r1.xyz        // shell offset (vertex position + scaled normal}

                                m4x4 oPos,r0,c0                 // transform position to clip space
                                mov oT0,v7                      // output uvs
                                
                                            mov r1.w,c20.w                  // r1.w=1
                                dp4 r0,v0,c10                   // distance to camera position
                                add r0,r0,-c20.x                // distance-fog_start
                                mad r0.x,-r0.x,c20.z,r1.w       // 1-(distance-fog_start}*(1/(fog_end-fog_start}}
                                max oFog,r0.x,c95.w           // clamp with custom max value

                        };
                        
                        
                        pixelShader=
                        asm
                        {
                                ps.1.1
                                
                                
                                tex t0 // sample colormap

                                mov r0,t0
    
                        };
                }

                //-----------------------------------------------------------------------------
					
					
                pass p1
                {
                        texture[0]=<mtlSkin1>;


                        zWriteEnable=false;
                        alphaBlendEnable=true;

                        vertexShaderConstant[0]=<matWorldViewProj>;
                        vertexShaderConstant[4]=<matWorld>;
                        vertexShaderConstant[8]=<matWorldView>;
                        vertexShaderConstant[16]=<vecSkill41>;
                        vertexShaderConstant[17]={1.0,0.0,0.0,0.0};
                        vertexShaderConstant[19]=<vecSunDir>;
                        vertexShaderConstant[20]=<vecFog>;
                        vertexShaderConstant[94]=<vecSkill1>;
                        vertexShaderConstant[95]={0.5,1.0,2.0,0.0};

                        vertexShader =

                        asm
                        {
                                vs.1.1
										  dcl_position  v0
										  dcl_normal    v3
										  dcl_texcoord1 v7 //color uv
               
                                mov r0,v0
                                mov r1,c16
                                mul r1,r1.x,c17.x
                                mul r1,r1,v3
                                add r0.xyz,r0.xyz,r1.xyz

                                m4x4 oPos,r0,c0
                                mov oT0,v7
                                
                                            mov r1.w,c20.w                  // r1.w=1
                                dp4 r0,v0,c10                   // distance to camera position
                                add r0,r0,-c20.x                // distance-fog_start
                                mad r0.x,-r0.x,c20.z,r1.w       // 1-(distance-fog_start}*(1/(fog_end-fog_start}}
                                max oFog,r0.x,c95.w           // clamp with custom max value
    
                                
                        };
                        pixelShader=
                        asm
                        {
                                ps.1.1
                 
                                tex t0
   
                             	  mov r0,t0
                        
 
                        };
                }
                
               
                pass p2
                {
                        texture[0]=<mtlSkin1>;
 

                        zWriteEnable=false;
                        alphaBlendEnable=true;

                        vertexShaderConstant[0]=<matWorldViewProj>;
                        vertexShaderConstant[4]=<matWorld>;
                        vertexShaderConstant[8]=<matWorldView>;
                        vertexShaderConstant[16]=<vecSkill41>;
                        vertexShaderConstant[17]={2.0,0.0,0.0,10000};
                        vertexShaderConstant[19]=<vecSunDir>;
                        vertexShaderConstant[20]=<vecFog>;
                        vertexShaderConstant[94]=<vecSkill1>;
                        vertexShaderConstant[95]={0.5,1.0,2.0,0.0};

                        vertexShader =

                        asm
                        {
                                vs.1.1
										  dcl_position  v0
										  dcl_normal    v3
										  dcl_texcoord1 v7 //color uv
                      
                                mov r0,v0
                                mov r1,c16
                                mul r1,r1.x,c17.x
                                mul r1,r1,v3
                                add r0.xyz,r0.xyz,r1.xyz

                                m4x4 oPos,r0,c0
                                mov oT0,v7
                                
                                mov oFog,c17.w

    
                        };
                        pixelShader=
                        asm
                        {
                                ps.1.1
                               
                                tex t0
                                										
                             	   mov r0,t0
                             

                        };
                }
                pass p3
                {
                        texture[0]=<mtlSkin1>;


                        zWriteEnable=false;
                        alphaBlendEnable=true;

                        vertexShaderConstant[0]=<matWorldViewProj>;
                        vertexShaderConstant[4]=<matWorld>;
                        vertexShaderConstant[8]=<matWorldView>;
                        vertexShaderConstant[16]=<vecSkill41>;
                        vertexShaderConstant[17]={3.0,0.0,0.0,10000};
                        vertexShaderConstant[19]=<vecSunDir>;
                        vertexShaderConstant[20]=<vecFog>;
                        vertexShaderConstant[94]=<vecSkill1>;
                        vertexShaderConstant[95]={0.5,1.0,2.0,0.0};

                        vertexShader =
    
                        asm
                        {
                                vs.1.1
										  dcl_position  v0
										  dcl_normal    v3
										  dcl_texcoord1 v7 //color uv
                   
                                mov r0,v0
                                mov r1,c16
                                mul r1,r1.x,c17.x
                                mul r1,r1,v3
                                add r0.xyz,r0.xyz,r1.xyz

                                m4x4 oPos,r0,c0
                                mov oT0,v7
                                
                                mov oFog,c17.w

                        };
                        pixelShader=
                        asm
                        {
                                ps.1.1
                              
                                tex t0
        
                             	   mov r0,t0
                
                        };
                }
                pass p4
                {
                        texture[0]=<mtlSkin1>;
 

                        zWriteEnable=false;
                        alphaBlendEnable=true;

                        vertexShaderConstant[0]=<matWorldViewProj>;
                        vertexShaderConstant[4]=<matWorld>;
                        vertexShaderConstant[8]=<matWorldView>;
                        vertexShaderConstant[16]=<vecSkill41>;
                        vertexShaderConstant[17]={4.0,0.0,0.0,10000};
                        vertexShaderConstant[19]=<vecSunDir>;
                        vertexShaderConstant[20]=<vecFog>;
                        vertexShaderConstant[94]=<vecSkill1>;
                        vertexShaderConstant[95]={0.5,1.0,2.0,0.0};

                        vertexShader =
     
                        asm
                        {
                                vs.1.1
										  dcl_position  v0
										  dcl_normal    v3
										  dcl_texcoord1 v7 //color uv
                      
                                mov r0,v0
                                mov r1,c16
                                mul r1,r1.x,c17.x
                                mul r1,r1,v3
                                add r0.xyz,r0.xyz,r1.xyz

                                m4x4 oPos,r0,c0
                                mov oT0,v7
                                
                                mov oFog,c17.w
 
                        };
                        pixelShader=
                        asm
                        {
                                ps.1.1
                            
                                tex t0
                                										
                             	   mov r0,t0
                             	
                        };
                }
                
                pass p5
                {
                        texture[0]=<mtlSkin1>;
   

                        zWriteEnable=false;
                        alphaBlendEnable=true;

                        vertexShaderConstant[0]=<matWorldViewProj>;
                        vertexShaderConstant[4]=<matWorld>;
                        vertexShaderConstant[8]=<matWorldView>;
                        vertexShaderConstant[16]=<vecSkill41>;
                        vertexShaderConstant[17]={5.0,0.0,0.0,10000};
                        vertexShaderConstant[19]=<vecSunDir>;
                        vertexShaderConstant[20]=<vecFog>;
                        vertexShaderConstant[94]=<vecSkill1>;
                        vertexShaderConstant[95]={0.5,1.0,2.0,0.0};

                        vertexShader =

                        asm
                        {
                                vs.1.1
										  dcl_position  v0
										  dcl_normal    v3
										  dcl_texcoord1 v7 //color uv
                   
                                mov r0,v0
                                mov r1,c16
                                mul r1,r1.x,c17.x
                                mul r1,r1,v3
                                add r0.xyz,r0.xyz,r1.xyz

                                m4x4 oPos,r0,c0
                                mov oT0,v7
                                
                                mov oFog,c17.w

                        };
                        pixelShader=
                        asm
                        {
                                ps.1.1
                                
                                tex t0
                                										
                             	   mov r0,t0
                             	
                        };
                }
                pass p6
                {
                        texture[0]=<mtlSkin1>;
    

                        zWriteEnable=false;
                        alphaBlendEnable=true;

                        vertexShaderConstant[0]=<matWorldViewProj>;
                        vertexShaderConstant[4]=<matWorld>;
                        vertexShaderConstant[8]=<matWorldView>;
                        vertexShaderConstant[16]=<vecSkill41>;
                        vertexShaderConstant[17]={6.0,0.0,0.0,10000};
                        vertexShaderConstant[19]=<vecSunDir>;
                        vertexShaderConstant[20]=<vecFog>;
                        vertexShaderConstant[94]=<vecSkill1>;
                        vertexShaderConstant[95]={0.5,1.0,2.0,0.0};

                        vertexShader =
     
                        asm
                        {
                                vs.1.1
										  dcl_position  v0
										  dcl_normal    v3
										  dcl_texcoord1 v7 //color uv
                  
                                mov r0,v0
                                mov r1,c16
                                mul r1,r1.x,c17.x
                                mul r1,r1,v3
                                add r0.xyz,r0.xyz,r1.xyz

                                m4x4 oPos,r0,c0
                                mov oT0,v7
                                
                                mov oFog,c17.w

                        };
                        pixelShader=
                        asm
                        {
                                ps.1.1
                            
                                tex t0
                                										
                             	   mov r0,t0
              
                        };
                }
               
        }