var video_mode = 8;	 // screen size 640x480
var video_depth = 32; // 32 bit colour D3D mode

string level_str = <techex.WMB>; // give file names in angular brackets

dllfunction prototype;
dllfunction render_backbuffer(entity);

function main()
{
	level_load(level_str);
	freeze_mode = 1;
	wait(4);
	freeze_mode = 0;
	screengrab();
}

// Shader Part
var light_dist=700; //this is how far away form a light it will be visible.
action light_pos_object
{
wait(5);
my.invisible=on;
my.passable=on;


my.lightrange=700; //could be set also to a skill


my.red=128; //just put in the r,g,b values
my.green=128;
my.blue=128;

my.cast=on; //casts a shadow when on

} 



//******************

bmap env_bmp=<env_map.bmp>;
bmap castle1_walls = <castle1_walls_t.tga>;
bmap castle1_walls_tDOT3 = <castle1_walls_tDOT3.tga>;
bmap castle1_walls_tH = <castle1_walls_tHeight.tga>;

material castle1_walls_t
{
	skin2 = castle1_walls_tDOT3 ;
	skin3 = castle1_walls_tH ;
	flags = tangent;
}

material castle1_walls_2
{
	skin1 = castle1_walls_tDOT3 ;
	flags = tangent;
}

material castle1_walls_3
{
	skin1 = castle1_walls_tDOT3 ;
	flags = tangent;
}

material castle1_walls_4
{
	skin1 = castle1_walls_tDOT3 ;
	skin3 = castle1_walls;
	skin4 = env_bmp ;
	flags = tangent;
}

/////////////////////////
// Bloom

material mat_bloom
{
	
}

entity glow_quad
{
  type = <grey.TGA>; //128*128 works best but can be any size
//this entity is always invisible..
}

entity glow_quad_view
{
  	type = <grey.TGA>;
 	layer = 2; // display above view entities with layer 1
 	view = CAMERA; // same camera parameters as the default view
// set the x position according to the texture size..
//	x = 36; // for 32
//	x = 72; // for 64
	x = 145; // for 128 
 	y = 0; //center horzontally
 	z = 0; // and center vertically
}  

function map_glow()
{
	me=glow_quad_view;
	my.ambient=10;
	my.transparent=on;
	my.bright=on;
	my.alpha=50;
	my.visible=on;
	my.material=mat_bloom;
	my.scale_x=1.33; //this scales it to screen proportions..
	while(1)
	{
                //sets material skin1 to the rendered view tex
		mat_bloom.skin1=bmap_for_entity(glow_quad,0);
		wait(1);		
	}
}

function screengrab()
{
	wait(20);
	me=glow_quad;
	map_glow();
	while(1)
	{
		render_backbuffer(me);
		wait(1);		
	}
}

///////////////////
// Toon Shading

// Normaliser cubemap sprite
bmap bmp_normalizationcube=<tsnormalise.tga>;
// Paint shade map for toonshader
bmap bmp_tstonemap=<ts2tone.tga>;  // <<< CHANGE THIS TO CHANGE PAINT SHADING

function mat_toon_init
{
	bmap_to_cubemap(mtl.skin1);
}

material mat_toon
{
	skin1=bmp_normalizationcube;	// This is the normalisation cubemap created by the starter function
	skin2=bmp_tstonemap;	
	
	flags=tangent;

	event = mat_toon_init;	
}

action Shader_Toon
{
	//my.shadow = on;
	//my.cast = on;
	my.material = mat_toon;
	render_shadows();
}

/*******************************************************
softshadows.wdl
(c)2005 Matt Aufderheide
*******************************************************/

string my_file;
string empty="";
string sourcefile;
entity* temp_ent; 
var VecTo[3]; 
var VecFrom[3]; 

//change this for different LOD versions..
//here I am using the LOD 0 file ..
//however if you want, you can change it 1,2,3 to always have a 
//low res model as your shadow..however it seems to work fine this way if you have LODs
//if you dont have LOD change this string to simply ".mdl"
string control_file="e.mdl"; 

//i have included this tga file
bmap softshadow_bmap = <shadow_color.tga>;

material mat_softshadows{}

//flatten the shadow to the ground normals
function shadow_to_normal()
{	
			
  			temp_ent = YOU;

			trace_mode = IGNORE_PASSENTS+ IGNORE_ME+ IGNORE_YOU+ IGNORE_MODELS;
			vec_set(vecFrom,YOU.X);
			vec_set(vecTo,vecFrom);
			vecTo.Z -= 500;
			result = trace(vecFrom,vecTo);

			YOU = temp_ent; // YOU (the entity itself) is changed by SONAR

			if(result > 0)
			{
				// place shadow 2 quants above the floor
				MY.z = YOU.z - RESULT + 2; //YOUR.min_z*/ + 2 - RESULT;
				MY.x = YOU.x;
				MY.y = YOU.y;

				// adapt shadow orientation to floor slope
				if ((NORMAL.x != 0) || (NORMAL.y != 0))
				{ // we're on a slope
					// conform shadow to slope
					MY.PAN = 0;
					MY.tilt = - asin(NORMAL.x);
					MY.roll = - asin(NORMAL.y);
					temp.pan = YOU.PAN;
					temp.tilt = 0;
					temp.roll = 0;
					rotate(my,temp,nullvector);
 				}
				else
				{
					MY.pan = YOU.pan;
					MY.tilt = 0; // set it flat onto the floor
					MY.roll = 0;
				}
			}


}


//this function controls the far disnace you can see shadow
function shadow_vis()
{
	while(me)
	{
		if (vec_dist(my.x,camera.x) > 1000) //adjust this dist here
		{
			my.invisible=on;
		}
		
		else
	
		{
			my.invisible=off;
		}
		
		wait(10+(random(5)));
	}
	
}

//animate and move the shadow mesh
function shadow_mesh()
{
	my.scale_x=your.scale_x;
	my.scale_y=your.scale_y;
	my.scale_z=your.scale_z;
	my.scale_z*=0.01;

	my.passable=on;
	my.push=-1;	
	
	my.ambient=0;
	my.transparent=on;
	my.flare=on;
	my.passable=on;
	my.push=-1;	
	
	shadow_vis();
	
	my.material=mat_softshadows;
	mat_softshadows.skin1=softshadow_bmap;

  	my.skill41=float(0.4); // adjust this to increase blurriness..
	
	while(me)
	{
		
		if you!=null
		{
			my.frame=your.frame;
			my.next_frame=your.next_frame;
			shadow_to_normal();	
		}
		
		if you==null
		{
			ent_remove(me);
		}
		
		wait(1);
	}
	
}

function render_shadows()
{
	str_cpy(my_file,empty);
	str_for_entfile (sourcefile, me);
	str_trunc(sourcefile,5);
	str_cpy(my_file,sourcefile);
	str_cat(my_file,control_file);
	ent_create(my_file,my.x,shadow_mesh);
}


///////////////////////
// Load Shaders

starter load_shaders()
{
	d3d_automaterial=1;
	effect_load(castle1_walls_t,"parallax.fx");
	effect_load(castle1_walls_2,"normalmap_level_ps20.fx");
	effect_load(castle1_walls_4,"spec_mapworld.fx");
	effect_load(castle1_walls_3,"bumpmap.fx");
	effect_load(mat_bloom,"bloom.fx"); 
	effect_load(mat_toon,"toon.fx");
	effect_load(mat_softshadows,"softshadow.fx");
}






