//KEY REMAPPING FOR TEMPLATE SCRIPTS
//Keith Blount AKA Ambit 2001

//This is a very easy script that allows you to redefine all the default keys of games made with GameStudio
//It will automatically remember the new mapping when you close and restart the game (saving the info to contr15.SAV)...

//Just include this after all the template WDLs in your main game script and hit F12
//to change the key mapping - easy!

//To load the custom controls each time you start the game, just place:
//init_controls();
//somewhere near the beginning of main()...

//NB. The basic idea of using DEFINE to change the keys came from Keith MiddleBrook AKA Keebo's redefinition script, but
//this script takes advantage of the new scancode possibilities of the A5 engine to make it very easy to redefine keys.


string* new_key_str;  //pointer string

//return scancodes as variable:

function define_key()
{
 if(key_a==1)
  {
   new_key_str="A";
   return(30);
  }
 if(key_b==1)
  {
   new_key_str="B";
   return(48);
  }
 if(key_c==1)
  {
   new_key_str="C";
   return(46);
  }
 if(key_d==1)
  {
   new_key_str="D";
   return(32);
  }
 if(key_e==1)
  {
   new_key_str="E";
   return(18);
  }
 if(key_f==1)
  {
   new_key_str="F";
   return(33);
  }
 if(key_g==1)
  {
   new_key_str="G";
   return(34);
  }
 if(key_h==1)
  {
   new_key_str="H";
   return(35);
  }
 if(key_i==1)
  {
   new_key_str="I";
   return(23);
  }
 if(key_j==1)
  {
   new_key_str="J";
   return(36);
  }
 if(key_k==1)
  {
   new_key_str="K";
   return(37);
  }
 if(key_l==1)
  {
   new_key_str="L";
   return(38);
  }
 if(key_m==1)
  {
   new_key_str="M";
   return(50);
  }
 if(key_n==1)
  {
   new_key_str="N";
   return(49);
  }
 if(key_o==1)
  {
   new_key_str="O";
   return(24);
  }
 if(key_p==1)
  {
   new_key_str="P";
   return(25);
  }
 if(key_q==1)
  {
   new_key_str="Q";
   return(16);
  }
 if(key_r==1)
  {
   new_key_str="R";
   return(19);
  }
 if(key_s==1)
  {
   new_key_str="S";
   return(31);
  }
 if(key_t==1)
  {
   new_key_str="T";
   return(20);
  }
 if(key_u==1)
  {
   new_key_str="U";
   return(22);
  }
 if(key_v==1)
  {
   new_key_str="V";
   return(47);
  }
 if(key_w==1)
  {
   new_key_str="W";
   return(17);
  }
 if(key_x==1)
  {
   new_key_str="X";
   return(45);
  }
 if(key_y==1)
  {
   new_key_str="Y";
   return(21);
  }
 if(key_z==1)
  {
   new_key_str="Z";
   return(44);
  }
 if(key_cuu==1)
  {
   new_key_str="UP";
   return(72);
  }
 if(key_cud==1)
  {
   new_key_str="DOWN";
   return(80);
  }
 if(key_cul==1)
  {
   new_key_str="LEFT";
   return(75);
  }
 if(key_cur==1)
  {
   new_key_str="RIGHT";
   return(77);
  }
 if(key_0==1)
  {
   new_key_str="0";
   return(11);
  }
 if(key_1==1)
  {
   new_key_str="1";
   return(2);
  }
 if(key_2==1)
  {
   new_key_str="2";
   return(3);
  }
 if(key_3==1)
  {
   new_key_str="3";
   return(4);
  }
 if(key_4==1)
  {
   new_key_str="4";
   return(5);
  }
 if(key_5==1)
  {
   new_key_str="5";
   return(6);
  }
 if(key_6==1)
  {
   new_key_str="6";
   return(7);
  }
 if(key_7==1)
  {
   new_key_str="7";
   return(8);
  }
 if(key_8==1)
  {
   new_key_str="8";
   return(9);
  }
 if(key_9==1)
  {
   new_key_str="9";
   return(10);
  }
 if(key_esc==1)
  {
   new_key_str="ESCAPE";
   return(1);
  }
 if(key_f1==1)
  {
   new_key_str="F1";
   return(59);
  }
 if(key_f2==1)
  {
   new_key_str="F2";
   return(60);
  }
 if(key_f3==1)
  {
   new_key_str="F3";
   return(61);
  }
 if(key_f4==1)
  {
   new_key_str="F4";
   return(62);
  }
 if(key_f5==1)
  {
   new_key_str="F5";
   return(63);
  }
 if(key_f6==1)
  {
   new_key_str="F6";
   return(64);
  }
 if(key_f7==1)
  {
   new_key_str="F7";
   return(65);
  }
 if(key_f8==1)
  {
   new_key_str="F8";
   return(66);
  }
 if(key_f9==1)
  {
   new_key_str="F9";
   return(67);
  }
 if(key_f10==1)
  {
   new_key_str="F10";
   return(68);
  }
 if(key_f11==1)
  {
   new_key_str="F11";
   return(87);
  }
 if(key_f12==1)
  {
   new_key_str="F12";
   return(88);
  }
 if(key_enter==1)
  {
   new_key_str="ENTER";
   return(28);
  }
 if(key_tab==1)
  {
   new_key_str="TAB";
   return(15);
  }
 if(key_ctrl==1)
  {
   new_key_str="CTRL";
   return(29);
  }
 if(key_alt==1)
  {
   new_key_str="ALT";
   return(56);
  }
 if(key_shiftl==1)
  {
   new_key_str="L SHIFT";
   return(42);
  }
 if(key_shiftr==1)
  {
   new_key_str="R SHIFT";
   return(54);
  }
 if(key_space==1)
  {
   new_key_str="SPACE";
   return(57);
  }
 if(key_bksp==1)
  {
   new_key_str="BACKSPACE";
   return(14);
  }
 if(key_pgup==1)
  {
   new_key_str="PAGE UP";
   return(73);
  }
 if(key_pgdn==1)
  {
   new_key_str="PAGE DOWN";
   return(81);
  }
 if(key_home==1)
  {
   new_key_str="HOME";
   return(71);
  }
 if(key_end==1)
  {
   new_key_str="END";
   return(79);
  }
 if(key_ins==1)
  {
   new_key_str="INSERT";
   return(82);
  }
 if(key_del==1)
  {
   new_key_str="DELETE";
   return(83);
  }
 if(key_pause==1)
  {
   new_key_str="PAUSE";
   return(69);
  }
 if(key_cal==1)
  {
   new_key_str=",";
   return(51);
  }
 if(key_car==1)
  {
   new_key_str=".";
   return(52);
  }

 if(key_brackl==1)
  {
   new_key_str="[";
   return(26);
  }
 if(key_brackr==1)
  {
   new_key_str="]";
   return(27);
  }
 if(key_semic==1)
  {
   new_key_str=";";
   return(39);
  }
 if(key_apos==1)
  {
   new_key_str="'";
   return(40);
  }
 if(key_slash==1)
  {
   new_key_str="/";
   return(53);
  }

 if(key_minusc==1)
  {
   new_key_str="-";
   return(12);
  }
 if(key_equals==1)
  {
   new_key_str="=";
   return(13);
  }
 if(key_grave==1)
  {
   new_key_str="`";
   return(41);
  }

 if(key_bksl==1)
  {
   new_key_str="\#";
   return(43);
  }

//no backslash key!!!


 //JOYSTICK:
 if(joy_1==1)
  {
   new_key_str="JOY1";
   return(256);
  }
 if(joy_2==1)
  {
   new_key_str="JOY2";
   return(257);
  }
 if(joy_3==1)
  {
   new_key_str="JOY3";
   return(258);
  }
 if(joy_4==1)
  {
   new_key_str="JOY4";
   return(259);
  }
 if(joy_5==1)
  {
   new_key_str="JOY5";
   return(260);
  }
 if(joy_6==1)
  {
   new_key_str="JOY6";
   return(261);
  }
 if(joy_7==1)
  {
   new_key_str="JOY7";
   return(262);
  }
 if(joy_8==1)
  {
   new_key_str="JOY8";
   return(263);
  }
 if(joy_9==1)
  {
   new_key_str="JOY9";
   return(264);
  }
 if(joy_10==1)
  {
   new_key_str="JOY10";
   return(265);
  }

 //MOUSE BUTTONS:
 if(mouse_left==1)
  {
   new_key_str="MOUSE L";
   return(280);
  }
 if(mouse_right==1)
  {
   new_key_str="MOUSE R";
   return(281);
  }
 if(mouse_middle==1)
  {
   new_key_str="MOUSE MID";
   return(282);
  }

}


//This is used by putting eg. this at the beginning of a controls section:
//define my_up_key,key_a;
//key_up_scancode=29; //or whatever
//in controls section:
//my_up_key=get_key(key_up_scancode);

//To be placed at beginning of control section (eg. Player Intentions):
function get_key(key_var)
{
 if(key_var==30)
  {return(key_a);}
 if(key_var==48)
  {return(key_b);}
 if(key_var==46)
  {return(key_c);}
 if(key_var==32)
  {return(key_d);}
 if(key_var==18)
  {return(key_e);}
 if(key_var==33)
  {return(key_f);}
 if(key_var==34)
  {return(key_g);}
 if(key_var==35)
  {return(key_h);}
 if(key_var==23)
  {return(key_i);}
 if(key_var==36)
  {return(key_j);}
 if(key_var==37)
  {return(key_k);}
 if(key_var==38)
  {return(key_l);}
 if(key_var==50)
  {return(key_m);}
 if(key_var==49)
  {return(key_n);}
 if(key_var==24)
  {return(key_o);}
 if(key_var==25)
  {return(key_p);}
 if(key_var==16)
  {return(key_q);}
 if(key_var==19)
  {return(key_r);}
 if(key_var==31)
  {return(key_s);}
 if(key_var==20)
  {return(key_t);}
 if(key_var==22)
  {return(key_u);}
 if(key_var==47)
  {return(key_v);}
 if(key_var==17)
  {return(key_w);}
 if(key_var==45)
  {return(key_x);}
 if(key_var==21)
  {return(key_y);}
 if(key_var==44)
  {return(key_z);}
 if(key_var==72)
  {return(key_cuu);}
 if(key_var==80)
  {return(key_cud);}
 if(key_var==75)
  {return(key_cul);}
 if(key_var==77)
  {return(key_cur);}
 if(key_var==11)
  {return(key_0);}
 if(key_var==2)
  {return(key_1);}
 if(key_var==3)
  {return(key_2);}
 if(key_var==4)
  {return(key_3);}
 if(key_var==5)
  {return(key_4);}
 if(key_var==6)
  {return(key_5);}
 if(key_var==7)
  {return(key_6);}
 if(key_var==8)
  {return(key_7);}
 if(key_var==9)
  {return(key_8);}
 if(key_var==10)
  {return(key_9);}
 if(key_var==1)
  {return(key_esc);}
 if(key_var==59)
  {return(key_f1);}
 if(key_var==60)
  {return(key_f2);}
 if(key_var==61)
  {return(key_f3);}
 if(key_var==62)
  {return(key_f4);}
 if(key_var==63)
  {return(key_f5);}
 if(key_var==64)
  {return(key_f6);}
 if(key_var==65)
  {return(key_f7);}
 if(key_var==66)
  {return(key_f8);}
 if(key_var==67)
  {return(key_f9);}
 if(key_var==68)
  {return(key_f10);}
 if(key_var==87)
  {return(key_f11);}
 if(key_var==88)
  {return(key_f12);}
 if(key_var==28)
  {return(key_enter);}
 if(key_var==15)
  {return(key_tab);}
 if(key_var==29)
  {return(key_ctrl);}
 if(key_var==56)
  {return(key_alt);}
 if(key_var==42)
  {return(key_shiftl);}
 if(key_var==54)
  {return(key_shiftr);}
 if(key_var==57)
  {return(key_space);}
 if(key_var==14)
  {return(key_bksp);}
 if(key_var==73)
  {return(key_pgup);}
 if(key_var==81)
  {return(key_pgdn);}
 if(key_var==71)
  {return(key_home);}
 if(key_var==79)
  {return(key_end);}
 if(key_var==82)
  {return(key_ins);}
 if(key_var==83)
  {return(key_del);}
 if(key_var==69)
  {return(key_pause);}
 if(key_var==51)
  {return(key_cal);}
 if(key_var==52)
  {return(key_car);}

 if(key_var==26)
  {return(key_brackl);}
 if(key_var==27)
  {return(key_brackr);}
 if(key_var==39)
  {return(key_semic);}
 if(key_var==40)
  {return(key_apos);}

 if(key_var==12)
  {return(key_minusc);}
 if(key_var==13)
  {return(key_equals);}
 if(key_var==53)
  {return(key_slash);}
 if(key_var==41)
  {return(key_grave);}
 if(key_var==43)
  {return(key_bksl);}

 if(key_var==256)
  {return(joy_1);}
 if(key_var==257)
  {return(joy_2);}
 if(key_var==258)
  {return(joy_3);}
 if(key_var==259)
  {return(joy_4);}
 if(key_var==260)
  {return(joy_5);}
 if(key_var==261)
  {return(joy_6);}
 if(key_var==262)
  {return(joy_7);}
 if(key_var==263)
  {return(joy_8);}
 if(key_var==264)
  {return(joy_9);}
 if(key_var==265)
  {return(joy_10);}

 if(key_var==280)
  {return(mouse_left);}
 if(key_var==281)
  {return(mouse_right);}
 if(key_var==282)
  {return(mouse_middle);}

}





function get_key_string(key_var)
{
 if(key_var==30)
  {return("A");}
 if(key_var==48)
  {return("B");}
 if(key_var==46)
  {return("C");}
 if(key_var==32)
  {return("D");}
 if(key_var==18)
  {return("E");}
 if(key_var==33)
  {return("F");}
 if(key_var==34)
  {return("G");}
 if(key_var==35)
  {return("H");}
 if(key_var==23)
  {return("I");}
 if(key_var==36)
  {return("J");}
 if(key_var==37)
  {return("K");}
 if(key_var==38)
  {return("L");}
 if(key_var==50)
  {return("M");}
 if(key_var==49)
  {return("N");}
 if(key_var==24)
  {return("O");}
 if(key_var==25)
  {return("P");}
 if(key_var==16)
  {return("Q");}
 if(key_var==19)
  {return("R");}
 if(key_var==31)
  {return("S");}
 if(key_var==20)
  {return("T");}
 if(key_var==22)
  {return("U");}
 if(key_var==47)
  {return("V");}
 if(key_var==17)
  {return("W");}
 if(key_var==45)
  {return("X");}
 if(key_var==21)
  {return("Y");}
 if(key_var==44)
  {return("Z");}
 if(key_var==72)
  {return("UP");}
 if(key_var==80)
  {return("DOWN");}
 if(key_var==75)
  {return("LEFT");}
 if(key_var==77)
  {return("RIGHT");}
 if(key_var==11)
  {return("0");}
 if(key_var==2)
  {return("1");}
 if(key_var==3)
  {return("2");}
 if(key_var==4)
  {return("3");}
 if(key_var==5)
  {return("4");}
 if(key_var==6)
  {return("5");}
 if(key_var==7)
  {return("6");}
 if(key_var==8)
  {return("7");}
 if(key_var==9)
  {return("8");}
 if(key_var==10)
  {return("9");}
 if(key_var==1)
  {return("ESCAPE");}
 if(key_var==59)
  {return("F1");}
 if(key_var==60)
  {return("F2");}
 if(key_var==61)
  {return("F3");}
 if(key_var==62)
  {return("F4");}
 if(key_var==63)
  {return("F5");}
 if(key_var==64)
  {return("F6");}
 if(key_var==65)
  {return("F7");}
 if(key_var==66)
  {return("F8");}
 if(key_var==67)
  {return("F9");}
 if(key_var==68)
  {return("F10");}
 if(key_var==87)
  {return("F11");}
 if(key_var==88)
  {return("F12");}
 if(key_var==28)
  {return("ENTER");}
 if(key_var==15)
  {return("TAB");}
 if(key_var==29)
  {return("CTRL");}
 if(key_var==56)
  {return("ALT");}
 if(key_var==42)
  {return("L SHIFT");}
 if(key_var==54)
  {return("R SHIFT");}
 if(key_var==57)
  {return("SPACE");}
 if(key_var==14)
  {return("BACKSPACE");}
 if(key_var==73)
  {return("PAGE UP");}
 if(key_var==81)
  {return("PAGE DOWN");}
 if(key_var==71)
  {return("HOME");}
 if(key_var==79)
  {return("END");}
 if(key_var==82)
  {return("INSERT");}
 if(key_var==83)
  {return("DELETE");}
 if(key_var==69)
  {return("PAUSE");}
 if(key_var==51)
  {return(",");}
 if(key_var==52)
  {return(".");}

 if(key_var==26)
  {return("[");}
 if(key_var==27)
  {return("]");}
 if(key_var==39)
  {return(";");}
 if(key_var==40)
  {return("'");}

 if(key_var==12)
  {return("-");}
 if(key_var==13)
  {return("=");}
 if(key_var==53)
  {return("/");}
 if(key_var==41)
  {return("`");}
 if(key_var==43)
  {return("\#");}

 if(key_var==256)
  {return("JOY1");}
 if(key_var==257)
  {return("JOY2");}
 if(key_var==258)
  {return("JOY3");}
 if(key_var==259)
  {return("JOY4");}
 if(key_var==260)
  {return("JOY5");}
 if(key_var==261)
  {return("JOY6");}
 if(key_var==262)
  {return("JOY7");}
 if(key_var==263)
  {return("JOY8");}
 if(key_var==264)
  {return("JOY9");}
 if(key_var==265)
  {return("JOY10");}

 if(key_var==280)
  {return("MOUSE L");}
 if(key_var==281)
  {return("MOUSE R");}
 if(key_var==282)
  {return("MOUSE MID");}

}


//////END OF KEY REDEFINITION SCRIPT//////////////////////////////////////////////////////////////////////////////////




//EVERYTHING BELOW DEALS WITH REDEFINING THE TEMPLATES AND CREATING A MENU TO ALLOW THE REDEFINITION OF KEYS WITH THE
//TEMPLATE SCRIPTS...

bmap controlsmap = <controls.pcx>;

//"Controls" panel:
panel controls_screen
{
 bmap = controlsmap;
 flags = refresh,d3d,overlay;
 layer=3;
}


////////////////////////////////////////////////////////////////////////////

//OVERRIDES FOR TEMPLATES:

define my_key_up,key_cuu;
var_info up_key_var=72;

define my_key_down,key_cud;
var_info down_key_var=80;

define my_key_left,key_cul;
var_info left_key_var=75;

define my_key_right=key_cur;
var_info right_key_var=77;

define my_key_run=key_a; //cannot define key_shift initially, or you get a read-only error
var_info run_key_var=54;      //but scancode 54 is right shift, so it will be redefined immediately!

define my_key_jump=key_home;
var_info jump_key_var=71;

define my_key_crouch=key_end;
var_info crouch_key_var=79;

define my_key_roll=key_alt;
var_info roll_key_var=56;

define my_key_lookup=key_pgup;
var_info lookup_key_var=73;

define my_key_lookdown=key_pgdn;
var_info lookdown_key_var=81;

define my_key_strafel=key_cal;
var_info strafel_key_var=51;

define my_key_strafer=key_car;
var_info strafer_key_var=52;


var updown_force;
var leftright_force;


function _player_intentions()
{

//get custom key configuration:
my_key_up=get_key(up_key_var);
my_key_down=get_key(down_key_var);
my_key_left=get_key(left_key_var);
my_key_right=get_key(right_key_var);
my_key_run=get_key(run_key_var);
my_key_jump=get_key(jump_key_var);
my_key_crouch=get_key(crouch_key_var);
my_key_roll=get_key(roll_key_var);
my_key_lookup=get_key(lookup_key_var);
my_key_lookdown=get_key(lookdown_key_var);
my_key_strafel=get_key(strafel_key_var);
my_key_strafer=get_key(strafer_key_var);


if(my_key_up==1)
{updown_force=1;}
   if(my_key_down==1)
{updown_force=-1;}
   if((my_key_up==0)&&(my_key_down==0))
{updown_force=0;}
   if(my_key_left==1)
 {leftright_force=-1;}
   if(my_key_right)
 {leftright_force=1;}
if((my_key_right==0)&&(my_key_left==0))
 {leftright_force=0;}


// Set the angular forces according to the player intentions
	aforce.PAN = -astrength.PAN*(leftright_force+JOY_FORCE.X);
	aforce.TILT = astrength.TILT*(my_key_lookup-my_key_lookdown);
	if(MOUSE_MODE == 0)
	{	// Mouse switched off?
		 aforce.PAN += -astrength.PAN*MOUSE_FORCE.X*mouseview*(1+my_key_run);
		 aforce.TILT += astrength.TILT*MOUSE_FORCE.Y*mouseview*(1+my_key_run);
	}
	aforce.ROLL = 0;
// Set ROLL force if ALT was pressed
	if(my_key_roll != 0)
	{
		aforce.ROLL = aforce.PAN;
		aforce.PAN = 0;
	}
// Double the forces in case the player pressed SHIFT
/*--	if(my_key_run != 0)
	{
		aforce.PAN += aforce.PAN;
		aforce.TILT += aforce.TILT;
		aforce.ROLL += aforce.ROLL;
	}--*/
// Limit the forces in case the player
// pressed buttons, mouse and joystick simultaneously
	limit.PAN = 2*astrength.PAN;
	limit.TILT = 2*astrength.TILT;
	limit.ROLL = 2*astrength.ROLL;

	if(aforce.PAN > limit.PAN) {  aforce.PAN = limit.PAN; }
	if(aforce.PAN < -limit.PAN) {  aforce.PAN = -limit.PAN; }
	if(aforce.TILT > limit.TILT) {  aforce.TILT = limit.TILT; }
	if(aforce.TILT < -limit.TILT) {  aforce.TILT = -limit.TILT; }
	if(aforce.ROLL > limit.ROLL) {  aforce.ROLL = limit.ROLL; }
	if(aforce.ROLL < -limit.ROLL) {  aforce.ROLL = -limit.ROLL; }

// Set the cartesian forces according to the player intentions
	force.X = strength.X*(updown_force+JOY_FORCE.Y);
	force.Y = strength.Y*(my_key_strafel-my_key_strafer);
	force.Z = strength.Z*(my_key_jump-my_key_crouch);
	if(MOUSE_MODE == 0)
	{	// Mouse switched off?
		force.X += strength.X*MOUSE_RIGHT*mouseview;
		//force.X += strength.X*mouseview; //can't move forward using mouse_right!
	}

// Double the forces in case the player pressed SHIFT
	if(my_key_run != 0)
	{
		force.X += force.X;
		force.Y += force.Y;
		force.Z += force.Z;
	}

// Limit the forces in case the player tried to cheat by
// operating buttons, mouse and joystick simultaneously
	limit.X = 2*strength.X;
	limit.Y = 2*strength.Y;
	limit.Z = 2*strength.Z;

	if(force.X > limit.X) {  force.X = limit.X; }
	if(force.X < -limit.X) { force.X = -limit.X; }
	if(force.Y > limit.Y) {  force.Y = limit.Y; }
	if(force.Y < -limit.Y) { force.Y = -limit.Y; }
	if(force.Z > limit.Z) {  force.Z = limit.Z; }
	if(force.Z < -limit.Z) { force.Z = -limit.Z; }
}



///////////////////////////////////////
//From weapons.wdl:

define my_key_shoot,key_ctrl;
var_info fire_key_var=29;


function weapon_fire()
{

	my_key_shoot=get_key(fire_key_var);

	weapon_firing = 1;
 	while(my_key_shoot) { wait(1); }
	weapon_firing = 0;
}


///////////////////////////////////////////////

//CHECK INPUT FOR ON_KEYS:

var_info mousetoggle_key_var=281; //mouse_right - From menu.wdl
var_info toggleview_key_var=65; //f7 - From camera.wdl
//From weapons.wdl:
var_info cyclegunup_key_var=18; // E
var_info cyclegundown_key_var=16; // Q
var_info togglecrosshair_key_var=37; // K
var_info handle_key_var=57; //Space - from input.wdl

function check_input(scancode)
{
 //Depending on scancode - ie key pressed - perform relevant function:

 if(scancode==mousetoggle_key_var) //check for Enter key...
  {mouse_toggle();}

 if(scancode==toggleview_key_var) //check for key assigned to send handle...
  {cycle_person_view();}

  if(scancode==cyclegunup_key_var)
   {gun_select_cycle_up();}

  if(scancode==cyclegundown_key_var)
   {gun_select_cycle_down();}

  if(scancode==togglecrosshair_key_var)
   {pan_cross_toggle();}

 if(scancode==handle_key_var) //check for key assigned to send handle...
  {send_handle();}
}


///////////////////////////////////////////////////////////////////////////////////////
//
///   EXAMPLE MENU:

string my_str[200];

//define strings with default keys and enough room for longer strings...
string up_str[15];
string down_str[15];
string left_str[15];
string right_str[15];
string handle_str[15];
string run_str[15];
string jump_str[15];
string crouch_str[15];
string strafel_str[15];
string strafer_str[15];
string fire_str[15];
string lookup_str[15];
string lookdown_str[15];
string roll_str[15];
string cyclegunup_str[15];
string cyclegundown_str[15];
string togglecrosshair_str[15];
string mousetoggle_str[15];
string toggleview_str[15];


font menufont, <fontsmal.bmp>, 8, 10;
font menufontyellow, <hifont.bmp>, 8, 10;  //same font but highlighted yellow...


//TEXTS:

//The following texts constitute the list of controls available:
//(note that their screen position is calculated in the main function)
text forward_text
{
 font=menufont;
 strings=1;
 string="FORWARD";
 layer=3;
}

text backwards_text
{
 font=menufont;
 strings=1;
 string="BACKWARDS";
 layer=3;
}

text left_text
{
 font=menufont;
 strings=1;
 string="LEFT";
 layer=3;
}

text right_text
{
 font=menufont;
 strings=1;
 string="RIGHT";
 layer=3;
}

text handle_text
{
 font=menufont;
 strings=1;
 string="USE";
 layer=3;
}

text run_text
{
 font=menufont;
 strings=1;
 string="RUN";
 layer=3;
}

text jump_text
{
 font=menufont;
 strings=1;
 string="JUMP";
 layer=3;
}

text crouch_text
{
 font=menufont;
 strings=1;
 string="CROUCH";
 layer=3;
}

text strafel_text
{
 font=menufont;
 strings=1;
 string="STRAFE LEFT";
 layer=3;
}

text strafer_text
{
 font=menufont;
 strings=1;
 string="STRAFE RIGHT";
 layer=3;
}

text fire_text
{
 font=menufont;
 strings=1;
 string="FIRE";
 layer=3;
}

text lookup_text
{
 font=menufont;
 strings=1;
 string="LOOK UP";
 layer=3;
}

text lookdown_text
{
 font=menufont;
 strings=1;
 string="LOOK DOWN";
 layer=3;
}

text roll_text
{
 font=menufont;
 strings=1;
 string="ROLL";
 layer=3;
}

text cyclegunup_text
{
 font=menufont;
 strings=1;
 string="CYCLE WEAPON UP";
 layer=3;
}

text cyclegundown_text
{
 font=menufont;
 strings=1;
 string="CYCLE WEAPON DOWN";
 layer=3;
}

text togglecrosshair_text
{
 font=menufont;
 strings=1;
 string="TOGGLE CROSSHAIR";
 layer=3;
}

text mousetoggle_text
{
 font=menufont;
 strings=1;
 string="TOGGLE MOUSE POINTER";
 layer=3;
}

text toggleview_text
{
 font=menufont;
 strings=1;
 string="TOGGLE VIEW";
 layer=3;
}


//Key strings:

text upkey_text
{
 font=menufont;
 strings=1;
 string=up_str;
 layer=3;
}

text downkey_text
{
 font=menufont;
 strings=1;
 string=down_str;
 layer=3;
}

text leftkey_text
{
 font=menufont;
 strings=1;
 string=left_str;
 layer=3;
}

text rightkey_text
{
 font=menufont;
 strings=1;
 string=right_str;
 layer=3;
}

text handlekey_text
{
 font=menufont;
 strings=1;
 string=handle_str;
 layer=3;
}

text runkey_text
{
 font=menufont;
 strings=1;
 string=run_str;
 layer=3;
}

text jumpkey_text
{
 font=menufont;
 strings=1;
 string=jump_str;
 layer=3;
}

text crouchkey_text
{
 font=menufont;
 strings=1;
 string=crouch_str;
 layer=3;
}

text strafelkey_text
{
 font=menufont;
 strings=1;
 string=strafel_str;
 layer=3;
}

text straferkey_text
{
 font=menufont;
 strings=1;
 string=strafer_str;
 layer=3;
}

text firekey_text
{
 font=menufont;
 strings=1;
 string=fire_str;
 layer=3;
}

text lookupkey_text
{
 font=menufont;
 strings=1;
 string=lookup_str;
 layer=3;
}

text lookdownkey_text
{
 font=menufont;
 strings=1;
 string=lookdown_str;
 layer=3;
}

text rollkey_text
{
 font=menufont;
 strings=1;
 string=roll_str;
 layer=3;
}

text cyclegunupkey_text
{
 font=menufont;
 strings=1;
 string=cyclegunup_str;
 layer=3;
}

text cyclegundownkey_text
{
 font=menufont;
 strings=1;
 string=cyclegundown_str;
 layer=3;
}

text togglecrosshairkey_text
{
 font=menufont;
 strings=1;
 string=togglecrosshair_str;
 layer=3;
}

text mousetogglekey_text
{
 font=menufont;
 strings=1;
 string=mousetoggle_str;
 layer=3;
}

text toggleviewkey_text
{
 font=menufont;
 strings=1;
 string=toggleview_str;
 layer=3;
}

text resetdefaults_text
{
 font=menufont;
 strings=1;
 string="RESTORE DEFAULTS";
 layer=3;
 flags=center_x;
}




//The menus...

var controltoggle=0;

function controls_menu_toggle()
{
 if (controltoggle==0)
  {
   controltoggle=1;
   controls_menu_on();
  }
 else
  {
   controltoggle=0;
   save_info("contr",015); //save new definitions when controls menu is closed
   controls_menu_off();
  }
}



var cursorstop=0;

var cursorpos=0;


function controls_menu_on()
{
 //Get the current mapping and copy to relevant strings:
 str_cpy(up_str,get_key_string(up_key_var));
 str_cpy(down_str,get_key_string(down_key_var));
 str_cpy(left_str,get_key_string(left_key_var));
 str_cpy(right_str,get_key_string(right_key_var));
 str_cpy(handle_str,get_key_string(handle_key_var));
 str_cpy(run_str,get_key_string(run_key_var));
 str_cpy(jump_str,get_key_string(jump_key_var));
 str_cpy(crouch_str,get_key_string(crouch_key_var));
 str_cpy(strafel_str,get_key_string(strafel_key_var));
 str_cpy(strafer_str,get_key_string(strafer_key_var));
 str_cpy(fire_str,get_key_string(fire_key_var));
 str_cpy(lookup_str,get_key_string(lookup_key_var));
 str_cpy(lookdown_str,get_key_string(lookdown_key_var));
 str_cpy(roll_str,get_key_string(roll_key_var));
 str_cpy(cyclegunup_str,get_key_string(cyclegunup_key_var));
 str_cpy(cyclegundown_str,get_key_string(cyclegundown_key_var));
 str_cpy(togglecrosshair_str,get_key_string(togglecrosshair_key_var));
 str_cpy(mousetoggle_str,get_key_string(mousetoggle_key_var));
 str_cpy(toggleview_str,get_key_string(toggleview_key_var));




 cursorpos=0; //reset cursor position to top;

 freeze_mode=1; //pause game

 //get text positions relative to screen (so the menu looks okay in any resolution):
 forward_text.pos_x=screen_size.x/2-150;
 forward_text.pos_y=screen_size.y/2-175;
 backwards_text.pos_x=screen_size.x/2-150;
 backwards_text.pos_y=screen_size.y/2-155;
 left_text.pos_x=screen_size.x/2-150;
 left_text.pos_y=screen_size.y/2-135;
 right_text.pos_x=screen_size.x/2-150;
 right_text.pos_y=screen_size.y/2-115;
 handle_text.pos_x=screen_size.x/2-150;
 handle_text.pos_y=screen_size.y/2-95;
 run_text.pos_x=screen_size.x/2-150;
 run_text.pos_y=screen_size.y/2-75;
 jump_text.pos_x=screen_size.x/2-150;
 jump_text.pos_y=screen_size.y/2-55;
 crouch_text.pos_x=screen_size.x/2-150;
 crouch_text.pos_y=screen_size.y/2-35;
 strafel_text.pos_x=screen_size.x/2-150;
 strafel_text.pos_y=screen_size.y/2-15;
 strafer_text.pos_x=screen_size.x/2-150;
 strafer_text.pos_y=screen_size.y/2+5;
 fire_text.pos_x=screen_size.x/2-150;
 fire_text.pos_y=screen_size.y/2+25;
 lookup_text.pos_x=screen_size.x/2-150;
 lookup_text.pos_y=screen_size.y/2+45;
 lookdown_text.pos_x=screen_size.x/2-150;
 lookdown_text.pos_y=screen_size.y/2+65;
 roll_text.pos_x=screen_size.x/2-150;
 roll_text.pos_y=screen_size.y/2+85;
 cyclegunup_text.pos_x=screen_size.x/2-150;
 cyclegunup_text.pos_y=screen_size.y/2+105;
 cyclegundown_text.pos_x=screen_size.x/2-150;
 cyclegundown_text.pos_y=screen_size.y/2+125;
 togglecrosshair_text.pos_x=screen_size.x/2-150;
 togglecrosshair_text.pos_y=screen_size.y/2+145;
 mousetoggle_text.pos_x=screen_size.x/2-150;
 mousetoggle_text.pos_y=screen_size.y/2+165;
 toggleview_text.pos_x=screen_size.x/2-150;
 toggleview_text.pos_y=screen_size.y/2+185;

 upkey_text.pos_x=screen_size.x/2+75;
 upkey_text.pos_y=screen_size.y/2-175;
 downkey_text.pos_x=screen_size.x/2+75;
 downkey_text.pos_y=screen_size.y/2-155;
 leftkey_text.pos_x=screen_size.x/2+75;
 leftkey_text.pos_y=screen_size.y/2-135;
 rightkey_text.pos_x=screen_size.x/2+75;
 rightkey_text.pos_y=screen_size.y/2-115;
 handlekey_text.pos_x=screen_size.x/2+75;
 handlekey_text.pos_y=screen_size.y/2-95;
 runkey_text.pos_x=screen_size.x/2+75;
 runkey_text.pos_y=screen_size.y/2-75;
 jumpkey_text.pos_x=screen_size.x/2+75;
 jumpkey_text.pos_y=screen_size.y/2-55;
 crouchkey_text.pos_x=screen_size.x/2+75;
 crouchkey_text.pos_y=screen_size.y/2-35;
 strafelkey_text.pos_x=screen_size.x/2+75;
 strafelkey_text.pos_y=screen_size.y/2-15;
 straferkey_text.pos_x=screen_size.x/2+75;
 straferkey_text.pos_y=screen_size.y/2+5;
 firekey_text.pos_x=screen_size.x/2+75;
 firekey_text.pos_y=screen_size.y/2+25;
 lookupkey_text.pos_x=screen_size.x/2+75;
 lookupkey_text.pos_y=screen_size.y/2+45;
 lookdownkey_text.pos_x=screen_size.x/2+75;
 lookdownkey_text.pos_y=screen_size.y/2+65;
 rollkey_text.pos_x=screen_size.x/2+75;
 rollkey_text.pos_y=screen_size.y/2+85;
 cyclegunupkey_text.pos_x=screen_size.x/2+75;
 cyclegunupkey_text.pos_y=screen_size.y/2+105;
 cyclegundownkey_text.pos_x=screen_size.x/2+75;
 cyclegundownkey_text.pos_y=screen_size.y/2+125;
 togglecrosshairkey_text.pos_x=screen_size.x/2+75;
 togglecrosshairkey_text.pos_y=screen_size.y/2+145;
 mousetogglekey_text.pos_x=screen_size.x/2+75;
 mousetogglekey_text.pos_y=screen_size.y/2+165;
 toggleviewkey_text.pos_x=screen_size.x/2+75;
 toggleviewkey_text.pos_y=screen_size.y/2+185;

 resetdefaults_text.pos_x=screen_size.x/2;
 resetdefaults_text.pos_y=screen_size.y/2+220;

//Title panel:
controls_screen.pos_x=screen_size.x/2-75;
controls_screen.pos_y=screen_size.y/2-230;
controls_screen.visible=on;


 forward_text.visible=on;
 backwards_text.visible=on;
 left_text.visible=on;
 right_text.visible=on;
 handle_text.visible=on;
 run_text.visible=on;
 jump_text.visible=on;
 crouch_text.visible=on;
 strafel_text.visible=on;
 strafer_text.visible=on;
 fire_text.visible=on;
 lookup_text.visible=on;
 lookdown_text.visible=on;
 roll_text.visible=on;
 cyclegunup_text.visible=on;
 cyclegundown_text.visible=on;
 togglecrosshair_text.visible=on;
 mousetoggle_text.visible=on;
 toggleview_text.visible=on;

 upkey_text.visible=on;
 downkey_text.visible=on;
 leftkey_text.visible=on;
 rightkey_text.visible=on;
 handlekey_text.visible=on;
 runkey_text.visible=on;
 jumpkey_text.visible=on;
 crouchkey_text.visible=on;
 strafelkey_text.visible=on;
 straferkey_text.visible=on;
 firekey_text.visible=on;
 lookupkey_text.visible=on;
 lookdownkey_text.visible=on;
 rollkey_text.visible=on;
 cyclegunupkey_text.visible=on;
 cyclegundownkey_text.visible=on;
 togglecrosshairkey_text.visible=on;
 mousetogglekey_text.visible=on;
 toggleviewkey_text.visible=on;

 resetdefaults_text.visible=on;


 while(controltoggle==1) //while menu is visible:
  {
   
  if(key_cud==0)&&(key_cuu==0){cursorstop=0;} 

   if(key_cud==1)&&(cursorstop==0)
    {
     cursorpos+=1;
     cursorstop=1;
    }
   if(key_cuu==1)&&(cursorstop==0)
    {
     cursorpos-=1;
     cursorstop=1;
    }

   if (cursorpos>19) //cycle to top
    {cursorpos=0;}
   if (cursorpos<0) //cycle to bottom
    {cursorpos=19;}


   if(cursorpos==0)
   {
    forward_text.font=menufontyellow;
    upkey_text.font=menufontyellow;
   }
    else
   {
    forward_text.font=menufont;
    upkey_text.font=menufont;
   }

   if(cursorpos==1)
   {
    backwards_text.font=menufontyellow; 
    downkey_text.font=menufontyellow;
   }
    else
   {
    backwards_text.font=menufont; 
    downkey_text.font=menufont;
   }

   if(cursorpos==2)
   {
    left_text.font=menufontyellow; 
    leftkey_text.font=menufontyellow;
   }
    else
   {
    left_text.font=menufont; 
    leftkey_text.font=menufont;
   }

   if(cursorpos==3)
   {
    right_text.font=menufontyellow; 
    rightkey_text.font=menufontyellow;
   }
    else
   {
    right_text.font=menufont; 
    rightkey_text.font=menufont;
   }

   if(cursorpos==4)
   {
    handle_text.font=menufontyellow; 
    handlekey_text.font=menufontyellow;
   }
    else
   {
    handle_text.font=menufont; 
    handlekey_text.font=menufont;
   }

   if(cursorpos==5)
   {
    run_text.font=menufontyellow; 
    runkey_text.font=menufontyellow;
   }
    else
   {
    run_text.font=menufont; 
    runkey_text.font=menufont;
   }

   if(cursorpos==6)
   {
    jump_text.font=menufontyellow; 
    jumpkey_text.font=menufontyellow;
   }
    else
   {
    jump_text.font=menufont; 
    jumpkey_text.font=menufont;
   }

   if(cursorpos==7)
   {
    crouch_text.font=menufontyellow; 
    crouchkey_text.font=menufontyellow;
   }
    else
   {
    crouch_text.font=menufont; 
    crouchkey_text.font=menufont;
   }

   if(cursorpos==8)
   {
    strafel_text.font=menufontyellow; 
    strafelkey_text.font=menufontyellow;
   }
    else
   {
    strafel_text.font=menufont; 
    strafelkey_text.font=menufont;
   }

   if(cursorpos==9)
   {
    strafer_text.font=menufontyellow; 
    straferkey_text.font=menufontyellow;
   }
    else
   {
    strafer_text.font=menufont; 
    straferkey_text.font=menufont;
   }

   if(cursorpos==10)
   {
    fire_text.font=menufontyellow; 
    firekey_text.font=menufontyellow;
   }
    else
   {
    fire_text.font=menufont; 
    firekey_text.font=menufont;
   }

   if(cursorpos==11)
   {
    lookup_text.font=menufontyellow; 
    lookupkey_text.font=menufontyellow;
   }
    else
   {
    lookup_text.font=menufont; 
    lookupkey_text.font=menufont;
   }

   if(cursorpos==12)
   {
    lookdown_text.font=menufontyellow; 
    lookdownkey_text.font=menufontyellow;
   }
    else
   {
    lookdown_text.font=menufont; 
    lookdownkey_text.font=menufont;
   }

   if(cursorpos==13)
   {
    roll_text.font=menufontyellow; 
    rollkey_text.font=menufontyellow;
   }
    else
   {
    roll_text.font=menufont; 
    rollkey_text.font=menufont;
   }

   if(cursorpos==14)
   {
    cyclegunup_text.font=menufontyellow; 
    cyclegunupkey_text.font=menufontyellow;
   }
    else
   {
    cyclegunup_text.font=menufont; 
    cyclegunupkey_text.font=menufont;
   }

   if(cursorpos==15)
   {
    cyclegundown_text.font=menufontyellow; 
    cyclegundownkey_text.font=menufontyellow;
   }
    else
   {
    cyclegundown_text.font=menufont; 
    cyclegundownkey_text.font=menufont;
   }

   if(cursorpos==16)
   {
    togglecrosshair_text.font=menufontyellow; 
    togglecrosshairkey_text.font=menufontyellow;
   }
    else
   {
    togglecrosshair_text.font=menufont; 
    togglecrosshairkey_text.font=menufont;
   }

   if(cursorpos==17)
   {
    mousetoggle_text.font=menufontyellow; 
    mousetogglekey_text.font=menufontyellow;
   }
    else
   {
    mousetoggle_text.font=menufont; 
    mousetogglekey_text.font=menufont;
   }

   if(cursorpos==18)
   {
    toggleview_text.font=menufontyellow; 
    toggleviewkey_text.font=menufontyellow;
   }
    else
   {
    toggleview_text.font=menufont; 
    toggleviewkey_text.font=menufont;
   }

   if(cursorpos==19)
   {
    resetdefaults_text.font=menufontyellow; 
   }
    else
   {
    resetdefaults_text.font=menufont; 
   }

   if(key_enter==1)
    {
     if(cursorpos==0)
      {
       str_cpy(up_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       up_key_var=define_key();
       str_cpy(up_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==1)
      {
       str_cpy(down_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       down_key_var=define_key();
       str_cpy(down_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==2)
      {
       str_cpy(left_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       left_key_var=define_key();
       str_cpy(left_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==3)
      {
       str_cpy(right_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       right_key_var=define_key();
       str_cpy(right_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==4)
      {
       str_cpy(handle_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       handle_key_var=define_key();
       str_cpy(handle_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==5)
      {
       str_cpy(run_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       run_key_var=define_key();
       str_cpy(run_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==6)
      {
       str_cpy(jump_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       jump_key_var=define_key();
       str_cpy(jump_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==7)
      {
       str_cpy(crouch_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       crouch_key_var=define_key();
       str_cpy(crouch_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==8)
      {
       str_cpy(strafel_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       strafel_key_var=define_key();
       str_cpy(strafel_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==9)
      {
       str_cpy(strafer_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       strafer_key_var=define_key();
       str_cpy(strafer_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==10)
      {
       str_cpy(fire_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       fire_key_var=define_key();
       str_cpy(fire_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==11)
      {
       str_cpy(lookup_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       lookup_key_var=define_key();
       str_cpy(lookup_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==12)
      {
       str_cpy(lookdown_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       lookdown_key_var=define_key();
       str_cpy(lookdown_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==13)
      {
       str_cpy(roll_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       roll_key_var=define_key();
       str_cpy(roll_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==14)
      {
       str_cpy(cyclegunup_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       cyclegunup_key_var=define_key();
       str_cpy(cyclegunup_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==15)
      {
       str_cpy(cyclegundown_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       cyclegundown_key_var=define_key();
       str_cpy(cyclegundown_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==16)
      {
       str_cpy(togglecrosshair_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       togglecrosshair_key_var=define_key();
       str_cpy(togglecrosshair_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==17)
      {
       str_cpy(mousetoggle_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       mousetoggle_key_var=define_key();
       str_cpy(mousetoggle_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==18)
      {
       str_cpy(toggleview_str,"ENTER NEW KEY");
       waitt(10);
       while(key_any==0){wait(1);}
       toggleview_key_var=define_key();
       str_cpy(toggleview_str,new_key_str);
       while(key_any==1){wait(1);}
      }

     if(cursorpos==19)
      {reset_default_keys();}

    }
   wait(1);
  }
}


function controls_menu_off()
{
 controls_screen.visible=off;

 forward_text.visible=off;
 backwards_text.visible=off;
 left_text.visible=off;
 right_text.visible=off;
 handle_text.visible=off;
 run_text.visible=off;
 jump_text.visible=off;
 crouch_text.visible=off;
 strafel_text.visible=off;
 strafer_text.visible=off;
 fire_text.visible=off;
 lookup_text.visible=off;
 lookdown_text.visible=off;
 roll_text.visible=off;
 cyclegunup_text.visible=off;
 cyclegundown_text.visible=off;
 togglecrosshair_text.visible=off;
 mousetoggle_text.visible=off;
 toggleview_text.visible=off;

 upkey_text.visible=off;
 downkey_text.visible=off;
 leftkey_text.visible=off;
 rightkey_text.visible=off;
 handlekey_text.visible=off;
 runkey_text.visible=off;
 jumpkey_text.visible=off;
 crouchkey_text.visible=off;
 strafelkey_text.visible=off;
 straferkey_text.visible=off;
 firekey_text.visible=off;
 lookupkey_text.visible=off;
 lookdownkey_text.visible=off;
 rollkey_text.visible=off;
 cyclegunupkey_text.visible=off;
 cyclegundownkey_text.visible=off;
 togglecrosshairkey_text.visible=off;
 mousetogglekey_text.visible=off;
 toggleviewkey_text.visible=off;

 resetdefaults_text.visible=off;

 freeze_mode=0; //resume game
}


//Reset default keys:
function reset_default_keys()
{
 //Reset keys by scancode:
 up_key_var=72;
 down_key_var=80;
 left_key_var=75;
 right_key_var=77;
 handle_key_var=57;
 run_key_var=54;
 jump_key_var=71;
 crouch_key_var=79;
 strafel_key_var=51;
 strafer_key_var=52;
 fire_key_var=29;
 lookup_key_var=73;
 lookdown_key_var=81;
 roll_key_var=56;
 cyclegunup_key_var=18;
 cyclegundown_key_var=16;
 togglecrosshair_key_var=37;
 mousetoggle_key_var=281;
 toggleview_key_var=65;

 //Now refresh the display accordingly:
 str_cpy(up_str,get_key_string(up_key_var));
 str_cpy(down_str,get_key_string(down_key_var));
 str_cpy(left_str,get_key_string(left_key_var));
 str_cpy(right_str,get_key_string(right_key_var));
 str_cpy(handle_str,get_key_string(handle_key_var));
 str_cpy(run_str,get_key_string(run_key_var));
 str_cpy(jump_str,get_key_string(jump_key_var));
 str_cpy(crouch_str,get_key_string(crouch_key_var));
 str_cpy(strafel_str,get_key_string(strafel_key_var));
 str_cpy(strafer_str,get_key_string(strafer_key_var));
 str_cpy(fire_str,get_key_string(fire_key_var));
 str_cpy(lookup_str,get_key_string(lookup_key_var));
 str_cpy(lookdown_str,get_key_string(lookdown_key_var));
 str_cpy(roll_str,get_key_string(roll_key_var));
 str_cpy(cyclegunup_str,get_key_string(cyclegunup_key_var));
 str_cpy(cyclegundown_str,get_key_string(cyclegundown_key_var));
 str_cpy(togglecrosshair_str,get_key_string(togglecrosshair_key_var));
 str_cpy(mousetoggle_str,get_key_string(mousetoggle_key_var));
 str_cpy(toggleview_str,get_key_string(toggleview_key_var));
}


function init_controls() //call from main() to initiate the saved control configuration...
{
 load_info("contr",015);
}





////////////////////////////////////////////
//
// ON KEYS:

//get rid of defualt on_keys:
on_space=null;
on_f7=null;
on_mouse_right=null;
on_e=null;
on_q=null;
on_k=null;

//now use anykey to check which button pressed:
on_anykey=check_input;

on_f12=controls_menu_toggle; //call redefine controls menu...