// Altered by Matthew Coles
// LiveWire Entertainment

// Compatible With Newton Bouyancy

////////////////////////////////////////////////////////
// Environment Mapping Bump Mapping Water
// 
// Version 2
//
// Eric Hendrickson-Lambert (Steempipe)
//
//////////////////////////////////////////////////////// 

////////////////////////////////////////////////////////
// Since at this time I cannot get a cubic Env Map
// to work.  I have taken out most references to it
// and used a basic sky texture because it needs
// the cloud noise for the specular
///////////////////////////////////////////////////////

bmap waterbump2 = <waterbump.bmp>;
bmap envspec2 =  <sky.tga>;
bmap base2 = <gradient.bmp>;

function mtl_ffpwater2_1()
{

///////////////////////////////////////////////
//  Lets make it scroll in some direction
//

  mtl.skill1 += time;		
  mtl.matrix41 = floatd(mtl.skill1,4000); 
   	

}

function mtl_ffpwater2_init()
{
  
  mtl.matrix11 = float(1.6); 	
  mtl.matrix22 = float(0.8);	
 
  bmap_to_mipmap(mtl.skin1);
  bmap_to_mipmap(mtl.skin2);
   bmap_to_mipmap(mtl.skin3);

  bmap_to_normals(mtl.skin1,0.5);

  //bmap_to_cubemap(mtl.Skin2);
  
  mtl.event = mtl_ffpwater2_1;

  mtl.enable_view = on;

}


material mtl_ffpwater2
 {
   skin1=waterbump2;
   skin2=envspec2;
   skin3=base2;

   event = mtl_ffpwater2_init;
   
   effect = "

     matrix matMtl;
     
     texture mtlSkin1;
     texture mtlSkin2;
     texture mtlSkin3;
	
      technique makewater2
        {
          
          pass p0
          {
	
	  Texture[0] = <mtlSkin3>;
		
	  magFilter[0]=linear;
	  minFilter[0]=linear;
	  mipFilter[0]=linear;

          AddressU[0]=Clamp;
	  AddressV[0]=Clamp;

	  ColorArg1[0] = Texture; 
          ColorOp[0] = modulate;
          ColorArg2[0] = diffuse;

     	  alphaop[0]=selectarg1;
	  alphaarg1[0]=texture;

	  texcoordindex[0]=1;
 
	  
          Texture[1] = <mtlSkin1>;
		
	  magFilter[1]=linear;
	  minFilter[1]=linear;
	  mipFilter[1]=linear;
      
	  ColorArg1[1] = Texture; 
          ColorOp[1] = bumpenvmap;
          ColorArg2[1] = current;

	  TextureTransformFlags[1] = Count2;
          TextureTransform[1] = <matMtl>;
          Texcoordindex[1]=1;


	  Texture[2] = <mtlSkin2>;

	  magFilter[2]=linear;
	  minFilter[2]=linear;
	  mipFilter[2]=linear;

	  AddressU[2]=Clamp;
	  AddressV[2]=Clamp;

          ColorArg1[2] = Texture; 
          ColorOp[2] = Add;
	  ColorArg2[2] = Current;
	
        
	  TextureTransformFlags[2] =count3 | projected;
           
       	  texcoordindex[2]= cameraspaceposition | 1;    // For cubemap use: cameraspacereflectionvector
	
          }

       }

technique fallback { pass p0 { } }

    ";
}



action Shader_water2 { 

	var body;

	dll_handle = newtonHandle;
	
	if (my.density == 0.0) {
		my.density = 1.0;
	}

	my.water_entity = 0;	
	body = NewtonAddMapEntity (my, 0);
	NewtonSetBodyMass (body, 0);
	
	NewtonSetBodyMaterial (body, water_material);
	

my.material = mtl_ffpwater2; 

}

