///////////////////////////////////////////////////////////////////////////////////////////////////////////
//A water shader which uses Reflection, Refraction, and thefresnel effect.
//It uses a bumpmap for waves, feel free to use Your own
//You do not have to credit me, it is freeware, although I would appreciate it
//Roel Smit, july 2008
///////////////////////////////////////////////////////////////////////////////////////////////////////////
//variables
float4x4 matWorldViewProj;
float4x4 matWorld;
float4 vecViewPos;
float4 vecFog;
float4 vecTime;
float4 vecSunDir;

//rwater_fx.skill3 = float(my.skill3);
//rwater_fx.skill4 = float(my.skill4);
//rwater_fx.skill5 = float(camera.clip_near);
//rwater_fx.skill6 = float(camera.clip_far);

float4 vecSkill1;
float4 vecSkill5;
//textures
texture mtlSkin1;
texture mtlSkin2;
texture entSkin1;
///////////////////////////////////////////
//samplers
sampler ReflectTex = sampler_state
{
	texture = <mtlSkin1>;
	AddressU = Clamp;
	AddressV = Clamp;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler RefractTex = sampler_state
{
	texture = <mtlSkin2>;
	AddressU = Clamp;
	AddressV = Clamp;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler BumpMap = sampler_state
{
	texture = <entSkin1>;
	AddressU = wrap;
	AddressV = wrap;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
};
///////////////////////////////////////////
//structs to store data
struct VertexIn
{
	float4 Pos 			: POSITION;
	float2 Texc			: TEXCOORD0;
	float3 Normal		: NORMAL;
};
struct PixelIn
{
	float4 Pos 			: POSITION;
	float2 Texc			: TEXCOORD0;
	float4 TPos			: TEXCOORD2;
	float3 Normal		: TEXCOORD3;
};
///////////////////////////////////////////////////////////////////////////////////////////////////////////
//vertex shader
void MainVS_1_1(in VertexIn Input,out PixelIn Output)
{
	//multiply the position
	Output.Pos = mul(Input.Pos,matWorldViewProj);
	//posworld
	float4 PosWorld = mul(Input.Pos ,matWorld);
	
	Output.Texc = PosWorld.xz;
	Output.TPos = Output.Pos;
	Output.Normal = Input.Normal;
//	Output.Depth = min((Output.TPos.w*700/(vecSkill5.x-vecSkill5.y)),0.05);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////
//the reflection coordinates are processed in the pixel shader.
//here we won't have any distortion
//there is a wave effect added.
//the color is taken by a reflection and refraction Map
//pixel shader
//if you want to take care of the depth, comment all the depth things out
float4 MainPS_2_0(in PixelIn Input) : COLOR
{
	//reflection and refraction coordinates
	float2 RCoord = 0.5*(1+Input.TPos.xy/Input.TPos.w);
	//view direction
	float4 vecView = normalize(Input.TPos - vecViewPos);
	float fresnel = dot(Input.Normal,-vecView)*0.5+1;
	//bumpcoordinates
	float2 BumpCoord1 = Input.Texc*0.001*vecSkill1.z+vecTime.w*vecSkill1.w*0.002;
	float2 BumpCoord2 = Input.Texc*0.0003*vecSkill1.z+vecTime.w*vecSkill1.w*0.003;
	//if you want depth, remove *0.1, and insert /(depth)
	//Play with it if you want
	//waves
	RCoord+= tex2D(BumpMap,BumpCoord1)*0.1;//	/(depth)
	RCoord-= tex2D(BumpMap,BumpCoord2)*0.1;//	/(depth)
	//getting color
	half4 Color = tex2D(ReflectTex,RCoord)*(fresnel)+ 
					  tex2D(RefractTex,RCoord)*(1-fresnel);				  
	return Color*0.9;
}
//I need a second pixelshader for the normals, and the reflection view bug
//I know there is reflection under water too, but it leads to a sort of "errors"
//I hope nobody minds
float4 MainPS_2_0_cw(in PixelIn Input) : COLOR
{
	float2 RCoord = 0.5*(1+Input.TPos.xy/Input.TPos.w);
	
	float2 BumpCoord1 = Input.Texc*0.001*vecSkill1.z+vecTime.w*vecSkill1.w*0.002;
	float2 BumpCoord2 = Input.Texc*0.0003*vecSkill1.z+vecTime.w*vecSkill1.w*0.003;
	//if you want depth, remove *0.1, and insert /(depth)
	//Play with it if you want
	RCoord+= tex2D(BumpMap,BumpCoord1)*0.1;//	/(depth)
	RCoord-= tex2D(BumpMap,BumpCoord2)*0.1;//	/(depth)
	half4 Color = tex2D(RefractTex,RCoord);				  
	return Color;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////
//double pass, because we now can see under water too
//techniques
technique DefaultTech
{
	pass p0
	{
		VertexShader = compile vs_1_1 MainVS_1_1();//1.1 is enough
		PixelShader  = compile ps_2_0 MainPS_2_0();//we need 2.0 here, or the w component wouldn't be available
      Fogenable = false;
	}
	pass p0
	{
		VertexShader = compile vs_1_1 MainVS_1_1();//1.1 is enough
		PixelShader  = compile ps_2_0 MainPS_2_0_cw();//we need 2.0 here too
		cullmode = cw;
      Fogenable = false;
	}
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////
//fallback technique for slower machines
technique FallBack
{
	pass p0
	{
		cullmode = none;
	}
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////
//You do not have to credit me, it is freeware, although I would appreciate it
//Roel Smit, july 2008
///////////////////////////////////////////////////////////////////////////////////////////////////////////