/////////////////////////////////////////////////////////////////////////////////////////////////////
//two views
view reflect_view{layer = -1;}
view refract_view{layer = -1;}
bmap* bmap_mirrortarget;
bmap* bmap_refracttarget;
//you may change these sizes, but do not exceed the screen height(or width if you have a strange machine)
var reflectsize[3] = 256,256,16;
var refractsize[3] = 256,256,16;
/////////////////////////////////////////////////////////////////////////////////////////////////////
define reflection_strength,skill1;
define refraction_strength,skill2;
define wavesize,skill3;
define wavespeed,skill4;
define reflect_handle,skill5;
define refract_handle,skill6;
/////////////////////////////////////////////////////////////////////////////////////////////////////
//skill1 = reflect strength
//skill2 = refract strength
//skill3 = clip near 
//skill4 = clip far

function rwater_fx_event
{
	if(render_view == reflect_view || refract_view)
	{
		return(0);
	}
	return(1);
}
material rwater_fx
{
	event = rwater_fx_event;
	effect = "fx_rwater.fx";
	flags = enable_render;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
function create_reflect_view
{
	//create bitmap
	bmap_mirrortarget = bmap_createblack(reflectsize.x,reflectsize.y,reflectsize.z);
	rwater_fx.skin1 = bmap_mirrortarget;
	reflect_view.bmap = bmap_mirrortarget;
	//size settings
	reflect_view.size_x = bmap_width(reflect_view.bmap);
	reflect_view.size_y = bmap_height(reflect_view.bmap);
	//set some flags
	reflect_view.noparticle = on;
	reflect_view.noshader = on;
	reflect_view.visible = on;
	reflect_view.portalclip = on;
	
}
function create_refract_view
{
	//create bitmap
	bmap_refracttarget = bmap_createblack(refractsize.x,refractsize.y,refractsize.z);
	rwater_fx.skin2 = bmap_refracttarget;
	refract_view.bmap = bmap_refracttarget;
	//size settings
	refract_view.size_x = bmap_width(refract_view.bmap);
	refract_view.size_y = bmap_height(refract_view.bmap);
	//set some flags
	refract_view.noparticle = on;
	refract_view.noshader = on;	
	refract_view.visible = on;	
	refract_view.portalclip = on;
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
function check_defaults
{
	if(my.reflection_strength == 0)
	{
		my.reflection_strength = 80;
	}
	if(my.refraction_strength == 0)
	{
		my.refraction_strength = 20;
	}
	if(my.wavesize == 0)
	{
		my.wavesize = 1;
	}
	if(my.wavespeed == 0)
	{
		my.wavespeed = 1;
	}
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
//skill3: wavesize 1
//skill4: wavespeed 1
action water_mirorred
{
	check_defaults();
	my.transparent = off;
	create_reflect_view();
	create_refract_view();
	my.material = rwater_fx;
	while(1)
	{
		while(my.clipped == 1){wait(1);}
		proc_late();
		rwater_fx.skill3 = float(my.skill3);
		rwater_fx.skill4 = float(my.skill4);
		rwater_fx.skill5 = float(camera.clip_near);
		rwater_fx.skill6 = float(camera.clip_far);
		
		//also being under water
		if(camera.z > my.max_z + my.z){result = 1;}else{result = -1;}
		//setting clip planes
		vec_set(reflect_view.pnormal_x,vector(0,0,result));
		vec_set(refract_view.pnormal_x,vector(0,0,-result));
		vec_set(reflect_view.portal_x,vector(0,0,my.z+my.max_z+ result));
		vec_set(refract_view.portal_x,vector(0,0,my.z+my.max_z-1));
		
		//refraction view
		vec_set(refract_view.x,camera.x);
		vec_set(refract_view.pan,camera.pan);
		refract_view.aspect = -screen_size.x/screen_size.y;
		refract_view.arc = camera.arc;
		refract_view.clip_near = camera.clip_near*2;
		refract_view.clip_far = camera.clip_far/2;
		refract_view.genius = camera.genius;
		
		//reflection view
		reflect_view.fog_start = camera.fog_start;
		reflect_view.fog_end = camera.fog_end;
		reflect_view.aspect = screen_size.x/screen_size.y;
		reflect_view.arc = camera.arc;
		reflect_view.clip_near = camera.clip_near*2;
		reflect_view.clip_far = camera.clip_far/2;
		reflect_view.genius = camera.genius;
		reflect_view.pan = camera.pan;
		reflect_view.tilt = -camera.tilt;
		reflect_view.roll = -camera.roll;
		vec_set(reflect_view.x,camera.x);
		reflect_view.z =  2*reflect_view.portal_z - camera.z;
		wait(1);
	}
}

