///////////////////////////////////////////////////////////////////////////////////
var video_mode = 6; 		// 640x480;
var video_depth = 16;	// D3D mode

bmap splashmap = <logolite.bmp>;

panel splashscreen 
{ 
bmap = splashmap; 
flags = refresh,d3d; 
}
///////////////////////////////////////////////////////////////////////////////////
INCLUDE <DEBUG.WDL>;

BMAP MOUSEBMP = <Mouse.bmp>;
string Platform = <platform.mdl>;

var disablemouse; //0 - no, 1 - yes
var vrows;
var vcols;
var vmines;

var NumOfSteps;
var steps[300]; //pointers
var mines[300];
define mine,flag1;
define minecount,skill1;
define col,skill2;
define row,skill3;
///////////////////////////////////////////////////////////////////////////////////
Function Main()
{

// center the splash screen for non-640x480 resolutions
	splashscreen.pos_x = (screen_size.x - bmap_width(splashmap))/2;
	splashscreen.pos_y = (screen_size.y - bmap_height(splashmap))/2;
// set it visible
	splashscreen.visible = on;

// wait 3(!) frames for triple buffering, until it is flipped to the foreground
	sleep(3);

// now load the level
	level_load("MINESW~1.wmb");
// wait the required second, then switch the splashscreen off.
	sleep(1);

  	splashscreen.visible = off;
	bmap_purge(splashmap);	// remove logo bitmap from video memory

vrows = 7;
vcols = 7;
vmines = 10;
GenerateLevel();
InitMouse();

DisplayStr("Pressed R to generate a new mine feild");

while(1)
{
CheckPuzzle();
wait(1);
}

}
///////////////////////////////////////////////////////////////////////////////////
Function DisplayMines()
{
var i;
i = 1;
while(i < vmines)
{
you = ptr_for_handle(steps[mines[i]]);
you.skin = 12;
i += 1;
}

}
///////////////////////////////////////////////////////////////////////////////////
Function CheckPuzzle()
{

var i;
i = 1;
while(i < numofsteps)
{
you = ptr_for_handle(steps[i]);
//See if step has been uncovered
if(you.skin == 1)
{
return; //Return
}
i += 1;
}

//if it got this far the puzzle must be solved
displaystr("SOLVED");

}
///////////////////////////////////////////////////////////////////////////////////
Function ClickEvents()
{

temp.x = MOUSE_POS.x;
temp.y = MOUSE_POS.y;
temp.z = 9999;
vec_for_screen(temp,camera);

trace_mode = IGNORE_PASSABLE; 
trace(camera.x,temp);

if(you != null)
{
if(mouse_left == 1)
{
you.skin = you.minecount + 1;

if(you.minecount == 0)
{
you.skin = 10;
}

if(you.mine == on)
{
you.skin = 12;
DisplayMines();
disablemouse = 1;
}
}

if(mouse_right == 1)
{
if(you.skin == 1) //make sure hasn't been changed yet
{
you.skin = 11;
}
}

}

}
///////////////////////////////////////////////////////////////////////////////////
Function InitMouse()
{
MOUSE_MAP = MOUSEBMP;
mouse_mode = 1;

While(1)
{
MOUSE_POS.X = POINTER.X;
MOUSE_POS.Y = POINTER.Y;

if(disablemouse == 0)
{
ClickEvents();
}

wait(1);
}

}
///////////////////////////////////////////////////////////////////////////////////
Function UpdateNearbySteps(n)
{

my = ptr_for_handle(steps[n]);

if(n + 1 > vcols * vrows)
{
}
else
{
you = ptr_for_handle(steps[n + 1]);
if(my.row == you.row) //have to been in the same row
{
you.minecount += 1;
}
}

if(n - 1 <= 0)
{
}
else
{
you = ptr_for_handle(steps[n - 1]);
if(my.row == you.row) //have to been in the same row
{
you.minecount += 1;
}
}

if(n - vcols <= 0)
{
}
else
{
you = ptr_for_handle(steps[n - vcols]);
you.minecount += 1;
}

if(n + vcols > vcols * vrows)
{
}
else
{
you = ptr_for_handle(steps[n + vcols]);
you.minecount += 1;
}

if(n - (vcols + 1) <= 0)
{
}
else
{
you = ptr_for_handle(steps[n - (vcols + 1)]);
if(my.col - 1 == you.col)
{
you.minecount += 1;
}
}

if(n + (vcols + 1) > vcols * vrows)
{
}
else
{
you = ptr_for_handle(steps[n + (vcols + 1)]);
if(my.col + 1 == you.col)
{
you.minecount += 1;
}
}

if(n + (vcols - 1) > vcols * vrows)
{
}
else
{
you = ptr_for_handle(steps[n + (vcols - 1)]);
if(my.row + 1 == you.row)
{
you.minecount += 1;
}
}

if(n - (vcols - 1) <= 0)
{
}
else
{
you = ptr_for_handle(steps[n - (vcols - 1)]);
if(my.row - 1 == you.row)
{
you.minecount += 1;
}
}

}
///////////////////////////////////////////////////////////////////////////////////
Function Reset()
{
DisplayStr("Pressed R to generate a new mine feild");

var i;
i = 1;
while(i < numofsteps + 1)
{
you = ptr_for_handle(steps[i]);
ent_remove(you);
i += 1;
}

disablemouse = 0;
numofsteps = 0;
}
///////////////////////////////////////////////////////////////////////////////////
Function GenerateLevel()
{
Reset();
//Create a 5 by 5 map
var i;
var j;
j = 1;
i = 1;
while(i < vrows + 1)
{
while(j < vcols + 1)
{
temp.x = i * 50;
temp.y = j * 50;
temp.z = 0;
you = ent_create(Platform,temp,NULL);
you.row = i;
you.col = j;
NumOfSteps += 1;
steps[NumOfSteps] = handle(you);
j += 1;
}
j = 1;
i += 1;
}

//Generate the mines
var n;
n = 1;
var c;
while(n < vmines + 1)
{
randomize();
c = int(random(vcols * vrows + 1));
if(c == 0)
{
}
else
{
you = ptr_for_handle(steps[c]);
if(you.mine == on)
{
}
else
{
mines[n] = c;
you.mine = on;
//Update nearby steps
UpdateNearbySteps(c);
//End update
n += 1;
}
}
wait(1);
}
//Done Generating

//Adjust camera
you = ptr_for_handle(steps[int(vcols * vrows / 2 + 1)]);
camera.x = you.x;
camera.y = you.y;
camera.z = vcols * vrows * 16;
camera.tilt = -90;
camera.roll = -90;
//Done adjusting

}
///////////////////////////////////////////////////////////////////////////////////
on_r GenerateLevel();