//Joris Lambrecht
//2-23-2009
//
//Include this script to enable a maximize button in the engine window, window sizing with
//proper cursors, and automatic adjustment of the resolution to match the scaled window size.
//
//A7.08 or later required for mouse_pointer > 4
//To Add: fullscreen mode on non-primary monitor if command_str == "-mon #"  Requires (P A7.2)
//
//revisions:
//

#ifndef WindowSizing_c
#define WindowSizing_c

#define MY_WINDOW_STYLE WS_TILEDWINDOW
#define OVER_RIGHT_EDGE  1
#define OVER_LEFT_EDGE   2
#define OVER_TOP_EDGE    4
#define OVER_BOTTOM_EDGE 8

BOOL wflags[5];
#define RESTORE   0
#define RESIZED   1
#define MAXIMIZED 2
#define MOVED     3
#define IGNORE	   4
var window_mode; //maximized, minimized, restored

var bw, bh, ch; //border width, border height, caption height (get via sys_metrics)
VECTOR client_size, window_size, restore_pos, new_restore_pos;
RECT client_rect; 

PANEL* display_panel = {
	digits(10, 10, "HIDE panel with f1 key...", "Courier#12", 0, 0);
	digits(10, 25, "Double click for FULLSCREEN", "Courier#12", 0, 0);
	digits(10, 40, "Drag edges to SIZE WINDOW", "Courier#12", 0, 0);
	digits(10, 60, "screen resolution : %4.0f X", "Courier#12", 1, screen_size.x);
	digits(10, 60, "                           %4.0f", "Courier#12", 1, screen_size.y);
	digits(10, 75, "window client size: %4.0f X", "Courier#12", 1, client_size.x);
	digits(10, 75, "                           %4.0f", "Courier#12", 1, client_size.y);
	digits(10, 100, "current window position: %4.0f X", "Courier#12", 1, window_pos.x);
	digits(10, 100, "                                %4.0f", "Courier#12", 1, window_pos.y);
	digits(10, 115, "restore window position: %4.0f X", "Courier#12", 1, restore_pos.x);
	digits(10, 115, "                                %4.0f", "Courier#12", 1, restore_pos.y);
	digits(10, 135, "border width  : %2.0f", "Courier#12", 1, bw);
	digits(10, 150, "border height : %2.0f", "Courier#12", 1, bh);
	digits(10, 165, "caption height: %2.0f", "Courier#12", 1, ch);
	digits(10, 185, "mouse coordinates : %4.0f X", "Courier#12", 1, mouse_cursor.x);
	digits(10, 185, "                           %4.0f", "Courier#12", 1, mouse_cursor.y);
	digits(10, 200, "mouse pointer type: %2.0f", "Courier#12", 1, mouse_pointer);
	
	flags = SHOW;	
}

function ToggleFullScreen(){
	if(video_screen != 1){
		//Window will open fullscreen on the primary monitor
		var w=sys_metrics(SM_CXSCREEN);
		var h=sys_metrics(SM_CYSCREEN);
		video_set(w,h,0,1);
	}
	else
		wflags[RESTORE] = ON;
}

function MyWindowProc(UINT message, WPARAM wParam, LPARAM lParam){
	if(message==WM_SIZE && !wflags[IGNORE]){
		client_size.x=LOWORD(lParam);
		client_size.y=HIWORD(lParam);
		window_mode=wParam;
		if(window_mode == SIZE_MAXIMIZED) wflags[MAXIMIZED] = ON;
		if(window_mode == SIZE_RESTORED && wflags[MAXIMIZED])	wflags[RESTORE] = ON;
		wflags[RESIZED]=ON;
	}
	if(message==WM_MOVE){
		wflags[MOVED]=ON;
	}	
	if(message==WM_LBUTTONDBLCLK && !wflags[MAXIMIZED]){
		ToggleFullScreen();
	}
}

function VideoSetError(){
	MessageBox(hWnd, "Resolution adjustment failed, resize the window to refresh","Target Task", 
	                          MB_OK+MB_SETFOREGROUND+MB_DEFBUTTON1+MB_ICONEXCLAMATION);	
}

function TogglePanel(){
	toggle(display_panel, SHOW);
}

function LocateMouse(){
	var mouse_location = 0;
	if(mouse_cursor.x >= screen_size.x && mouse_cursor.x <= screen_size.x + bw)
		mouse_location += OVER_RIGHT_EDGE;
	if(mouse_cursor.x >= -bw && mouse_cursor.x < 0)
		mouse_location += OVER_LEFT_EDGE;
	if(mouse_cursor.y >= screen_size.y && mouse_cursor.y <= screen_size.y + bh)
		mouse_location += OVER_BOTTOM_EDGE;
	if(mouse_cursor.y >= -bh-ch && mouse_cursor.y + ch < 0)
		mouse_location += OVER_TOP_EDGE;
	return(mouse_location);
}

function windowsizing_startup(){
	video_window(NULL, NULL, 116, 0); //make a window with a menu and thick sizing frame
	SetClassLong(hWnd, GCL_STYLE, GetClassLong(hWnd, GCL_STYLE) | CS_DBLCLKS); 
		//enable double clicks for use in MyWindowProc
	SetWindowLong(hWnd,GWL_STYLE, MY_WINDOW_STYLE);  
		//change the window style to include a maximize button.  
		//important: this style has the same border thickness and caption heights as before
	
	wait(2);
	wflags[RESIZED]=ON; wflags[MOVED]=ON;
	
	on_scanmessage = MyWindowProc; 
	on_f1 = TogglePanel;
	//get border sizes for mouse over information
	bw = sys_metrics(SM_CXFRAME);
	bh = sys_metrics(SM_CYFRAME);
	ch = sys_metrics(SM_CYCAPTION);
		
	while(1){
		//adjust the cursor based on the mouse position
		if(!mouse_valid && video_screen !=1){
			switch(LocateMouse()){
				case OVER_RIGHT_EDGE:
				case OVER_LEFT_EDGE:
					mouse_pointer = 8; break;
				case OVER_TOP_EDGE:
				case OVER_BOTTOM_EDGE:
					mouse_pointer = 9; break;
				case OVER_RIGHT_EDGE+OVER_TOP_EDGE:
				case OVER_LEFT_EDGE+OVER_BOTTOM_EDGE:
					mouse_pointer = 7; break;
				case OVER_LEFT_EDGE+OVER_TOP_EDGE:
				case OVER_RIGHT_EDGE+OVER_BOTTOM_EDGE:
					mouse_pointer = 6; break;
				default: 
					mouse_pointer = 2;
			}
		}
		else
			mouse_pointer = 3;
			
		if(wflags[MOVED] && video_screen !=1 && !wflags[MAXIMIZED]){
			vec_set(restore_pos, window_pos);
			wflags[MOVED]=OFF;
		}
		if(wflags[RESIZED] && video_screen !=1 || wflags[RESTORE]){
			//if the window got restored from maximized or fullscreen,
			//set the window to its former restored size (stored in client_rect)
			if(wflags[RESTORE]){
				window_size.x=client_rect.right;
				window_size.y=client_rect.bottom;			
				wflags[RESTORE] = OFF;
			}
			//otherwise set the window size returned by WM_SIZE in MyWindowProc
			else{
				window_size.x=client_size.x;
				window_size.y=client_size.y;
			}
			
			switch(window_mode) {
				case SIZE_MAXIMIZED: 
					//video_set does not support maximized windows, so it will restore the window before 
					//setting the new resolution.  The window will not fit because of the borders, so before
					//using video_set change the window style to a borderless window.  Set the wflags[IGNORE] flag 
					//because the video_set will create an unwanted WM_SIZE message
					wflags[IGNORE]=ON;
					video_window(NULL, NULL, 1, 0); //remove borders
					if(video_set(window_size.x, window_size.y, 0, 2)==0) {VideoSetError();}
					SetWindowLong(hWnd,GWL_STYLE, MY_WINDOW_STYLE); //restore MY_WINDOW_STYLE
					ShowWindow(hWnd,SW_MAXIMIZE); //show the window as maximized.
					wflags[IGNORE]=OFF;
					break;
				case SIZE_MINIMIZED:
					ShowWindow(hWnd,SW_MINIMIZE);
					break;
				case SIZE_RESTORED:
					video_window(NULL, NULL, 116, 0); //reset the window to a style that has the same 
						//border/caption sizes as MY_WINDOW_STYLE
					if(video_set(window_size.x, window_size.y, 0, 2)==0) {VideoSetError();}
					SetWindowLong(hWnd,GWL_STYLE, MY_WINDOW_STYLE); //restore MY_WINDOW_STYLE
					ShowWindow(hWnd,SW_SHOWNORMAL); //show the window as restored.
					
					video_window(restore_pos, NULL, NULL, 0);
					wflags[MAXIMIZED]=OFF;
					GetClientRect(hWnd, &client_rect);	//Get the new client_rect 
						//If the window is maximized it will restore to this size
					break; 
				default:
					error("shouldn't get to this case");
			}
			wflags[RESIZED]=OFF;	
		}
		wait(1);
	}
}

#endif


