////////////////////////////////////////////////////////////////////////
// A6 main wdl:
//		Created by WED.
////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where template files can be found.
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6";	// Path to A6 templates directory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\code";	// Path to A6 template code subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\images";	// Path to A6 template image subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\sounds";	// Path to A6 template sound subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\models";	// Path to A6 template model subdirectory

/////////////////////////////////////////////////////////////////
// Filename of the starting level.
string level_str = <LESSON3.WMB>; // give file names in angular brackets

////////////////////////////////////////////////////////////////////////////
// Included files
include <gid01.wdl>;	// global ids
include <display00.wdl>;  // basic display settings





/////////////////////////////////////////////////////////////////
// Desc: The main() function is started at game start
function main()
{
	// set some common flags and variables
	// freeze all entity functions
	freeze_mode = 1;
	// no level has been loaded yet...
	gid01_level_state = gid01_level_not_loaded;

// entry: Warning Level (0,1, or 2)
// entry_help: Sets sensitivity to warnings (0 = none, 1 = some, 2 = all).
	warn_level = 2;	// announce bad texture sizes and bad wdl code


// entry: Starting Mouse Mode (0, 1, or 2)
	mouse_mode = 0;

	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);
	
	max_particles = 10000;

	// now load the level
	level_load(level_str);

	wait(2);	// let level load
	// level should be loaded at this point...
	gid01_level_state = gid01_level_loaded;

//+++ load starting values

	// main game loop
	while(1)
	{
		if(gid01_level_state != gid01_level_loaded)
		{
			// pause the game
			freeze_mode = 1;
		}
		else
		{
			// un-freeze the game
			freeze_mode = 0;
		}
		wait(1);
	}
}


// Desc: this is the function used to restart the game.
function	main_restart_game()
{
	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);

	max_particles = 10000;

	// now load the level
	level_load(level_str);
	// freeze the game
	freeze_mode = 1;

	wait(2);	// 1-level loads, 2-entities load

//+++ load starting values

	// un-freeze the game
	freeze_mode = 0;
}


// Desc: this is the function used to quit the game.
function	main_quit()
{
//+++			// save global skills & strings
	exit;
}

/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
WINDOW WINSTART
{
	TITLE			"3D GameStudio";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}

/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FONT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/


/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;

string instructions = "Press 1 for the minimal laser beam and 2 for the improved one.";

text instructions_txt 
{
  font = _a4font; 
  pos_x = 10; 
  pos_y = 10;
}

function on_screen(str) 
{
  instructions_txt.string = str;
  instructions_txt.visible = on;
}

///////////////////////////////////////////////////////////////////////
// Minimal script
////////////////////////////////////////////////////////////////////////

function min_photon();

var photon_size = 5;								 
var velocity;																

action a_min_laser
{	
	randomize();
	on_screen(instructions);

	// define a direction/velocity for the laser
	velocity.x = 50;
	velocity.y = 0;
	velocity.z = 0;
	
	// loop which generates the photons
	while(1)
	{
		if (key_1)
		{	
			// create the particles
			effect(min_photon,1,my.x,velocity.x);
		}
		wait(1);
	}
}

function min_photon()
{
	if (my.lifespan==80)
	{
		my.size = photon_size;
		my.bright = on;
		my.flare = on;
		my.alpha = 100;
		my.move  = on;
		my.red = random(40);
		my.green = 255;
		my.blue = random(40);
		my.gravity = 0;
		my.lifespan = 30;
	}
}


//////////////////////////////////////////////////////////////////////
//			Improved script
//////////////////////////////////////////////////////////////////////

function ceiling(x)
{
	return(int(x)+(frc(x)>0));
}

function improved_photon();

var position;

bmap photon = <novaV1.pcx>;
var n;
var photon_p = 0.2;
var velocity_dir;

action a_improved_laser
{	
	// define a direction/velocity for the laser
	velocity.x = 50;
	velocity.y = 0;
	velocity.z = 0;
	
	// loop which generates the photons
	while(1)
	{
		n = ceiling(vec_length(velocity.x)*time/(photon_size*photon_p));
		
		if (key_2)
		{	
			my.skill1 = 1;		// counts particles in the strip
				
			while(my.skill1<=n)
			{
				// compute the unitary vector parallel the velocity
				vec_set(velocity_dir.x,velocity.x);
				vec_normalize(velocity_dir.x,1);
				
				// places the n particles along a strip begining at my.x
				// and ending at my.x + vel_direction*l*(n-1)
				position.x = my.x + 
				             (my.skill1-1)*velocity_dir.x*(photon_size*photon_p)
								- time*velocity.x;
				position.y = my.y + 
				             (my.skill1-1)*velocity_dir.y*(photon_size*photon_p)
								- time*velocity.y;;
				position.z = my.z + 
				             (my.skill1-1)*velocity_dir.z*(photon_size*photon_p)
								- time*velocity.z;
				
				// creats the particles
				effect(improved_photon,1,position.x,velocity.x);

				//increment the counter
				my.skill1 += 1;
			}

		}
		wait(1);
	}
}

function improved_photon()
{
	if (my.lifespan==80)
	{
		my.bmap = photon;
		my.size = photon_size;
		my.bright = on;
		my.flare = on;
		my.alpha = 100;
		my.move  = on;
		my.red = random(40);
		my.green = 255;
		my.blue = random(40);
		my.gravity = 0;
		my.lifespan = 30;
	}
}