////////////////////////////////////////////////////////////////////////
// A6 main wdl:
//		Created by WED.
////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where template files can be found.
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6";	// Path to A6 templates directory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\code";	// Path to A6 template code subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\images";	// Path to A6 template image subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\sounds";	// Path to A6 template sound subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\models";	// Path to A6 template model subdirectory

/////////////////////////////////////////////////////////////////
// Filename of the starting level.
string level_str = <LESSON4.WMB>; // give file names in angular brackets

////////////////////////////////////////////////////////////////////////////
// Included files
include <gid01.wdl>;	// global ids
include <display00.wdl>;  // basic display settings





/////////////////////////////////////////////////////////////////
// Desc: The main() function is started at game start
function main()
{
	// set some common flags and variables
	// freeze all entity functions
	freeze_mode = 1;
	// no level has been loaded yet...
	gid01_level_state = gid01_level_not_loaded;

// entry: Warning Level (0,1, or 2)
// entry_help: Sets sensitivity to warnings (0 = none, 1 = some, 2 = all).
	warn_level = 2;	// announce bad texture sizes and bad wdl code


// entry: Starting Mouse Mode (0, 1, or 2)
	mouse_mode = 0;

	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);
	
	max_particles = 10000;

	// now load the level
	level_load(level_str);

	wait(2);	// let level load
	// level should be loaded at this point...
	gid01_level_state = gid01_level_loaded;

//+++ load starting values

	// main game loop
	while(1)
	{
		if(gid01_level_state != gid01_level_loaded)
		{
			// pause the game
			freeze_mode = 1;
		}
		else
		{
			// un-freeze the game
			freeze_mode = 0;
		}
		wait(1);
	}
}


// Desc: this is the function used to restart the game.
function	main_restart_game()
{
	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);
	
	max_particles = 10000;

	// now load the level
	level_load(level_str);
	// freeze the game
	freeze_mode = 1;

	wait(2);	// 1-level loads, 2-entities load

//+++ load starting values

	// un-freeze the game
	freeze_mode = 0;
}


// Desc: this is the function used to quit the game.
function	main_quit()
{
//+++			// save global skills & strings
	exit;
}

/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
WINDOW WINSTART
{
	TITLE			"3D GameStudio";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}

/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FONT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/


/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;

function leader();
function tail();
function spark();

function ceiling(x)
{
	return(int(x)+(frc(x)>0));
}

// function of the launcher
var initial_speed = 80;

action a_launcher
{
	randomize();
	
	var theta;
	var phi;
	var init_velocity;
	
	my.skill1 = 4;			// wait 4 ticks between launches
	
	while(1)
	{
		if (my.skill1>0)
		{
			my.skill1 -= time;
		}
		else
		{
			my.skill1 = 4;
			// pick an initial velocity in a cone 
			theta = random(30);
			phi = random(360);
			init_velocity.x = initial_speed*cos(phi)*sin(theta);
			init_velocity.y = initial_speed*sin(phi)*sin(theta);
			init_velocity.z = initial_speed*cos(theta);
			// launch now
			effect(leader,1,my.x,init_velocity.x);
		}
		wait(1);
	}
}	

// function of the leader
bmap leader_image = <novaR1.pcx>;
var leader_life = 32;

bmap tail_image = <novaw.pcx>;
var tail_size = 40;
var tail_p = 0.2;		
var tail_position;

var spark_vel;	

function leader()
{
	if (my.lifespan==80)
	{ 
		my.bmap = leader_image;
		my.size = 300;
		my.bright = on;
		my.flare = on;
		my.alpha = 100;
		my.move  = on;
		my.red = 255;
		my.green = 150;
		my.blue = 50;
		my.gravity = 3;
		my.lifespan = leader_life;
	}
	
	// leader size fluctuates a bit
	my.size = 300*(0.75+0.25*random(1));
	
	// now for the green tail
	// first compute velocity length
	my.skill_a = 
	sqrt(my.vel_x*my.vel_x+my.vel_y*my.vel_y+my.vel_z*my.vel_z);
	// then compute the number of particles necessary for each frame
	my.skill_b = ceiling(my.skill_a*time/(tail_size*tail_p));
	// finally the tail is constructed here
	my.skill_c = 0;
	while(my.skill_c<my.skill_b)
	{
		tail_position.x = my.x - time*my.vel_x*(my.skill_c/my.skill_b-1);
		tail_position.y = my.y - time*my.vel_y*(my.skill_c/my.skill_b-1);
		tail_position.z = my.z - time*my.vel_z*(my.skill_c/my.skill_b-1);

		effect(tail,1,tail_position.x,nullvector);
		
		my.skill_c += 1;
	}
	
	// create some white sparks during the last 50% of leader's life
	if (my.lifespan<(0.5*leader_life))
	{
		// spark is created with a little random velocity in (xy)
		spark_vel.x = 10*(random(1)-0.5);
		spark_vel.y = 10*(random(1)-0.5);
		spark_vel.z = 0;
		effect(spark,1,my.pos,spark_vel);
	} 
}

// function of the tail particle
var tail_life = 7;	

function tail()
{
	if (my.lifespan==80)
	{ 
		my.bmap = tail_image;
		my.size = tail_size;
		my.bright = on;
		my.flare = on;
		my.alpha = 100;
		my.move  = on;
		my.red = 50;
		my.green = 255;
		my.blue = 50;
		my.gravity = 0;
		my.lifespan = tail_life;
	}
	
	// erases the tail after a while
	my.alpha = 100*(my.lifespan/tail_life);
}

// function for the white sparks
bmap spark_image = <novaw.pcx>;
var spark_size = 50;				
var spark_max_life = 20;		

function spark()
{
	if (my.lifespan==80)
	{ 
		my.bmap = spark_image;
		my.size = 0;
		my.bright = on;
		my.flare = on;
		my.alpha = 100;
		my.move  = on;
		my.red = 255;
		my.green = 255;
		my.blue = 255;
		my.gravity = 2;
		my.lifespan = 5 + random(spark_max_life-5);
	}
	
	// makes the sparks "pop"
	my.size = spark_size*sin(180*my.lifespan/spark_max_life);
}