////////////////////////////////////////////////////////////////////////
// A6 main wdl:
//		Created by WED.
////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where template files can be found.
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6";	// Path to A6 templates directory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\code";	// Path to A6 template code subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\images";	// Path to A6 template image subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\sounds";	// Path to A6 template sound subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\models";	// Path to A6 template model subdirectory

/////////////////////////////////////////////////////////////////
// Filename of the starting level.
string level_str = <LESSON5.WMB>; // give file names in angular brackets

////////////////////////////////////////////////////////////////////////////
// Included files
include <gid01.wdl>;	// global ids
include <display00.wdl>;  // basic display settings





/////////////////////////////////////////////////////////////////
// Desc: The main() function is started at game start
function main()
{
	// set some common flags and variables
	// freeze all entity functions
	freeze_mode = 1;
	// no level has been loaded yet...
	gid01_level_state = gid01_level_not_loaded;

// entry: Warning Level (0,1, or 2)
// entry_help: Sets sensitivity to warnings (0 = none, 1 = some, 2 = all).
	warn_level = 2;	// announce bad texture sizes and bad wdl code


// entry: Starting Mouse Mode (0, 1, or 2)
	mouse_mode = 0;

	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);
	
	max_particles = 10000;

	// now load the level
	level_load(level_str);

	wait(2);	// let level load
	// level should be loaded at this point...
	gid01_level_state = gid01_level_loaded;

//+++ load starting values

	// main game loop
	while(1)
	{
		if(gid01_level_state != gid01_level_loaded)
		{
			// pause the game
			freeze_mode = 1;
		}
		else
		{
			// un-freeze the game
			freeze_mode = 0;
		}
		wait(1);
	}
}


// Desc: this is the function used to restart the game.
function	main_restart_game()
{
	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);
	
	max_particles = 10000;

	// now load the level
	level_load(level_str);
	// freeze the game
	freeze_mode = 1;

	wait(2);	// 1-level loads, 2-entities load

//+++ load starting values

	// un-freeze the game
	freeze_mode = 0;
}


// Desc: this is the function used to quit the game.
function	main_quit()
{
//+++			// save global skills & strings
	exit;
}

/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
WINDOW WINSTART
{
	TITLE			"3D GameStudio";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}

/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FONT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/


/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;

function a_planet();
function a_ship();
function a_rocket();

var r_planet = 500;
var ang_planet = 2;
var pos_planet;

var ang_ship = 3;
var r_ship = 150;

string missile = <missile.pcx>;
var vel_rocket;
var angle_rocket;

action a_star
{
	randomize();
	
	camera.arc = 100;
	my.oriented = on;
	my.facing = off;
	my.scale_x = 2;
	my.scale_y = 2;
	my.ambient = 100;
	my.light = on;
	my.red = 255;
	my.green = 255;
	my.blue = 255;
	
	var velocity;
	var delay;
	
	while(1)
	{
		// death star rotates
		my.pan += 0.5*time;
		
		// shoots things
		if (delay==16)
		{
			// lauch missile
			velocity = 50+random(10);
			angle_rocket = random(360);
			vel_rocket.x = velocity*cos(angle_rocket);
			vel_rocket.y = velocity*sin(angle_rocket);
			ent_create(missile,my.x,a_rocket);
		}
		
		// update counter
		if (delay>0)
		{
			delay -= time;
		}
		else
		{
			delay = 16;
		}
		wait(1);
	}
}


action a_planet
{
	my.oriented = on;
	my.facing = off;
	my.scale_x = 1.5;
	my.scale_y = 1.5;
	my.ambient = 100;
	my.light = on;
	my.red = 255;
	my.green = 255;
	my.blue = 255;
	
	while(1)
	{
		// orbits around the star
		pos_planet.x = r_planet*cos(ang_planet*total_ticks);
		pos_planet.y = r_planet*sin(ang_planet*total_ticks);
		pos_planet.z = 70;
		vec_set(my.x,pos_planet.x);
		// rotates onto itself too
		my.pan += ang_planet*time;
		wait(1);
	}
}


action a_ship
{
	proc_late();
	my.oriented = on;
	my.facing = off;
	my.scale_x = 0.75;
	my.scale_y = 0.75;
	my.pan = 180;
	my.ambient = 100;
	my.light = on;
	my.red = 255;
	my.green = 255;
	my.blue = 255;
	
	while(1)
	{
		// orbits around the planet
		my.x = pos_planet.x + r_ship*cos(ang_ship*total_ticks);
		my.y = pos_planet.y + r_ship*sin(ang_ship*total_ticks);
		wait(1);
	}
}

action a_rocket
{
	my.oriented = on;
	my.facing = off;
	my.tilt = 90;
	my.pan = 180+angle_rocket;   // turn the missile so it points 
									     // where it is going.
	my.ambient = 100;
	my.light = on;
	my.red = 255;
	my.green = 255;
	my.blue = 255;
	my.scale_x = 1;
	my.scale_y = 1;
	
	my.skill1 = vel_rocket.x;
	my.skill2 = vel_rocket.y;
	my.skill3 = 16;
	
	while(1)
	{
		if (my != null)
		{
			if (my.skill3>0)
			{
				my.x += my.skill1*time;
				my.y += my.skill2*time;
				my.skill3 -= time;
			}
			else
			{
				remove(me);
			}
		}
		
		wait(1);
	}
	
}