////////////////////////////////////////////////////////////////////////
// A6 main wdl:
//		Created by WED.
////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where template files can be found.
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6";	// Path to A6 templates directory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\code";	// Path to A6 template code subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\images";	// Path to A6 template image subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\sounds";	// Path to A6 template sound subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\models";	// Path to A6 template model subdirectory

/////////////////////////////////////////////////////////////////
// Filename of the starting level.
string level_str = <LESSON6.WMB>; // give file names in angular brackets

////////////////////////////////////////////////////////////////////////////
// Included files
include <gid01.wdl>;	// global ids
include <display00.wdl>;  // basic display settings





/////////////////////////////////////////////////////////////////
// Desc: The main() function is started at game start
function main()
{
	// set some common flags and variables
	// freeze all entity functions
	freeze_mode = 1;
	// no level has been loaded yet...
	gid01_level_state = gid01_level_not_loaded;

// entry: Warning Level (0,1, or 2)
// entry_help: Sets sensitivity to warnings (0 = none, 1 = some, 2 = all).
	warn_level = 2;	// announce bad texture sizes and bad wdl code


// entry: Starting Mouse Mode (0, 1, or 2)
	mouse_mode = 0;

	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);
	
	max_particles = 10000;

	// now load the level
	level_load(level_str);

	wait(2);	// let level load
	// level should be loaded at this point...
	gid01_level_state = gid01_level_loaded;

//+++ load starting values

	// main game loop
	while(1)
	{
		if(gid01_level_state != gid01_level_loaded)
		{
			// pause the game
			freeze_mode = 1;
		}
		else
		{
			// un-freeze the game
			freeze_mode = 0;
		}
		wait(1);
	}
}


// Desc: this is the function used to restart the game.
function	main_restart_game()
{
	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);
	
	max_particles = 10000;

	// now load the level
	level_load(level_str);
	// freeze the game
	freeze_mode = 1;

	wait(2);	// 1-level loads, 2-entities load

//+++ load starting values

	// un-freeze the game
	freeze_mode = 0;
}


// Desc: this is the function used to quit the game.
function	main_quit()
{
//+++			// save global skills & strings
	exit;
}

/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
WINDOW WINSTART
{
	TITLE			"3D GameStudio";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}

/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FONT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/


/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;

string instructions = "Move the camera closer to the portal";

text instructions_txt 
{
  font = _a4font; 
  pos_x = 10; 
  pos_y = 10;
}

function on_screen(str) 
{
  instructions_txt.string = str;
  instructions_txt.visible = on;
}


function a_circle();
function spark_rise();

var delay_circles = 16;
var delay_sparks = 0.5;
var radius_disk = 15;
var ang_velocity = 15;

string circle_image = <circle.pcx>;

bmap spark_image = <novaw1.pcx>;

action a_portal
{
	randomize();
	on_screen(instructions);
	
	wait(2);
	fog_color = 1;
	camera.fog = 40;
	
	my.invisible = on;
	my.passable = on;
	
	my.skill1 = delay_circles;
	my.skill2 = delay_sparks;
	
	// to compute distance camera-portal
	var temporary;
	var distance;
	
	// to create sparks
	var r;
	var phi;
	var position;
	var velocity;
	var spark_speed;
	
	while(1)
	{
		// computes distance between camera and portal
		vec_set(temporary.x,my.x);
		vec_diff(temporary.x,temporary.x,camera.x);
		distance = vec_length(temporary.x);
		
		// create a circle
		if (my.skill1==delay_circles)
		{
			ent_create(circle_image,my.x,a_circle);
		}
		
		// create sparks that rise if camera farther than 500 quants
		if ((my.skill2==delay_sparks) && (distance>500))
		{
			// we pick a location RANDOMLY in the circle r<radius
			r = random(radius_disk);
			phi = random(360);
			position.x = r*cos(phi);
			position.y = r*sin(phi);
			position.z = my.z+10;
			// we give a slight radial speed
			spark_speed = random(2.5);
			velocity.x = spark_speed*cos(phi);
			velocity.y = spark_speed*sin(phi);
			velocity.z = 0;
			// create the particle
			effect(spark_rise,1,position.x,velocity.x);
		}
		
		// creates a string of sparks that circle the portal
		if ((my.skill2==delay_sparks) && (distance<500))
		{
			// we pick a ROTATING location on the circle r = 2*radius_disk
			phi = ang_velocity*total_ticks;
			position.x = 2*radius_disk*cos(phi);
			position.y = 2*radius_disk*sin(phi);
			position.z = my.z+10;
			// create the particle
			effect(spark_rise,1,position.x,nullvector);
		}
		
		// update the timer for the circles
		if (my.skill1>0)
		{
			my.skill1 -= time;
		}
		else
		{
			my.skill1 = delay_circles;
		}
		
		// update the timer for the sparks
		if (my.skill2>0)
		{
			my.skill2 -= time;
		}
		else
		{
			my.skill2 = delay_sparks;
		}
		
		wait(1);
	}
}

// action for circles in the portal
action a_circle
{
	my.passable = on;
	my.oriented = on;
	my.flare = on;
	my.bright = on;
	my.blue = 255;
	my.green = 255;
	my.red = 255;
	my.alpha = 100;
	my.tilt = 90;
	my.scale_x = 0.1;
	my.scale_y = 0.1;
	my.light = on;
	my.ambient = -255;
	my.unlit = on;
	
	while(my.scale_x<2)
	{
		// expand the circle
		my.scale_x += 0.05*time;
		my.scale_y = my.scale_x;
		
		// dim the circle once scale>0.5
		if (my.scale_x>0.5)
		{
			my.alpha = 100*(2-my.scale_x)/1.9;
		}
		
		wait(1);
	}
	remove(me);
}

// function for sparks that rise
function spark_rise()
{
	if (my.lifespan==80)
	{
		my.move = on;
		my.bmap = spark_image;
		my.size = 25;
		my.flare = on;
		my.bright = on;
		my.alpha = 100;
		my.red = 255;
		my.green = 255;
		my.blue = 255;
		my.gravity = -1;
		my.lifespan = 16;
	}
	
	my.size -= 1*time;
	my.alpha -= 5*time;
}