////////////////////////////////////////////////////////////////////////
// A6 main wdl:
//		Created by WED.
////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where template files can be found.
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6";	// Path to A6 templates directory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\code";	// Path to A6 template code subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\images";	// Path to A6 template image subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\sounds";	// Path to A6 template sound subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\models";	// Path to A6 template model subdirectory

/////////////////////////////////////////////////////////////////
// Filename of the starting level.
string level_str = <LESSON7.WMB>; // give file names in angular brackets

////////////////////////////////////////////////////////////////////////////
// Included files
include <gid01.wdl>;	// global ids
include <display00.wdl>;  // basic display settings





/////////////////////////////////////////////////////////////////
// Desc: The main() function is started at game start
function main()
{
	// set some common flags and variables
	// freeze all entity functions
	freeze_mode = 1;
	// no level has been loaded yet...
	gid01_level_state = gid01_level_not_loaded;

// entry: Warning Level (0,1, or 2)
// entry_help: Sets sensitivity to warnings (0 = none, 1 = some, 2 = all).
	warn_level = 2;	// announce bad texture sizes and bad wdl code


// entry: Starting Mouse Mode (0, 1, or 2)
	mouse_mode = 0;

	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);
	
	max_particles = 10000;

	// now load the level
	level_load(level_str);

	wait(2);	// let level load
	// level should be loaded at this point...
	gid01_level_state = gid01_level_loaded;

//+++ load starting values

	// main game loop
	while(1)
	{
		if(gid01_level_state != gid01_level_loaded)
		{
			// pause the game
			freeze_mode = 1;
		}
		else
		{
			// un-freeze the game
			freeze_mode = 0;
		}
		wait(1);
	}
}


// Desc: this is the function used to restart the game.
function	main_restart_game()
{
	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);
	
	max_particles = 10000;

	// now load the level
	level_load(level_str);
	// freeze the game
	freeze_mode = 1;

	wait(2);	// 1-level loads, 2-entities load

//+++ load starting values

	// un-freeze the game
	freeze_mode = 0;
}


// Desc: this is the function used to quit the game.
function	main_quit()
{
//+++			// save global skills & strings
	exit;
}

/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
WINDOW WINSTART
{
	TITLE			"3D GameStudio";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}

/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FONT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/


/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;

function blue_square();
function red_square();

var radius_spheres = 100;
var orbit_radius = 250;
var red_sphere_center;
var v_drop = 5;

var theta;
var phi;

entity* base;

// creates both "spheres"
action a_spheres
{
	randomize();
	
	base = my;
	my.invisible = on;
	
	var timer = 0;
	var delay = 0;
	
	// initial position of the red sphere: phi = 90 degrees
	red_sphere_center.x = my.x + orbit_radius*cos(90);
	red_sphere_center.y = my.y + orbit_radius*sin(90);
	red_sphere_center.z = my.z;

	// build the blue sphere 
	theta = 0;
	phi = 0;
	while(theta<=180)
	{
		while(phi<=360)
		{
			phi += 10;
			// create blue particle with parameters (theta,phi)
			effect(blue_square,1,nullvector,nullvector);
			wait(1);
		}
		theta += 10;
		phi = 0;			
	}
	
	// build the red sphere
	theta = 0;
	phi = 0;
	while(phi<=360)
	{
		while(theta<=180)
		{
			theta += 10;
			// create red particle with parameters (theta,phi)
			effect(red_square,1,nullvector,nullvector);
			wait(1);
		}
		phi += 10;
		theta = 0;			
	}
	
	// wait until everybody has fallen into place
	delay = 300/(v_drop*16);
	sleep(delay);
	
	// red sphere starts to orbit around the blue at 3 degrees/tick
	while(1)
	{
		// move the center of the red sphere around blue sphere
		red_sphere_center.x = my.x + orbit_radius*cos(3*timer+90);
		red_sphere_center.y = my.y + orbit_radius*sin(3*timer+90);
		red_sphere_center.z = my.z;
		timer += time;
		wait(1);
	}
}

// blue particle
function blue_square()
{
	if (my.lifespan==80)
	{ 
		my.size = 2;
		my.flare = on;
		my.alpha = 100;
		my.move  = on;
		my.red = 0;
		my.green = 200 + random(55);
		my.blue = 200 + random(55);
		// remember theta and phi, pick a radius>radius_spheres
		my.skill_a = theta;
		my.skill_b = phi;
		my.skill_c = radius_spheres + random(300);
	}
	
	my.lifespan = 70;				// particle never dies
	
	if(my.skill_c>radius_spheres)
	{
		// turns around center at 5 degrees/tick 
		// with decreasing radius my.skill_c
		my.x = base.x + my.skill_c*
		                cos(my.skill_b+5*total_ticks)*
		                sin(my.skill_a);
		my.y = base.y + my.skill_c*
		                sin(my.skill_b+5*total_ticks)*
		                sin(my.skill_a);
		my.z = base.z + my.skill_c*
		                cos(my.skill_a);
		// falls toward "sphere surface"
		my.skill_c -= v_drop*time;
	}
	else
	{
		// only turns around center at 5 degrees/tick
		// with radius radius_spheres
		my.x = base.x + radius_spheres*
		                cos(my.skill_b+5*total_ticks)*
		                sin(my.skill_a);
		my.y = base.y + radius_spheres*
		                sin(my.skill_b+5*total_ticks)*
		                sin(my.skill_a);
		my.z = base.z + radius_spheres*
		                cos(my.skill_a);
	}
}

// red particle
function red_square()
{
	if (my.lifespan==80)
	{ 
		my.size = 2;
		my.flare = on;
		my.alpha = 100;
		my.move  = on;
		my.red = 200 + random(55);
		my.green = random(55);
		my.blue = random(55);
		// remember the theta and phi
		my.skill_a = theta;
		my.skill_b = phi;
		// height over the final position
		my.skill_d = 300;
	}
	
	my.lifespan = 70;		// particle never dies
	
	if (my.skill_d>0)
	{
		// turns around center at 5 degrees/tick 
		// with radius radius_spheres/2 at height my.skill_d
		my.x = red_sphere_center.x +
		         (radius_spheres/2)*
		         cos(my.skill_b-5*total_ticks)*
		         sin(my.skill_a);
		my.y = red_sphere_center.y +
		         (radius_spheres/2)*
		         sin(my.skill_b-5*total_ticks)*
		         sin(my.skill_a);
		my.z = red_sphere_center.z +
		         (radius_spheres/2)*
		         cos(my.skill_a) + my.skill_d;
		// drops from the ceiling
		my.skill_d -= v_drop*time;
	}
	else
	{
		// turns around center at 5 degrees/tick
		// with radius radius_spheres/2
		my.x = red_sphere_center.x + 
		         (radius_spheres/2)*
		         cos(my.skill_b-5*total_ticks)*
		         sin(my.skill_a);
		my.y = red_sphere_center.y +
		         (radius_spheres/2)*
		         sin(my.skill_b-5*total_ticks)*
		         sin(my.skill_a);
		my.z = red_sphere_center.z +
		         (radius_spheres/2)*cos(my.skill_a);
	}
}