////////////////////////////////////////////////////////////////////////
// A6 main wdl:
//		Created by WED.
////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where template files can be found.
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6";	// Path to A6 templates directory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\code";	// Path to A6 template code subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\images";	// Path to A6 template image subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\sounds";	// Path to A6 template sound subdirectory
path "C:\\PROGRAM FILES\\GSTUDIO6\\template_6\\models";	// Path to A6 template model subdirectory

/////////////////////////////////////////////////////////////////
// Filename of the starting level.
string level_str = <LESSON8.WMB>; // give file names in angular brackets

////////////////////////////////////////////////////////////////////////////
// Included files
include <gid01.wdl>;	// global ids
include <display00.wdl>;  // basic display settings





/////////////////////////////////////////////////////////////////
// Desc: The main() function is started at game start
function main()
{
	// set some common flags and variables
	// freeze all entity functions
	freeze_mode = 1;
	// no level has been loaded yet...
	gid01_level_state = gid01_level_not_loaded;

// entry: Warning Level (0,1, or 2)
// entry_help: Sets sensitivity to warnings (0 = none, 1 = some, 2 = all).
	warn_level = 2;	// announce bad texture sizes and bad wdl code


// entry: Starting Mouse Mode (0, 1, or 2)
	mouse_mode = 0;

	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);
	
	max_particles = 10000;

	// now load the level
	level_load(level_str);

	wait(2);	// let level load
	// level should be loaded at this point...
	gid01_level_state = gid01_level_loaded;

//+++ load starting values

	// main game loop
	while(1)
	{
		if(gid01_level_state != gid01_level_loaded)
		{
			// pause the game
			freeze_mode = 1;
		}
		else
		{
			// un-freeze the game
			freeze_mode = 0;
		}
		wait(1);
	}
}


// Desc: this is the function used to restart the game.
function	main_restart_game()
{
	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);
	
	max_particles = 10000;

	// now load the level
	level_load(level_str);
	// freeze the game
	freeze_mode = 1;

	wait(2);	// 1-level loads, 2-entities load

//+++ load starting values

	// un-freeze the game
	freeze_mode = 0;
}


// Desc: this is the function used to quit the game.
function	main_quit()
{
//+++			// save global skills & strings
	exit;
}

/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
WINDOW WINSTART
{
	TITLE			"3D GameStudio";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}

/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FONT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/


/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;

string instructions = "Press 1 to fire the chrysanthemum";

text instructions_txt 
{
  font = _a4font; 
  pos_x = 10; 
  pos_y = 10;
}

function on_screen(str) 
{
  instructions_txt.string = str;
  instructions_txt.visible = on;
}




function leader();
function tail();

function ceiling(x)
{
	return(int(x)+(frc(x)>0));
}

var initial_velocity = 70; 
var spacing = 0.25;

bmap leader_image = <superw.pcx>;
var leader_life = 20;	
var leader_size = 200;			
var position;
		
bmap tail_image = <novaw.pcx>;
var tail_life = 5;	
var tail_p = 0.3;
var tail_size = 50;
var start_tail = 16;

// action for the particle source
action a_chrysanthemum
{	
	randomize();
	on_screen(instructions);

	my.invisible = on;
	my.skill1 = 0;			
	var velocity;
	var phi;
	var theta;
	var dphi;
	var dtheta;
	var nb_theta;
	var nb_phi;
	
	while(1)
	{
		if ((key_1==1) & (my.skill1==0))
		{
			// initialize delay
			my.skill1 = 16;			// delay to prevent multiple firing 
			
			// we create a group of spherically distributed leaders
			phi = 0;		
			theta = 0;	
			nb_theta = pi/spacing;
			dtheta = 180/nb_theta;	
			
			while(theta<=180)
			{
				nb_phi = 2*pi*sin(theta)/spacing;
				if (nb_phi!=0)
				{
					dphi = 360/nb_phi;
				}
				else
				{
					dphi = 360;
				}
				
				phi = 0;
				while(phi<360)
				{
					velocity.x = initial_velocity*cos(phi)*sin(theta);
					velocity.y = initial_velocity*sin(phi)*sin(theta);
					velocity.z = initial_velocity*cos(theta);
					effect(leader,1,my.pos,velocity);
					phi += dphi;
				}
				theta += dtheta;	
			}
		}
		
		// updating of the timer
		if (my.skill1>0)
		{
			my.skill1 -= time;
		}
		else
		{
			my.skill1 = 0;
		}
		wait(1);
	}
}

function leader()
{
	if (my.lifespan==80)
	{ 
		my.bmap = leader_image;
		my.size = 0;
		my.bright = on;
		my.flare = on;
		my.alpha = 100;
		my.move  = on;
		my.red = 255;
		my.green = 55;
		my.blue = 55;
		my.gravity = 0;
		my.lifespan = leader_life;
		
		// used to modify the velocity 
		my.skill_x = my.vel_x;
		my.skill_y = my.vel_y;
		my.skill_z = my.vel_z; 
	}
	
	// variation of the speed
	my.vel_x = my.skill_x*(0.1+sin(90*my.lifespan/leader_life));
	my.vel_y = my.skill_y*(0.1+sin(90*my.lifespan/leader_life));
	my.vel_z = my.skill_z*(0.1+sin(90*my.lifespan/leader_life));
	
	// variation of the size
	my.size = leader_size*sin(my.lifespan*180/leader_life);
	
	// we build the tail
	my.skill_a = 
	sqrt(my.vel_x*my.vel_x+my.vel_y*my.vel_y+my.vel_z*my.vel_z);
	my.skill_b = ceiling(my.skill_a*time/(tail_size*tail_p));
	my.skill_c = 0;
	while(my.skill_c<my.skill_b)
	{
		position.x = my.x - time*my.vel_x*my.skill_c/my.skill_b 
		+ time*my.vel_x;
		position.y = my.y - time*my.vel_y*my.skill_c/my.skill_b
		+ time*my.vel_y;
		position.z = my.z - time*my.vel_z*my.skill_c/my.skill_b
		+ time*my.vel_z;
		
		// emit tail and change leader color to red
		if (my.lifespan<start_tail)
		{
			my.red = 255;
			my.green = 0;
			my.blue = 0;
			effect(tail,1,position.x,nullvector);
		}
		my.skill_c += 1;
	}
}

function tail()
{
	if (my.lifespan==80)
	{ 
		my.bmap = tail_image;
		my.size = tail_size;
		my.bright = on;
		my.flare = on;
		my.alpha = 100;
		my.move  = on;
		my.red = 100;
		my.green = 255;
		my.blue = 255;
		my.gravity = 0;
		my.lifespan = tail_life;
	}
	
	// we dim the particles
	my.alpha = 100*(my.lifespan/tail_life);
	
	// and make them more blue-ish
	my.green = 255*(my.lifespan/tail_life);
	my.red = 100*(my.lifespan/tail_life);
}