///////////////////////////////////////////////////////////////////////////////////
// A* for 3D Game Studio in WDL/C-Script
////////////////////////////////////////////////////////////////////////////
path "..\\template";	// Path to WDL templates subdirectory

////////////////////////////////////////////////////////////////////////////
// INCLUDES
////////////////////////////////////////////////////////////////////////////
include <movement.wdl>;
include <messages.wdl>;

////////////////////////////////////////////////////////////////////////////
// Function-Deklarationen
////////////////////////////////////////////////////////////////////////////
function select_entity();
function turnto(&vectorto,&position,&resultvec);
function move_unit();
function init_astar(&start);
function astar(&start,&goal);
function define_children(parent_id);
function get_id(&vector);
function vec_for_id(id);
function heapsort(node);
function exchange(x,y);
function delete(node);
function get_path(parent_id);


////////////////////////////////////////////////////////////////////////////
// Variablen-Deklarationen
////////////////////////////////////////////////////////////////////////////
var video_mode = 8;	 // 6=screen size 640x480
var video_depth = 32; // 16 bit colour D3D mode

// Counter-Variablen
var j;
var n=1;
var i;
var i2;
var firsttime;

// Vertex-Gitter Settings
var nodes_per_axis=200;
var node_dist=50;
var vertex_dist=1;
var terrain_mod;

var dist[3];
var dist_mod[3];
var vecdist1[3];
var vecdist2[3];

// Input fr A*
var start_pos[3];
var goal_pos[3];
var path_area[5];

// Arrays vom A*
var NODE_LIST[16000];		// 4*4000 Nodes
var CLOSED[8000];			// 4*2000 Nodes
var WAYPOINTS[3000];		// 3*1000 Nodes
var ID_LIST[40001];		// 200 "Vertices" * 200 "Vertices" +1
var closed_ids[40001];


// Node-Variablen
var cost_value=1;
var current_vec[3];
var current_node[4];
var node_child[8];
var node_costs;

//Heapsort
var parent;
var child;


// Misc
var break_mode=0;
var tick_count;

// Movement
var distance[3];
var unit_speed=5;
var front_left[3];
var front_right[3];

var marker_distance = 50;
var marker_width = 25;

////////////////////////////////////////////////////////////////////////////
// Strings and Filenames
////////////////////////////////////////////////////////////////////////////
string level_str = <astar.WMB>; // give file names in angular brackets

string no_ent="Keine Entity ausgewhlt";


BMAP arrow,<arrow.pcx>;// mouse pointer

////////////////////////////////////////////////////////////////////////////
// Pointers
////////////////////////////////////////////////////////////////////////////
entity* sel_entity;
entity* sel_terrain;
entity* goal_node;
entity* cur_node;
entity* child_node;

entity* marker_ptr_l;
entity* marker_ptr_r;

////////////////////////////////////////////////////////////////////////////
// Defines
////////////////////////////////////////////////////////////////////////////
DEFINE index,0;
DEFINE heap_index,1;
DEFINE pathwalking,21;

DEFINE row_no,3;
DEFINE col_no,4;
DEFINE obstacle_right,FLAG1;
DEFINE obstacle_left,FLAG2;
DEFINE SPEED,skill1;
DEFINE ANIMATION,skill2;
DEFINE TARGET_ANGLE,skill3;

////////////////////////////////////////////////////////////////////////////
// Sky
////////////////////////////////////////////////////////////////////////////
bmap horizon_map = <horizon.pcx>;
// A backdrop texture's horizontal size must be a power of 2;
// the vertical size does not matter

function init_environment()
{
	scene_map = horizon_map;	// horizon backdrop overlay
	scene_nofilter = on;

	sky_speed.x = 1;
	sky_speed.y = 1.5;
	cloud_speed.x = 3;
	cloud_speed.y = 4.5;

	sky_scale = 0.5;
	sky_curve = 1;  			// 'steepness' of sky dome

	scene_field = 60;  		// repeat map 6 times
	scene_angle.tilt = -10; // lower edge of scene_map 10 units below horizon

	sky_clip = scene_angle.tilt;	// clip the sky at bottom of scene_map
}

////////////////////////////////////////////////////////////////////////////
// Main-Script
////////////////////////////////////////////////////////////////////////////
function main()
{
	init_environment();
	level_load(level_str);
	wait(1);
// call further functions here...
	MOUSE_MODE+=2;
	mouse_on();
	call camera_move;
	firsttime=0;
}

function mouse_on()
{
	MOUSE_MAP = arrow;
	while(MOUSE_MODE > 0)
	{
		MOUSE_POS.X = POINTER.X;
		MOUSE_POS.Y = POINTER.Y;
		wait(1); 		      // now move it over the screen
	}
}

action dummy_unit
{
	sel_entity=ME;
	MY.NARROW=ON;
	MY.SPEED=5;
	while(1)
	{
		if(MY._MOVEMODE==_MODE_WALKING)
		{
			
			if(turnto(goal_pos,MY.X,MY.PAN)>30)
			{
				move_unit();
			}
			else { MY._MOVEMODE=0; }
		}
		if(MY._MOVEMODE==pathwalking)
		{
			if(i>=0)
			{
				if( vec_dist(waypoints[i],NULLVECTOR)==0) { i-=3; }
				
				if(turnto(waypoints[i],MY.X,MY_ANGLE)<50) { i-=3;}

				MY.TARGET_ANGLE = ang (my_angle.pan - my.pan);

				if(sel_terrain==0){ create_markers(); }					// AUM4-Markers nur ohne Terrain benutzen

				if(MY.obstacle_left==OFF && MY.obstacle_right==OFF)
				{
					MY.PAN += 0.2 * MY.TARGET_ANGLE * TIME; // rotate towards the target
				}
				else
				{
					if(MY.obstacle_left)
					{
							MY.PAN-=MY.SPEED*TIME;
					}
					if(MY.obstacle_right)
					{
							MY.PAN+=MY.SPEED*TIME;
					}
					if (MY.obstacle_left && MY.obstacle_right) { my.pan = random(360); }
				}
				move_unit();
			}
			else
			{
				MY._MOVEMODE=0;
			}
		}
		wait(1);
	}
}

function turnto(&vectorto,&position,&resultvec)
{
	vec_set(temp,VectorTo);
	vec_sub(temp,position);
	return (vec_to_angle(resultvec,temp));
}

function move_unit()
{
	distance.X=MY.SPEED*TIME;
	distance.Y=0;

	vec_set(temp,MY.X);
	temp.Z-=2000;
	trace_mode=IGNORE_ME+IGNORE_MODELS+USE_BOX;
	distance.Z= -trace(my.X,temp);

	MOVE_MODE=IGNORE_PASSABLE+GLIDE;
	result=ent_move(distance,NULLVECTOR);

	MY.animation+=MY.SPEED*TIME*RESULT;
	if(MY.ANIMATION>=100)
	{
		MY.ANIMATION-=100;
	}
	ent_cycle("walk",MY.ANIMATION);
}

function create_markers()
{
		front_right.x = sel_entity.x + marker_distance * cos(sel_entity.pan) + marker_width * sin(sel_entity.pan);
		front_right.y = sel_entity.y + marker_distance * sin(sel_entity.pan) - marker_width * cos(sel_entity.pan);
		front_right.z = sel_entity.z;

		front_left.x = sel_entity.x + marker_distance * cos(sel_entity.pan) - marker_width * sin(sel_entity.pan);
		front_left.y = sel_entity.y + marker_distance * sin(sel_entity.pan) + marker_width * cos(sel_entity.pan);
		front_left.z = sel_entity.z;

		if(content(front_right)==content_solid)
		{
			sel_entity.obstacle_right=ON;
		}
		else
		{
			sel_entity.obstacle_right=OFF;
		}
		if(content(front_left)==content_solid)
		{
			sel_entity.obstacle_left=ON;
		}
		else
		{
			sel_entity.obstacle_left=OFF;
		}
}



action pointer_prop
{
	goal_node=ME;
	my.passable=ON;
}
action node_pointer
{
	cur_node=ME;
	my.passable=ON;
	my.invisible=ON;
}

action child_pointer
{
	child_node=ME;
	my.passable=ON;
	my.invisible=ON;
}

function cleanup()
{
	sel_terrain=0;
	terrain_mod=0;
	vec_set(current_node,NULLVECTOR);
	n=1;
	i=0;
	i2=0;
	while(i<WAYPOINTS.length)
	{
		waypoints[i]=0;
		ID_LIST[i]=0;
		closed_ids[i]=0;
		i+=1;
	}
	while(i<ID_LIST.length)
	{
		ID_LIST[i]=0;
		closed_ids[i]=0;
		i+=1;
	}
	i=0;
}

function select_entity()
{
	if(sel_entity!=0) { sel_entity._MOVEMODE=0; }
	i=-1;
	if(freeze_mode!=1)
	{
		cleanup();
		vecFrom.X = MOUSE_POS.X;
		vecFrom.Y = MOUSE_POS.Y;
		vecFrom.Z = 10;
		vec_set(vecTo,vecFrom);
		vec_for_screen(vecFrom,CAMERA); // near point
		vecTo.Z =5000;
		vec_for_screen(vecTo,CAMERA);   // far point
		trace_mode=IGNORE_ME+IGNORE_YOU+IGNORE_PASSABLE+IGNORE_PASSENTS+IGNORE_SPRITES+SCAN_TEXTURE;
		result=trace(vecFrom,vecTo);

		if(str_stri(tex_name,"MDL")!=0)
		{
			sel_entity=YOU;
		}
		if(str_stri(tex_name,"HMP")!=0)
		{
			sel_terrain=YOU;
		}
		if(str_stri(tex_name,"tilegrass")!=0 || sel_terrain!=0)
		{
			if(sel_entity==NULL)
			{
				msg_show(no_ent,5);
			}
			else
			{
				if(firsttime==0)
				{
					create(<arrow.pcx>,goal_pos,pointer_prop); 
					create(<arrow.pcx>,nullvector,node_pointer); 
					create(<arrow1.pcx>,nullvector,child_pointer);
					firsttime+=1;
				}
				vec_set(goal_node.X,TARGET.X);
				vec_set(goal_pos,TARGET.X);
				goal_pos.Z=sel_entity.Z;
				vec_set(vecFrom,sel_entity.X);
				vec_set(vecTo,goal_node.X);		
				ME=sel_entity;
				trace_mode=IGNORE_ME+IGNORE_PASSABLE+IGNORE_PASSENTS+IGNORE_SPRITES;
				result=trace(vecFrom,vecTo);
				if(result!=0)
				{
					vec_set(start_pos,sel_entity.X);
					start_pos.Z=sel_entity.Z;
					start_pos.X=INT(start_pos.X);
					start_pos.Y=INT(start_pos.Y);
					start_pos.Z=INT(start_pos.Z);
					if (sel_terrain!=0)
					{
						terrain_mod=1;
						vec_set(start_pos,TARGET.X);
						start_pos.Z=sel_entity.Z;
					}
				}
				else
				{
					sel_entity._MOVEMODE=1;
					return;
				}
				result=astar(start_pos,goal_pos);	
				if (result==1 && break_mode==0) { sel_entity._MOVEMODE=pathwalking; }
			}
		}
	}
}

ON_MOUSE_LEFT select_entity;

function init_astar(&start)
{
	if(sel_terrain==0)
	{
		path_area.X=start[0]-(nodes_per_axis*node_dist)/2;
		path_area.Y=start[1]+(nodes_per_axis*node_dist)/2;
		path_area.Z=start[2];

		path_area[row_no]=nodes_per_axis;
		path_area[col_no]=nodes_per_axis;

		dist_mod.X=node_dist;
		dist_mod.Y=node_dist;
		vertex_dist=1;
	}
	else
	{
		path_area.X=sel_terrain.X+sel_terrain.MIN_X;
		path_area.Y=sel_terrain.Y+sel_terrain.MAX_Y;
		path_area.Z=start[2];	

		path_area[row_no]=sel_terrain.skill1;
		path_area[col_no]=sel_terrain.skill2;

		vec_set(vecdist1,path_area);
		vec_set(vecdist2,path_area);
		vecdist2.X=sel_terrain.X+sel_terrain.MAX_X;
		dist_mod.X=INT(vec_dist(vecdist1,vecdist2))/path_area[col_no];

		vec_set(vecdist1,path_area);
		vec_set(vecdist2,path_area);
		vecdist1.Y=sel_terrain.Y+sel_terrain.MIN_Y;
		dist_mod.Y=INT(vec_dist(vecdist1,vecdist2))/path_area[row_no];				
	}
}


function astar(&start,&goal)
{
	init_astar(start);
	tick_count=total_ticks;
	NODE_LIST[index]=1;
	j=NODE_LIST[index];
	NODE_LIST[j*4+0]=get_id(start);
	NODE_LIST[j*4+1]=cost_value;
	NODE_LIST[j*4+2]=NODE_LIST[j*4+1]+vec_dist(start,goal);
	NODE_LIST[j*4+3]=NULL;
	ID_LIST[NODE_LIST[j*4+0]]=j;
	NODE_LIST[index]+=1;

	while (NODE_LIST[index]*4<NODE_LIST.length)				
	{	
		vec_for_id(NODE_LIST[1*4]);
		if(vec_dist(current_vec,goal)<=50)		// Ist Node = Zielpunkt?
		{
			vec_set(CLOSED[n*4],NODE_LIST[1*4]);
			CLOSED[n*4+3]=NODE_LIST[1*4+3];
			closed_ids[CLOSED[n*4]]=n;
			vec_set(WAYPOINTS[0],goal);
			i=3;	
			get_path(CLOSED[n*4+3]);		// Konstruiere einen Path vom Goal-Vertex ber die Parent-Nodes zum Startpunkt zurck
			tick_count=total_ticks-tick_count;
			return(1);
		}
		vec_set(current_node,NODE_LIST[1*4]);
		current_node[3]=NODE_LIST[1*4+3];
		define_children(NODE_LIST[1*4]);

		i=0;
		while (i<8)
		{			
			vec_for_id(current_node[0]);	
			vec_set(vecdist1,current_vec);
			vec_set(vecdist2,NULLVECTOR);
			vec_for_id(node_child[i]);
			ME=sel_entity;
			trace_mode=IGNORE_ME+IGNORE_PASSABLE+IGNORE_PASSENTS+IGNORE_SPRITES+USE_BOX;
			result=trace(vecdist1,current_vec);
			vecdist1.X=0;
			vecdist1.Y=0;
			vecdist2.Z=current_vec.Z;
			if(result==0 && vec_dist(vecdist1,vecdist2)<50)
			{
				j=NODE_LIST[index];
				if(j<=0 || j*4>=NODE_LIST.length){break;}
				node_costs=current_node[1]+cost_value+vec_dist(current_vec,goal);			// Kosten=Kosten der Parent-Node+1+Abstand zum Ziel
				if(closed_ids[node_child[i]]!=0)
				{	
					j=closed_ids[node_child[i]];
					if(CLOSED[j*4+1]==current_node[1]-cost_value) {i+=1; continue;}		// Hinter der aktuellen Node liegende Nodes (einen Wegkosten-Wert weniger) mssen nicht nochmal untersucht werden.
					if(node_costs>=CLOSED[j*4+2]) {i+=1; continue;}
				
				}
				if(ID_LIST[node_child[i]]!=0)									// Existiert diese Node bereits?
				{
					j=ID_LIST[node_child[i]];
					if(NODE_LIST[j*4+1]==current_node[1]-cost_value) {i+=1; continue;}	// Hinter der aktuellen Node liegende Nodes (einen Wegkosten-Wert weniger) mssen nicht nochmal untersucht werden.
					if(node_costs>=NODE_LIST[j*4+2]) {i+=1; continue;}				// Aktuelle Berechnung hher als vorherige
				}
				NODE_LIST[j*4+0]=node_child[i];
				NODE_LIST[j*4+1]=current_node[1]+cost_value;
				NODE_LIST[j*4+2]=node_costs;
				NODE_LIST[j*4+3]=current_node[0];
				ID_LIST[node_child[i]]=j;
				heapsort(j);
				if(j==NODE_LIST[index])
				{
					NODE_LIST[index]+=1;
				}
				if (break_mode==1)
				{
					child_node.invisible=OFF;
					vec_set(child_node.X,current_vec);						
					while(mouse_right!=1){wait(1);}
					wait(32);
				}			
			}
			i+=1;
		}
		if(n*4<CLOSED.length)
		{
			j=n;
			if(closed_ids[current_node[0]]!=0 && CLOSED[closed_ids[current_node[0]]*4+2]>current_node[2])
			{							// Existiert die Node schon in CLOSED?
				j=closed_ids[current_node[0]];
			}
			vec_set(CLOSED[j*4],current_node);
			CLOSED[j*4+3]=current_node[3];

			closed_ids[current_node[0]]=j;
			if(j==n){n+=1;}
			delete(ID_LIST[current_node[0]]);
			ID_LIST[current_node[0]]=0;
		}
	}
	return (0);
}

function define_children(parent_id)
{
	if(parent_id>=row_no+terrain_mod) 
	{	
		node_child[0]=parent_id-path_area[row_no]*vertex_dist; 
	}
	if(parent_id>=row_no+terrain_mod &&	frc((parent_id+1-terrain_mod)/path_area[row_no])!=0)
	{	
		node_child[1]=parent_id-path_area[row_no]*vertex_dist+1*vertex_dist;
	}
	if(frc((parent_id+1-terrain_mod)/path_area[row_no])!=0) 
	{
		node_child[2]=parent_id+1*vertex_dist;
	}
	if(parent_id<path_area[row_no]*(path_area[col_no]-1)+terrain_mod && frc((parent_id+1-terrain_mod)/path_area[row_no])!=0)
	{
		node_child[3]=parent_id+path_area[row_no]*vertex_dist+1*vertex_dist;
	}
	if(parent_id<path_area[row_no]*(path_area[col_no]-1)+terrain_mod) 
	{ 
		node_child[4]=parent_id+path_area[row_no]*vertex_dist; 
	}
	if(parent_id<path_area[row_no]*(path_area[col_no]-1)+terrain_mod && frc((parent_id-terrain_mod)/path_area[row_no])!=0)
	{
		node_child[5]=parent_id+path_area[row_no]*vertex_dist-1*vertex_dist;
	}
	if(frc((parent_id-terrain_mod)/path_area[row_no])!=0) 
	{ 
		node_child[6]=parent_id-1*vertex_dist; 
	}
	if(parent_id>=row_no+terrain_mod && frc((parent_id-terrain_mod)/path_area[row_no])!=0)
	{
		node_child[7]=parent_id-path_area[row_no]*vertex_dist-1*vertex_dist;
	}
}

function get_id(&vector)
{
	vec_set(vecdist1,path_area);
	vec_set(vecdist2,vector);
	vecdist1.Y=vecdist2.Y;
	vecdist1.Z=vecdist2.Z;
	dist.X=INT(vec_dist(vecdist1,vecdist2)/dist_mod.X);
	vec_set(vecdist1,path_area);
	vecdist1.X=vecdist2.X;
	dist.Y=INT(vec_dist(vecdist1,vecdist2)/dist_mod.Y);

	if(sel_terrain!=0) { dist.X+=1; }
	return ( INT((dist.X)+path_area[row_no]*dist.Y) );	
}

function vec_for_id(id)
{
	if(sel_terrain!=0)
	{
		vec_for_vertex(current_vec,sel_terrain,id);
	}
	else
	{
		temp=id/nodes_per_axis;
		if(frc(temp)==0) { temp-=1; }
		dist.Y=int(temp);
		dist.X=abs(dist.Y*nodes_per_axis-id);

		current_vec.X=path_area.X+dist.X*node_dist;
		current_vec.Y=path_area.Y-dist.Y*node_dist;
		current_vec.Z=path_area.Z;
	}
}

function heapsort(node)
{
	NODE_LIST[heap_index]=NODE_LIST[index];
	if(node!=NODE_LIST[index]){NODE_LIST[heap_index]-=1;}

//	Upheap
	while(node>1)
	{
		parent=INT(node/2);			// parent ist Vorgnger
		if(NODE_LIST[parent*4+2]>=NODE_LIST[node*4+2])	
		{
			exchange(parent,node);
		}
		else{	node=parent; break;}
		node=parent;
	}

//	Downheap
	node=INT(node);
	while(node<INT(NODE_LIST[heap_index]/2)+1)		// node ist kein Blatt
	{
		child=node*2;			// child ist erster Nachfolger
		if(child+1<NODE_LIST[heap_index])		// Existiert ein zweiter Nachfolger?
		{
			if (NODE_LIST[(child+1)*4+2]<NODE_LIST[child*4+2]){child+=1;}
		}
		if (NODE_LIST[node*4+2]>=NODE_LIST[child*4+2])
		{
			exchange(node,child);
		}
		else{break;}
		node=child;
	}
}

function exchange(x,y)
{
	i2=0;
	while (i2<4)
	{
		if(NODE_LIST[x*4]==0 && temp==0){breakpoint;}
		if(NODE_LIST[y*4]==0 && temp==0){breakpoint;}
		temp=NODE_LIST[x*4+i2];
		NODE_LIST[x*4+i2]=NODE_LIST[y*4+i2];
		NODE_LIST[y*4+i2]=temp;
		i2+=1;
	}
	ID_LIST[NODE_LIST[x*4+0]]=x;
	ID_LIST[NODE_LIST[y*4+0]]=y;
}

function delete(node)
{
	NODE_LIST[index]-=1;
	j=NODE_LIST[index];
	exchange(node,j);
	vec_set(NODE_LIST[j*4],NULLVECTOR);
	NODE_LIST[j*4+3]=0;
	heapsort(1);
}

function get_path(parent_id)
{
	vec_for_id(parent_id);
	temp=INT(i/3);
	if(temp<n){vec_set(WAYPOINTS[i],current_vec); }
	j=closed_ids[parent_id];
	if(CLOSED[j*4+3]!=0)
	{
		i+=3;
		get_path(CLOSED[j*4+3]);
	}
}

var ziel_test[3]=0,800,35;

function astar_testcall()
{
	result=astar(sel_entity.X,ziel_test);
	if(result==1)
	{		
		sel_entity._MOVEMODE=pathwalking; 
	}
//	cleanup();
}

ON_A astar_testcall;
