///////////////////////////////////////////////////////////////////////////////////
// GameStudio main script
////////////////////////////////////////////////////////////////////////////
// Files to over-ride:
// * logodark.bmp - the engine logo, include your game title
// * horizon.pcx - A horizon map displayed over the sky and cloud maps
////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
path "C:\\Program Files\\GStudio6\\template";	// Path to WDL templates subdirectory

////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions
include <movement.wdl>;
include <messages.wdl>;
include <menu.wdl>;		// must be inserted before doors and weapons
//include <particle.wdl>; // remove when you need no particles
include <doors.wdl>;		// remove when you need no doors
include <actors.wdl>;   // remove when you need no actors
//include <weapons.wdl>;  // remove when you need no weapons
//include <war.wdl>;      // remove when you need no fighting
//include <venture.wdl>;	// include when doing an adventure
include <lflare.wdl>;   // remove when you need no lens flares



/****************************************************************************************
	The following two lines are required to use the Light Mixer Control Panel on any game

*****************************************************************************************/
path "C:\\Program Files\\GStudio6\\lighttut\\lghtmixr";	// Path to LightMixer
include <lmx.wdl>;   		// Light Effects Panel

////////////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the follwing vars.
var video_mode = 6;	 // screen size 640x480
var video_depth = 16; // 16 bit colour D3D mode

/////////////////////////////////////////////////////////////////
// Strings and filenames
// change this string to your own starting mission message.
string mission_str = "Make this scene look GOOD!";
string level_str = <room.WMB>; // give file names in angular brackets

/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo
bmap splashmap = <logodark.pcx>; // the default logo in templates
panel splashscreen {
	bmap = splashmap;
	flags = refresh,d3d;
}

////////////////////////////////////////////////////////////////////////////
// The following script controls the sky
//sky horizon_sky {
	//	// A backdrop texture's horizontal size must be a power of 2;
	//	// the vertical size does not matter
	//	type = <horizon.pcx>;
	//	tilt = -10;
	//	flags = scene,overlay,visible;
	//	layer = 3;
//}

/////////////////////////////////////////////////////////////////
// The main() function is started at game start
function main()
{
	fps_max = 200;
	d3d_lightres = on;  // Set for High Resolution Lighting
	
	mouse_pointer = 0; // get rid of the windows mouse pointer in Windows mode

	// set some common flags and variables
	//	warn_level = 2;	// announce bad texture sizes and bad wdl code

	tex_share = on;	// map entities share their textures

	// center the splash screen for non-640x480 resolutions, and display it
	splashscreen.pos_x = (screen_size.x - bmap_width(splashmap))/2;
	splashscreen.pos_y = (screen_size.y - bmap_height(splashmap))/2;
	splashscreen.visible = on;
	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);

	// now load the level
	level_load(level_str);
	// freeze the game
	freeze_mode = 1;

	/***************************************************************************
	Restore the settings Arrays if they exist. All values defined as 
	var_info will be restored if the INFO.0 file exists
	****************************************************************************/
	//	game_load ("INFO",0);

	// wait the required second, then switch the splashscreen off.
	sleep(1);
	splashscreen.visible = off;
	bmap_purge(splashmap);	// remove splashscreen from video memory

	// load some global variables, like sound volume
	load_status();

	// display the initial message
	msg_show(mission_str,10);

	// initialize lens flares when edition supports flares
	ifdef CAPS_FLARE;
		lensflare_start();
	endif;

	// use the new 3rd person camera
	move_view_cap = 1;

	// un-freeze the game
	freeze_mode = 0;

	//	client_move();	// for a possible multiplayer game
	// call further functions here..
}


/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
WINDOW WINSTART
{
	TITLE			"3D GameStudio";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
	//	BUTTO N		BUTTO N_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTO N		BUTTO N_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}

/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FO NT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/


/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;

/******************************************************************************
Game Code Starts Here
********************************************************************************/

/******************************************************************************
Declare our global variables here
*******************************************************************************/
var desired_height = -320;   	// desired height of our reactor (start at eye level)
var min_height = -600;			// This corresponds to the floor of the 'cooling pool'
var max_height = 350;			// This corresponds to the ceilings height

var Desired_x = 0;         // Desired x coordinate of the reactor
var Min_x = -316;
var Max_x = 1410;

var reactor_rotation = 1;     // set the reactor default to rotate
entity* Reactor1_ptr;       // Entity pointers for our reactors!

/******************************************************************************
Declare our dynamic lights
******************************************************************************/
action lightBulb1
{
	my.lightrange=400;
}

action lightBulb2
{
	my.lightrange=400;
}

/*********************************************************************************
Declare our Main Reactor 
*********************************************************************************/

ACTION	Reactor1
{
	my.lightrange = 0;
	Reactor1_ptr = me;	 //	pointer to Reactor
	// and have it do SOMETHING! 
	while (1)							// 	loop forever
	{
		while reactor_rotation
		{
		my.pan += .5;							// Rotate the reactor .5 degrees
		if (my.pan > 360) {my.pan = 1;} 	// if we've gone all the way around start over
		wait(1);                         // wait for next frame
		} 
	wait (1); 	// must wait otherwise this is an endless loop
	}
}



/**********************************************************************************
Declare a"Lifter Rod" - so we can attach the tool to it and raise it up/down  
***********************************************************************************/

action lifterTube 
{
	while (Reactor1_ptr == null)  {wait(1);}			// Null Pointer Check	
	while (1)
	{
		if (my.z < desired_height) {my.z += 1;}	// Raise the lifterTube 
		if (my.z > desired_height)	{my.z -= 1;}	// or Lower it
		if (my.x < desired_x) {my.x += 1;}		// move back  
		if (my.x > desired_x) {my.x -= 1;}	// and forth
		
		Reactor1_ptr.z = my.z-5;   // And pull the Reactor along
		Reactor1_ptr.x = my.x;
		wait (1); // wait 1 frame
	}   
}

/************************************************************************************
The next two functions are called if the w or s key is pressed. 
They adjust the 'desired' height so that the lifterTube can raise or lower
*************************************************************************************/
function raiseTool ()
{
	// Loop as long as the w key is held down
	while key_w 		
	{
		if (desired_height < max_height) &&
		(((desired_x > 1220) && (desired_x < 1340))  // make sure we are over a pit
		|| ((desired_x > -70) && (desired_x < 60)))

		{desired_height +=1;}	// increase height to maximum
		else {beep;}										// to HIGH
		wait(1);
	}
}

function lowerTool ()
{ 
	// Loop as long as the s key is held down
	while key_s                                 
	{
		if (desired_height > min_height) &&        
		(((desired_x > 1220) && (desired_x < 1340))  // make sure we are over a pit
		|| ((desired_x > -70) && (desired_x < 60)))
		{desired_height -=1;}	// decrease height to minimum
		else {beep;}										// to LOW
		wait(1);
	}
}

function toolForward ()
{
	// Loop as long as the a key is held down
	while key_a 		
	{
		if (desired_x < max_x) && (desired_height > -350) {desired_x +=1;}	// increase x to maximum
		else {beep;}										// to HIGH
		wait(1);
	}
}

function toolBackward ()

{ 
	// Loop as long as the s key is held down
	while key_d                                
	{
		if (desired_x > min_x) && (desired_height > -350)  {desired_x -=1;}	// decrease x to minimum
		else {beep;}										// to LOW
		wait(1);
	}
}

function toggleReactorRotation ()
{

reactor_rotation = (reactor_rotation == off);
}

function game_exit ()
{exit;}

on_w = raiseTool;
on_s = lowerTool;
on_a = toolForward;
on_d = toolBackward;
on_x = toggleReactorRotation;

on_esc = game_exit;



