/***************************************************************************************
Light Mixer Helper Script
Design goal: Make a control panel that let's us dynamically adjust various lighting
settings of the entities in a game. It should be totally generic, so it could be used 
with by any 3DGS game developer that is running A6 on a system with a 'newer' video card.
It should also be as unintrusive on the game developers code as possible.

Things to do:
1) We really should be using an array of handles to keep track of our material pointers
2) A nice feature would be 'generate material text file' feature
****************************************************************************************/


/***************************************************************************************
Global Variables go here
****************************************************************************************/

entity* lmxTarget_ptr;               // this is our pointer to the target entity

string lmxStrNm [20];               // a string to hold the target entities name;

// save the users mouse settings while panel is up
var saveMouseMode;                      
var saveMousePointer;
var saveMouseEnable;

//font lmx_font = <ackfont.pcx>, 8, 10; // small text font
font arial_font = "Arial",1,12; // truetype font 
font courier_font = "Courier",1,12; // truetype font 

text lmxStrDsply // and this is a text panel to display the name of the target entity
{
	layer = 1000; pos_x = 534;pos_y = 315; font = arial_font; string = "   Entity Search"; alpha = 100;
	flags = center_x, narrow, transparent;
}

/*****************************************************
I'll set up to handle 4 different entities materials
*****************************************************/

var lmxMatCount = 0;    // keep track of how many entities have materials attached.
var lmxDsplyCount = 4;  // Display # of attachments left to go
// declare 4 materials

material lmxMat0   
{ } 

material lmxMat1
{ }

material lmxMat2
{ }

material lmxMat3
{ }

material* lmxMat_ptr = lmxMat0;   	// This pointer is referenced in the panel

// setup pointers for the 4 materials since I can't use them in arrays
// I need to look into the handle stuff to deal with this, but for now:

entity* lmxEnt0;      				// and these are to keep track of which entities are attached
entity* lmxEnt1;
entity* lmxEnt2;
entity* lmxEnt3;

/***************************************************************************************
Various Bit Maps used for the panel itself
****************************************************************************************/

bmap lmxMap = <lmxPanel.bmp>; 

bmap lmxButtonRadioup = <lmxButtonRadioUp.bmp>;
bmap lmxButtonRadioDown = <lmxButtonRadioDown.bmp>;

bmap lmxButtonRightArrowUp = <lmxRightArrowUp.bmp>;
bmap lmxButtonRightArrowDown = <lmxRightArrowDown.bmp>;

bmap lmxButtonAttachUp = <lmxButtonattachUp.bmp>;
bmap lmxButtonAttachDown = <lmxButtonattachDown.bmp>;

bmap lmxSliderblue = <lmxbluesquare.bmp>;  
bmap lmxSlidergreen = <lmxgreensquare.bmp>;   
bmap lmxSliderred = <lmxredsquare.bmp>; 
bmap lmxSliderwhite = <lmxwhitesquare.bmp>;

// Predefines for the panel
function lmxTargetTransparent ();                
function lmxTargetFlare ();
function lmxTargetOverlay (); 
function lmxTargetBright (); 
function lmxTargetMetal (); 
function lmxTargetLight (); 
function lmxAttachMaterial ();

/********************************************************************************
Text to display the radio buttons on/off indication
*********************************************************************************/
text lmxTransparentX
{
	layer = 1000; pos_x = 533;pos_y = 345; font = _a4font; string = ""; alpha = 100;
	flags = center_x, narrow, transparent, visible;
}
text lmxFlareX
{
	layer = 1000;pos_x = 533;pos_y = 361;font = _a4font;string = "";alpha = 100;
	flags = center_x, narrow, transparent, visible;

}
text lmxOverlayX
{
	layer = 1000;pos_x = 533;pos_y = 378;font = _a4font;string = "";alpha = 100;
	flags = center_x, narrow, transparent, visible;

}
text lmxBrightX
{
	layer = 1000;pos_x = 533;pos_y = 395;font = _a4font;string = "";alpha = 100;
	flags = center_x, narrow, transparent, visible;

}
text lmxMetalX
{
	layer = 1000;pos_x = 533;pos_y = 410;font = _a4font;string = "";alpha = 100;
	flags = center_x, narrow, transparent, visible;

}
text lmxLightX
{
	layer = 1000;pos_x = 533;pos_y = 428;font = _a4font;string = "";alpha = 100;
	flags = center_x, narrow, transparent, visible;
}

/********************************************************************************
Panel for manipulating an entities lights 
*********************************************************************************/

panel lmxPanel
{
	bmap =lmxMap;
	pos_x = 0;
	pos_y = 0; // was 175
	alpha=100;
	layer=1000;

	vslider = 8,345,120,lmxSliderred,1,255,lmxMat_ptr.emissive_red;
	vslider = 28,345,120,lmxSlidergreen,1,255,lmxMat_ptr.emissive_green;
	vslider = 48,345,120,lmxSliderblue,1,255,lmxMat_ptr.emissive_blue;
	
	vslider = 83,345,120,lmxSliderred,1,255,lmxMat_ptr.ambient_red;
	vslider = 103,345,120,lmxSlidergreen,1,255,lmxMat_ptr.ambient_green;
	vslider = 123,345,120,lmxSliderblue,1,255,lmxMat_ptr.ambient_blue;
	
	vslider = 158,345,120,lmxSliderred,1,255,lmxMat_ptr.diffuse_red;
	vslider = 178,345,120,lmxSlidergreen,1,255,lmxMat_ptr.diffuse_green;
	vslider = 198,345,120,lmxSliderblue,1,255,lmxMat_ptr.diffuse_blue;
	
	vslider = 233,345,120,lmxSliderred,1,255,lmxMat_ptr.specular_red;
	vslider = 253,345,120,lmxSlidergreen,1,255,lmxMat_ptr.specular_green;	
	vslider = 273,345,120,lmxSliderblue,1,255,lmxMat_ptr.specular_blue;	

	vslider = 308,345,120,lmxSliderwhite,0,10,lmxMat_ptr.power;
	vslider = 328,345,120,lmxSliderwhite,0,100,lmxMat_ptr.alpha;	
	vslider = 348,345,120,lmxSliderwhite,1,100,lmxMat_ptr.albedo;	
	
	vslider = 383,345,120,lmxSliderred,1,255,lmxTarget_ptr.red;
	vslider = 403,345,120,lmxSlidergreen,1,255,lmxTarget_ptr.green;	
	vslider = 423,345,120,lmxSliderblue,1,255,lmxTarget_ptr.blue;	

	vslider = 458,345,120,lmxSliderwhite,0,1000,lmxTarget_ptr.lightrange;	
	vslider = 478,345,120,lmxSliderwhite,0,100,lmxTarget_ptr.alpha;
	vslider = 498,345,120,lmxSliderwhite,0,100,lmxTarget_ptr.albedo;	

	//	vslider = 600,345,120,lmxSliderwhite,0,1000,lmxLight_ptr.lightrange;	

	Button = 530,345,lmxButtonRadioDown,lmxButtonRadioUp,lmxButtonRadioUp,lmxTargetTransparent,null,null;
	button = 530,361,lmxButtonRadioDown,lmxButtonRadioUp,lmxButtonRadioUp,lmxTargetFlare,null,null;
	button = 530,377,lmxButtonRadioDown,lmxButtonRadioUp,lmxButtonRadioUp,lmxTargetOverlay,null,null;
	button = 530,396,lmxButtonRadioDown,lmxButtonRadioUp,lmxButtonRadioUp,lmxTargetBright,null,null;
	button = 530,411,lmxButtonRadioDown,lmxButtonRadioUp,lmxButtonRadioUp,lmxTargetMetal,null,null;	
	button = 530,428,lmxButtonRadioDown,lmxButtonRadioUp,lmxButtonRadioUp,lmxTargetLight,null,null;


	button = 570,330,lmxButtonRightArrowdown,lmxButtonRightArrowUp,lmxButtonRightArrowUp,lmxGetNextEntity,null,null;

	button = 600,445,lmxButtonAttachDown,lmxButtonAttachUp,lmxButtonAttachUp,lmxAttachMaterial,null,null;

	digits = 7,465,3,_a4font,1,lmxMat_ptr.emissive_red;
	digits = 27,465,3,_a4font,1,lmxMat_ptr.emissive_green;
	digits = 47,465,3,_a4font,1,lmxMat_ptr.emissive_blue;
	
	digits = 82,465,3,_a4font,1,lmxMat_ptr.ambient_red;
	digits = 102,465,3,_a4font,1,lmxMat_ptr.ambient_green;
	digits = 122,465,3,_a4font,1,lmxMat_ptr.ambient_blue;

	digits = 157,465,3,_a4font,1,lmxMat_ptr.diffuse_red;
	digits = 177,465,3,_a4font,1,lmxMat_ptr.diffuse_green;
	digits = 197,465,3,_a4font,1,lmxMat_ptr.diffuse_blue;

	digits = 232,465,3,_a4font,1,lmxMat_ptr.specular_red;
	digits = 252,465,3,_a4font,1,lmxMat_ptr.specular_green;	
	digits = 272,465,3,_a4font,1,lmxMat_ptr.specular_blue;	
	
	digits = 307,465,3,_a4font,1,lmxMat_ptr.power;
	digits = 327,465,3,_a4font,1,lmxMat_ptr.alpha;		
	digits = 347,465,3,_a4font,1,lmxMat_ptr.albedo;

	digits = 382,465,3,_a4font,1,lmxTarget_ptr.red;
	digits = 402,465,3,_a4font,1,lmxTarget_ptr.green;	
	digits = 422,465,3,_a4font,1,lmxTarget_ptr.blue;	
	
	digits = 447,465,4,_a4font,1,lmxTarget_ptr.lightRange;
	digits = 477,465,3,_a4font,1,lmxTarget_ptr.alpha;
	digits = 497,465,3,_a4font,1,lmxTarget_ptr.albedo;

	digits = 600,440,2,_a4font,1,lmxDsplyCount;		
	
	flags overlay,refresh;
}


/****************************************************************************
Functions display an x if various flags are set for the entity on
*****************************************************************************/
function displayX()
{
	if (lmxTarget_ptr == null)    // protect ourselves from null pointers
	{return;}
	if lmxPanel.visible
	{
	if (lmxTarget_ptr.Transparent == 1) {lmxTransparentX.string = "x";} else {lmxTransparentX.string = "";}
	if (lmxTarget_ptr.flare == 1) {lmxFlareX.string = "x";} else {lmxFlareX.string = "";}
	if (lmxTarget_ptr.overlay == 1) {lmxOverlayX.string = "x";} else {lmxOverlayX.string = "";}	
	if (lmxTarget_ptr.Bright == 1) {lmxBrightX.string = "x";} else	{lmxBrightX.string = "";}	
	if (lmxTarget_ptr.Metal == 1) {lmxMetalX.string = "x";} else {lmxMetalX.string = "";}
	if (lmxTarget_ptr.Light == 1) {lmxLightX.string = "x";}else	{lmxLightX.string = "";}
	}
	else
	{
		// Clear any text we might have up
		lmxStrDsply.visible = off;
		lmxTransparentX.string = "";
		lmxFlareX.string = "";
		lmxOverlayX.string = "";
		lmxBrightX.string = "";
		lmxMetalX.string = "";
		lmxLightX.string = "";
	}
}


/****************************************************************************
Functions to toggle on and off various entity flags and display an x if on
*****************************************************************************/
function lmxTargetTransparent ()
{
	if (lmxTarget_ptr != null)
	{lmxTarget_ptr.Transparent = (lmxTarget_ptr.Transparent == 0);displayX();}  
}

function lmxTargetflare ()

{
	if (lmxTarget_ptr != null)
	{lmxTarget_ptr.flare = (lmxTarget_ptr.flare == 0);displayX();}
}

function lmxTargetoverlay ()
{
	if (lmxTarget_ptr != null)
	{lmxTarget_ptr.overlay = (lmxTarget_ptr.overlay == 0);displayX();} 
} 
function lmxTargetbright ()
{
	if (lmxTarget_ptr != null)
	{lmxTarget_ptr.bright = (lmxTarget_ptr.bright == 0);displayX();}  
}
function lmxTargetMetal ()
{
	if (lmxTarget_ptr != null)
	{lmxTarget_ptr.metal = (lmxTarget_ptr.metal == 0);displayX();}  
}
function lmxTargetLight ()
{
	if (lmxTarget_ptr != null)
	{lmxTarget_ptr.light = (lmxTarget_ptr.light == 0);displayX();}  
}


/****************************************************************************
Function to attach materials to our target and remember which entity we are
attached to:
IMPROVEMENT NEEDED: change to use handles and store in a larger array
*****************************************************************************/
function lmxAttachMaterial ()
{
	if (lmxMatCount > 3)  							// test to see if we are full 
	{beep;return;}     							// and sound off if we are
	
	if (lmxTarget_ptr == null)                   // null pointer test
	{beep;return;}

	// test to see if we are already attached
	if ((lmxEnt0 == lmxTarget_ptr) || (lmxEnt1 == lmxTarget_ptr) 
	|| (lmxEnt2 == lmxTarget_ptr) || (lmxEnt3 == lmxTarget_ptr))
	{beep;return;} // yup, signal and return

	// We must not be currently attached, so let's attach now
	// Set our Generic Material pointer to one of our 4 save slots 
	// and remember which entity we are attached to
	if (lmxMatCount == 0) {lmxMat_ptr = lmxMat0;lmxEnt0 = lmxTarget_ptr;}
	if (lmxMatCount == 1) {lmxMat_ptr = lmxMat1;lmxEnt1 = lmxTarget_ptr;}
	if (lmxMatCount == 2) {lmxMat_ptr = lmxMat2;lmxEnt2 = lmxTarget_ptr;}
	if (lmxMatCount == 3) {lmxMat_ptr = lmxMat3;lmxEnt3 = lmxTarget_ptr;}
	lmxMatCount += 1;    						// Next Material pointer please
	lmxDsplyCount = 4-lmxMatCount;         // count down of available slots	
	lmxTarget_ptr.material = lmxMat_ptr; // attach our Generic Material Pointer
}

/***************************************************************************************
This function will cycle through all of the available entities
It sets our target pointer to the entities pointer 
It also gets the string name of the entity for us to display
And finally, if we have already attached a material, the it reattaches the material	
****************************************************************************************/

function lmxGetNextEntity ()
{
	if (lmxPanel.visible == off)                 // ignore if our panel is not up
	{return;}	
	lmxTarget_ptr = ent_next (lmxTarget_ptr);    // load the entity pointer from the internal list
	if (lmxTarget_ptr != null)							// last entry is null,(protection null pointer)
	{
		str_for_entname (lmxStrNm, lmxTarget_ptr);   // get the string name
		lmxStrDsply.string = lmxStrNm;					// and load it in our text display
		// test if we are already attached, and reattach
		if (lmxEnt0 == lmxTarget_ptr) 
		{lmxMat_ptr = lmxMat0; lmxTarget_ptr.material = lmxMat_ptr;beep;return;}         
		if (lmxEnt1 == lmxTarget_ptr) 
		{lmxMat_ptr = lmxMat1; lmxTarget_ptr.material = lmxMat_ptr;beep;return;} 
		if (lmxEnt2 == lmxTarget_ptr) 
		{lmxMat_ptr = lmxMat2; lmxTarget_ptr.material = lmxMat_ptr;beep;return;} 
		if (lmxEnt3 == lmxTarget_ptr) 
		{lmxMat_ptr = lmxMat3; lmxTarget_ptr.material = lmxMat_ptr;beep;return;} 
	}
	else
	{lmxStrDsply.string = "   Entity Search";}
	displayX();                                   // display 'radio buttons'
}

/**************************************************************************
Raise and lower our Panels AND switch between the target and the Light
***************************************************************************/

function lmxTogglePanel
{  
	lmxPanel.visible = (lmxPanel.visible == Off);     			// toggle our panel on and off
	if (lmxPanel.visible == on) 
	{
		lmxStrDsply.visible = on;             // and our Entity String display as well
		// save the users mouse settings
		saveMouseEnable = enable_mouse;		
		saveMouseMode = mouse_mode;
		saveMousePointer = mouse_pointer;
		// switch to what we need
		enable_mouse = on;
		mouse_pointer == 2;
		mouse_mode == 2;
	}
	else
	{
		// now put back the mouse settings the way they were
		enable_mouse = saveMouseEnable;
		mouse_pointer = saveMousePointer;
		mouse_mode = saveMouseMode;
		lmxStrDsply.visible = off;   // shut the text display off
		displayX();                  // and clear up any radion button x's
	} 	

}

/*******************************************************************************
Adjust the position of the Light Mixer Control Panel Based on the current 
video mode
********************************************************************************/
starter lmxHandleVideoMode ()
{
	var xOffset;
	var yOffset;

	waitt (16); // just in case
	while (1)
	{
		while lmxPanel.visible
		{
			if (video_mode == 6)
				{xoffset=0;yoffset=0;}			
			if (video_mode == 7)
				{xoffset=80;yoffset=120;}
			if (video_mode == 8)
				{xoffset=192;yoffset=288;}
			if (video_mode == 9)
				{xoffset=320;yoffset=480;}
			if (video_mode == 10)
				{xoffset=380;yoffset=570;}
			if (video_mode == 11)
				{xoffset=480;yoffset=720;}

			lmxPanel.pos_x= 0 + xOffset; 
			lmxPanel.pos_y = 0 + yOffset;
			lmxStrDsply.pos_x = 534 + xOffset;
			lmxStrDsply.pos_y = 315 +yOffset;	
			wait (1);
		}
		wait (1);
	}		
}
on_n lmxGetNextEntity;
on_p lmxTogglePanel;
