PATH	"IMAGES";	// Path to our images subdirectory
PATH	"..\\template";	// Path to WDL templates subdirectory

// Include files
INCLUDE <movement.wdl>;
INCLUDE <messages.wdl>;
INCLUDE <particle.wdl>;
INCLUDE <doors.wdl>;
INCLUDE <actors.wdl>;
INCLUDE <weapons.wdl>;
INCLUDE <war.wdl>;
INCLUDE <menu.wdl>;

// Starting engine values
IFDEF LORES;
var video_mode = 4;		// 320x240
IFELSE;
var video_mode = 6;		// 640x480
ENDIF;
var video_depth = 16;	// D3D, 16 bit resolution
var fps_max = 40;	// 40 fps max
var floor_range = 200;	// prevent sudden brightness changes on aircraft

// Desc: Our MAIN function called at game start
function  main()
{
IFNDEF NOTEX; // disable d3d_texreserved by starting with -d notex on weak cards
	D3D_TEXRESERVED = min(12000,D3D_TEXMEMORY/2); // biggest level of game needs 12 MB tex space
ENDIF;
	// set sky maps before level loading to give them priority
	init_environment();	// set up our environment (sky, clouds, etc.)
	LOAD_LEVEL <flywork.WMB>;
	load_status();	// restore global skills
}


// our environment bitmaps
BMAP my_sky = <sky1.pcx>,0,0,128,128;
BMAP my_clouds = <sky1.pcx>,128,0,128,128;
BMAP my_mountains = <mount16.pcx>;

// Desc: set up the sky, cloud, and scene maps
function init_environment()
{
	sky_map = my_sky;
	cloud_map = my_clouds;
	scene_map = my_mountains;

	scene_field = 180;
	scene_angle.tilt = -10;

	SKY_SPEED.X = 0;
	SKY_SPEED.Y = .025;
	CLOUD_SPEED.X = 3;
	CLOUD_SPEED.Y = 4.5;
	SKY_SCALE = 1.0;
	SKY_CURVE = 1;
}

// Aircraft DEFINEs and values
DEFINE _MODE_PLANE,16;
DEFINE _RPM,SKILL31;		// motor speed

// airplane values
var stallspeed = 8;		// plane stalls below this speed
var climbrate = 1.5;		// maximum climb rate
var climbfactor = 0.1;	// wing profile
var height_max = 750;	// maximum height
var speed_max = 25;		// max airspeed
var max_rpm = 7;		// maximum engine speed

// sound vales
var enghandle = 0;
SOUND engsound = <jet.wav>;	// engine sound

// animation string
string anim_fly_str = "fly";

define _FLYSCALE 0.3;

// Desc: our aircraft action
ACTION player_aircraft
{
	// Init values
	IF(MY.client == 0) { player = MY; } // created on the server?

	MY._TYPE = _TYPE_PLAYER;
	MY.ENABLE_SCAN = on;	// so that enemies can detect me

	IF(MY._FORCE == 0) {  MY._FORCE = 1.5; }
	IF(MY._MOVEMODE == 0) { MY._MOVEMODE = _MODE_PLANE; }

	MY.scale_x *= _FLYSCALE;
	MY.scale_y *= _FLYSCALE;
	MY.scale_z *= _FLYSCALE;

	drop_shadow(); // needs _movemode to be set

	// while we are in a valid MOVEMODE
	WHILE(MY._MOVEMODE == _MODE_PLANE
		|| MY._MOVEMODE == _MODE_DRIVING)
	{

		_player_force();  // set force and aforce values from player input
		scan_floor();     // set floor_normal, my_height, and floor_speed

		// Calculate Engine speed (accelerate motor with [HOME], [END])
		// MY._RPM = rpm / 1000
		MY._RPM += 0.0025*force.Z*TIME;
		// limit _RPM between 0 and 7000 rpm max
		MY._RPM = max(0,min(max_rpm,MY._RPM));

		// start, stop or tune the engine sound
		if(MY == player)
		{
			// if the engine is running...
			if(MY._RPM > 0)
			{
				if(enghandle == 0)  // no sound is playing
				{
					// start playing engine sound
					PLAY_LOOP engsound,25;
					enghandle = RESULT;
				}
				// tune the sound depending on speed_ahead
				temp = (MY._RPM + MY._SPEED_X * 0.2) * 60;
				TUNE_SOUND enghandle,25,temp;
			}
			else  // engine is stopped...
			{
				if(enghandle != 0)	// sound is playing
				{
					// stop playing engine sound
					STOP_SOUND enghandle;
					enghandle = 0;
				}
			}
		} // END if(MY == player)


		// Calculate lift force, dependent on speed, tilt and roll angle
		force.z = (climbfactor*MY._SPEED_X)
			 * (0.05 * (90 + ang(MY.tilt)- (0.5*abs(ang(MY.roll))) ));

		// if our speed is less then the stall speed...
		if(MY._SPEED_X < stallspeed)
		{
			// stall (no lift)
			force.z = 0;
		}

		// airplane is effected by gravity
		force.z -= gravity;

		// limit the lift force
		force.z = min(force.z,climbrate);

		// if on the ground, drive around
		IF(my_height < 5)
		{
			MY._MOVEMODE = _MODE_DRIVING;

			// the ahead force depends on the motor speed (always positive)
			force.X = max(0,0.5*(MY._RPM - 1));

			// steer with both stick and pedals [<] [>]
			if (aforce.pan == 0)
			{
				aforce.pan = force.Y;
			}

			// If the roll angle was not zero,
			// apply a roll force to set the angle back
			aforce.roll = -0.2*ang(MY.roll);

			// Now accelerate the angular speed, and set the angles
			friction = min(1,TIME*ang_fric);
			MY._ASPEED_PAN += (TIME * 0.3 * aforce.pan)
						- (friction * MY._ASPEED_PAN);
			MY._ASPEED_ROLL+= (TIME * aforce.roll)
						- (friction * MY._ASPEED_ROLL);

			MY.pan += TIME * MY._ASPEED_PAN * MY._SPEED_X * 0.025;
			MY.roll+= TIME * MY._ASPEED_ROLL;
			MY.tilt = 0;

			friction = min(1,TIME*gnd_fric*0.3);
			// accelerate the entity relative speed by the force
			MY._SPEED_X += TIME*force.X - friction*MY._SPEED_X;
			dist.X = TIME * MY._SPEED_X;
			dist.Y = 0;
			dist.Z = 0;

			MY._SPEED_Z += TIME*force.z - friction*MY._SPEED_Z;
			absdist.X = 0;
			absdist.Y = 0;
			absdist.Z = TIME*MY._SPEED_Z;

			// Add the speed given by the ground elasticity
			absdist.Z = max(0,absdist.Z) - min(0,max(my_height,-10));

			// If the plane is on a moving platform add floorspeed
			absdist.X += my_floorspeed.X;
			absdist.Y += my_floorspeed.Y;
		}
		ELSE // airborne
		{
			MY._MOVEMODE = _MODE_PLANE;
			// tilting is done by the up/down keys, 
			// and swings back after releasing
			aforce.tilt = (-0.1*force.X) - (0.01*ang(MY.tilt));
			// rolling is done by the left/right keys,
			// and swings back after releasing
			aforce.roll = (-0.1*aforce.pan) - (0.02*ang(MY.roll));
			// the pan force depends on the rudder padals 
			// and the roll angle
			aforce.pan = (0.01*force.Y) - (0.03*ang(MY.roll));

			// the ahead force depends on the motor speed 
			// and the tilt and roll angle
			force.X = (0.5*MY._RPM)   // motor speed
				  -(0.01*ang(MY.tilt))// minus speed due to tilt
				  -(0.005*abs(ang(MY.roll)));// minus speed due to roll

			// Now accelerate the angular speed, and change the angles
			friction = min(1,TIME*ang_fric);
			MY._ASPEED_PAN  += (TIME*aforce.pan)  
						- (friction*MY._ASPEED_PAN);
			MY._ASPEED_TILT += (TIME*aforce.tilt) 
						- (friction*MY._ASPEED_TILT);
			MY._ASPEED_ROLL += (TIME*aforce.roll) 
						- (friction*MY._ASPEED_ROLL);

			MY.pan  += TIME * MY._ASPEED_PAN;
			MY.roll += TIME * MY._ASPEED_ROLL;
			MY.tilt += TIME * MY._ASPEED_TILT;

			// Artificial limits
			// prevent climbing out of the world
			force.Z -= max(0, 0.01*(my_height - height_max));
			// prevent over speed
			force.X -= max(0, 0.1*(MY._SPEED_X - speed_max));

			// accelerate the entity relative speed by the force
			friction = min(1,TIME*gnd_fric*0.2);
			MY._SPEED_X += (TIME*force.X) - (friction*MY._SPEED_X);
			dist.X = TIME * MY._SPEED_X;
			dist.Y = 0;
			dist.Z = 0;	// lift force controls absolute speed only

			// Add the lift and gravity force
			MY._SPEED_Z += (TIME*force.z) - (friction*MY._SPEED_Z);
			absdist.X = 0;
			absdist.Y = 0;
			absdist.Z = TIME * MY._SPEED_Z;
		}  // END 'airborne'

		// Now move ME by the relative and the absolute distance
		YOU = NULL;	// YOU entity is considered passable by MOVE
		MOVE ME,dist,absdist;

		aircraft_anim(); // animate the aircraft

		// If I'm the only player, draw the camera and weapon with ME
		if (client_moving == 0) { move_view(); }

		// Wait one tick, then repeat
		wait(1);
	}
}

// Desc: animate the aircraft
function aircraft_anim()
{
 	MY._ANIMDIST += MY._RPM * TIME;
	// wrap animation TIME to a value between zero and 100 percent
	while(MY._ANIMDIST > 100) { MY._ANIMDIST -= 100; }
	// set the frame from the percentage
	SET_CYCLE MY,anim_fly_str,MY._ANIMDIST;
}

