ifndef display00_wdl;
define display00_wdl;

// ver: 1
// date: 032312


// title: Display
// image: display.pcx
/*
help: The display represents the screen that all windows are rendered to.
*/

// needs: gid01.wdl

// prefix: display00_
// idcode: 00A


//----------------------------------------------------------------------
// section: General Settings

// entry: Screen Resolution-
// entry_help: Set the initial screen resolution.
// entry_help: Note: Some resolutions may not be available on all video cards.
// entry_help:or for all versions of GStudio.
// entry_help: 1 - 320x200, 2 - 320x240, 3 - 320x400, 4 - 400x300,
// entry_help: 5 - 512x384, 6 - 640x480, 7 - 800x600, 8 - 1024x768
// entry_help: 9 - 1280x960, 10 - 1400x1050, 11 - 1600x1200
// id: 1
var   video_mode = 7;	// 800x600

// entry: Color Depth-
// entry_help: Video color depth. Can be set to 16 (high-color) or 32 (true-color)
// id: 2
var 	video_depth = 16; // 16bit high-color

// entry: Force display to fullscreen (1) or windowed (2), or leave unchanged (0)
// entry_help: Set to 1 to have the display fill the screen, set to 2 to
// entry_help:to display in a window. Set to 0 to keep the mode set by the
// entry_help:launching application or batch file.
// id: 3
define	display00_force_window_full_const = 0;

// entry: Select the corner where the watermark will appear.
// entry_help:(0-off, 1-4 select corner)
// id: 4
var logo = 0;

//----------------------------------------------------------------------
// section: Limits

// entry: Set the maximum number of entities.
// id: 5
var max_entities = 500;

// entry: Set the maximum number of Particles
// id: 6
var max_particles = 2000;


//----------------------------------------------------------------------
// section: Frames Per Second (FPS)

// entry: Maximum frame per second (FPS)
// entry_help: Note! TIME correction may not work at higher frame rates!
// id: 7
var fps_max = 90;

// entry: Minimum frame per second (FPS)
// id: 8
var fps_min = 4;

// enable: Lock time step to maximum frame per second (FPS)
// id: 9
/*> var fps_lock = ON; <*/

//----------------------------------------------------------------------
// section: Lighting

// entry: Maxium number of dynamic lights (2..8)
// entry_help: Gives the maxium number of dynamic lights (including the sun) that
// entry_help: can be active at the same time (Range: 2..8).
// id: 10
var max_lights = 8;


// entry: Use directional light for sun? (If set above 0, yes).
// entry_help: This reduces the maximum number of dynamic lights to 7.
// id: 11
var sun_light = 1;


//----------------------------------------------------------------------
// section: Entity Display Settings

// entry: Set the distance that entity shadows are offset from the floor
// id: 12
var shadow_offset = 2.5;

// entry: Set the range within which the light value of a entity is effected.
// id: 13
var floor_range = 1000;

// enable: (Advanced) Disable sorting of transparent entities
// id: 14
/*> var d3d_entsort = 0; <*/

// enable: (Advanced) Make map entities share texture with level and each other.
// id: 15
/*<>*/ var tex_share = 1;



//----------------------------------------------------------------------
// section: Mouse

// entry: Set the look of the windows mouse pointer when over the application window.
// entry_help:   0: The mouse pointer is always switched off over the window.
// entry_help:   1: The mouse pointer is switched off when mouse_mode is activated
// entry_help:        and a mouse_map is set, otherwise it's a hand.
// entry_help:   2: Like 1, but the mouse pointer is the standard arrow.
// entry_help:   3: Like 1, but the mouse pointer is a crosshair.
// entry_help:   4: Like 1, but the mouse pointer is a hourglass.
// id: 20
var	mouse_pointer = 0;	// turn off mouse pointer


//----------------------------------------------------------------------
// section: Advanced Settings

// entry: Maximum level of anisotopy (0 - off)
// entry_help: Used to help eliminate distortion in textures whose surfaces
// entry_help:are oriented with respect to the screen plane.
// entry_help: Set to a value greater than 1.0 to activate.
// id: 21
var	d3d_anisotropy = 0;

// enable: (Advanced) Force triple buffering?
// id: 22
/*> var d3d_triplebuffer = 1;  <*/

// enable: (Advanced) Prevent triple buffering?
// id: 23
/*> var d3d_triplebuffer = 0;  <*/

// enable: (Advanced) Force vertical sync?
// id: 24
/*> var d3d_vsync = 1;  <*/

// enable: (Advanced) Prevent vertical sync?
// id: 25
/*> var d3d_vsync = 0; <*/

// enable: Deactivate mipmapping
// id: 26
/*> var d3d_mipmapping = 0; <*/

// entry: Set the relative distance for switching mipmap textures on flat surfaces
// id: 27
var mip_flat = 1.5;

// entry: Set the relative distance for switching mipmap textures on shaded surfaces
// id: 28
var mip_shaded = 1.0;

// enable: Improve light resolution
// id: 29
/*> var d3d_lightres = 1; <*/

// enable: Disable color lights
// id: 30
/*> var d3d_monochrome = 1; <*/

// entry: (Advanced) Set the amount of video memory reserved for non-managed textures.
// entry:Use a negative value to let 3DGS set the memory reserve for you (recommended).
// id: 31
define display00_texture_reserve_const = -1;

// entry: Set the number of detail pixels per terrain surface pixel.
// id: 32
var detail_size = 4;



//+++ ... add other 'display' entries here


// An array of bit-encoded fields which tell which, if any, camera is
//currently assigned to update a particular camera.
// Index: 0:main view, 1-4: sub views 1-4
var	display_active_camera_vec[5];

// Count of the number of active views
// default to just the main view (1)
var 	display_active_views = 1;




//----------------------------------------------------------------------
// section: Clip Ranges

// entry: Multiplier for the clipping range or world (BSP) polygons.
// entry_help: Example: A value of 2 would clip world polygons at twice
// entry_help:the distance as object polygons.
// id: 40
var clip_factor = 2.0;

// entry: Multiplier for the clipping range of particles.
// entry_help: Example: A value of 0.5 would clip particles at half the
// entry_help:distance as object polygons.
// id: 41
var clip_particles = 0.5;

// entry: Minimum number of pixels a polygon must cover before being clipped.
// entry_help: Example: a value of 0.5 would clip polygons whose size is less
// entry_help:than half a pixel.
// id: 42
var clip_size = 0.5;


// function_help: Init display values
// Init values
// Update views using assigned update functions
starter	Display00_Init()
{
	diag("\nWDL-Loaded:display00.wdl");
	// Init display

// entry: Near camera clipping
// entry_help: Reduce this value if you can see through near objects
// id: 43
	camera.clip_near = 10;

// entry: Far camera clipping
// entry_help: Increase this value if objects vanish too soon.
// id: 44
	camera.clip_far = 50000;

	// force a switch on the video modes if display00_force_window_full_const is set
	video_switch(0,0,display00_force_window_full_const);
	
	

//----------------------------------------------------------------------
// section: Background Color

// entry: Set background color's red component.
// entry_help: note: if all three components are set to 0, no background color is drawn.
// id: 45
	bg_color.red = 0;
// entry: Set background color's green component.
// entry_help: note: if all three components are set to 0, no background color is drawn.
// id: 46
	bg_color.green = 0;
// entry: Set background color's blue component.
// entry_help: note: if all three components are set to 0, no background color is drawn.
// id: 47
	bg_color.blue = 0;

	// force texture reserve if display00_texture_reserve_const is set
	if(display00_texture_reserve_const >= 0)
	{
		if (d3d_texreserved )
		{
			// reserve the amount asked for or half the amount available (whichever is less)
			d3d_texreserved = min(display00_texture_reserve_const,d3d_texfree/2);
		}
	}


}

endif;