ifndef gid01_wdl;
define gid01_wdl;

// ver: 1
// date: 032312


// title: Global Identifiers (01)
// image: gid.pcx
/*
help: Most scripts that deal with an entity require this script. It is used
to give each type of entity a unique identification number. This identification
number is used by other scripts to determine behavior.

Global Identifiers also contains skill defines for values like velocity,
damage, distance, and time. These "generic values" can be used to pass
information between scripts.

This is also where global 'event varibles' are stored.
*/

// needs:

// external:

// prefix: gid01_
// idcode: 00

////////////////////////////////////////////////////////////////////////
// Global
define	GID01_OLD_COLLIDE;	// use the old collision code

////////////////////////////////////////////////////////////////////////
// Entity IDs (stored in SKILL48)
define	_gid01_id, skill48;
// player IDs
define gid01_player_const = 1; 		// player id

// AI ids (64-127)
define gid01_ai_const = 64;			// generic AI



// Map entity IDs
define gid01_platform_const = 128; 		// moving platform id (lift01)
define gid01_water_const = 129;			// generic water id
define gid01_forcefield_const = 130; 	// force field id
define gid01_door_const = 131;			// door id (door01)
define gid01_damagefield_const = 132;  // dmage field id

// shared skills:

// Velocity in quants/tick
define	_gid01_vel_x, skill21;        // current velocity (quants/tick)
define	_gid01_vel_y, skill22;        // current velocity (quants/tick)
define	_gid01_vel_z, skill23;        // current velocity (quants/tick)

// ang velocity in deg/tick
define _gid01_ang_vel_pan, SKILL24;
define _gid01_ang_vel_tilt, SKILL25;
define _gid01_ang_vel_roll, SKILL26;



////////////////////////////////////////////////////////////////////////
// Shared vars (used for passing "event values")

// Type of event being preformed:
var	gid01_event_type;
// -entity is being activated by a scan (i.e. open door, pickup item, etc.)
define	gid01_event_scan_activate = 1;
// -entity has been shot by a projectile
define	gid01_event_projectile_damage = 2;

// -"alert" sound scan (guard raising alarm, siren going off, etc.)
define	gid01_event_alert_sound = 3;


// Value associated with current 'gid01_event_type'
// (e.g. if gid01_event_type == gid01_event_projectile_damage, then
// gid01_event_value == Damage_Done)
var	gid01_event_value;


////////////////////////////////////////////////////////////////////////
// Global State values



// state of the level
var	gid01_level_state = 0;
// level is not loaded
define	gid01_level_not_loaded = 0;
// level is loaded
define	gid01_level_loaded = 1;
// level is being restarted
define	gid01_level_restart = 2;
// level is changing (e.g. level1 to level2)
define	gid01_level_change = 3;


//----------------------------------------------------------------------
// Temp values
string gid01_temp_mdl = <temp.mdl>;	// placeholder model
var	 gid01_vec[3];						// temp vec
var	 gid01_vec2[3];					// temp vec2


endif;