////////////////////////////////////////////////////////////////////////
// A6 main wdl:
//		Created by WED.
////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where template files can be found.
path "F:\\Arquivos de programas\\GStudio6\\template_6";	// Path to A6 templates directory
path "F:\\Arquivos de programas\\GStudio6\\template_6\\code";	// Path to A6 template code subdirectory
path "F:\\Arquivos de programas\\GStudio6\\template_6\\images";	// Path to A6 template image subdirectory
path "F:\\Arquivos de programas\\GStudio6\\template_6\\sounds";	// Path to A6 template sound subdirectory
path "F:\\Arquivos de programas\\GStudio6\\template_6\\models";	// Path to A6 template model subdirectory
//path "F:\\Arquivos de programas\\GStudio6\\template";
/////////////////////////////////////////////////////////////////
// Filename of the starting level.
string level_str = <pool_demo.WMB>; // give file names in angular brackets

////////////////////////////////////////////////////////////////////////////
// Included files
include <gid01.wdl>;	// global ids
include <display00.wdl>;  // basic display settings
include <movement.wdl>;	  //includes the A6 template script for moving entity




/////////////////////////////////////////////////////////////////
// Desc: The main() function is started at game start
function main()
{
	// set some common flags and variables
	// freeze all entity functions
	freeze_mode = 1;
	// no level has been loaded yet...
	gid01_level_state = gid01_level_not_loaded;

// entry: Warning Level (0,1, or 2)
// entry_help: Sets sensitivity to warnings (0 = none, 1 = some, 2 = all).
	warn_level = 2;	// announce bad texture sizes and bad wdl code


// entry: Starting Mouse Mode (0, 1, or 2)
	mouse_mode = 0;

	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);

	// now load the level
	level_load(level_str);

	wait(2);	// let level load
	// level should be loaded at this point...
	gid01_level_state = gid01_level_loaded;

//+++ load starting values

	// un-freeze the game
	freeze_mode = 0;
}


// Desc: this is the function used to restart the game.
function	main_restart_game()
{
	// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);

	// now load the level
	level_load(level_str);
	// freeze the game
	freeze_mode = 1;

	wait(2);	// 1-level loads, 2-entities load

//+++ load starting values

	// un-freeze the game
	freeze_mode = 0;
}


// Desc: this is the function used to quit the game.
function	main_quit()
{
//+++			// save global skills & strings
	exit;
}

/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
WINDOW WINSTART
{
	TITLE			"3D GameStudio";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}

/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FONT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/













/*global Variables*/
/*global Variables*/



//Panel 1
bmap sonar_out_a = <Sonar_Out_A.pcx>; 



//Panel2
bmap sonar_out = <Sonar_Out.pcx>; 



//Panel3
bmap scan_01=<Sonar_Scan_01.pcx>;
bmap scan_02=<Sonar_Scan_02.pcx>;
bmap scan_03=<Sonar_Scan_03.pcx>;
bmap scan_04=<Sonar_Scan_04.pcx>;



//Manipulates the gravity influence
var switchgrav = 0.01;



//overwrite the predefined vars of movement.wdl script

var gravity=0;

var air_fric = 0.05; 


/*end global Variables*/
/*end global Variables*/



















/*Panel 1*/


panel subsonar_outa
{

bmap=sonar_out_a;
layer=3;
pos_X = 4; pos_y = 400;
flags = REFRESH,VISIBLE,OVERLAY;

}


/*End Panel 1*/























/*Panel 2*/


panel subsonar_out
{
pos_x=4;pos_y=400;
bmap=sonar_out;
alpha=90;
flags = REFRESH,VISIBLE,OVERLAY;
}


/*End Panel 2*/

















/*Panel 3*/


panel sub_scan
{

alpha=60;
layer=2;
pos_x=4; pos_y=400;
flags = REFRESH,VISIBLE,OVERLAY;
}


/*End Panel 3*/




























/*Function that deals Panel 3 image rotation*/


function rotate_scan
{
	while(1)
	{
	sub_scan.bmap=scan_01;
	wait(32);
	sub_scan.bmap=scan_02;
	wait(32);
	sub_scan.bmap=scan_03;
	wait(32);
	sub_scan.bmap=scan_04;
	wait(32);
	}
}


/*End Function that deals Panel 3 image Rotation*/























//Function to deal the predefined var gravity 
//from the movement template script


function switch_gravity
{

if(key_f)
{
person_3rd = 0.5;
}



while(key_a)
{
gravity-=switchgrav;
wait(1);
}


while(key_z)
{
gravity+=switchgrav;
wait(1);
}


gravity=0;

}


//End Function to deal the predefined var gravity 
//from the movement template script
































/*Action for the submarine entity*/

action sub_simulate
{

my.narrow = OFF;
my.fat = ON; 

player_drive();

on_anykey=switch_gravity;

rotate_scan();

}

/*End Action for the submarine entity*/








/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;