// title: 		mouse gestures
// author: 		u.seiffert
// homepage: 	www.gameus.de
// date:			05.2006
//----------------------------------------------------------------------

// === just for information at designtime ==============================
string str_tmp1;
string str_tmp2;
string str_tmp3;
// show normalized vectors
text txt_vec_list {
	pos_x=20;
	pos_y=20;
	strings=14;
	string="mouse-moves:  write a S or a W"," ","  /  ","  /  ","  /  ","  /  ","  /  ","  /  ","  /  ","  /  ","  /  ","  /  "," ","                                     ";
	flags=visible;
}
// === just for information at designtime ==============================

// the idea is to recognize the changing of the mousdirection, 
// normalize them and compare it with different vector-arrays


// Vectors for a "S"
var gest_s[10] = -1,-1, -1,1, 1,1, -1,1, -1,-1;   // the moves for a "S"
var gest_s_check = 0; // every match increment this counter, else reset it

// Vectors for an "W"
var gest_w[8] = 1,1, 1,-1, 1,1, 1,-1;	// the moves for an "W" 
var gest_w_check = 0; // every match increment this counter, else reset it



function check_gesture(p_dx,p_dy) {
	
	// S ....
	if(p_dx==gest_s[gest_s_check] && p_dy==gest_s[gest_s_check+1]){
		gest_s_check+=2;	// match -> next one
	}else{
		gest_s_check=0; 	// failed -> reset
	}	
	// all points succeeded?
	if(gest_s_check==10){
		str_cpy(txt_vec_list.string[13],"this was a 'S'!");		
		gest_s_check=0;
		wait(1); beep;	sleep(1);
		str_cpy(txt_vec_list.string[13],"");
	}
	
	// W
	if(p_dx==gest_w[gest_w_check] && p_dy==gest_w[gest_w_check+1]){
		gest_w_check+=2;	// match -> next one
	}else{
		gest_w_check=0; 	// failed -> reset
	}	
	// all points succeeded?
	if(gest_w_check==8){
		str_cpy(txt_vec_list.string[13],"this was an 'W'!");		
		gest_w_check=0;
		beep;		
	}	
	
}


//----------------------------------------------------------------------
function show_mouse_move(p_dx,p_dy) {
var lv_cnt;

	// shift the stack
	lv_cnt=2;
	while(lv_cnt<11){
		str_cpy(txt_vec_list.string[lv_cnt],txt_vec_list.string[lv_cnt+1]);
		lv_cnt+=1;
	}
	// write the actual at the end last
	str_for_num(str_tmp1,p_dx);
	str_for_num(str_tmp2,p_dy);
	str_cpy(str_tmp3,str_tmp1);
	str_cat(str_tmp3,"/");
	str_cat(str_tmp3,str_tmp2);
	str_cpy(txt_vec_list.string[11],str_tmp3);
	
	wait(1);	
}


//----------------------------------------------------------------------
// main...
function main {
var lv_lastpos[2];
var lv_currdir[2];
var lv_lastdir[2];
	
	// set background
	bg_color.red=10;
	bg_color.green=10;
	bg_color.blue=10;
	
	// set the mouseproperties
	mouse_mode=2;
	mouse_pointer=2;	
	mouse_calm=10; // sensibility in pixels  (see mouse_moving)
	mouse_time=16; // sensibility in ticks   (see mouse_moving)
	
	// save positions/directions	
	vec_set(lv_lastpos,pointer.x);	// remenber the last position
	vec_set(lv_lastdir, nullvector);	// remeber the current direction 
	
	// load an empty level
	level_load("empty.wmb");
	wait(3);

	// ...	
	while(1){
		
		// Move the mousepointer
		mouse_pos.x = pointer.x;
		mouse_pos.y = pointer.y;
	
		// check the current direction
		if(sign(mouse_pos.x-lv_lastpos[0])!=0){lv_currdir[0]=sign(mouse_pos.x-lv_lastpos[0]);}
		if(sign(mouse_pos.y-lv_lastpos[1])!=0){lv_currdir[1]=sign(mouse_pos.y-lv_lastpos[1]);}
		
		// mouse changed the direction?
		if((abs(lv_currdir[0])>0 && lv_currdir[0]!=lv_lastdir[0]) || (abs(lv_currdir[1])>0 && lv_currdir[1]!=lv_lastdir[1])){		
			// remember last direction
			lv_lastdir[0]=lv_currdir[0];
			lv_lastdir[1]=lv_currdir[1];			
			// show (for info)
			show_mouse_move(lv_currdir[0],lv_currdir[1]);			
			// check gesture
			check_gesture(lv_currdir[0],lv_currdir[1]);
		}
	
		// current pos will be last pos after wait();
		lv_lastpos[0]=pointer.x;
		lv_lastpos[1]=pointer.y;
		
		// if no mouse_move -> reset all flags
		if(mouse_moving==0){
			gest_s_check=0;
			gest_w_check=0;			
			str_cpy(txt_vec_list.string[13],"no gesture detected");
		}
		
		
		wait(1);
	}
}