///////////////////////////////////////////////////////////////////////////////////
// A5 main wdl
////////////////////////////////////////////////////////////////////////////
// Files to over-ride:
// * logodark.bmp - the engine logo, include your game title
// * horizon.pcx - A horizon map displayed over the sky and cloud maps
////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
path "..\\template";	// Path to WDL templates subdirectory

////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions
include <movement.wdl>;
include <messages.wdl>;
include <menu.wdl>;		// must be inserted before doors and weapons
include <particle.wdl>; // remove when you need no particles
include <doors.wdl>;		// remove when you need no doors
include <actors.wdl>;   // remove when you need no actors
include <weapons.wdl>;  // remove when you need no weapons
include <war.wdl>;      // remove when you need no fighting
//include <venture.wdl>;	// include when doing an adventure
include <lflare.wdl>;   // remove when you need no lens flares
include <m_connect.wdl>;

////////////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the follwing vars.
var video_mode = 6;	 // screen size 640x480
var video_depth = 16; // 16 bit colour D3D mode




/////////////////////////////////////////////////////////////////
// Strings and filenames

string level_str = <level1.WMB>; // give file names in angular brackets

resource "model.wrs";

string caracter0_mdl = "security.mdl";
string caracter1_mdl = "kronos.mdl";
string caracter2_mdl = "cwarrior.mdl";
string caracter3_mdl = "trooper.mdl";
// function prototypes
function player_client();


entity* player1;
entity* player2;
entity* player_for_action;


var fleche_speed[3] =50,0,0;
var m_start[3];
var m_end[4];
string fleche_mdl <test.mdl>;
var player_clicked = 0;


///////////////////////////////////////////////////////////////
//our skills
define _id,skill48;
define health,skill47;
define armor,skill46;
define affiche_text,skill45;
																	//

/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo
bmap splashmap = <logodark.bmp>; // the default logo in templates
panel splashscreen {
	bmap = splashmap;
	flags = refresh,d3d;
}

////////////////////////////////////////////////////////////////////////////
// The following script controls the sky movement
bmap horizon_map = <horizon.pcx>;
// A backdrop texture's horizontal size must be a power of 2;
// the vertical size does not matter

function init_environment()
{
	scene_map = horizon_map;	// horizon backdrop overlay
	scene_nofilter = on;

	sky_speed.x = 1;
	sky_speed.y = 1.5;
	cloud_speed.x = 3;
	cloud_speed.y = 4.5;

	sky_scale = 0.5;
	sky_curve = 1;  			// 'steepness' on sky dome

	scene_field = 60;  		// repeat map 6 times
	scene_angle.tilt = -10; // lower edge on scene_map 10 units below horizon

	sky_clip = scene_angle.tilt;	// clip the sky at bottom on scene_map
}

/////////////////////////////////////////////////////////////////
// The main() function is started at game start
function main()
{
// animation adaption
	anim_walk_dist = 2; // for the new guards
	anim_run_dist = 3;
	walk_or_run = 8;
	camera_dist.z = -50;

// set some common flags and variables
//	warn_level = 2;	// announce bad texture sizes and bad wdl code
	tex_share = on;	// map entities share their textures

// center the splash screen for non-640x480 resolutions, and display it
	splashscreen.pos_x = (screen_size.x - bmap_width(splashmap))/2;
	splashscreen.pos_y = (screen_size.y - bmap_height(splashmap))/2;
	splashscreen.visible = on;
// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);

// init the 'environment' (sky & sceen map)
	init_environment();
// now load the level
	level_load(level_str);
// freeze the game
	freeze_mode = 1;

// wait the required second, then switch the splashscreen off.
	waitt(16);
  	splashscreen.visible = off;
	bmap_purge(splashmap);	// remove splashscreen from video memory

// load some global variables, like sound volume
	load_status();
	choice();

	while (all_ready ==0){


wait(1);}
	disable_all();

// un-freeze the game
	freeze_mode = 0;

// create the player entity of the client
ifdef CLIENT;
	client_move();	// enable multiuser mode

// create a client entity at a random place
//quel numro de joueur suis-je ?
//j'ai la chance d'avoir les 8 noms sur ma machine dont le mien il suffit de le trouver
	if (str_cmpi(player1_name_str,player_name)){temp.X = 16;}
	if (str_cmpi(player2_name_str,player_name)){temp.X = 32;}
	if (str_cmpi(player3_name_str,player_name)){temp.X = 48;}
	if (str_cmpi(player4_name_str,player_name)){temp.X = 64;}
	if (str_cmpi(player5_name_str,player_name)){temp.X = 80;}
	if (str_cmpi(player6_name_str,player_name)){temp.X = 96;}
	if (str_cmpi(player7_name_str,player_name)){temp.X = 112;}
	if (str_cmpi(player8_name_str,player_name)){temp.X = 128;}


//j'en profite pour envoyer 3 variables du joueur que sont health, armor et skin
	temp.X += choice_color+1;//skin choisie

	if (choice_player == 0){temp.y=90;temp.z = 110;player = ent_create(caracter0_mdl,temp,player_client);}
	if (choice_player == 1){temp.y=70;temp.z = 150;player = ent_create(caracter1_mdl,temp,player_client);}
	if (choice_player == 2){temp.y=80;temp.z = 120;player = ent_create(caracter2_mdl,temp,player_client);}
	if (choice_player == 3){temp.y=100;temp.z = 100;player = ent_create(caracter3_mdl,temp,player_client);}
//attention ici le programme continue alors que le joueur n'est pas compltement cr donc player.skin inefficace !!!


// the following flags are required for the camera
	player._MOVEMODE = _MODE_WALKING;
	player.__BOB = on;

endif;
}
function player_event
{handle_touch();
	if(EVENT_TYPE == EVENT_TOUCH) { _show_touch(); return; }
	if(EVENT_TYPE == EVENT_RELEASE) { _hide_touch(); return; }
	
}



function player_client()
{
	my.skin = (my.x)& 15;
	my._id = (my.x-my.skin)/16;

	if (my._id == 1){my.string1 = player1_name_str;player1 = my;while (player1 == null){wait(1);}}
	if (my._id == 2){my.string1 = player2_name_str;player2 = my;while (player2 == null){wait(1);}}
	if (my._id == 3){my.string1 = player3_name_str;}
	if (my._id == 4){my.string1 = player4_name_str;}
	if (my._id == 5){my.string1 = player5_name_str;}
	if (my._id == 6){my.string1 = player6_name_str;}
	if (my._id == 7){my.string1 = player7_name_str;}
	if (my._id == 8){my.string1 = player8_name_str;}
	my.health = my.y;
	my.armor = my.z;
	my.enable_click = on;
	my.enable_touch = on;
	my.x = 0+60+sys_seconds;my.y = 0;my.z = 50;
	MY.FAT = OFF;
	MY.NARROW = ON;		// set narrow hull
	MY._WALKFRAMES = 1;	// enable frame name animation
	MY._FORCE = 0.5;		// He should be not too fast
	MY._MOVEMODE = _MODE_WALKING;
	MY._BANKING = -0.1;
	MY.__JUMP = ON;
	MY.__DUCK = ON;
	MY.__STRAFE = ON;
	MY.__BOB = ON;
	MY.__TRIGGER = ON;
	while (my == null){wait(1);}
	MY.ENABLE_DISCONNECT = ON;
	MY.EVENT = player_event;
	player_move();
	if (MY.shadow == OFF) { drop_shadow(); }
	send_variable();
}



function send_variable
{

	while(1)
	{
		if (player1)
		{
			send (player1._id);
		}
		if (player2)
		{
			send (player2._id);
		}
		wait (1);
	}
}


function f_quit
{
	exit;
}
on_f10 f_quit;
