///////////////////////////////////////////////////////////////////////////////////
// A5 main wdl
////////////////////////////////////////////////////////////////////////////
// Files to over-ride:
// * logodark.bmp - the engine logo, include your game title
// * horizon.pcx - A horizon map displayed over the sky and cloud maps
////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
path "..\\template";	// Path to WDL templates subdirectory

////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions
include <movement.wdl>;
include <messages.wdl>;
include <menu.wdl>;		// must be inserted before doors and weapons
//include <particle.wdl>; // remove when you need no particles
//include <doors.wdl>;		// remove when you need no doors
//include <actors.wdl>;   // remove when you need no actors
//include <weapons.wdl>;  // remove when you need no weapons
//include <war.wdl>;      // remove when you need no fighting
//include <venture.wdl>;	// include when doing an adventure
//include <lflare.wdl>;   // remove when you need no lens flares
include <m_connect.wdl>;

////////////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the follwing vars.
var video_mode = 6;	 // screen size 640x480
var video_depth = 16; // 16 bit colour D3D mode




/////////////////////////////////////////////////////////////////
// Strings and filenames

string level_str = <level1.WMB>; // give file names in angular brackets

resource "model.wrs";

string caracter0_mdl = "security.mdl";
string caracter1_mdl = "kronos.mdl";
string caracter2_mdl = "cwarrior.mdl";
string caracter3_mdl = "trooper.mdl";
// function prototypes
function player_client();


entity* player1;
entity* player2;
entity* player3;
entity* player4;
entity* player5;
entity* player6;
entity* player7;
entity* player8;
entity* player_for_action;


var fleche_speed[3] =50,0,0;
var m_start[3];
var m_end[3];
string fleche_mdl <test.mdl>;
var player_clicked = 0;


///////////////////////////////////////////////////////////////
//our skills
define _id,skill48;
define health,skill47;
define armor,skill46;
define affiche_text,skill45;
define clicked,skill41;
//skill42,43,44 = temp for click mouse
																	//

/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo
bmap splashmap = <logodark.bmp>; // the default logo in templates
panel splashscreen {
	bmap = splashmap;
	flags = refresh,d3d;
}

////////////////////////////////////////////////////////////////////////////
// The following script controls the sky movement
bmap horizon_map = <horizon.pcx>;
// A backdrop texture's horizontal size must be a power of 2;
// the vertical size does not matter

function init_environment()
{
	scene_map = horizon_map;	// horizon backdrop overlay
	scene_nofilter = on;

	sky_speed.x = 1;
	sky_speed.y = 1.5;
	cloud_speed.x = 3;
	cloud_speed.y = 4.5;

	sky_scale = 0.5;
	sky_curve = 1;  			// 'steepness' on sky dome

	scene_field = 60;  		// repeat map 6 times
	scene_angle.tilt = -10; // lower edge on scene_map 10 units below horizon

	sky_clip = scene_angle.tilt;	// clip the sky at bottom on scene_map
}

/////////////////////////////////////////////////////////////////
// The main() function is started at game start
function main()
{
// animation adaption
	anim_walk_dist = 2; // for the new guards
	anim_run_dist = 3;
	walk_or_run = 8;
	camera_dist.z = -50;

// set some common flags and variables
//	warn_level = 2;	// announce bad texture sizes and bad wdl code
	tex_share = on;	// map entities share their textures

// center the splash screen for non-640x480 resolutions, and display it
	splashscreen.pos_x = (screen_size.x - bmap_width(splashmap))/2;
	splashscreen.pos_y = (screen_size.y - bmap_height(splashmap))/2;
	splashscreen.visible = on;
// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);

// init the 'environment' (sky & sceen map)
	init_environment();
// now load the level
	level_load(level_str);
// freeze the game
	freeze_mode = 1;

// wait the required second, then switch the splashscreen off.
	waitt(16);
  	splashscreen.visible = off;
	bmap_purge(splashmap);	// remove splashscreen from video memory

// load some global variables, like sound volume
	load_status();
	choice();

	while (all_ready ==0){


wait(1);}

	disable_all();

// un-freeze the game
	freeze_mode = 0;

// create the player entity of the client
ifdef CLIENT;
	client_move();	// enable multiuser mode

// create a client entity at a random place
//quel numro de joueur suis-je ?
//j'ai la chance d'avoir les 8 noms sur ma machine dont le mien il suffit de le trouver
	if (str_cmpi(player1_name_str,player_name)){temp.X = 16;}
	if (str_cmpi(player2_name_str,player_name)){temp.X = 32;}
	if (str_cmpi(player3_name_str,player_name)){temp.X = 48;}
	if (str_cmpi(player4_name_str,player_name)){temp.X = 64;}
	if (str_cmpi(player5_name_str,player_name)){temp.X = 80;}
	if (str_cmpi(player6_name_str,player_name)){temp.X = 96;}
	if (str_cmpi(player7_name_str,player_name)){temp.X = 112;}
	if (str_cmpi(player8_name_str,player_name)){temp.X = 128;}


//j'en profite pour envoyer 3 variables du joueur que sont health, armor et skin
	temp.X += choice_color+1;//skin choisie

	if (choice_player == 0){temp.y=90;temp.z = 110;player = ent_create(caracter0_mdl,temp,player_client);}
	if (choice_player == 1){temp.y=70;temp.z = 150;player = ent_create(caracter1_mdl,temp,player_client);}
	if (choice_player == 2){temp.y=80;temp.z = 120;player = ent_create(caracter2_mdl,temp,player_client);}
	if (choice_player == 3){temp.y=100;temp.z = 100;player = ent_create(caracter3_mdl,temp,player_client);}
//attention ici le programme continue alors que le joueur n'est pas compltement cr donc player.skin inefficace !!!


// the following flags are required for the camera
	player._MOVEMODE = _MODE_WALKING;
	player.__BOB = on;

endif;

}

function player_event
{ //you._id qui est la fleche souris du joueur demandeur contient le numero de joueur demandeur, c'est  lui qu'on envoie l'info

		IF(event_type == event_impact)//on affiche le texte de l'entit qui a t percute par la flche souris
		{	
			if (you._id == 1)
			{
			player1.clicked= my._id ;
			send (player1.clicked);
				player1.affiche_text =1;
				send (player1.affiche_text);
			}
			if (you._id == 2)
			{
			player2.clicked= my._id ;
			send (player2.clicked);
				player2.affiche_text =1;
				send (player2.affiche_text);
			}
			if (you._id == 3)
			{
			player3.clicked= my._id ;
			send (player3.clicked);
				player3.affiche_text =1;
				send (player3.affiche_text);
			}

		}
}

function player_client()
{
	my.skin = (my.x)& 15;
	my._id = (my.x-my.skin)/16;

	if (my._id == 1){player1 = my;while (player1 == null){wait(1);}}
	if (my._id == 2){player2 = my;while (player2 == null){wait(1);}}
	if (my._id == 3){player3 = my;while (player3 == null){wait(1);}}
	if (my._id == 4){my.string1 = player4_name_str;}
	if (my._id == 5){my.string1 = player5_name_str;}
	if (my._id == 6){my.string1 = player6_name_str;}
	if (my._id == 7){my.string1 = player7_name_str;}
	if (my._id == 8){my.string1 = player8_name_str;}
	my.health = my.y;
	my.armor = my.z;
	my.enable_impact = on;
	my.x = 0+60+sys_seconds;my.y = 0;my.z = 50;
	MY.FAT = OFF;
	MY.NARROW = ON;		// set narrow hull
	MY._WALKFRAMES = 1;	// enable frame name animation
	MY._FORCE = 0.5;		// He should be not too fast
	MY._MOVEMODE = _MODE_WALKING;
	MY._BANKING = -0.1;
	MY.__JUMP = ON;
	MY.__DUCK = ON;
	MY.__STRAFE = ON;
	MY.__BOB = ON;
	MY.__TRIGGER = ON;
	while (my == null){wait(1);}
	MY.ENABLE_DISCONNECT = ON;
	MY.EVENT = player_event;
	player_move();
	if (MY.shadow == OFF) { drop_shadow(); }
	send_variable();
}
function send_variable
{

	while(1)
	{
		if (player1)
		{
			send (player1._id);
		}
		if (player2)
		{
			send (player2._id);
		}
		if (player3)
		{
			send (player3._id);
		}
		wait (1);
	}
}


function f_quit
{
	exit;
}

function fleche_event()
{
	IF(event_type == event_block)
	{
		WAIT (1);
		remove me; 
		return;
	}
	IF(event_type == event_entity)//on affiche le texte de l'entit
	{	
		WAIT (1);
		remove me; 
		return;
	}
} 
function fleche1_action {my._id = player1._id;vec_set(m_end.x,player1.skill42);fleche_action();}
function fleche2_action {my._id = player2._id;vec_set(m_end.x,player2.skill42);fleche_action();}
function fleche3_action {my._id = player3._id;vec_set(m_end.x,player3.skill42);fleche_action();}
function fleche4_action {my._id = player4._id;vec_set(m_end.x,player4.skill42);fleche_action();}
function fleche5_action {my._id = player5._id;vec_set(m_end.x,player5.skill42);fleche_action();}
function fleche6_action {my._id = player6._id;vec_set(m_end.x,player6.skill42);fleche_action();}
function fleche7_action {my._id = player7._id;vec_set(m_end.x,player7.skill42);fleche_action();}
function fleche8_action {my._id = player8._id;vec_set(m_end.x,player8.skill42);fleche_action();}

function fleche_action
{
	my.hidden = on;
	my.fat = off;my.narrow = on;
	MY.ENABLE_BLOCK = ON;
	MY.ENABLE_ENTITY = ON;
	MY.ENABLE_STUCK = OFF;
	MY.PUSH = 0;
	MY.PASSABLE = OFF;

	MY.TRANSPARENT = ON;
	MY.AMBIENT = 100;
	//my._id = m_end[3]; //donne 1  8 pour numro de joueur demandeur
	vec_set(temp,m_end.x);
	vec_sub(temp,my.x);
	vec_to_angle(my.pan,temp);

	MY.event = fleche_event;
	WHILE(1)
	{
		ent_MOVE (fleche_speed, nullvector) ;
		WAIT 1;
	}
}
function clic_souris //excute sur chaque poste, l'action qui en dcoule et donc les vnements sur le serveur
{
if ((mouse_mode == 0) || (all_ready ==0)){return;}

	player.affiche_text = 0; 
	m_start.x = mouse_pos.x;
	m_start.y = mouse_pos.y;
	m_start.z = 0;
	m_end.x = mouse_pos.x;
	m_end.y = mouse_pos.y;
	m_end.z = 200000;
	vec_for_screen(m_start,camera);
	vec_for_screen(m_end,camera);
	vec_set(player.skill42,m_end.x);//stocke temporairement les valeurs de fin
	send_vec (player.skill42);
	clic_souris_event();
	if (player._id ==1){ent_create (fleche_mdl, m_start.x,fleche1_action);}
	if (player._id ==2){ent_create (fleche_mdl, m_start.x,fleche2_action);}
	if (player._id ==3){ent_create (fleche_mdl, m_start.x,fleche3_action);}
	if (player._id ==4){ent_create (fleche_mdl, m_start.x,fleche4_action);}
	if (player._id ==5){ent_create (fleche_mdl, m_start.x,fleche5_action);}
	if (player._id ==6){ent_create (fleche_mdl, m_start.x,fleche6_action);}
	if (player._id ==7){ent_create (fleche_mdl, m_start.x,fleche7_action);}
	if (player._id ==8){ent_create (fleche_mdl, m_start.x,fleche8_action);}

}
function clic_souris_event //j'attends une info du serveur pour afficher du texte sur ma souris
{
	while (1)
	{
		if (player.affiche_text == 1)
		{
			if (player.clicked==1){touch_txt.STRING = player1_name_str;}
			if (player.clicked==2){touch_txt.STRING = player2_name_str;}
			if (player.clicked==3){touch_txt.STRING = player3_name_str;}
			play_sound(touch_sound,100);
			touch_txt.VISIBLE = ON;
			touch_txt.POS_X = mouse_pos.X;
			touch_txt.POS_Y = mouse_pos.Y;
			if (player.affiche_text == 1){waitt (32);}//affiche_text peut tre mis  0 ailleurs
			player.affiche_text = 0; 
			touch_txt.VISIBLE = Off;
		}
		wait (1);
	}
}
on_f10 f_quit;
on_mouse_left clic_souris;

//debug
//str_cpy (debug_str,string_receive);
//str_cat (debug_str,"/");
//str_cat(debug_str,string_to_send);
//str_cat (debug_str,"/");
//str_cat(debug_str,player2_name);
