///////////////////////////////////////////////////////////////////////////////////
// A5 main wdl
////////////////////////////////////////////////////////////////////////////
// Files to over-ride:
// * logodark.bmp - the engine logo, include your game title
// * horizon.pcx - A horizon map displayed over the sky and cloud maps
////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
path "..\\template";	// Path to WDL templates subdirectory

////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions
include <movement.wdl>;
include <messages.wdl>;
include <menu.wdl>;		// must be inserted before doors and weapons
include <particle.wdl>; // remove when you need no particles
include <doors.wdl>;		// remove when you need no doors
include <actors.wdl>;   // remove when you need no actors
include <weapons.wdl>;  // remove when you need no weapons
include <war.wdl>;      // remove when you need no fighting
//include <venture.wdl>;	// include when doing an adventure
include <lflare.wdl>;   // remove when you need no lens flares

////////////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the follwing vars.
var video_mode = 7;	 // screen size 800x600
var video_depth = 16; // 16 bit colour D3D mode

///////////////////////////////////////////////////////////////////////////
// for logo animate
/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo
bmap splash_map = <logodark.bmp>;

panel splashscreen
{
	layer = 1;
	bmap = splash_map;
	flags = refresh;
}

bmap fondmap = <myscreen.pcx>;

panel mydebpanel
{
	layer = 1;
	bmap = fondmap;
	flags = refresh;
}

bmap fondmap2 = <myscreen2.pcx>;

panel myendpanel
{
	layer = 1;
	bmap = fondmap2;
	flags = refresh;
}


bmap logoavi = <lganideb2.bmp>;  
var vary = 0;
sound logo_s = <xpln.wav>;
panel logoaviscreen
{
	layer = 2;
	window = 0,0,640,480,logoavi,0,vary;
	flags = overlay,refresh;
}


bmap logoavi2 = <lganifin2.bmp>;
panel logoendscreen
{
	layer = 3;
	window = 0,0,640,480,logoavi2,0,vary;
	flags = overlay,refresh;
}


/////////////////////////////////////////////////////////////////
// Strings and filenames

string level_str = <level2.WMB>; // give file names in angular brackets

string player_mdl = <ship.mdl>;
// function prototypes
function player_client();

string bullet_mdl = <bullet.mdl>;
string missile_l_mdl = <missle_l.mdl>;
string missile_r_mdl = <missle_r.mdl>;

var num_client = 1;
var bullet[3];
var bullet_speed[3] 40, 0,0;

var rocket_pos[3];
var rock_pan[3];
var v_smoke;
var rocket_speed[3] 10, 0,0;
var rocket_l[5] = 4,2,2,2,2;//le premier chiffre est le compteur, les autres valent 2 pour afficher la rocket et 0 pour ne rien afficher
var rocket_r[5] = 4,2,2,2,2;//on les retrouve en skill 37,38,39,40,41,42,43 et 44
var indice;


SOUND shotgun_s = <gunfire.wav>;
SOUND riccochet= <ricc.wav>;
SOUND explo = <explosin.wav>;
SOUND explo_miss_s= <explo_miss.wav>;
SOUND launch = <missle.wav>;


BMAP smoke_m = <smoke.pcx>;
BMAP eclat_m = <eclat.pcx>;
BMAP particle_m = <particle.pcx>;

entity* player1;
entity* player2;
entity* player3;
entity* player4;
entity* player_for_action;
bmap* particle_map = smoke_m;

define health,skill48;
define ammo,skill47;
define rocket_left, skill45;
define rocket_right, skill46;
var xx;

//panel
FONT panel_font, <bauhau20.bmp>, 18, 30;
FONT icone_font, <icone20.bmp>, 18, 30;
PANEL display_panel {
	LAYER		3;
	POS_X		0;
	DIGITS	5,0,1,panel_font,1,player.skin;
	DIGITS	30,0,1,icone_font,1,3;
	DIGITS	50,0,3,panel_font,1,player.health;
	DIGITS	130,0,1,icone_font,1,1;
	DIGITS	150,0,4,panel_font,1,player.ammo;
	DIGITS	300,0,1,icone_font,1,player.skill37;
	DIGITS	330,0,1,icone_font,1,player.skill38;
	DIGITS	360,0,1,icone_font,1,player.skill39;
	DIGITS	390,0,1,icone_font,1,player.skill40;
	DIGITS	500,0,1,icone_font,1,player.skill41;
	DIGITS	530,0,1,icone_font,1,player.skill42;
	DIGITS	560,0,1,icone_font,1,player.skill43;
	DIGITS	590,0,1,icone_font,1,player.skill44;

	FLAGS	= REFRESH,D3D;
}

////////////////////////////////////////////////////////////////////////////
// The following script controls the sky movement
bmap horizon_map = <horizon.pcx>;
// A backdrop texture's horizontal size must be a power of 2;
// the vertical size does not matter

function init_environment()
{
	scene_map = horizon_map;	// horizon backdrop overlay
	scene_nofilter = on;

	sky_speed.x = 1;
	sky_speed.y = 1.5;
	cloud_speed.x = 3;
	cloud_speed.y = 4.5;

	sky_scale = 0.5;
	sky_curve = 1;  			// 'steepness' of sky dome

	scene_field = 60;  		// repeat map 6 times
	scene_angle.tilt = -10; // lower edge of scene_map 10 units below horizon

	sky_clip = scene_angle.tilt;	// clip the sky at bottom of scene_map
}

/////////////////////////////////////////////////////////////////
// The main() function is started at game start
function main()
{
// set some common flags and variables
//	warn_level = 2;	// announce bad texture sizes and bad wdl code
	tex_share = on;	// map entities share their textures

//	play_logo /////////////////////////////////////////
	vary = 0;
	splashscreen.pos_x = (screen_size.x - bmap_width(splash_map))/2;
	splashscreen.pos_y = (screen_size.y - bmap_height(splash_map))/2;
	mydebpanel.pos_x = (screen_size.x - bmap_width(fondmap))/2;
	mydebpanel.pos_y = (screen_size.y - bmap_height(fondmap))/2;
	myendpanel.pos_x = (screen_size.x - bmap_width(fondmap2))/2;
	myendpanel.pos_y = (screen_size.y - bmap_height(fondmap2))/2;
	logoaviscreen.pos_x = (screen_size.x - bmap_width(splash_map))/2;
	logoaviscreen.pos_y = (screen_size.y - bmap_height(splash_map))/2;
	logoendscreen.pos_x = (screen_size.x - bmap_width(splash_map))/2;
	logoendscreen.pos_y = (screen_size.y - bmap_height(splash_map))/2;

	splashscreen.visible = off;
	mydebpanel.visible = on;
	while(key_any == 0){wait 1;}
	wait 10;
	play_sound(logo_s,100);
	logoaviscreen.visible = on;
//	while(key_any == 0){wait 1;}
	//wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait (3);
	
	while (vary < 6200)
	{
	//while(key_any == 0){wait 1;}
		waitt(2.5);
		vary += 480;
	}


// wait the required second, then switch the splashscreen off.
  	logoaviscreen.visible = off;
	mydebpanel.visible = off;
	splashscreen.visible = on;
	waitt(16);
	//bmap_purge(logoavi);	// remove splashscreen from video memory

//****************** the end
	splashscreen.visible = off;
	myendpanel.visible = on;
	vary = 0;
	logoendscreen.visible = on;

	while (vary < 6200)
	{
		//while(key_any == 0){wait 1;}
		waitt(2.5);
		vary += 480;
	}
	

// init the 'environment' (sky & sceen map)
	init_environment();
// now load the level
	level_load(level_str);
// freeze the game
	freeze_mode = 1;

// wait the required second, then switch the splashscreen off.
	waitt(16);
	logoendscreen.visible = off;
	myendpanel.visible = off;
  	splashscreen.visible = off;
	bmap_purge(splash_map);	// remove splashscreen from video memory


// load some global variables, like sound volume
	load_status();


// un-freeze the game
	freeze_mode = 0;

// create the player entity on the client
ifdef CLIENT;
	client_move();	// enable multiuser mode

// wait until the level is loaded, and the connection is established
	while (connection == 0) { wait(1); }
	player = ent_create(player_mdl,nullvector,player_client);
endif;
while (player.health == null){wait(1);}
send_rocket_empty_l();
send_rocket_empty_r();
display_panel.pos_y = screen_size.y -50;
display_panel.visible = on;
wait_end();
}

function wait_end
{
	while(1)
	{
		if (player)
		{
			if (player.health ==0) //on est mort
			{
				rocket_r =0;
				rocket_l = 0;
				send_rocket_empty_l();
				send_rocket_empty_r();
				wait(1);
				remove(player);
			}
		}
		wait (1);
	}

}
// helper function: sets the vector to random direction and length
function vec_randomize(&vec,range)
{
	vec[0] = random(1) - 0.5;
	vec[1] = random(1) - 0.5;
	vec[2] = random(1) - 0.5;
	vec_normalize(vec,random(range));
}

// helper function: fades out a particle
function part_alphafade()
{
	my.alpha -= time+time;
	if (my.alpha <= 0) { my.lifespan = 0; }
}

// particle function: generates a fading explosion into vel direction
function effect_explo()
{
	vec_randomize(temp,10);
	vec_add(my.vel_x,temp);
	my.alpha = 25 + random(25);
	my.bmap = scatter_map;
	my.flare = on;
	my.bright = on;
	my.beam = on;
	my.move = on;
	my.function = part_alphafade; // change to a shorter, faster function
}


function player_client()
{
	my.skin = num_client;
	
	if (my.skin==1){my.X = 1000;my.Y = -1000;my.z = 20;}
	if (my.skin==2){my.X = -1000;my.Y = 1000;my.z = 20;}
	if (my.skin==3){my.X = 1000;my.Y = 1000;my.z = 20;}
	if (my.skin==4){my.X = -1000;my.Y = -1000;my.z = 20;}

	if (my.skin ==1){player1 = my;while (player1 == null){wait(1);}}
	if (my.skin ==2){ player2 = my;while (player2 == null){wait(1);}}
	if (my.skin ==3){player3 = my;while (player3 == null){wait(1);}}
	if (my.skin ==4){player4 = my;while (player4 == null){wait(1);}}
	num_client += 1;
	if (num_client > 5){wait(1);remove (me);return;}
	MY.ENABLE_DISCONNECT = ON;
	MY.EVENT = _actor_connect;
	my.health = 100;
	my.ammo = 9999;

	player_drive();
	send_variable();
	if (MY.shadow == OFF) { drop_shadow(); }
}

function send_variable
{
	while(1)
	{
		if (player1)
		{
			v_smoke = (100-player1.health)/10;
			player1._force = 0.5+(player1.health/100);
			emit v_smoke,player1.pos,particle_smoke;
			send (player1._force);
			send (player1.health);
			send (player1.skin);
			send (player1.ammo);

			if (player1.health <= 0)
			{
				player1.health = 0;
				//player1.rocket_left = 2;//commentaire  enlever pour que la roquette parte  la mort du vaisseau
				//player1.rocket_right = 2;
				//send_vec (player1.rocket_left);
				play_entsound (player1,explo,2000);
				effect(effect_explo,2000,player1.x,normal);
				//player1.health = -1000;
				wait (1);
				remove player1; 
				//wait (1);
				goto suite;
			}

		}
		if (player2) 
		{
			v_smoke = (100-player2.health)/10;
			player2._force = 0.5+(player2.health/100);
			emit v_smoke,player2.pos,particle_smoke;
			send (player2._force);
			send (player2.skin);
			send (player2.health);
			send (player2.ammo);

			if (player2.health <= 0)
			{
				player2.health = 0;
				send (player2.health);
				//player2.rocket_left = 2;//commentaire  enlever pour que la roquette parte  la mort du vaisseau
				//player2.rocket_right = 2;
				//send_vec (player2.rocket_left);
				effect(effect_explo,1000,player2.x,normal);
				play_entsound (player2,explo,2000);
				WAIT 1;
				remove player2; 
				goto suite;
			}

		}
		if (player3)
		{
			v_smoke = (100-player3.health)/10;
			player3._force = 0.5+(player3.health/100);
			emit v_smoke,player3.pos,particle_smoke;
			send (player3._force);
			send (player3.health);
			send (player3.skin);
			send (player3.ammo);

			if (player3.health <= 0)
			{
				player3.health = 0;
				send (player3.health);
				//player3.rocket_left = 2;//commentaire  enlever pour que la roquette parte  la mort du vaisseau
				//player3.rocket_right = 2;
				//send_vec (player3.rocket_left);
				play_entsound (player3,explo,2000);
				effect(effect_explo,2000,player3.x,normal);
				WAIT 1;
				remove player3; 
				goto suite;
			}

		}
		if (player4)
		{
			v_smoke = (100-player4.health)/10;
			player4._force = 0.5+(player4.health/100);
			emit v_smoke,player4.pos,particle_smoke;
			send (player4._force);
			send (player4.health);
			send (player4.skin);
			send (player4.ammo);

			if (player4.health <= 0)
			{
				player4.health = 0;
				send (player4.health);
				//player4.rocket_left = 2;//commentaire  enlever pour que la roquette parte  la mort du vaisseau
				//player4.rocket_right = 2;
				//send_vec (player4.rocket_left);
				play_entsound (player4,explo,2000);
				effect(effect_explo,2000,player4.x,normal);
				WAIT 1;
				remove player4; 
				goto suite;
			}

		}
	suite:
		wait(1);
	}
}

ACTION gun1_action
{
	if (player1)
	{
		player_for_action = player1;
		gun_action();
	}
}

ACTION gun2_action
{
	if(player2)
	{
		player_for_action = player2;
		gun_action();
	}
}

ACTION gun3_action
{
	if (player3)
	{
		player_for_action = player3;
		gun_action();
	}
}

ACTION gun4_action
{
	if (player4)
	{
		player_for_action = player4;
		gun_action();
	}
}

function gun_event()
{
	IF(event_type == event_block)
	{
		scatter_map = eclat_m;
		EMIT 10, MY.pos, particle_scatter;

		PLAY_entsound (my,riccochet, 250);
		WAIT 1;
		remove me; 
		return;
	}
	IF(event_type == event_entity)
	{
		PLAY_entSOUND (my,shotgun_s, 500);
		scatter_map = particle_m;
		EMIT 10, YOUR.x, particle_scatter;
		particle_map = smoke_m;
		EMIT 1, YOUR.pos, particle_smoke;
		your.health -= 5;

		WAIT 1;
		remove me; 
		return;
	}
} 

function rocket_event()
{
	IF(event_type == event_block)
	{
		CREATE <choc.pcx>, my.pos, disp_impact;	// create choc marks
		//YOUR.scale_x = 2;
		//YOUR.scale_y = 2; 

		TO_ANGLE bounce, NORMAL;
		SET YOUR.ORIENTED, ON;
		YOUR.ROLL = random(360);
		YOUR.TILT = bounce.TILT;
		YOUR.PAN = bounce.PAN; 
		effect(effect_explo,300,my.x,normal);

		PLAY_entSOUND (my,explo_miss_s, 500);
		WAIT 1;
		remove me; 
		return;
	}
	IF(event_type == event_entity)
	{
		PLAY_entSOUND (my,explo_miss_s, 500);
		EMIT 10, YOUR.x, particle_scatter;
		EMIT 5, YOUR.pos, particle_smoke;

		your.health -= 45;
		effect(effect_explo,300,your.pos,normal);

		WAIT 1;
		remove me; 
		return;
	}
} 

function particle_smoke()
{
	// just born?
	IF (MY_AGE == 0)
	{
		MY_SPEED.X = random(5)-2.5;	// -0.5 to +0.5
		MY_SPEED.Y = random(5)-2.5;     // -1 to +1
		MY_SPEED.Z = random(5)+2.5;     // +1 to +2

		MY_SIZE = random(25)+100; // 100 to 125 in size

  		MY_MAP = particle_map;
		MY_FLARE = ON;
		MY_COLOR.RED = 245;
		MY_COLOR.GREEN = 200;
		MY_COLOR.BLUE = 80;

		RETURN;
	}

	// increase the size of the smoke particle (up to max)
	IF (MY_SIZE < 2000)
	{
 		MY_SIZE += (5000 - MY_SIZE)*0.1*TIME;
	}

	// Remove old particles
	IF (MY_AGE >= 3)
	{
  		MY_ACTION = NULL;
	}
}

ACTION disp_impact {	
	MY.PASSABLE = ON;

	MY.FLARE = ON;
	MY.TRANSPARENT = ON;

	EMIT 10, MY.x, particle_scatter;
	EMIT 3, MY.pos, particle_smoke;
	WHILE (1) {
		IF (MY.SKILL1 == 256) {
			REMOVE ME;
			END;
		}
		MY.SKILL1 += 1;

		WAIT (1);
	}
}

ACTION gun_action
{
	play_entsound (player_for_action,shotgun_s,250);
	player_for_action.ammo -=1;
	MY.ENABLE_BLOCK = ON;
	MY.ENABLE_ENTITY = ON;
	MY.ENABLE_STUCK = OFF;
	MY.PUSH = 0;
	MY.PASSABLE = OFF;

	MY.TRANSPARENT = ON;
	MY.AMBIENT = 100;
	vec_set(my.PAN, player_for_action.PAN);
	vec_set(my.x, player_for_action.x);

	MY.event = gun_event;
	WHILE(1)
	{
		ent_MOVE (bullet_speed,nullvector) ;
		WAIT 1;
	}
}

ACTION rocket1l_action
{
	if (player1)
	{
		MY.ENABLE_DISCONNECT = ON;
		MY.EVENT = _actor_connect;
		my.passable = on;

		while(my !=null && player1.rocket_left ==1)//la rocket suit le vaisseau
		{
			if (player1.health==0){wait(1);remove(me);end;}//pour dtruire la rocket en mme temps que le vaisseau 
											//mettre en // pour que la roquette parte
			vec_set(my.x,player1.x);
			vec_set(my.PAN, player1.pan);
			wait(1);
		}
//on excute rocket_action uniquement si on tire
		if (player1.rocket_left == 2){player_for_action = player1;rocket_action();}
	}
}


ACTION rocket2l_action
{
	if (player2)
	{
		MY.ENABLE_DISCONNECT = ON;
		MY.EVENT = _actor_connect;
		my.passable = on;
		while(my !=null && player2.rocket_left ==1)
		{
			if (player2.health==0){wait(1);remove(me);end;}//pour dtruire la rocket en mme temps que le vaisseau 
											//mettre en // pour que la roquette parte
			vec_set(my.x,player2.x);
			vec_set(my.PAN, player2.pan);
			wait(1);
		}
		if (player2.rocket_left == 2){player_for_action = player2;rocket_action();}
	}
}

ACTION rocket3l_action
{
	if (player3)
	{
		MY.ENABLE_DISCONNECT = ON;
		MY.EVENT = _actor_connect;
		my.passable = on;

		while(my !=null && player3.rocket_left ==1)//la rocket suit le vaisseau
		{
			if (player3.health==0){wait(1);remove(me);end;}//pour dtruire la rocket en mme temps que le vaisseau 
											//mettre en // pour que la roquette parte
			vec_set(my.x,player3.x);
			vec_set(my.PAN, player3.pan);
			wait(1);
		}
//on excute rocket_action uniquement si on tire
		if (player3.rocket_left == 2){player_for_action = player3;rocket_action();}
	}
}

ACTION rocket4l_action
{
	if (player4)
	{
		MY.ENABLE_DISCONNECT = ON;
		MY.EVENT = _actor_connect;
		my.passable = on;

		while(my !=null && player4.rocket_left ==1)//la rocket suit le vaisseau
		{
			if (player4.health==0){wait(1);remove(me);end;}//pour dtruire la rocket en mme temps que le vaisseau 
											//mettre en // pour que la roquette parte
			vec_set(my.x,player4.x);
			vec_set(my.PAN, player4.pan);
			wait(1);
		}
//on excute rocket_action uniquement si on tire
		if (player4.rocket_left == 2){player_for_action = player4;rocket_action();}
	}
}

ACTION rocket1r_action
{
	if (player1)
	{
		MY.ENABLE_DISCONNECT = ON;
		MY.EVENT = _actor_connect;
		my.passable = on;

		while(my !=null && player1.rocket_right ==1)//la rocket suit le vaisseau
		{
			if (player1.health==0){wait(1);remove(me);end;}//pour dtruire la rocket en mme temps que le vaisseau 
											//mettre en // pour que la roquette parte
			vec_set(my.x,player1.x);
			vec_set(my.PAN, player1.pan);
			wait(1);
		}
//on excute rocket_action uniquement si on tire
		if (player1.rocket_right == 2){player_for_action = player1;rocket_action();}
	}
}


ACTION rocket2r_action
{
	if (player2)
	{
		MY.ENABLE_DISCONNECT = ON;
		MY.EVENT = _actor_connect;
		my.passable = on;
		while(my !=null && player2.rocket_right ==1)
		{
			if (player2.health==0){wait(1);remove(me);end;}//pour dtruire la rocket en mme temps que le vaisseau 
											//mettre en // pour que la roquette parte
			vec_set(my.x,player2.x);
			vec_set(my.PAN, player2.pan);
			wait(1);
		}
		if (player2.rocket_right == 2){player_for_action = player2;rocket_action();}
	}
}

ACTION rocket3r_action
{
	if (player3)
	{
		MY.ENABLE_DISCONNECT = ON;
		MY.EVENT = _actor_connect;
		my.passable = on;

		while(my !=null && player3.rocket_right ==1)//la rocket suit le vaisseau
		{
			if (player3.health==0){wait(1);remove(me);end;}//pour dtruire la rocket en mme temps que le vaisseau 
											//mettre en // pour que la roquette parte
			vec_set(my.x,player3.x);
			vec_set(my.PAN, player3.pan);
			wait(1);
		}
//on excute rocket_action uniquement si on tire
		if (player3.rocket_right == 2){player_for_action = player3;rocket_action();}
	}
}

ACTION rocket4r_action
{
	if (player4)
	{
		MY.ENABLE_DISCONNECT = ON;
		MY.EVENT = _actor_connect;
		my.passable = on;

		while(my !=null && player4.rocket_right ==1)//la rocket suit le vaisseau
		{
			if (player4.health==0){wait(1);remove(me);end;}//pour dtruire la rocket en mme temps que le vaisseau 
											//mettre en // pour que la roquette parte
			vec_set(my.x,player4.x);
			vec_set(my.PAN, player4.pan);
			wait(1);
		}
//on excute rocket_action uniquement si on tire
		if (player4.rocket_right == 2){player_for_action = player4;rocket_action();}
	}
}
ACTION rocket_action
{
	play_entsound (player_for_action,launch,10000);
	MY.ENABLE_BLOCK = ON;
	MY.ENABLE_ENTITY = ON;
	MY.ENABLE_STUCK = OFF;
	MY.ENABLE_DETECT = ON;
	MY.ENABLE_SCAN = ON;

	MY.PUSH = 0;
	MY.PASSABLE = OFF;


	MY.event = rocket_event;
	WHILE(1)
	{
		temp.pan = 90;
		temp.tilt = 90;
		temp.z = 200;
		SCAN My.x, My.pan, temp;

		EMIT 5, MY.pos, particle_smoke; 
		ent_move ( rocket_speed,nullvector) ;
		WAIT (1);
	}
}

function gun_fire
{
	if (player)
	{
		vec_set(bullet.x,player.x);
		bullet.x +=20;
		if (player.skin == 1){ent_create (bullet_mdl, bullet.x,gun1_action);}
		if (player.skin == 2){ent_create (bullet_mdl, bullet.x,gun2_action);}
		if (player.skin == 3){ent_create (bullet_mdl, bullet.x,gun3_action);}
		if (player.skin == 4){ent_create (bullet_mdl, bullet.x,gun4_action);}
	}
}

function rocketl_fire //cette fonction est appelle sur chaque poste
//l'action qui en dcoule est toujours excute sur le serveur
{
	if (player)
	{
		if (player.skin == 1){ent_create (missile_l_mdl, player.x,rocket1l_action);}
		if (player.skin == 2){ent_create (missile_l_mdl, player.x,rocket2l_action);}
		if (player.skin == 3){ent_create (missile_l_mdl, player.x,rocket3l_action);}
		if (player.skin == 4){ent_create (missile_l_mdl, player.x,rocket4l_action);}
	}
}
function rocketr_fire //cette fonction est appelle sur chaque poste
//l'action qui en dcoule est toujours excute sur le serveur
{
	if (player)
	{
		if (player.skin == 1){ent_create (missile_r_mdl, player.x,rocket1r_action);}
		if (player.skin == 2){ent_create (missile_r_mdl, player.x,rocket2r_action);}
		if (player.skin == 3){ent_create (missile_r_mdl, player.x,rocket3r_action);}
		if (player.skin == 4){ent_create (missile_r_mdl, player.x,rocket4r_action);}
	}
}

function prepare_rocket_gauche//recharge une rocket  gauche
{
	if (player)
	{
		if (rocket_l == 0){return;}//il n'y a plus de roquette gauche
		if (player.rocket_left == 1){return;}//on ne peut pas charger 2 roquettes  la fois
		player.rocket_left = 1;
		rocket_l-=1;
		send_rocket_l();
		rocketl_fire();
	}
}

function tire_rocket//on tire une roquette gauche
{
	if (player)
	{
		player.rocket_left = 2;
		//send (player.rocket_left);
		send_rocket_empty_l();

	}
}

function prepare_rocket_droite//recharge une rocket  gauche
{
	if (player)
	{
		if (rocket_r == 0){return;}//il n'y a plus de roquette droite
		if (player.rocket_right == 1){return;}//on ne peut pas charger 2 roquettes  la fois
		player.rocket_right = 1;
		rocket_r -= 1;
		send_rocket_r();
		rocketr_fire();
	}
}

function tire_rocket_r//on tire une roquette
{
	if (player)
	{
		player.rocket_right = 2;
		//send (player.rocket_right);
		send_rocket_empty_r();
	}
}

function send_rocket_l
{	indice = 1;
	while (indice < 5)
	{
		if (indice <= rocket_l){rocket_l[indice] = 2;}//else {rocket_l[indice] = 0;}
		if ((indice == rocket_l+1) && (rocket_l[indice] != 0)){rocket_l[indice] = 4;}
		if (indice > rocket_l+1){rocket_l[indice] = 0;}

		indice += 1;
	}
	vec_set(player.skill37,rocket_l[1]);
	player.skill40 = rocket_l[4];
	send_var_vec();
}
function send_rocket_empty_l
{
	indice = 1;
	while (indice < 5)
	{
		if (indice <= rocket_l){rocket_l[indice] = 2;}else {rocket_l[indice] = 0;}
		indice += 1;
	}
	vec_set(player.skill37,rocket_l[1]);
	player.skill40 = rocket_l[4];
	send_var_vec();
}
function send_rocket_r
{	indice = 1;
	while (indice < 5)
	{
		if (indice <= rocket_r){rocket_r[indice] = 2;}//else {rocket_r[indice] = 0;}
		if ((indice == rocket_r+1)&& (rocket_r[indice] != 0)){rocket_r[indice] = 4;}
		if (indice > rocket_r+1){rocket_r[indice] = 0;}

		indice += 1;
	}
	
	vec_set(player.skill41,rocket_r[1]);
	player.skill44 = rocket_r[4];
	send_var_vec();
}

function send_rocket_empty_r
{
	indice = 1;
	while (indice < 5)
	{
		if (indice <= rocket_r){rocket_r[indice] = 2;}else {rocket_r[indice] = 0;}
		indice += 1;
	}
	vec_set(player.skill41,rocket_r[1]);
	player.skill44 = rocket_r[4];
	send_var_vec();
}


function send_var_vec
{
	send_vec (player.skill37);
	send_vec (player.skill40);
	send_vec (player.skill43);
	send_vec (player.skill46);
}

function f_quit
{
	exit;
}


on_f10 f_quit;
on_v gun_fire;
on_1 prepare_rocket_gauche;
on_space tire_rocket;
on_2 prepare_rocket_droite;
on_ctrl tire_rocket_r;

