///////////////////////////////////////////////////////////////////////////////////
// A5 main wdl
////////////////////////////////////////////////////////////////////////////
// Files to over-ride:
// * logodark.bmp - the engine logo, include your game title
// * horizon.pcx - A horizon map displayed over the sky and cloud maps
////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
path "..\\template";	// Path to WDL templates subdirectory

////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions
include <movement.wdl>;
include <messages.wdl>;
include <menu.wdl>;		// must be inserted before doors and weapons
include <particle.wdl>; // remove when you need no particles
include <doors.wdl>;		// remove when you need no doors
include <actors.wdl>;   // remove when you need no actors
include <weapons.wdl>;  // remove when you need no weapons
include <war.wdl>;      // remove when you need no fighting
//include <venture.wdl>;	// include when doing an adventure
include <lflare.wdl>;   // remove when you need no lens flares

////////////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the follwing vars.
var video_mode = 7;	 // screen size 800x600
var video_depth = 16; // 16 bit colour D3D mode

///////////////////////////////////////////////////////////////////////////
// for logo animate
/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo
bmap splash_map = <logodark.bmp>;

panel splashscreen
{
	layer = 1;
	bmap = splash_map;
	flags = refresh;
}

bmap fondmap = <myscreen.pcx>;

panel mydebpanel
{
	layer = 1;
	bmap = fondmap;
	flags = refresh;
}

bmap fondmap2 = <myscreen2.pcx>;

panel myendpanel
{
	layer = 1;
	bmap = fondmap2;
	flags = refresh;
}


bmap logoavi = <lganideb2.bmp>;  
var vary = 0;
sound logo_s = <xpln.wav>;
panel logoaviscreen
{
	layer = 2;
	window = 0,0,640,480,logoavi,0,vary;
	flags = overlay,refresh;
}


bmap logoavi2 = <lganifin2.bmp>;
panel logoendscreen
{
	layer = 3;
	window = 0,0,640,480,logoavi2,0,vary;
	flags = overlay,refresh;
}


/////////////////////////////////////////////////////////////////
// Strings and filenames

string level_str = <level2.WMB>; // give file names in angular brackets

string player_mdl = <ship.mdl>;
// function prototypes
function player_client();

string bullet_mdl = <bullet.mdl>;
string missile_l_mdl = <missle_l.mdl>;
string missile_r_mdl = <missle_r.mdl>;

var num_client = 1;
var bullet[3];
var bullet_speed[3] 40, 0,0;

var rocket_pos[3];
var rock_pan[3];
var v_smoke;
var rocket_speed[3] 10, 0,0;
var rocket_l[5] = 4,2,2,2,2;//le premier chiffre est le compteur, les autres valent 2 pour afficher la rocket et 0 pour ne rien afficher
var rocket_r[5] = 4,2,2,2,2;//on les retrouve en skill 37,38,39,40,41,42,43 et 44
var indice;


SOUND shotgun_s = <gunfire.wav>;
SOUND riccochet= <ricc.wav>;
SOUND explo = <explosin.wav>;
SOUND explo_miss_s= <explo_miss.wav>;
SOUND launch = <missle.wav>;


BMAP smoke_m = <smoke.pcx>;
BMAP eclat_m = <eclat.pcx>;
BMAP particle_m = <particle.pcx>;

entity* player1;
entity* player2;
entity* player3;
entity* player4;
entity* player_for_action;
bmap* particle_map = smoke_m;

define health,skill48;
define ammo,skill47;
define rocket_left, skill45;
define rocket_right, skill46;
var player_connected; //binary 1,2,4,8 for player 1,2,3,4
var player_connected1;
var player_connected2;
var player_connected3;
var player_connected4;

//panel
FONT panel_font, <bauhau20.bmp>, 18, 30;
FONT icone_font, <icone20.bmp>, 18, 30;
PANEL display_panel {
	LAYER		3;
	POS_X		0;
	DIGITS	5,0,1,icone_font,1,player_connected1;
	DIGITS	25,0,1,icone_font,1,player_connected2;
	DIGITS	45,0,1,icone_font,1,player_connected3;
	DIGITS	65,0,1,icone_font,1,player_connected4;

	DIGITS	130,0,1,icone_font,1,3;
	DIGITS	150,0,3,panel_font,1,player.health;
	DIGITS	230,0,1,icone_font,1,1;
	DIGITS	250,0,4,panel_font,1,player.ammo;
	DIGITS	400,0,1,icone_font,1,player.skill37;
	DIGITS	430,0,1,icone_font,1,player.skill38;
	DIGITS	460,0,1,icone_font,1,player.skill39;
	DIGITS	490,0,1,icone_font,1,player.skill40;
	DIGITS	600,0,1,icone_font,1,player.skill41;
	DIGITS	630,0,1,icone_font,1,player.skill42;
	DIGITS	660,0,1,icone_font,1,player.skill43;
	DIGITS	690,0,1,icone_font,1,player.skill44;

	FLAGS	= REFRESH,D3D;
}

////////////////////////////////////////////////////////////////////////////
// The following script controls the sky movement
bmap horizon_map = <horizon.pcx>;
// A backdrop texture's horizontal size must be a power of 2;
// the vertical size does not matter

function init_environment()
{
	scene_map = horizon_map;	// horizon backdrop overlay
	scene_nofilter = on;

	sky_speed.x = 1;
	sky_speed.y = 1.5;
	cloud_speed.x = 3;
	cloud_speed.y = 4.5;

	sky_scale = 0.5;
	sky_curve = 1;  			// 'steepness' of sky dome

	scene_field = 60;  		// repeat map 6 times
	scene_angle.tilt = -10; // lower edge of scene_map 10 units below horizon

	sky_clip = scene_angle.tilt;	// clip the sky at bottom of scene_map
}

/////////////////////////////////////////////////////////////////
// The main() function is started at game start
function main()
{
// set some common flags and variables
//	warn_level = 2;	// announce bad texture sizes and bad wdl code
	tex_share = on;	// map entities share their textures

//	play_logo /////////////////////////////////////////
	vary = 0;
	splashscreen.pos_x = (screen_size.x - bmap_width(splash_map))/2;
	splashscreen.pos_y = (screen_size.y - bmap_height(splash_map))/2;
	mydebpanel.pos_x = (screen_size.x - bmap_width(fondmap))/2;
	mydebpanel.pos_y = (screen_size.y - bmap_height(fondmap))/2;
	myendpanel.pos_x = (screen_size.x - bmap_width(fondmap2))/2;
	myendpanel.pos_y = (screen_size.y - bmap_height(fondmap2))/2;
	logoaviscreen.pos_x = (screen_size.x - bmap_width(splash_map))/2;
	logoaviscreen.pos_y = (screen_size.y - bmap_height(splash_map))/2;
	logoendscreen.pos_x = (screen_size.x - bmap_width(splash_map))/2;
	logoendscreen.pos_y = (screen_size.y - bmap_height(splash_map))/2;

	splashscreen.visible = off;
	mydebpanel.visible = on;
	while(key_any == 0){wait 1;}
	wait 10;
	play_sound(logo_s,100);
	logoaviscreen.visible = on;
//	while(key_any == 0){wait 1;}
	//wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait (3);
	
	while (vary < 6200)
	{
	//while(key_any == 0){wait 1;}
		waitt(2.5);
		vary += 480;
	}


// wait the required second, then switch the splashscreen off.
  	logoaviscreen.visible = off;
	mydebpanel.visible = off;
	splashscreen.visible = on;
	waitt(16);
	//bmap_purge(logoavi);	// remove splashscreen from video memory

//****************** the end
	splashscreen.visible = off;
	myendpanel.visible = on;
	vary = 0;
	logoendscreen.visible = on;

	while (vary < 6200)
	{
		//while(key_any == 0){wait 1;}
		waitt(2.5);
		vary += 480;
	}
	

// init the 'environment' (sky & sceen map)
	init_environment();
// now load the level
	level_load(level_str);
// freeze the game
	freeze_mode = 1;

// wait the required second, then switch the splashscreen off.
	waitt(16);
	logoendscreen.visible = off;
	myendpanel.visible = off;
  	splashscreen.visible = off;
	bmap_purge(splash_map);	// remove splashscreen from video memory


// load some global variables, like sound volume
	load_status();


// un-freeze the game
	freeze_mode = 0;

// create the player entity on the client
ifdef CLIENT;
	client_move();	// enable multiuser mode

// wait until the level is loaded, and the connection is established
	while (connection == 0) { wait(1); }
	player = ent_create(player_mdl,nullvector,player_client);
endif;
while (player.health == null){wait(1);}
send_rocket_empty_l();
send_rocket_empty_r();
display_panel.pos_y = screen_size.y -50;
display_panel.visible = on;
wait_end();
}

function wait_end
{
	while(1)
	{
		player_connected1 = 5+(player_connected & 1);//6
		player_connected2 = 5+(player_connected & 2);//7
		player_connected3 = 5+(3*((player_connected & 4)==4));//8
		player_connected4 = 5+(4*((player_connected & 8)==8));//9


		if (player)
		{
			if (player.health ==0) //on est mort
			{
				rocket_r =0;
				rocket_l = 0;
				send_rocket_empty_l();
				send_rocket_empty_r();
				wait(1);
				remove(player);
			}
		}
		wait (1);
	}

}
// helper function: sets the vector to random direction and length
function vec_randomize(&vec,range)
{
	vec[0] = random(1) - 0.5;
	vec[1] = random(1) - 0.5;
	vec[2] = random(1) - 0.5;
	vec_normalize(vec,random(range));
}

// helper function: fades out a particle
function part_alphafade()
{
	my.alpha -= time+time;
	if (my.alpha <= 0) { my.lifespan = 0; }
}

// particle function: generates a fading explosion into vel direction
function effect_explo()
{
	vec_randomize(temp,10);
	vec_add(my.vel_x,temp);
	my.alpha = 25 + random(25);
	my.bmap = scatter_map;
	my.flare = on;
	my.bright = on;
	my.beam = on;
	my.move = on;
	my.function = part_alphafade; // change to a shorter, faster function
}


function player_client()
{
	my.skin = num_client;
	
	if (my.skin==1){my.X = 1000;my.Y = -1000;my.z = 20;}
	if (my.skin==2){my.X = -1000;my.Y = 1000;my.z = 20;}
	if (my.skin==3){my.X = 1000;my.Y = 1000;my.z = 20;}
	if (my.skin==4){my.X = -1000;my.Y = -1000;my.z = 20;}

	if (my.skin ==1){player_connected |= 1;player1 = my;while (player1 == null){wait(1);}}
	if (my.skin ==2){ player_connected |= 2;player2 = my;while (player2 == null){wait(1);}}
	if (my.skin ==3){player_connected |= 4;player3 = my;while (player3 == null){wait(1);}}
	if (my.skin ==4){player_connected |= 8;player4 = my;while (player4 == null){wait(1);}}
	num_client += 1;
	if (num_client > 5){wait(1);remove (me);return;}
	MY.ENABLE_DISCONNECT = Off;
	MY.EVENT = _actor_connect;
	my.health = 100;
	my.ammo = 9999;

	player_drive();
	send_var (player_connected);
	send_variable();
	if (MY.shadow == OFF) { drop_shadow(); }
}

function send_variable
{
	while(1)
	{
		if (player1)
		{
			v_smoke = (100-player1.health)/10;
			player1._force = 0.5+(player1.health/100);
			emit v_smoke,player1.pos,particle_smoke;
			send (player1._force);
			send (player1.health);
			send (player1.skin);
			send (player1.ammo);

			if (player1.health <= 0)
			{
				player1.health = 0;
				//player1.rocket_left = 2;//commentaire  enlever pour que la roquette parte  la mort du vaisseau
				//player1.rocket_right = 2;
				//send_vec (player1.rocket_left);
				                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     