///////////////////////////////////////////////////////////////////////////////////
// A5 main wdl
////////////////////////////////////////////////////////////////////////////
// Files to over-ride:
// * logodark.bmp - the engine logo, include your game title
// * horizon.pcx - A horizon map displayed over the sky and cloud maps
////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
path "..\\template";	// Path to WDL templates subdirectory

////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions
include <movement.wdl>;
include <messages.wdl>;
include <menu.wdl>;		// must be inserted before doors and weapons
include <particle.wdl>; // remove when you need no particles
include <doors.wdl>;		// remove when you need no doors
include <actors.wdl>;   // remove when you need no actors
include <weapons.wdl>;  // remove when you need no weapons
include <war.wdl>;      // remove when you need no fighting
//include <venture.wdl>;	// include when doing an adventure
include <lflare.wdl>;   // remove when you need no lens flares

////////////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the follwing vars.
var video_mode = 6;	 // screen size 640x480
var video_depth = 16; // 16 bit colour D3D mode

/////////////////////////////////////////////////////////////////
// Strings and filenames

string level_str = <level1.WMB>; // give file names in angular brackets

resource "model.wrs";

string caracter0_mdl = "security.mdl";
string caracter1_mdl = "kronos.mdl";
string caracter2_mdl = "cwarrior.mdl";
string caracter3_mdl = "trooper.mdl";
// function prototypes
function player_client();


///////////////////////////////////////////////////////////////
//our skills
var all_ready = 0;
define health,skill48;
define armor,skill47;


///////////////////////////////////////////////////////////////
// define panles
bmap fond_map , <fond.pcx>;
bmap choix_map , <choix.pcx>;
bmap caracter_map , <caracter.pcx>;
bmap hand_map, <hand_mouse.pcx>;

bmap bgon,<bgon.pcx>;
bmap bdon,<bdon.pcx>;
bmap bgov,<bgov.pcx>;
bmap bdov,<bdov.pcx>;
bmap bgof,<bgof.pcx>;
bmap bdof,<bdof.pcx>;
bmap bhon,<bhon.pcx>;
bmap bbon,<bbon.pcx>;
bmap bhof,<bhof.pcx>;
bmap bhov,<bhov.pcx>;
bmap bbof,<bbof.pcx>;
bmap bbov,<bbov.pcx>;
bmap tout,<toutcouleur.pcx>;
bmap val_on,<val_on.pcx>;
bmap val_of,<val_of.pcx>;

var offset_color = 0;
var offset_player = 0;
var offset_caracter = 0;
var choice_player = 0;
var choice_color = 0;
panel fond_pan 
{
	pos_x = 0;pos_y = 0;
     	layer = 1;
	bmap fond_map;
	window = 310,175,300,210,caracter_map,0,offset_caracter;
//valid your choice
	button = 328,406,val_on,val_of,val_of,f_all_ready,null,null;
	mouse_map = hand_map;
     	flags = d3d,refresh;
}
panel choix_pan 
{
	pos_x = 150;pos_y = 170;
     	layer = 2;
	bmap choix_map;
	mouse_map = hand_map;
     	flags = d3d,overlay,refresh;
	window = 32,49,80,140,tout,offset_color,offset_player;
//choice player
	button = -62,71,bhon,bhof,bhov,minus_player,null,null;//x = 23,y 69
	button = -62,132,bbon,bbof,bbov,plus_player,null,null;//x=23,y = 130
//choice color
	button = 0,192,bgon,bgof,bgov,minus_color,null,null;
	button = 73,192,bdon,bdof,bdov,plus_color,null,test;
}
var vary = 0;
bmap les_six_map,<les_six.pcx>;
panel les_six_pan 
{
	pos_x = 190;pos_y = 160;
     	layer = 2;
	window = 0,0,280,140,les_six_map,0,vary;
      	flags = overlay,refresh;
}


/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo
bmap splashmap = <logodark.bmp>; // the default logo in templates
panel splashscreen {
	bmap = splashmap;
	flags = refresh,d3d;
}

////////////////////////////////////////////////////////////////////////////
// The following script controls the sky movement
bmap horizon_map = <horizon.pcx>;
// A backdrop texture's horizontal size must be a power of 2;
// the vertical size does not matter

function init_environment()
{
	scene_map = horizon_map;	// horizon backdrop overlay
	scene_nofilter = on;

	sky_speed.x = 1;
	sky_speed.y = 1.5;
	cloud_speed.x = 3;
	cloud_speed.y = 4.5;

	sky_scale = 0.5;
	sky_curve = 1;  			// 'steepness' on sky dome

	scene_field = 60;  		// repeat map 6 times
	scene_angle.tilt = -10; // lower edge on scene_map 10 units below horizon

	sky_clip = scene_angle.tilt;	// clip the sky at bottom on scene_map
}

/////////////////////////////////////////////////////////////////
// The main() function is started at game start
function main()
{
// animation adaption
	anim_walk_dist = 2; // for the new guards
	anim_run_dist = 3;
	walk_or_run = 8;
	camera_dist.z = -50;

// set some common flags and variables
//	warn_level = 2;	// announce bad texture sizes and bad wdl code
	tex_share = on;	// map entities share their textures

// center the splash screen for non-640x480 resolutions, and display it
	splashscreen.pos_x = (screen_size.x - bmap_width(splashmap))/2;
	splashscreen.pos_y = (screen_size.y - bmap_height(splashmap))/2;
	splashscreen.visible = on;
// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);

// init the 'environment' (sky & sceen map)
	init_environment();
// now load the level
	level_load(level_str);
// freeze the game
	freeze_mode = 1;

// wait the required second, then switch the splashscreen off.
	waitt(16);
  	splashscreen.visible = off;
	bmap_purge(splashmap);	// remove splashscreen from video memory

// load some global variables, like sound volume
	load_status();
	choice();
	while (all_ready ==0){wait(1);}
// un-freeze the game
	freeze_mode = 0;

// create the player entity of the client
ifdef CLIENT;
	client_move();	// enable multiuser mode

// wait until the level is loaded, and the connection is established
	while (connection == 0) { wait(1); }

// create a client entity at a random place
//j'en profite pour envoyer 3 variables du joueur que sont health, armor et skin
	temp.X = choice_color+1;//skin choisie
	//temp.Y = 0;
	//temp.Z = 50;
	if (choice_player == 0){temp.y=90;temp.z = 110;player = ent_create(caracter0_mdl,temp,player_client);}
	if (choice_player == 1){temp.y=70;temp.z = 150;player = ent_create(caracter1_mdl,temp,player_client);}
	if (choice_player == 2){temp.y=80;temp.z = 120;player = ent_create(caracter2_mdl,temp,player_client);}
	if (choice_player == 3){temp.y=100;temp.z = 100;player = ent_create(caracter3_mdl,temp,player_client);}
//attention ici le programme continue alors que le joueur n'est pas compltement cr donc player.skin inefficace !!!


// the following flags are required for the camera
	player._MOVEMODE = _MODE_WALKING;
	player.__BOB = on;

endif;
}

function choice()
{
	fond_pan.visible = on;
	choix_pan.visible = on;
	mouse_mode = 2;
	mouse_on();
	enable_mouse = on;
}


function plus_player
{
	choice_player +=1;
	if (choice_player == 4){choice_player = 0;}
	offset_player = 140*choice_player;
	offset_caracter = 210*choice_player;
}
function minus_player
{
	choice_player -=1;
	if (choice_player <0){choice_player = 3;}
	offset_player = 140*choice_player;
	offset_caracter = 210*choice_player;
}
function plus_color
{
	choice_color +=1;
	if (choice_color == 7){choice_color = 0;}
	offset_color = 80*choice_color;
}



function minus_color
{
	choice_color -=1;
	if (choice_color <0){choice_color = 6;}
	offset_color = 80*choice_color;
}

function test
{
while (1){
if (mouse_right==1){plus_color();}
wait (10);}
}

function f_all_ready
{
	fond_pan.visible = off;
	choix_pan.visible = off;
	mouse_mode = 0;
	mouse_off();
	enable_mouse = off;
	all_ready = 1;
}
function player_client()
{
	my.skin = my.x;
	my.health = my.y;
	my.armor = my.z;
	my.x = 0+60+sys_seconds;my.y = 0;my.z = 50;
	MY.FAT = OFF;
	MY.NARROW = ON;		// set narrow hull
	MY._WALKFRAMES = 1;	// enable frame name animation
	MY._FORCE = 0.5;		// He should be not too fast
	MY._MOVEMODE = _MODE_WALKING;
	MY._BANKING = -0.1;
	MY.__JUMP = ON;
	MY.__DUCK = ON;
	MY.__STRAFE = ON;
	MY.__BOB = ON;
	MY.__TRIGGER = ON;
	while (my == null){wait(1);}
	MY.ENABLE_DISCONNECT = ON;
	MY.EVENT = _actor_connect;

	player_move();
	if (MY.shadow == OFF) { drop_shadow(); }
}

function f_quit
{
	exit;
}

on_f10 f_quit;
on_mouse_right null;

