////////////////////////////////////////////////////////////////////////////
// GameStudio main script
////////////////////////////////////////////////////////////////////////////

// Test level for Snake67's Volumetric Muzzle Flash

////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
path = "c:\\programme\\gstudio6\\template";	// Path to WDL templates subdirectory

////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions

include <movement.wdl>;
include <messages.wdl>;
include <menu.wdl>;		// must be inserted before doors and weapons
include <particle.wdl>; // remove when you need no particles
include <doors.wdl>;		// remove when you need no doors
include <actors.wdl>;   // remove when you need no actors
include <muzzle.wdl>;
include <weapons01.wdl>;  // remove when you need no weapons
include <war.wdl>;      // remove when you need no fighting
//include <venture.wdl>;	// include when doing an adventure
//include <lflare.wdl>;   // remove when you need no lens flares

////////////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the follwing vars.

var video_mode = 8;	 // screen size 1024x768
var video_depth = 32; // 32 bit colour D3D mode

/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo

bmap splashmap = <logodark.pcx>; // the default logo in templates

panel splashscreen {
	bmap = splashmap;
	pos_x=0;
	pos_y=0;
	flags = refresh,d3d;
}

/////////////////////////////////////////////////////////////////
//	Sky System

sky sky_back
{
	type=<sky_back.tga>;
	layer=1;
	red=100;
	green=100;
	blue=100;
	speed_u=6;
	speed_v=-8;
	scale_x=2;
	scale_y=2;
	flags=dome, visible;
}

sky sky_clouds
{
	type=<sky_clouds.tga>;
	layer=3;
	red=100;
	green=100;
	blue=100;
	speed_u=8;
	speed_v=12;
	scale_x=2;
	scale_y=2;
	alpha=70;
	flags=dome, visible, transparent;
}

/////////////////////////////////////////////////////////////////
// The main() function is started at game start

function main()
{
	tex_share = on;	// map entities share their textures
	
// scale the splash screen for non-800x600 resolutions, and display it
	splashscreen.scale_x=1.28;
	splashscreen.scale_y=1.28;
	splashscreen.visible=on;

// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);

// now load the level
	level_load("test.wmb");

// freeze the game
	freeze_mode=1;

// wait the required second, then switch the splashscreen off.
	sleep(1);
  	splashscreen.visible=off;
	bmap_purge(splashmap);	// remove splashscreen from video memory

// load some global variables, like sound volume
	load_status();

// use the new 3rd person camera
	move_view_cap=1;

// un-freeze the game
	freeze_mode=0;

//	client_move();	// for a possible multiplayer game
// call further functions here...
}

/////////////////////////////////////////////////////////////////
// Sample Weapon with Volumetric Muzzle Flash

action weap_muz_mg
{
	MY.__ROTATE=ON;				// gun rotates before being picked up
	MY.__REPEAT=ON;				// repeats (Auto-fire)
	MY.__BOB=ON;					// 'bobs' when the player moves
	MY._OFFS_X=20;					// x,y,z pos of the gun
	MY._OFFS_Y=6;
	MY._OFFS_Z=10;
	MY._AMMOTYPE=1.99;			// type of ammo '.' rounds in gun
	
	MY._WEAPONNUMBER=2;  		// weapon number (press to equip)
	MY._BULLETSPEED=1000.01;	// bulletspeed '.' recoil
	MY._FIRETIME=2;				// time to cycle (reload)
	
	MY._FIREMODE=DAMAGE_SHOOT+HIT_HOLE+0.20;
	gun();
	my._muzzle_handle=handle(ent_create("muzzle_0.mdl", nullvector, init_muzzle));
	my._muzzle_vert=3;			// hier die Zahl eingeben, die MED anzeigt!
	vec_for_vertex(my._GUN_SOURCE_X, me, my._muzzle_vert);
	vec_sub(my._GUN_SOURCE_X, my.x);
}

/////////////////////////////////////////////////////////////////

function quit()
{
	exit;
}

on_esc=quit;
on_f10=quit;

/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.

WINDOW WINSTART
{
	TITLE			"3D GameStudio";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}

/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FONT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/

/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;