/////////////////////////////////////////////////
// File: pfx.wdl
// WDL code fire, smoke, rain and spell - effects
/////////////////////////////////////////////////

/***************
* Smoke effect *
***************/

bmap smoke_parmap=<smoke.pcx>;

function smoke_effect();	// prototype
function smoke_property();	// prototype

function smoke_effect() {
	my.vel_x=0;
	my.vel_y=0;
	my.vel_z=random(3);
	my.move=on;
	my.size=15;
	my.bmap=smoke_parmap;
	my.flare=on;
	my.alpha=10;
	my.function=smoke_property;
}

function smoke_property() {
	my.alpha-=0.1*time;
	if (my.alpha<=0) {
		my.lifespan=0;
	}
}

action smoke {
	while (1) {
		temp.x=my.x+random(32)-16;
		temp.y=my.y+random(32)-16;
		temp.z=my.z;
		effect(smoke_effect,5*time,temp,temp);
		wait 1;
	}
}

/**************
* Fire effect *
**************/

bmap fire_parmap=<fire.pcx>;

function fire_effect();
function fire_property();


function fire_effect() {
	my.x+=random (30*(sin(total_ticks*200) * cos(total_ticks*50)));

	my.y+=random (30*(sin(total_ticks*200) * sin(total_ticks*50)));

	my.size=15;
	my.vel_x=0;
	my.vel_y=0;
	my.vel_z=2+random(2);
	my.move=on;
	my.bmap=fire_parmap;
	my.flare=on;
	my.bright=on;
	my.alpha=25;
	my.function=fire_property;
}

function fire_property() {
	my.alpha-=1*time;
	if (my.alpha<=0) {
		my.lifespan=0;
	}
}

action fire {
	While (1) {
		temp.x=my.x;
		temp.y=my.y;
		temp.z=my.z;
		effect(fire_effect,20*time,temp,temp);
		Wait 1;
	}
}

/**************
* Rain effect *
**************/

bmap rain_parmap=<rain.pcx>;

function rain_effect();
function rain_property();

var raining=0;

function rain_effect() {
	my.vel_z=(-12.5-random(5));
	my.x=camera.x+random(1500)-750;
	my.y=camera.y+random(1500)-750;
	my.skill_x=my.x;
	my.skill_y=my.y;
	my.skill_z=player.z+player.min_z;
	my.skill_x=my.x;
	my.skill_y=my.y;
	my.skill_z=player.z+player.min_z;
	my.z=camera.z+500;
	my.move=on;
	my.x-=33*my.vel_x;
	my.y-=33*my.vel_y;
	trace_mode = ignore_me;
	trace(my.x,my.skill_x);
	my.skill_z=target.z;
	my.bmap=rain_parmap;
	my.flare=on;
	my.function=rain_property;
}

function rain_property() {
	if (my.z<=my.skill_z) {
		my.lifespan=0;
	}
}

function rain(vel_x,vel_y,intensity) {
	if (intensity==0) {intensity=20;}
	if (raining==1) {
		raining=0;
	} else {
		raining=1;
	}
	while (raining==1) {
		temp.x=vel_x;
		temp.y=vel_y;
		effect(rain_effect, intensity*time, temp, temp);
		wait 1;
	}
}

/***************
* Spell effect *
***************/

var spell_angle=0;
var spell_radius=0;
var spell_time=0;
var spell_existing=0;

bmap spell_parmap=<spell.pcx>;

function spell_effect();
function spell_property();

function spell_effect() {
	my.size=10;
	my.vel_x=0;
	my.vel_y=0;
	my.vel_z=0;
	my.move=on;
	my.bmap=spell_parmap;
	my.flare=on;
	my.bright=on;
	my.alpha=25;
	my.function=spell_property;
}

function spell_property() {
	my.alpha-=1*time;
	if (my.alpha<=0) {
		my.lifespan=0;
	}
	my.gravity=2;
}

function spell() {
	if (spell_existing==0) {
		spell_existing=1;
		spell_time=0;
		spell_angle=0;
		spell_radius=0;
		spell_angle=player.pan;
		while (spell_time<50) {
			temp.x=player.x;
			temp.y=player.y;
			temp.z=player.z;
			temp.x+=sin(90 - spell_angle) * cos (min(360,spell_time*2+270))*500;
			temp.y+=cos(90 - spell_angle) * cos (min(360,spell_time*2+270))*500;
			temp.z+=sin (min (360, spell_time * 2+270))*500+500;
			effect(spell_effect,1*time,temp, temp);
			temp.x+=sin(- spell_angle) * cos(spell_time*50)*spell_radius;
			temp.y+=cos (- spell_angle) * cos(spell_time*50)*spell_radius;

			temp.z+=cos(- spell_time * 2) * sin(spell_time*50)*spell_radius;
			temp.x+=sin(90-spell_angle)*sin(-spell_time*2)*sin(spell_time*50)*spell_radius;
			temp.y+=cos(90-spell_angle)*sin(-spell_time*2)*sin(spell_time*50)*spell_radius;
			effect(spell_effect,1*time, temp, temp);
			spell_radius+=1*time;
			spell_time+=time;
			wait 1;
		}
		rain(0,0,0);
		spell_existing=0;
	}
}