///////////////////////////////
#include <acknex.h>
#include <default.c>
#include <mtlFX.c>
#include <ackphysx.h>
///////////////////////////////

#define PRAGMA_PATH "3dmodels"
#define PRAGMA_PATH "graphics"
#define PRAGMA_PATH "scripts"
#define PRAGMA_PATH "sounds"


PANEL* hud_pan =
{
 	bmap = "hud.png";
 	flags = SHOW | OVERLAY; 			
}




function sprite_played()
{
	set (my, PASSABLE |TRANSLUCENT);
	my.scale_x = 0.5; 
	my.scale_y = my.scale_x; 
	my.ambient = 100;
	my.roll = random(360); 
	my.alpha = 100; 
	while (my.frame < 16) 
	{	
		my.frame += 1 * time_step; 
		wait (1);
	}
	while (my.alpha > 0) 
	{
		my.alpha -= 4 * time_step; 
		wait (1);
	}
	ent_remove (me);
}


SOUND* glass_snd = "glass.wav";


function main()
{
	physX_open();
	pX_setccd(1);
	
	video_set(1024,768,0,0);
	level_load("explo.WMB");
	random_seed( 0 );
}


ENTITY* shard;

function create_shard()
{
	set(my,BRIGHT | TRANSLUCENT | SHADOW);

	pXent_settype(my, PH_RIGID, PH_SPHERE); // this entity behaves like a box
	pXent_addforcecentral ( my, vector(sign(random(2)-1)*random(100),sign(random(2)-1)*random(100),0));
	pXent_setfriction (shard,50); // set the friction on the ground
	pXent_setdamping (shard,200,200); // set the damping
	pXent_setelasticity (shard,3); // set the elasticity
	wait(-3);
	ent_remove(me);
}



action pyra_explode()
{
	set(my,TRANSLUCENT);
	my.alpha = 50;
	while(1)
	{
		wait(-10);
		snd_play (glass_snd, 100, 0);
		set(my,INVISIBLE);
		ent_create("explo2+16.tga", vector(my.x,my.y,my.z+50), sprite_played);
		ent_create("shard1.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard2.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard3.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard4.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard1.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard2.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard3.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard4.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard3.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard1.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard1.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard2.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard3.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard4.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard1.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard2.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard3.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard4.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard3.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard1.mdl",vector(my.x,my.y,my.z+100),create_shard);
		wait(-3);
		reset(my,INVISIBLE);
		wait(1);
	}
}


action pyra_explode2()
{
	set(my,TRANSLUCENT);
	my.alpha = 50;
	while(1)
	{
		wait(-3);
		snd_play (glass_snd, 100, 0);
		set(my,INVISIBLE);
		ent_create("explo2+16.tga", vector(my.x,my.y,my.z+50), sprite_played);
		ent_create("shard1.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard2.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard3.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard4.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard1.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard2.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard3.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard4.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard3.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard1.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard1.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard2.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard3.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard4.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard1.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard2.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard3.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard4.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard3.mdl",vector(my.x,my.y,my.z+100),create_shard);
		ent_create("shard1.mdl",vector(my.x,my.y,my.z+100),create_shard);
		wait(-3);
		reset(my,INVISIBLE);
		wait(1);
	}
}