

#define PRAGMA_PATH "3Dmodels"
#define PRAGMA_PATH "Graphics"
#define PRAGMA_PATH "Sounds"

SOUND* point_snd = "point.wav";
SOUND* appear_snd = "appear.wav";
SOUND* enemy_snd = "enemy.wav";
SOUND* start_snd = "start.wav";
SOUND* bhole_snd = "bhole.wav";
SOUND* gameover_snd = "gameover.wav";

function sprite_played()
{

	set (my, PASSABLE |TRANSLUCENT);
	my.scale_x = 0.5; 
	my.scale_y = my.scale_x; 
	my.ambient = 100;
	my.roll = random(360); 
	my.alpha = 100; 
	while (my.frame < 8) 
	{	
		my.frame += 1 * time_step; 
		wait (1);
	}
	while (my.alpha > 0) 
	{
		my.alpha -= 4 * time_step; 
		wait (1);
	}
	
	ent_remove (me);
}



FONT* arial_font = "DooM#18b"; // truetype font, 20 point bold 
// empty string:
STRING* texttest = "";

// text to be displayed:
TEXT* mytext = {
	// set the string:
	string = texttest;
	blue =255;
	green =255;
	red = 255;
	layer = 2; 
	font = arial_font;
	// set flags:
	flags = SHOW;
}

function scrolling_txt()
{


	var fhandle1 = file_open_read("my.txt");
	
	file_str_read(fhandle1, texttest);

	file_close(fhandle1);

	mytext.pos_x = screen_size.x + 5;

	wait(1);
	// get the width of the string:
	var width = str_width(texttest, NULL);
	// loop:
	while(1){
		
		if(mytext.pos_x < -width-1500){
			// set it back to the upper right corner:
			mytext.pos_x = screen_size.x + 500;
		}
		// scroll text to the left:
		mytext.pos_x -= 10 * time_step;
		// place text at the far right corner:
		mytext.pos_y = screen_size.y - 20;
		// wait one frame:
		wait(1);
	}	
}



ENTITY* spawner;

action blackhole();
action light_follows_path();

BMAP* effect_tga = "spark.tga";
function my_effect(PARTICLE *p)
{
	p.lifespan = 10; // kill the particle right after its creation
	p.alpha = 10;
	p.bmap = effect_tga;
	p.size = 10;
	p.flags |= (MOVE | BRIGHT);
	p.event = NULL;
}


var soundtrack_handle;

var score = 0;



ENTITY* sky = 
{
	type = "spacecube1+6.bmp"; 
	flags2 = SKY | CUBE | SHOW;

	

}

PANEL* title_pan =

{
	bmap = "title.bmp";
	pos_x = 0;
	pos_y = 0;
	layer = 20;
}

PANEL* black_pan =

{

	bmap = "black.bmp";
	pos_x = 0;
	pos_y = 0;
	layer = 20;
}

var highscore;

FONT*	fnt2_pan = "Ariel#18b"; 
PANEL* pan_highscore = {digits=850,5,"Highscore: %00.0f",fnt2_pan,1,highscore; 
	layer = 1;
	flags = SHOW;
}


FONT*	fnt1_pan = "Ariel#22b"; 
PANEL* pan_score = {digits=10,5,"Score: %00.0f",fnt1_pan,1,score; 
	layer = 1;
	flags = SHOW;
}

var enemies = 0;

FONT*	fnt1_pan = "Ariel#22b"; 
PANEL* pan_enemies = {digits=10,50,"Enemies: %00.0f",fnt1_pan,1,enemies; 
	layer = 1;
	flags = SHOW;
}



var game_enable =0;



BMAP* gameover_map = "gameover.png"; 

PANEL* gameover_pan =
{
	bmap = gameover_map; 
	pos_x = 0;
	pos_y = 0;
	layer = 1;

}

BMAP* start_map = "start.png"; 

PANEL* start_pan =
{
	bmap = start_map; 
	pos_x = 0;
	pos_y = 0;
	layer = 1;

}

function taking_off()
{
	
	my.pan = 180;
	my.tilt = 90;
	set(my,PASSABLE | TRANSLUCENT);
	my.alpha =100;
	wait(-0.2);
	while(1)
	{
		my.y -=10*time_step;
		my.alpha -=1*time_step;
		wait(1);
		if(my.alpha <=0){
			ent_remove(me);
			break;
		}
	}
}


function random_pointsplacement();

action enemy_spawner();
action player_movement();

function begin_game()
{

	if(game_enable ==0){
		enemies =0;
		snd_play(start_snd,50,0);
		reset(start_pan,SHOW);
		reset(gameover_pan,SHOW);
		score =0;
		level_load("SG.WMB");
		ent_create("player.mdl", vector(-0,-0,10), player_movement);
		ent_create("spawner.mdl", vector(-216,-223,7), enemy_spawner);
		
		game_enable =2;
		random_pointsplacement();
		
	}
}

////////////////////////////////hscorestuff/////////////////////////

#define HIGH_SCORE_SAVE_FILE "hs.score"

TEXT* input_file = { strings = 1; } // used to load saved information, only one string needed

void load_highscore()
{
	txt_load(input_file, HIGH_SCORE_SAVE_FILE);
	wait(1); // wait one frame to load the text file - important!
	
	highscore = str_to_float( (input_file.pstring)[0] ); // (<text>.pstring) [ line, beginning with 0! ] -> convert to float
}

void save_highscore()
{
	var file_handle = file_open_write(HIGH_SCORE_SAVE_FILE);
	wait(1); // wait to open the file?? - not sure if this is needed
	
	file_str_write(file_handle, str_for_float(NULL, (double)highscore)); // convert the highscore to a string -> write into file
	file_close(file_handle);
}
////////////////////////////////////////////////////////////////////////////


action pickup_points();

function main()
{
	video_set(1024,768,32,0);
	soundtrack_handle = media_loop("ingame.mp3",NULL,60);
	set(title_pan,SHOW);
	set(black_pan,SHOW | TRANSLUCENT);

	black_pan.alpha = 100;
	wait(-3);

	while(black_pan.alpha > 0)
	{
		black_pan.alpha = maxv(black_pan.alpha - 20 * time_step,0);
		wait(1);
	}
	wait(-2);
	
	level_load("SG.WMB");
	load_highscore();
	set(start_pan,SHOW);
	on_space = begin_game;
	random_seed(0);
	while(black_pan.alpha < 100) 
	{
		black_pan.alpha = minv(black_pan.alpha + 10 * time_step,100);
		wait(1);
	}
	reset(title_pan,SHOW);
	wait(-1);
	while(black_pan.alpha > 0)
	{
		black_pan.alpha = maxv(black_pan.alpha - 20 * time_step,0);
		wait(1);
	}
	scrolling_txt();
	reset(black_pan,SHOW);
}



function random_pointsplacement()
{
	var pointsplace = 12;
	pointsplace = integer(random(12));
	wait(-2);
	snd_play(appear_snd,50,0);
	if(pointsplace ==0){
		ent_create("points.mdl", vector(-210,92,7), pickup_points);
	}
	if(pointsplace ==1){
		ent_create("points.mdl", vector(-210,92,7), pickup_points);
	}
	if(pointsplace ==2){
		ent_create("points.mdl", vector(-76,153,7), pickup_points);
	}
	if(pointsplace ==3){
		ent_create("points.mdl", vector(-179,153,7), pickup_points);
	}
	if(pointsplace ==4){
		ent_create("points.mdl", vector(-179,12,7), pickup_points);
	}
	if(pointsplace ==5){
		ent_create("points.mdl", vector(-0,153,7), pickup_points);
	}
	if(pointsplace ==6){
		ent_create("points.mdl", vector(-0,90,7), pickup_points);
	}
	if(pointsplace ==7){
		ent_create("points.mdl", vector(-0,-212,7), pickup_points);
	}
	if(pointsplace ==8){
		ent_create("points.mdl", vector(215,-216,7), pickup_points);
	}
	if(pointsplace ==9){
		ent_create("points.mdl", vector(-187,-216,7), pickup_points);
	}
	if(pointsplace ==10){
		ent_create("points.mdl", vector(212,204,7), pickup_points);
	}
	if(pointsplace ==11){
		wait(-0.5);
		snd_play(bhole_snd,100,0);
		ent_create("blackhole.mdl", vector(spawner.x,spawner.y,spawner.z), blackhole);
	}
}



function playeris_hit()
{
	media_pause(soundtrack_handle);
		snd_play(gameover_snd,150,0);
	score = score + enemies*score;

	wait(1);


	set(my,INVISIBLE | PASSABLE);
	my.event = NULL;
	reset(my,SHADOW);
	set(gameover_pan,SHOW);
	set(start_pan,SHOW);
	wait(1);
	ent_remove(me);
	game_enable = 0;
	level_load("SG.WMB");
	wait(-3);
	media_start(soundtrack_handle);
	if(score >= highscore){
		
		highscore = score +0;
		save_highscore();


	}	

}

action player_movement()

{

	my.emask |= (ENABLE_IMPACT | ENABLE_ENTITY); // the object is sensitive to block and entity collisions
	my.event = playeris_hit;
	var run_percentage = 0;
	var stand_percentage = 0;
	set(my,SHADOW | METAL);
	c_setminmax(my);
	my.skill5 =0;
	player = me;
	while(1)
	{
		if(key_cul && my.pan != 90){ my.pan = 90; }
		if(key_cur && my.pan != 270){ my.pan = 270; }
		if(key_cuu && my.pan != 0){ my.pan = 0; }
		if(key_cud && my.pan != 180){ my.pan = 180; }
		result = c_move(me, nullvector, vector(10 * (key_cuu - key_cud) * time_step, 10 * (key_cul - key_cur) * time_step, 0), GLIDE | IGNORE_ME | IGNORE_PASSABLE);

		wait(1);
		if(score > highscore){
			if(my.skill5==0)
			ent_create("highscore.png", vector(my.x,my.y,my.z+40), taking_off);	
			my.skill5 =1;
		}
		if(score ==100){
			set(my,INVISIBLE | PASSABLE);
			reset(my,SHADOW);
			my.event = NULL;
			score +=50;
			ent_create("bigger.png", vector(my.x,my.y,my.z+40), taking_off);		
			ent_create("player2.mdl", vector(my.x,my.y,my.z), player_movement);
			wait(1);
			
			ent_remove(me);
			break;
			
		}
		if(score ==200){
			set(my,INVISIBLE | PASSABLE);
			reset(my,SHADOW);
			my.event = NULL;
			score +=50;
			ent_create("bigger.png", vector(my.x,my.y,my.z+40), taking_off);		
			ent_create("player3.mdl", vector(my.x,my.y,my.z), player_movement);
			ent_create("blindspot.mdl", vector(-632,194,56), light_follows_path);
			wait(1);
			ent_remove(me);
			break;
			
		}
		if(score ==400){
			set(my,INVISIBLE | PASSABLE);
			reset(my,SHADOW);
			my.event = NULL;
			score +=50;
			ent_create("bigger.png", vector(my.x,my.y,my.z+40), taking_off);		
			ent_create("player4.mdl", vector(my.x,my.y,my.z), player_movement);
			wait(1);
			ent_remove(me);
			break;
			
		}
	}
}

action pickup_points()
{
		ent_create("magic22+8.png", vector(my.x,my.y,my.z), sprite_played);
	c_setminmax(my);
	set(my,PASSABLE | METAL | SHADOW);
	while (!player) {wait (1);} // wait until the player is created
	while(vec_dist(my.x,player.x) >10)
	{
		
		my.pan +=5*time_step;
		wait(1);

		
	}



	snd_play(point_snd,50,0);
	ent_remove(me);
	score +=10;
	random_pointsplacement();
}


function bounce_off() // ball's event function
{
	vec_to_angle(my.pan, bounce); // change the direction as expected from a "real" ball
	my.pan += 5 - random(10); // add some randomness at each collision (don't allow the ball to get stuck)
	my.tilt = 0;
	if (you) // collided with another entity (maybe with our special wall)?
	{
		if (you.skill100 == 100) // if the entity is our special wall indeed
		{

			set(my,INVISIBLE | PASSABLE);
			my.event = NULL;

			wait(1);
			ent_remove(me);
			wait(1);
			enemies -=1;

		}
	}
}




action enemy() // attach this action to your ball
{
	my.emask |= (ENABLE_BLOCK | ENABLE_ENTITY); // the object is sensitive to block and entity collisions
	my.event = bounce_off;
	c_setminmax(my);
	set(my,METAL |SHADOW);
	my.pan += 5 - random(20);
	
	while(1)
	{

		c_move(me, vector(10 * time_step, 0, 0), nullvector,  IGNORE_PASSABLE | GLIDE | IGNORE_SPRITES);  // move ahead, in the direction given by the pan angle
		wait(1);
		if(game_enable ==0){
			
			ent_remove(me);
			break;
		}	
	}
}


action enemy_spawner()
{

	c_setminmax(my);
	set(my,SHADOW |METAL | PASSABLE );
	spawner = me;
	var waiting_timer = 100;
	while(1)
	{
		waiting_timer -=1*time_step;
		my.pan +=5*time_step;
		wait(1);
		if(waiting_timer <=0){
			snd_play(enemy_snd,50,0);
			ent_create("enemy.mdl", vector(my.x,my.y,my.z), enemy);
			enemies +=1;
			waiting_timer = 100;
			if(game_enable ==0){
				ent_remove(me);
				break;
			}	
		}
	}	
}


action my_teleport01()
{
	set(my, POLYGON | INVISIBLE); // use polygon-based collision detection
	wait(-0.8);

	VECTOR temp;
	while (!player) {wait (1);} // wait until the player model is loaded
	while (1)

	{
		my.pan +=20*time_step;
		
		vec_for_vertex(temp, my, 401); // generate particles from the 10th vertex of the entity
		effect(my_effect, 1, temp.x, nullvector);
		if (vec_dist(player.x, my.x) < 50) // trigger distance, play with 100

		{


			vec_set (player.x, vector (-200, -2, 10));
		}
		wait (1);
	}
}

action my_teleport02()
{
	set(my, POLYGON | INVISIBLE); // use polygon-based collision detection
	wait(-0.6);

	VECTOR temp;
	while (!player) {wait (1);} // wait until the player model is loaded
	while (1)
	{
		my.pan +=20*time_step;
		vec_for_vertex(temp, my, 401); // generate particles from the 10th vertex of the entity
		effect(my_effect, 1, temp.x, nullvector);
		if (vec_dist(player.x, my.x) < 50) // trigger distance, play with 100
		{


			vec_set (player.x, vector (200, -2, 10));
		}
		wait (1);
	}
}

action my_teleport03()
{
	set(my, POLYGON | INVISIBLE); // use polygon-based collision detection
	wait (-0.3);

	VECTOR temp;
	while (!player) {wait (1);} // wait until the player model is loaded
	while (1)
	{
		my.pan +=20*time_step;
		vec_for_vertex(temp, my, 401); // generate particles from the 10th vertex of the entity
		effect(my_effect, 1, temp.x, nullvector);
		if (vec_dist(player.x, my.x) < 50) // trigger distance, play with 100
		{


			vec_set (player.x, vector (1, -207, 10));
		}
		wait (1);
	}
}

action my_teleport04()
{
	set(my, POLYGON | INVISIBLE); // use polygon-based collision detection
	wait(-0.1);

	VECTOR temp;
	while (!player) {wait (1);} // wait until the player model is loaded
	while (1)
	{
		my.pan +=20*time_step;
		vec_for_vertex(temp, my, 401); // generate particles from the 10th vertex of the entity
		effect(my_effect, 1, temp.x, nullvector);
		if (vec_dist(player.x, my.x) < 50) // trigger distance, play with 100
		{


			vec_set (player.x, vector (1, 190, 10));
		}
		wait (1);
	}
}



var entity_speed = 1;
var movement_enabled = 0;
var dist_to_node;
var current_node = 1;
VECTOR temp_angle;
VECTOR pos_node; // stores the position of the node
function move_target()
{
	while(1)
	{
		if(movement_enabled)
		{
			entity_speed = minv(3, entity_speed + 0.1 * time_step);
			c_move(my, vector(entity_speed * time_step, 0, 0), nullvector, IGNORE_PASSABLE | GLIDE);
			vec_to_angle (my.pan, vec_diff (temp_angle, pos_node, my.x));
		}
		wait(1);
	}
}
action light_follows_path() // attach this action to your light model
{
	// set (my, INVISIBLE | PASSABLE); // if you don't want the light to be visible
	vec_set(my.blue, vector(255, 255, 255)); // set a white color for the light
	my.lightrange = 200; // and a range of 300 quants
	move_target();
	result = path_scan(me, my.x, my.pan, vector(360, 0, 500)); // scan the area
	if (result) {movement_enabled = 1;}
	path_getnode (my, 1, pos_node, NULL);
	vec_to_angle (my.pan, vec_diff (temp_angle, pos_node, my.x)); // rotate towards the node
	while(1)
	{
		dist_to_node = vec_dist(my.x, pos_node);
		if(dist_to_node < 50) // close to the node?
		{
			current_node = path_nextnode(my, current_node, 1);
			if (!current_node) {current_node = 1;} // reached the end of the path? Then start over!
			path_getnode (my, current_node, pos_node, NULL);
		}
		wait(1);
	}
}


function suck_in() // ball's event function
{
	vec_to_angle(my.pan, bounce); // change the direction as expected from a "real" ball
	my.pan += 5 - random(20); // add some randomness at each collision (don't allow the ball to get stuck)
	my.tilt = 0;

}


action blackhole() // attach this action to your ball
{
	var total_time;
	my.emask |= (ENABLE_BLOCK | ENABLE_ENTITY); // the object is sensitive to block and entity collisions
	my.event = suck_in;
	c_setminmax(my);
	set(my,METAL |SHADOW);
	my.pan += 5 - random(20);
	my.skill100 = 100;
	total_time = 200;
	while(1)
	{
		total_time -=1*time_step;
		c_move(me, vector(10 * time_step, 0, 0), nullvector,  IGNORE_PASSABLE | GLIDE | IGNORE_SPRITES);  // move ahead, in the direction given by the pan angle
		wait(1);
		if(game_enable ==0){
			
			ent_remove(me);
			
			break;
		}	
		if(total_time <=0){
			
			ent_remove(me);
			random_pointsplacement();
			break;
		}	
	}
}
