#include <acknex.h>
#include <default.c>
#include <ackphysx.h>
#include <mtlView.c>

#define PRAGMA_PATH "3dmodels"
#define PRAGMA_PATH "graphics"
#define PRAGMA_PATH "scripts"
#define PRAGMA_PATH "sounds"


function p_alphafade(PARTICLE *p)
{
	p.alpha = random(100);
	if (p.alpha <= 10) p.lifespan = 0;
}

function p_alphafade2(PARTICLE *p)
{
	p.alpha = random(100);
	if (p.alpha <= 10) p.lifespan = 0.5;
}

BMAP* effect_tga = "spark.tga";


function my_effect(PARTICLE *p)
{
	p.lifespan = 0.1; 
	p.alpha = 60;
	p.bmap = effect_tga;
	p.size = random(40);
	p.flags |= (MOVE|BRIGHT );
	p.event = p_alphafade;
}

function my_effect2(PARTICLE *p)
{
	p.lifespan = 0.4; 
	p.alpha = 60;
	p.bmap = effect_tga;
	p.size = random(40);
	p.flags |= (MOVE|BRIGHT );
	p.event = p_alphafade2;
}


var score =0;

FONT*	fnt3_pan = "Ariel#22b"; 
PANEL* pan_score = {digits=10,10,"score: %00.0f",fnt3_pan,1,score; 
	layer = 1;
	flags = SHOW;
}


var ammo_count = 200;
FONT*	fnt3_pan = "Ariel#22b"; 
PANEL* pan_ammo_count = {digits=10,50,"Ammo: %00.0f",fnt3_pan,1,ammo_count; 
	layer = 1;
	flags = SHOW;
}

PANEL* title_pan =

{
	bmap = "title.bmp";
	pos_x = 0;
	pos_y = 0;
	layer = 17000;
}

PANEL* black_pan =

{

	bmap = "black.bmp";
	pos_x = 0;
	pos_y = 0;
	layer = 17000;
}

PANEL* gameover_pan =
{
	bmap = "gameover.png";
	pos_x =0;
	pos_y = 0;
}


PANEL* destroy_pan =
{
	bmap = "destroy.png";
	pos_x =0;
	pos_y = 0;
}

var soundtrack_handle;


var restart_game = 0;

function main();
var enable_shooting = 0;
function restart_dagame()
{
	if(restart_game >=1){
		media_stop(soundtrack_handle);
		reset(gameover_pan,SHOW);
		ammo_count = 500;
		////set(pan_score,SHOW);
		restart_game =0;
		score = 0;
		enable_shooting =0;
		level_load("Powerloader.WMB");
		soundtrack_handle = media_play("ingame.wav", NULL, 150);
		set(destroy_pan,SHOW);
		wait(-4);
		reset(destroy_pan,SHOW);
	}
}


function main()
{
	
	shadow_stencil = 2;
video_set(1024,768,0,0);
	 
	soundtrack_handle = media_loop("ingame.wav", NULL, 150);
	set(title_pan,SHOW);
	set(black_pan,SHOW | TRANSLUCENT);
	black_pan.alpha = 100;
	wait(-2);
	while(black_pan.alpha > 0)
	{
		black_pan.alpha = maxv(black_pan.alpha - 20 * time_step,0);
		wait(1);
	}
	wait(-2);
	while(black_pan.alpha < 100) 
	{
		black_pan.alpha = minv(black_pan.alpha + 10 * time_step,100);
		wait(1);
	}
	reset(title_pan,SHOW);
	wait(-0.5);

	while(black_pan.alpha > 0) 
	{
		black_pan.alpha = maxv(black_pan.alpha - 35 * time_step,0);
		wait(6);
	}
	reset(black_pan,SHOW);
	wait(1);
	level_load("Powerloader.WMB");

	set(destroy_pan,SHOW);
	wait(-4);
	reset(destroy_pan,SHOW);
}

function fire_bullet();
function shoot_bullet();
function remove_bullet();

#define health skill20

function health_indicator()
{
	ENTITY* ent_owner = you;
	
	set (my, BRIGHT |PASSABLE);
	while (ent_owner)
	{
		vec_set (my.x, ent_owner.x);
		my.z += 10;
		my.x +=50;
		my.tilt =-90;

		my.scale_x = ent_owner.health * 0.05; 
		wait (1);
	}
}


function remove_player()
{
	my.skill20 -=1;

}


ENTITY* powerloader;


var run_percentage = 0;
var stand_percentage = 0;
var attack_percentage = 0;

action player_movement()
{
	var run_percentage = 0;
	var stand_percentage = 0;
	var attack_percentage = 0;
	var fire_lock=0;
	my.skill20 = 10;
	my.group=2;
	set(my,SHADOW | METAL | POLYGON);
	my.emask |= (ENABLE_ENTITY |ENABLE_IMPACT | ENABLE_SCAN); 
	my.event = remove_player;
	powerloader = me;
	my.eflags |= FAT | NARROW; 
	vec_set(my.min_x,vector(-20,-20,-20));
	vec_set(my.max_x,vector(20,20,20));
	ent_create ("health.pcx", nullvector, health_indicator);	
	while(1)
	{
		 
		if(fire_lock)
		{
				attack_percentage += 20 * time_step;
			//attack_percentage %= 100;
			ent_animate(my, "attack", attack_percentage, NULL);
			if(attack_percentage>=100)
			{
				fire_bullet();
				fire_lock =0;
				attack_percentage=0;
			}
		}
		if(key_ctrl && !fire_lock)
		{
			fire_lock=1;
			
		}
		
		c_ignore(2);
		vec_to_angle(my.pan, vector(15 * (key_cuu - key_cud), 15 * (key_cul - key_cur), 0));
		result = c_move(me, nullvector, vector(15 * (key_cuu - key_cud) * time_step, 15 * (key_cul-
		key_cur) * time_step, 0), GLIDE | IGNORE_ME | IGNORE_PASSABLE |IGNORE_SPRITES);
		if(result > 0 && !fire_lock)
		{
			run_percentage += 3 * time_step;
			run_percentage %= 100;
			ent_animate(my, "walk", run_percentage, ANM_CYCLE);
		}
		else{
			if(!fire_lock
			){
			
			stand_percentage += 1* time_step;
			stand_percentage %= 100;
			ent_animate(my, "Idle", stand_percentage, ANM_CYCLE);}
		}
		camera.tilt = -90;
		vec_set (camera.x, powerloader.x);
		camera.z = powerloader.z + 500;
		if(my.skill20 <=0){
			enable_shooting =1;
			set(my,PASSABLE | INVISIBLE);
			my.event=NULL;
			wait(1);
			ent_remove(me);
			set(gameover_pan,SHOW);
			restart_game = 1;
			on_r = restart_dagame;
			break;
		}
		wait(1);
	}
}


/////////////////////////////////weapon use/////////////////////////////////////////////////////////

SOUND* explosion_snd = "explosion.wav";
SOUND* shoot_snd = "shoot.wav";
SOUND* created_snd = "created.wav";

function sprite_played()
{
	set (my, PASSABLE |TRANSLUCENT);
	my.scale_x = 0.5; 
	my.scale_y = my.scale_x; 
	my.ambient = 100;
	my.roll = random(360); 
	my.alpha = 100; 
	while (my.frame < 16) 
	{	
		my.frame += 1 * time_step; 
		wait (1);
	}
	while (my.alpha > 0) 
	{
		my.alpha -= 4 * time_step; 
		wait (1);
	}
	ent_remove (me);
}





function fire_bullet()
{

	if(enable_shooting + ammo_count >=1){
		snd_play(shoot_snd,100,0);
		VECTOR gun_pos;
		vec_for_vertex(gun_pos, powerloader, 1322); 
		ENTITY *bullet = ent_create ("bullet.mdl", gun_pos, shoot_bullet);
		ammo_count -=1;
		
	}
	else
	{
		if(enable_shooting + ammo_count <=0)
		wait(-2);		
	}
}



function shoot_bullet()
{
	my.group=2;
	VECTOR bullet_speed, temp;
	VECTOR temp1;
	my.emask |= (ENABLE_ENTITY | ENABLE_BLOCK | ENABLE_IMPACT);
	my.event = remove_bullet;
	set(my,BRIGHT | POLYGON | UNLIT);
	set(my,TRANSLUCENT);
	c_setminmax(me);
	my.pan = powerloader.pan;
	my.roll = 180;
	vec_set(bullet_speed.x, nullvector); // none sense !!!!
	
	while (1)
	{
		bullet_speed.x = 20*time_step;
		vec_for_vertex(temp1, my, 636); 
		effect(my_effect, 1, temp1.x, nullvector);
		c_ignore(2);
		c_move (my, bullet_speed.x, nullvector, GLIDE | IGNORE_SPRITES);
		wait(1);
		//if(my.x >= powerloader.x+620  )
		if(vec_dist(my.x,powerloader.x)>=620) 
		{
			my.event = NULL;
			set(my,INVISIBLE |PASSABLE);
			wait(1);
			break;
		}		
	}
	remove_bullet();
}



function remove_bullet()
{
	set (my, INVISIBLE | PASSABLE);
	wait(1);
	my.event = NULL;
	////ent_create("explo2+16.tga", vector(my.x,my.y,my.z), sprite_played);
	ent_remove(me); 
}


//////////////////////////////////////////////////////////////////////////

function enemy_stands()
{
	ent_animate(my, "stand", stand_percentage, ANM_CYCLE); 
	stand_percentage += 2 * time_step;      
}




function remove_enemy()
{

	ent_create("explo2+16.tga", vector(my.x,my.y,my.z), sprite_played);
	snd_play (explosion_snd, 100, 0);
	set(my,INVISIBLE |PASSABLE);
	my.event = NULL;
	wait(1);
	ent_remove(me);
	score +=25;
	wait(1);	
}




action enemy_1()
{
	var run_percentage;
	my.group=1;
	set(my,BRIGHT | POLYGON | METAL | SHADOW);
	my.emask |= (ENABLE_ENTITY |ENABLE_IMPACT | ENABLE_SCAN); 
	my.event = remove_enemy;
	
	my.eflags |= FAT | NARROW; 
	vec_set(my.min_x,vector(-20,-20,-20)); 
	vec_set(my.max_x,vector(20,20,20));
	VECTOR temp;

	while (!powerloader) {wait (1);}
	while (1)
	{
		if (vec_dist(powerloader.x, my.x) > 1500) 
		{
			enemy_stands(); 
		}
		else 
		{
			if (vec_dist (powerloader.x, my.x) > 10) 
			{
				vec_set(temp, powerloader.x);
				vec_sub(temp, my.x);
				vec_to_angle(my.pan, temp);
				ent_animate(my, "walk", run_percentage, ANM_CYCLE); // then play the "run" animation
				c_ignore(1);
				c_move (my, vector(15 * time_step, 0, 0), nullvector, IGNORE_PASSABLE | GLIDE);                                
				run_percentage += 2 * time_step; // 6 = "run" animation speed                                
				if(enable_shooting ==1){
				ent_remove(me);
				break;
			}
		}
			else 
			{
				enemy_stands(); 
			}
		}
		wait (1);
	}
}


//////////////////////enemy spawn//////////////////////////////////////////////////////////////////////////////////////////

action enemy_spawner()
{
	set(my,PASSABLE | INVISIBLE);
	var spawn_timer = 160;
	VECTOR temp1;
	while(1)
	{
		my.pan += 10* time_step;
		my.roll += 10*time_step;
		vec_for_vertex(temp1, my, 1330); 
		effect(my_effect2, 1, temp1.x, nullvector);
		spawn_timer -=1* time_step;
		
		if(spawn_timer <=0){
			snd_play(created_snd,100,0);
			ent_create("magic23+8.png", vector(my.x,my.y,my.z+50), sprite_played);
			ent_create("powerloadere.mdl", vector(my.x+20,my.y,my.z),enemy_1);
			wait(-2);
			spawn_timer =random (150);	
		}
		
		if(enable_shooting ==1){
			ent_remove(me);
			break;
		}

		wait(1);
	}	
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

