//////////////////////react by Rene Pol aka Realspawn  RP-interactive.nl -2015-///////////////////////////////////

///////////////////////////////
#define PRAGMA_PATH "3Dmodels"
#define PRAGMA_PATH "Graphics"
#define PRAGMA_PATH "Sounds"

///////////////////////////////
FONT* arial_font = "DooM#18b"; // truetype font, 20 point bold 
// empty string:
STRING* texttest = "";

// text to be displayed:
TEXT* mytext = {
	// set the string:
	string = texttest;
	blue =255;
	green =255;
	red = 255;
	layer = 2; 
	font = arial_font;
	// set flags:
	flags = SHOW;
}


var soundtrack_handle;


SOUND* speed_snd = "speed.wav";
SOUND* start_snd = "start.wav";
SOUND* bounce_snd = "bounce.wav";

PANEL* title_pan =

{

	bmap = "title.bmp";

	pos_x = 0;

	pos_y = 0;
	
	layer = 17;

	
}

PANEL* black_pan =

{

	bmap = "black.bmp";

	pos_x = 0;

	pos_y = 0;
	layer = 17000;

	
}



var score =0;

FONT*	fnt2_pan = "Ariel#14b"; /// The true type font we want to use size and bold use any font you like
PANEL* pan_score = {digits=21,14," %00.0f",fnt2_pan,1,score; //the panel where the number is shown on
	layer = 1; //the layer of the panel
	flags = SHOW;green=255; blue=255; red=255;// the color of the font that is used. This is yellow.
}


var hscore =0;

FONT*	fnt3_pan = "Ariel#22b"; /// The true type font we want to use size and bold use any font you like
PANEL* pan_hscore = {digits=150,5,"Best score: %00.0f",fnt3_pan,1,hscore; //the panel where the number is shown on
	layer = 1; //the layer of the panel
	////	flags = SHOW;green=255; blue=255; red=255;// the color of the font that is used. This is yellow.
}


#define HIGH_SCORE_SAVE_FILE "hs.score"

TEXT* input_file = { strings = 1; } // used to load saved information, only one string needed

void load_highscore()
{
	txt_load(input_file, HIGH_SCORE_SAVE_FILE);
	wait(1); // wait one frame to load the text file - important!
	
	hscore = str_to_float( (input_file.pstring)[0] ); // (<text>.pstring) [ line, beginning with 0! ] -> convert to float
}

void save_highscore()
{
	var file_handle = file_open_write(HIGH_SCORE_SAVE_FILE);
	wait(1); // wait to open the file?? - not sure if this is needed
	
	file_str_write(file_handle, str_for_float(NULL, (double)hscore)); // convert the highscore to a string -> write into file
	file_close(file_handle);
}

var pillar =0;
var wall =0;

action remove_wall()
{
	my.skill100 = 13579;
	set(my,UNLIT);
	my.skill1 = 999; // this value identifies an enemy
	wait(-0.08);
	ent_remove(me);
	wall =0;
}


PANEL* end_pan =
{
	bmap = "end.png";
	pos_x = 100;
	pos_y = 100;
	layer = 1;
	/////flags = SHOW;
}

PANEL* time_pan =
{
	bmap = "time.png";
	pos_x = 5;
	pos_y = 2;
	layer = 1;
	flags = SHOW;
}

PANEL* how_pan =
{
	bmap = "how.png";
	pos_x = 65;
	pos_y = 300;
	layer = 1;
	//////flags = SHOW;
}

action my_ball();
function create_wall()
{

	if(wall ==0){
		ent_create("wall.wmb", vector(-249,0,0), remove_wall);////	
		wall =1;
	}
	
}

var game_on = 0;
var hit_bar = 0;

function start_game()
{
	
	if(game_on == 0){
		snd_play(start_snd,100,0);
		pillar =0;
		score =0;
		hit_bar =0;
		reset(pan_hscore,SHOW);
		reset(end_pan,SHOW);
		set(pan_score,SHOW);
		ent_create("ball.mdl", vector(-189,0,9), my_ball);////	
		game_on =1;
		reset(how_pan,SHOW);
	}
}

function scrolling_txt()
{


	var fhandle1 = file_open_read("my.txt");
	
	file_str_read(fhandle1, texttest);

	file_close(fhandle1);

	mytext.pos_x = screen_size.x + 5;

	wait(1);
	// get the width of the string:
	var width = str_width(texttest, NULL);
	// loop:
	while(1){
		
		if(mytext.pos_x < -width-500){
			// set it back to the upper right corner:
			mytext.pos_x = screen_size.x + 500;
		}
		// scroll text to the left:
		mytext.pos_x -= 3 * time_step;
		// place text at the far right corner:
		mytext.pos_y = screen_size.y - 20;
		// wait one frame:
		wait(1);
	}	
}


function main()
{
	video_set(450,700,32,0);
	soundtrack_handle = media_loop("ingame.mp3", NULL, 80);
	set(title_pan,SHOW);
	set(black_pan,SHOW | TRANSLUCENT);
	black_pan.alpha = 100;
	wait(-2);
	while(black_pan.alpha > 0)
	{
		black_pan.alpha = maxv(black_pan.alpha - 15 * time_step,0);
		wait(1);
	}
	level_load("react.WMB");
	wait(-2);
	while(black_pan.alpha < 100) 
	{
		black_pan.alpha = minv(black_pan.alpha + 10 * time_step,100);
		wait(1);
	}
	reset(title_pan,SHOW);
	wait(-0.5);

	while(black_pan.alpha > 0) 
	{
		black_pan.alpha = maxv(black_pan.alpha - 35 * time_step,0);
		wait(6);
	}
	reset(black_pan,SHOW);
	set(how_pan,SHOW);
	load_highscore();
	on_space = create_wall;
	on_enter = start_game;
	scrolling_txt();

}






function scoring()
{
	set(pan_hscore,SHOW);
	if(score >= hscore){
		hscore = score;
		save_highscore();	
		set(pan_hscore,SHOW);
		reset(pan_score,SHOW);
		
	}
}



action pillar_rot()
{
	set(my,UNLIT);
	while(1)
	{
		my.pan +=2*time_step;
		wait(1);
		if(pillar ==0){
			ent_remove(me);
			break;
		}
		
	}
}



function bounce_off() // ball's event function
{
	snd_play(bounce_snd,100,0);

    vec_to_angle(my.pan, bounce); // change the direction as expected from a "real" ball
	
	my.pan += 5 - random(10); // add some randomness at each collision (don't allow the ball to get stuck)
	
		if (you) // collided with another entity (maybe with our special wall)?
	{
		if (you.skill100 == 13579) // if the entity is our special wall indeed
		{
			snd_play(speed_snd,100,0);
			hit_bar +=1;
			score +=1;
		}
		
	}
}
action my_ball() // attach this action to your ball
{

	var speed = 10;	
	my.emask |= (ENABLE_BLOCK | ENABLE_ENTITY); // the object is sensitive to block and entity collisions
	my.event = bounce_off;
	my.skill100 = 13579; // set this skill to a weird value in order to differentiate the object from the others
	

	set(my,BRIGHT  | METAL);
	while(1)
	{
	
		c_move(me, vector(speed * time_step, 0, 0), nullvector, GLIDE | IGNORE_PASSABLE); // move ahead, in the direction given by the pan angle
		wait(1);
		if(my.x <=-240){
			set(my,INVISIBLE | PASSABLE);
			my.event = NULL;
			wait(1);
			ent_remove(me);
			game_on =0;
			scoring();
			set(how_pan,SHOW);
			break;
		}
		if(hit_bar ==1){
			speed =13;
			
		}
		if(hit_bar ==2){
			speed =16;
			
		}
		if(hit_bar ==3){
			speed =19;
			
		}
		if(hit_bar ==4){
			speed =22;
			
		}
		if(hit_bar ==5){
			speed =25;
			if(pillar ==0)
			ent_create("pillar.wmb", vector(120,0,15), pillar_rot);////
			pillar =1;
			
			
		}
		if(hit_bar ==6){
			speed =26;
			
		}
		if(hit_bar ==7){
			speed =27;
			
		}
		if(hit_bar ==8){
			speed =28;
			
		}
		if(hit_bar ==9){
			speed =29;
			
		}
		if(hit_bar ==10){
			speed =29;
			
		}
		if(hit_bar ==11){
			speed =30;
			
		}
		if(hit_bar ==12){
			speed =31;
			
		}
		if(hit_bar ==13){
			speed =32;
			
		}
		if(hit_bar ==14){
			speed =33;
			
		}
		if(hit_bar ==15){
			speed =34;
			
		}
		if(hit_bar ==16){
			speed =35;
			
		}
		if(hit_bar ==17){
			speed =36;
			
		}
		if(hit_bar ==18){
			speed =37;
			
		}
		if(hit_bar ==19){
			speed =38;
			
		}
		if(hit_bar ==20){
			set(my,INVISIBLE | PASSABLE);
			my.event = NULL;
			wait(1);
			ent_remove(me);
			game_on =0;
			scoring();
			set(how_pan,SHOW);
			set(end_pan,SHOW);
			break;
		}
	}
}


