#define PRAGMA_PATH "3Dmodels"


function main()
{
	video_set(1024,768,32,0);
	video_window(vector(0,0,0),vector(1024,768,0), 16, "Basic movement in lite_C by RP-Interactive, Ren Pol");
	level_load("tbm.WMB");
}



action simply_moving()
{
	set(my,SHADOW);
	while(1)
	{
		c_move (my, vector (2 * time_step, 0, 0), nullvector, GLIDE);
		wait(1); 
	}
}


action simply_animmoving()
{
	set(my,SHADOW);
	var walking_percentage = 0;
	while(1)
	{
		walking_percentage %= 100;
		walking_percentage += 3 * time_step;
		ent_animate(my, "walk", walking_percentage, ANM_CYCLE);
		
		c_move (my, vector (2 * time_step, 0, 0), nullvector, GLIDE);
		wait(1);
	}
}

action keya_moving()
{
	set(my,SHADOW);
	var walking_percentage = 0;
	while (!key_cuu) wait (1);
	while(1)
	{
		walking_percentage %= 100;
		walking_percentage += 3 * time_step;
		ent_animate(my, "walk", walking_percentage, ANM_CYCLE);
		
		c_move (my, vector (2 * time_step, 0, 0), nullvector, GLIDE);
		wait(1);
	}
}

action simply_packman()
{
	set(my,SHADOW);
	var walking_percentage = 0;
	while(1)
	{
		if(key_cul){
			my.pan =90;
		}
		if(key_cur){
			
			my.pan =-90;
		}
		if(key_cud){
			
			my.pan =-180;
		}
		if(key_cuu){
			
			my.pan =0;
		}
		walking_percentage %= 100;
		walking_percentage += 10 * time_step;
		ent_animate(my, "walk", walking_percentage, ANM_CYCLE);
		
		c_move (my, vector (10 * time_step, 0, 0), nullvector, GLIDE);
		wait(1);
	}
}

action adventure_movement()
{
	set(my,SHADOW);
	var walking_percentage = 0;
	var standing_percentage = 0;
	while(1)
	{
		if(key_cul){
			my.pan =90;
		}
		if(key_cur){
			
			my.pan =-90;
		}
		if(key_cud){
			
			my.pan =-180;
		}
		if(key_cuu){
			
			my.pan =0;
		}
		if(!key_cuu - key_cud - key_cul - key_cur)
		{
			standing_percentage %= 100;
			standing_percentage += 3 * time_step;
			ent_animate(my, "stand", standing_percentage, ANM_CYCLE);
			wait(1);
		}
		else
		{
			walking_percentage %= 100;
			walking_percentage += 10 * time_step;
			ent_animate(my, "walk", walking_percentage, ANM_CYCLE);
			c_move (my, vector (10 * time_step, 0, 0), nullvector, GLIDE);
			wait(1);
		}

	}
}





action joystick_movement()
{
	set(my,SHADOW);
	var walking_percentage = 0;
	var standing_percentage = 0;
	while(1)
	{
		if(joy_force.x < 0 && my.pan != 90){ my.pan = 90; }
		if(joy_force.x > 0 && my.pan != 270){ my.pan = 270; }
		if(joy_force.y > 0 && my.pan != 0){ my.pan = 0; }
		if(joy_force.y < 0 && my.pan != 180){ my.pan = 180; }
		result = c_move(me, nullvector, vector(10 * joy_force.y * time_step, -10 * joy_force.x * time_step, 0), GLIDE | IGNORE_ME | IGNORE_PASSABLE);
		if(result > 0)
		{
			walking_percentage %= 100;
			walking_percentage += 5 * time_step;
			ent_animate(my, "walk", walking_percentage, ANM_CYCLE);
			wait(1);
		}
		else{
			standing_percentage %= 100;
			standing_percentage += 5 * time_step;
			ent_animate(my, "stand", standing_percentage, ANM_CYCLE);
			
			wait(1);
		}
	}
}


action joystick2_movement()
{
	set(my,SHADOW);
	var walking_percentage = 0;
	var standing_percentage = 0;
	while(1)
	{
		if(joy_force.x < 0 && my.pan != 90){ my.pan = 90; }
		if(joy_force.x > 0 && my.pan != 270){ my.pan = 270; }
		if(joy_force.y > 0 && my.pan != 0){ my.pan = 0; }
		if(joy_force.y < 0 && my.pan != 180){ my.pan = 180; }
		result = c_move(me, nullvector, vector(10 * joy_force.y * time_step, -10 * joy_force.x * time_step, 0), GLIDE | IGNORE_ME | IGNORE_PASSABLE);
		if(result > 0)
		{
			walking_percentage %= 100;
			walking_percentage += 5 * time_step;
			ent_animate(my, "walk", walking_percentage, ANM_CYCLE);
			wait(1);
		}
		else{
			standing_percentage %= 100;
			standing_percentage += 5 * time_step;
			ent_animate(my, "stand", standing_percentage, ANM_CYCLE);
			if(joy_1)
			draw_text("YAY THE BUTTON WORKS ! ",100,10,vector(100,100,255));
			wait(1);
		}
	}
}




VECTOR absdist = 50;
var jump_time = 1;
var jump_height = 50;
var my_height = 50;


function my_jump(){

	if(jump_time != 1){ return; }
	
	while(jump_time > -1){	
		
		jump_time -= 0.2 * time_step;
		
		absdist.z = jump_height * jump_time * time_step;

		
		wait(1);
	}
	while(my_height > 5){ wait(1); }
	
	jump_time = 1;


}

function my_gravity(){
	
	VECTOR temp;
	vec_fill(temp.x, 0);

	vec_set(temp.x, my.x);
	temp.z  -= 2000;
	
	trace_mode = IGNORE_PASSABLE | IGNORE_ME | USE_BOX;
	my_height = c_trace(my.x, temp.x, trace_mode);
	
	if(my_height > 5 || my_height <= 0){
		accelerate(absdist.z, -20 * time_step, 0.3);

	}
	else{
		if(jump_time == 1){
			absdist.z = 0;

		}
	}
}


action adventure2_movement()
{
	set(my,SHADOW);
	var walking_percentage = 0;
	var standing_percentage = 0;

	on_space = my_jump;
	while(1)
	{
		my_gravity();
		
	
		if(key_cul){
			my.pan =90;
		}
		if(key_cur){
			
			my.pan =-90;
		}
		if(key_cud){
			
			my.pan =-180;
		}
		if(key_cuu){
			
			my.pan =0;
		}
		
		if(!key_cuu - key_cud - key_cul - key_cur )
		{
			standing_percentage %= 100;
			standing_percentage += 3 * time_step;
			ent_animate(my, "stand", standing_percentage, ANM_CYCLE);
			
			c_move (my, vector (0 * time_step, 0, absdist.z), nullvector, IGNORE_PASSABLE | IGNORE_ME | GLIDE);
			wait(1);
		}
		else
		{
			walking_percentage %= 100;
			walking_percentage += 10 * time_step;
			ent_animate(my, "walk", walking_percentage, ANM_CYCLE);
			c_move (my, vector (10 * time_step, 0, absdist.z), nullvector, IGNORE_PASSABLE | IGNORE_ME | GLIDE);
			wait(1);
			
		}
	}
}



action car_movement()
{
	set(my,SHADOW,METAL);
	var movement_speed = 0; 
	var rotation_speed = 15;
	var car_maxspeed = 20;
	VECTOR car_speed, temp;
	c_setminmax(me);
	while(1)
	{
		
		my.pan += rotation_speed * (key_cul - key_cur) * time_step;
		
		
		
		vec_set(car_speed.x, accelerate (movement_speed, 5 * (key_cuu - key_cud), 0.1));

		car_speed.y = 0;
		vec_set (temp.x, my.x);
		temp.z -= 10000;
		car_speed.z = -c_trace (my.x, temp.x, IGNORE_ME  | USE_BOX) ;
		c_move (my, car_speed.x, nullvector, GLIDE); 
		wait(1);
		if (movement_speed >= car_maxspeed){
			movement_speed =20;
		}
		if(movement_speed <=-20){
			movement_speed =-20;
		}


		

	}

}


action adventure_amovement()
{
set(my,SHADOW);
var walking_percentage = 0;
var standing_percentage = 0;
var jumping_percentage =0;
on_space = my_jump;
while(1)
{
my_gravity();
while(key_space){
ent_animate(my, "jump", jumping_percentage, 0); // "death" one-shot   animation
jumping_percentage += 4 * time_step;
c_move (my, vector (10 * time_step, 0, absdist.z), nullvector, IGNORE_PASSABLE | IGNORE_ME | GLIDE);
wait(1);
}
if(key_cul){
my.pan =90;
}
if(key_cur){
my.pan =-90;
}
if(key_cud){
my.pan =-180;
}
if(key_cuu){
my.pan =0;
}
if(!key_cuu - key_cud - key_cul - key_cur )
{
standing_percentage %= 100;
standing_percentage += 3 * time_step;
ent_animate(my, "stand", standing_percentage, ANM_CYCLE);
c_move (my, vector (0 * time_step, 0, absdist.z), nullvector, IGNORE_PASSABLE | IGNORE_ME | GLIDE);
wait(1);
}
else
{
walking_percentage %= 100;
walking_percentage += 10 * time_step;
ent_animate(my, "walk", walking_percentage, ANM_CYCLE);
c_move (my, vector (10 * time_step, 0, absdist.z), nullvector, IGNORE_PASSABLE | IGNORE_ME | GLIDE);
wait(1);
}
}
}