#define PRAGMA_PATH "3Dmodellen"
#define PRAGMA_PATH "Plaatjes"
#define PRAGMA_PATH "Geluiden"

/////////////////variables used//////////////////////////

var game_enable =0;

var score =0;

FONT*	fnt3_pan = "Ariel Black#22bI"; 
PANEL* pan_score = {digits=26,35,"SCORE : %006.0f",fnt3_pan,1,score; 
	layer = 15;
	flags = SHOW;green=255; blue=0; red=255;
}

var health =100;

FONT*	fnt3_pan = "Ariel Black#22bI"; 
PANEL* pan_health = {digits=855,718,"Health : %03.0f",fnt3_pan,1,health; 
	layer = 15;
	flags = SHOW;green=255; blue=0; red=255;
}

var soundtrack_handle;

////////////////////////////////sounds used/////////////////

SOUND* spit_snd = "spit.wav";
SOUND* die_snd = "die.wav";

//////////////////////////////preloaded///////////////////

action spin_controle();
action vijand_spinnen();

/////////////////particle trail//////////////////////////

function smokefnc(PARTICLE *p)
{
	p.alpha -= p.skill_a*time_step;
	p.size += p.skill_a*time_step;
	if (p.blue > 0) { p.blue -= p.skill_a*time_step*2; }
	if (p.red > 0) { p.red -= p.skill_a*time_step*2; }
	if (p.green > 0) { p.green -= p.skill_a*time_step*2; }
	if (p.alpha <= 0) p.lifespan = 0;
}

function smoke(PARTICLE* p)
{
	vec_set(p.blue,vector(212,255,123));
	set(p, MOVE | BRIGHT | TRANSLUCENT);
	p.alpha = 50+random(20);
	p.size = 0.1+random(0.1);
	p.gravity = -0.025;
	p.skill_a = 18; // fade factor
	p.event = smokefnc;
}

///////////////////////////////panels and graphics used/////

BMAP* black_map = "black.png"; 
PANEL* black_pan =
{
	bmap = black_map; 
	pos_x = 0;
	pos_y = 0;
	layer = 200;
	flags = SHOW;
}


BMAP* logo_map = "logo.png"; 
PANEL* logo_pan =
{
	bmap = logo_map; 
	pos_x = 0;
	pos_y = 0;
	layer = 100;
	flags = SHOW;
}


BMAP* gamehud_map = "gamehud.png"; 
PANEL* gamehud_pan =
{
	bmap = gamehud_map; 
	pos_x = 0;
	pos_y = 0;
	layer = 11;
	flags = SHOW;
}

BMAP* rs_map = "restart.png"; 
PANEL* rs_pan =
{
	bmap = rs_map; 
	pos_x = 300;
	pos_y = 350;
	layer = 11;

}

///////////////////////////entity pointers used//////////////////////////////////////////////////////


ENTITY* spider;

//////////////////////////////////////////////////////////////////////////////////////////////////////


function begin_game()
{
	if(game_enable ==0){
		reset(rs_pan,SHOW);
		game_enable =3;
		score =0;
		health =100;
		ent_create("playerspider.mdl", vector(0.037,-0.064,5.478),spin_controle);
		wait(-1);
		game_enable =1;
	}
}


function main()
{
	set(logo_pan,SHOW);
	set(black_pan,SHOW |TRANSLUCENT);
	black_pan.alpha =100;
	video_set(1024,768,32,0);
	video_window(vector(0,0,0),vector(1024,768,0), 16, "Spider attack ! by RP-Interactive, Ren Pol");
	wait(-2);
	while(black_pan.alpha >0){
		black_pan.alpha -=8*time_step;
		wait(1);
	}
	wait(-2);
	level_load("spiderattack.WMB");
	soundtrack_handle = media_loop("ingame.mp3", NULL, 100);
	while(black_pan.alpha <100){
		black_pan.alpha +=8*time_step;
		wait(1);
	}
	wait(-1);
	set(rs_pan,SHOW);
	on_space = begin_game;
	reset(logo_pan,SHOW);
	while(black_pan.alpha >0){
		black_pan.alpha -=8*time_step;
		wait(1);
	}
	reset(black_pan,SHOW | TRANSLUCENT);	
}


function gif_hit()
{
	set(my,PASSABLE | INVISIBLE);
	my.event = NULL;
	wait(1);
	ent_remove(me);
}


action fire_gif()
{
	set(my,INVISIBLE);
	my.emask |= ENABLE_ENTITY | ENABLE_IMPACT; 
	my.event= gif_hit;
	my.pan = spider.pan;
	my.lightrange =100;
	my.ambient =100;
	while(1)
	{
		effect(smoke,1,my.x,nullvector);
		c_move(my, vector(15 * time_step, 0, 0), nullvector, GLIDE);
		wait(1);
		if(vec_dist (my.x, spider.x) > 600){
			gif_hit();
		}
	}
}



function attack()
{
	if(game_enable ==1){
			snd_play(spit_snd,100,0);
		ent_create("ball.mdl", vector(spider.x,spider.y,spider.z), fire_gif);
		wait(-1);
	}
}



function satellite()
{
	set(my, PASSABLE);
	var orbit_radius = 300; 
	var orbit_speed = 4; 
	var temp_angle;
	var timing_spawn =20;
	timing_spawn = 20;
	while(1)
	{
		if(health <=0){
			ent_remove(me);
			wait(1);
			break;
		}
		timing_spawn -=1*time_step;
		my.x = you.x + sin(temp_angle) * orbit_radius;
		my.y = you.y + cos(temp_angle) * orbit_radius;
		my.z = you.z;
		temp_angle += orbit_speed * time_step;
		wait(1);
		if(timing_spawn <=0){
			ent_create("vijandspin.mdl", vector(my.x,my.y,my.z), vijand_spinnen);	
			timing_spawn = 20;
		}
	}
}


action stars_spider()
{
	set(my,INVISIBLE |PASSABLE);
	spider =me;
	on_space = begin_game;
	while(1)
	{
		camera.tilt = -90; 
		vec_set (camera.x, spider.x);
		camera.z = spider.z + 400; 
		if(game_enable ==3){
			ent_remove(me);
			break;
		}
		wait(1);
	}	
}

action spin_controle()
{
	set(my,SHADOW);
	spider = me;
	var idle_percentage = 0;
	var death_percentage =0;
	on_space = attack;
	ent_create("ball.mdl", nullvector, satellite); 
	while(health >0)
	{
		idle_percentage %= 100;
		idle_percentage += 5 * time_step;
		ent_animate(my, "idle", idle_percentage, ANM_CYCLE);
		camera.tilt = -90; 
		vec_set (camera.x, spider.x); 
		camera.z = spider.z + 400; 
		
		my.pan += 15 * (key_cul - key_cur) * time_step;
		wait(1);
	}
	ent_animate(my, "die", death_percentage, 0); 
	death_percentage += 0.5 * time_step; 
	wait (1);
	
	set(rs_pan,SHOW);
	game_enable =0;
	ent_remove(me);
	ent_create("playerspider.mdl", vector(0.037,-0.064,5.478),stars_spider);
}




function spider_hit()
{
	score +=10;
	set(my,TRANSLUCENT);
	my.alpha =100;
	my.tilt =180;
	my.event = NULL;
snd_play(die_snd,100,0);
	while(1)
	{
		my.alpha -=1*time_step;
		wait(1);
		ent_remove(me);
		break;
	}

}


action vijand_spinnen()
{
	set(my,METAL | PASSABLE);
	my.emask |= ENABLE_ENTITY | ENABLE_IMPACT; 
	my.event= spider_hit;
	var walk_percentage =0;
	var speed =0.5;
	while(1)
	{
		walk_percentage %= 100;
		walk_percentage += 3 * time_step;
		ent_animate(my, "walk", walk_percentage, ANM_CYCLE);
		c_move(my, vector(speed * time_step, 0, 0), nullvector, GLIDE | IGNORE_SPRITES);
		VECTOR temp;//declare temp vector
		vec_set(temp, spider.x);
		vec_sub(temp, my.x); 
		vec_to_angle(my.pan, temp); 
		wait(1);
		if(score >100){
			speed =1;
		}
		if(score >300){
			speed =2;
		}
		if(score >400){
			speed =4;
		}		
		if(score >500){
			speed =5;
		}
		if(score >600){
			speed =8;
		}
		if(vec_dist (my.x, spider.x) < 30){
			snd_play(die_snd,100,0);
			health -=10;
			spider_hit();
		}
		if(health <=0){
			set(my,PASSABLE | INVISIBLE);
			my.event = NULL;
			wait(1);
			ent_remove(me);
			break;
		}
	}
}
