/////////////////////////////////////////Z-roads template by RP-Interactive.nl 2016 Ren Pol.////////////////////////

/////////////////////////////////////////paths to the workfolder and subfolders//////////////////////////////////////

#define PRAGMA_PATH "3Dmodels"
#define PRAGMA_PATH "Graphics"
#define PRAGMA_PATH "Scripts"
#define PRAGMA_PATH "Sounds"

////////////////////////////////////////All variables used in game///////////////////////////////////////////////////

var soundtrack_handle;
var game_enable = 0;
var score =0;
var damage=279; 
var sound_on = 0;

FONT*	fnt3_pan = "Ariel Black#18bi"; 
PANEL* pan_score = {digits=885,10,"Score: %08.0f",fnt3_pan,1,score; 
	layer = 10;

	flags = SHOW;green=255; blue=0; red=255;
}


var zkills =0;

FONT*	fnt3_pan = "Ariel Black#18bi"; 
PANEL* pan_zkills = {digits=50,105,"Z-kills: %02.0f",fnt3_pan,1,zkills; 
	layer = 16;
	flags = SHOW;green=255; blue=0; red=255;
}

var stage =1;

FONT*	fnt3_pan = "Ariel Black#18bi"; 
PANEL* pan_stage = {digits=910,40,"Stage: %02.0f",fnt3_pan,1,stage; 
	layer = 10;
	flags = SHOW;green=255; blue=0; red=255;
}

var zbonus =0;

FONT*	fnt8_pan = "Ariel Black#28bi"; 
PANEL* pan_zbonus = {digits=495,285,"x:%02.0f",fnt8_pan,1,zbonus; 
	layer = 10;


}

//////////////////////////////////A simple skybox///////////////////////////////////////////////////////////////////

ENTITY* sky = 
{
	type = "skysunset+6.tga"; 
	flags2 = SKY | CUBE | SHOW;
}


/////////////////////////////////Entitie pointers///////////////////////////////////////////////////////////////////

ENTITY* zcar;


//////////////////////////////////Sounds defined and used in game//////////////////////////////////////////////////

SOUND* ding_snd = "ding.wav";
SOUND* explo2_snd = "explo2.wav";
SOUND* carengine_snd = "carengine.wav";
SOUND* zdead_snd = "zdead.wav";
SOUND* carhit_snd = "carhit.wav";
SOUND* blood_snd = "blood.wav";
SOUND* excel_snd = "excel.wav";
SOUND* wolf_snd = "wolf.wav";


////////////////////////////////Mouse cursor picture used///////////////////////////

BMAP* cursor_png = "pointer.png";

///////////////////////////////All panels graphics used defined/////////////////////

BMAP* flame_tga = "flame.tga";

BMAP* test_map = "bar.png";
PANEL* back_pan =
{
	hbar = 78, 739, 279,test_map, 1, damage;
	layer = 5;
	flags =  VISIBLE | OVERLAY; 
}

BMAP* menu_map = "menu.png"; 
PANEL* menu_pan =
{
	bmap = menu_map; 
	pos_x = 0;
	pos_y = 0;
	button (10, 600, "playbut02.png", "playbut01.png", "playbut01.png", begin_game, NULL, NULL); 
	layer = 21;
	flags = SHOW;
}


BMAP* break_map = "pause.png"; 
PANEL* break_pan =
{
	bmap = break_map; 
	pos_x = 380;
	pos_y = 300;
	layer = 5;
}


BMAP* gbar_map = "gbar.png"; 
PANEL* gbar_pan =
{
	bmap = gbar_map;
	pos_x = 10;
	pos_y = 715;
	layer = 5;
	flags = SHOW;
}


BMAP* bonus_map = "bonus.png"; 
PANEL* bonus_pan =
{
	bmap = bonus_map; 
	pos_x = 420;
	pos_y = 200;
	layer = 5;
}

BMAP* black_map = "black.png"; 
PANEL* black_pan =
{
	bmap = black_map; 
	pos_x = 0;
	pos_y = 0;
	layer = 25;
}

BMAP* logo_map = "logo.png"; 
PANEL* logo_pan =
{
	bmap = logo_map; 
	pos_x = 0;
	pos_y = 0;
	layer = 22;

}

BMAP* ga_map = "gameover.png"; 
PANEL* ga_pan =
{
	bmap = ga_map; 
	pos_x = 320;
	pos_y = 300;
	layer = 15;
}


BMAP* zombie_map = "zombief.png"; 
PANEL* zombie_pan =
{
	bmap = zombie_map; 
	pos_x = 25;
	pos_y = 10;
	layer = 15;
	flags = SHOW;
}

BMAP* zombieh_map = "zombief2.png"; 
PANEL* zombieh_pan =
{
	bmap = zombieh_map;
	pos_x = 25;
	pos_y = 10;
	layer = 16;
}


BMAP* three_map = "03.png"; 
PANEL* three_pan =
{
	bmap = three_map; 
	pos_x = 0;
	pos_y = 0;
	layer = 15;
}


BMAP* two_map = "02.png"; 
PANEL* two_pan =
{
	bmap = two_map;
	pos_x = 0;
	pos_y = 0;
	layer = 15;
}

BMAP* one_map = "01.png"; 

PANEL* one_pan =
{
	bmap = one_map; 
	pos_x = 0;
	pos_y = 0;
	layer = 15;
}

BMAP* go_map = "go.png"; 
PANEL* go_pan =
{
	bmap = go_map;
	pos_x = 0;
	pos_y = 0;
	layer = 15;
}


//////////////////////////////rear view mirror script///////////////////////////////

BMAP* mirror_map = "mirror.png"; 

PANEL* mirror_pan =
{
	bmap = mirror_map; // compass_map as panel background
	pos_x = 370;
	pos_y = 10;
	layer = 15;
	flags = SHOW;
}


VIEW* new_view =
{                
	pos_x = 370;
	pos_y = 10;	
	size_x = 280;		
	size_y = 100;		
	arc = 60;	
	layer = 4;
	flags = SHOW ;		
}

//////////////////////////////functions or actions that need to be preloaded////////

function begin_game();
function begin_newlevel();
function scoring_now();
action zombie_car();


/////////////////////////////fire particle code/////////////////////////////////////

var start_color[3]; 
var end_color[3];
var current_color[3]; 
var flame_lifespan = 10;

function vec_randomize(VECTOR* vec, var range){
	vec_set(vec, vector(random(1) - 0.5, random(1) - 0.5, random(1) - 0.5));
	vec_normalize(vec, random(range));
}

function flame_alphafade(PARTICLE* p){


	start_color[0] = 200;
	start_color[1] = 180;
	start_color[2] = 100;
	end_color[0] = 128;
	end_color[1] = 50;
	end_color[2] = 50;
	vec_lerp(current_color[0], end_color[0], start_color[0], p.lifespan / flame_lifespan);
	p.red = current_color[0];
	p.green = current_color[1];
	p.blue = current_color[2];
	p.alpha = p.lifespan / flame_lifespan * 100 * 0.3;
	if(p.alpha <= 0){ p.lifespan = 0; } 
}

function effect_flame(PARTICLE* p){
	
	VECTOR vTemp;
	vec_randomize(vTemp, 4 + random(1));
	vec_add(p.vel_x, vTemp);
	p.size = 15;
	p.bmap = flame_tga;
	p.gravity = -3; 
	p.lifespan = flame_lifespan;
	set(p, MOVE | BRIGHT | TRANSLUCENT);
	p.event = flame_alphafade;
}
/////////////////////////////Play animation sprite code//////////////////////////////////////////////////

function sprite_played()
{
	set (my, PASSABLE |TRANSLUCENT);
	my.scale_x = 0.5; 
	my.scale_y = my.scale_x; 
	my.ambient = 100;
	my.roll = random(360); 
	my.alpha = 100; 
	while (my.frame < 16) 
	{	
		my.frame += 1 * time_step; 
		wait (1);
	}
	while (my.alpha > 0) 
	{
		my.alpha -= 5 * time_step; 
		wait (1);
	}
	ent_remove (me);
}

///////////////////////////////////Level switching script function////////////////////////////////////////////////////////////////////////



function level_switch()
{

	set(black_pan,SHOW | TRANSLUCENT);
	black_pan.alpha = 0;
	while(black_pan.alpha <100){
		black_pan.alpha +=5*time_step;
		wait(1);
		
	}
	{
		
		reset(pan_zbonus,SHOW);
		reset(bonus_pan,SHOW);
		
		zbonus =0;
		stage +=1;
		wait(-1);
	}
	if(stage ==2){
		damage=279;
		game_enable = 0;
		level_load("stage002.WMB");	
		ent_create("zcar01.mdl", vector(-150,0,-5), zombie_car);
	}
	while(black_pan.alpha >0){
		black_pan.alpha -=5*time_step;
		wait(1);
		
	}

	begin_newlevel();
	
}

////////////////////////////////Score picture moving up and fading out script////////////////////////////////////////////////////////////


function score_up()
{
	my.tilt =90;
	my.pan= 180;
	my.alpha = 100;
	set(my,PASSABLE | TRANSLUCENT);
	while(1)
	{
		my.alpha -=1*time_step;
		my.x +=40*time_step;
		my.z +=1*time_step;
		wait(1);
		if(my.alpha <=0){
			ent_remove(me);
			break;
		}
	}
}



//////////////////////////////Start a new level script//////////////////////////////////////////////////////////////////////////////////




function begin_newlevel()
{

	wait(-1);
	snd_play(carengine_snd,150,0);
	set(three_pan,SHOW);
	wait(-1);
	reset(three_pan,SHOW);
	set(two_pan,SHOW);
	wait(-1);
	reset(two_pan,SHOW);
	set(one_pan,SHOW);
	wait(-1);
	reset(one_pan,SHOW);
	set(go_pan,SHOW);
	game_enable =1;
	wait(-1);
	reset(go_pan,SHOW);
}


////////////////////////////Begin a new game script////////////////////////////////////////////////////////////////////////////////////

function begin_game()
{
	set(black_pan,SHOW | TRANSLUCENT);
	black_pan.alpha = 0;
	mouse_mode = 0;
	while(black_pan.alpha <100){
		black_pan.alpha +=5*time_step;
		wait(1);
	}
	wait(-1);
	ent_create("zcar01.mdl", vector(-150,0,-5), zombie_car);
	
	reset(menu_pan,SHOW);
	while(black_pan.alpha >0){
		black_pan.alpha -=5*time_step;
		wait(1);
	}
	reset(black_pan,SHOW | TRANSLUCENT);
	wait(-1);
	snd_play(carengine_snd,150,0);
	set(three_pan,SHOW);
	wait(-1);
	reset(three_pan,SHOW);
	set(two_pan,SHOW);
	wait(-1);
	reset(two_pan,SHOW);
	set(one_pan,SHOW);
	wait(-1);
	reset(one_pan,SHOW);
	set(go_pan,SHOW);
	game_enable =1;
	wait(-1);
	reset(go_pan,SHOW);
}



////////////////////////////race out action at end level script/////////////////////////////////////////


action race_out()
{
	scoring_now();
	set(my,SHADOW | METAL | PASSABLE);
	my.pan = 0;
	while(1)
	{
		c_move(my, vector(35* time_step, 0, 0), nullvector, GLIDE | IGNORE_SPRITES | IGNORE_PASSABLE);
		wait(1);
	}
}

////////////////////////Function play scoring sound///////////////////////////////////////////////////

function play_sound()
{
	while(sound_on ==0)
	{
		snd_play(ding_snd,150,0);
		wait(-0.1);
	}
}

//////////////////////////////Function the scoring at end level script//////////////////////////////

function scoring_now()
{
	sound_on = 0;
	set(bonus_pan,SHOW);
	set(pan_zbonus,SHOW);
	play_sound();
	while(1)
	{
		zkills -=0.5*time_step;
		zbonus +=0.5*time_step;
		wait(1);
		if(zkills <0){
			zkills =0;
			sound_on =1;
			score = zbonus*100 +score;
			wait(-5);
			level_switch();
			break;
		}
	}
}

////////////////////////////////Function pause game script at press P key///////////////////////////

function pause_game()

{ 
	if(freeze_mode == 2) // all frozen??
	{
		freeze_mode = 0; // go on
		reset(break_pan,SHOW | TRANSLUCENT);
		media_start(soundtrack_handle);	
	}
	else
	{
		freeze_mode = 2; // pause
		set(break_pan,SHOW | TRANSLUCENT);
		media_pause(soundtrack_handle);
	}
} 

/////////////////////////////////The main function//////////////////////////////////////////////////


function main()
{
	mouse_pointer=0;
	shadow_stencil = 2;
	set(black_pan,SHOW|TRANSLUCENT);
	set(logo_pan,SHOW);
	video_set(1024,768,32,0);
	video_window(vector(0,0,0),vector(1024,768,0), 16, "Z-Roads by RP-Interactive, Ren Pol");
	level_load("Z-roads.WMB");
	black_pan.alpha = 100;
	while(black_pan.alpha >0){
		black_pan.alpha -=3*time_step;
		wait(1);
	}
	wait(-1);
	soundtrack_handle = media_loop("ingame.mp3", NULL, 200);
	while(black_pan.alpha <100){
		black_pan.alpha +=3*time_step;
		wait(1);
	}
	wait(-1);
	reset(logo_pan,SHOW);
	mouse_map = cursor_png;
	mouse_mode =3;
	
	while(black_pan.alpha >0){
		black_pan.alpha -=3*time_step;
		wait(1);
	}
	reset(black_pan,SHOW|TRANSLUCENT);
	on_p = pause_game;

}

//////////////////////////////Game over script/////////////////////////////////////////////////////


function game_over()
{

	wait(-5);
	set(black_pan,SHOW | TRANSLUCENT);
	black_pan.alpha = 0;
	while(black_pan.alpha <100){
		black_pan.alpha +=5*time_step;
		wait(1);
	}
	wait(-1);
	mouse_mode =3;
	set(menu_pan,SHOW);
	game_enable = 0;
	level_load("Z-roads.WMB");
	score = 0;
	zkills = 0;
	damage=279;
	reset(ga_pan,SHOW);
	while(black_pan.alpha >0){
		black_pan.alpha -=5*time_step;
		wait(1);
	}
	reset(black_pan,SHOW |TRANSLUCENT);
}


///////////////////////////action exploding car script///////////////////////////////////////////

action exploded()
{
	set(my,SHADOW | METAL);
	snd_play(explo2_snd,150,0);
	game_over();
	ent_create("Explosion+16.tga", vector(my.x,my.y,my.z), sprite_played);
	while(1)
	{
		effect(effect_flame, 1, my.x, nullvector);
		wait(1);
	}
}

////////////////////////Player car script/////////////////////////////////////////////////////////////////////////



action zombie_car()
{
	set(my,SHADOW | METAL);
	zcar = me;
	var speed = 25;
	c_setminmax(me);
	while(1)
	{
		while(game_enable ==1 && damage >0)
		{
			
			if(key_cul){
				my.pan = 6;
			}
			if(key_cur){
				my.pan = -6;
			}
			if(!key_cur && !key_cul){
				my.pan = 0;
			}
			damage -=0.6*time_step;
			my.y += 25 * (key_cul - key_cur) * time_step;
			my.y = clamp(my.y,-220,215);
			c_move(my, vector(speed* time_step, 0, 0), nullvector, GLIDE | IGNORE_SPRITES | IGNORE_PASSABLE);
			camera.tilt = -90; 
			camera.x = zcar.x+150;
			camera.z = zcar.z + 800; 
			new_view.tilt = -10;    
			new_view.pan =  -180;
			new_view.y = zcar.y;
			new_view.x =zcar.x-80;			 
			new_view.z = zcar.z+130; 
			wait (1);
			if(damage <=40){
				effect(effect_flame, 1, my.x, nullvector);
			}
			if(my.x >19441.801){
				set(zcar,INVISIBLE | PASSABLE);
				reset(zcar,SHADOW);
				ent_create("zcar01.mdl", vector(zcar.x,zcar.y,zcar.z),race_out);
				wait(1);
				ent_remove(zcar);
				return;	
			}
		}
		if(damage <1){
			set(my,INVISIBLE | PASSABLE);
			reset(my,SHADOW);
			snd_play(explo2_snd,150,0);
			ent_create("Explosion+16.tga", vector(zcar.x,zcar.y,zcar.z), sprite_played);
			ent_create("dcar.mdl", vector(zcar.x,zcar.y,zcar.z),exploded);
			wait(1);
			ent_remove(me);
			set(ga_pan,SHOW);
			break;
		}
		if(game_enable ==0)
		{
			
			new_view.tilt = -10;    
			new_view.pan = -180;
			new_view.y = zcar.y;
			new_view.x =zcar.x-80;			 
			new_view.z = zcar.z+130; 
			camera.tilt = -90; 
			camera.x = zcar.x+180;
			camera.z = zcar.z + 800; 
			wait (1);
		}	
	}
}



/////////////////////////////function fade out dead zomie///////////////////////////////////////////

function d_zombie()
{
	set(my,TRANSLUCENT | PASSABLE);
	my.alpha = 100;
	my.pan = integer(random(180));
	while(1)
	{
		my.alpha -=2*time_step;
		wait(1);
		if(my.alpha <=0){
			ent_remove(me);
			break;
		}
	}
}

//////////////////////////////function fade out lood puddle script///////////////////////////////////

function blood_pool()
{
	snd_play(zdead_snd,50,0);
	set(my,TRANSLUCENT | PASSABLE);
	my.alpha = 100;
	my.tilt = 90;
	my.pan = integer(random(180));
	while(1)
	{
		my.alpha -=1*time_step;
		wait(1);
		if(my.alpha <=0){
			ent_remove(me);
			break;
		}
	}
}

////////////////////////////function fade out tire tracks////////////////////////////////////////////

function track()
{

	set(my,TRANSLUCENT | PASSABLE);
	my.alpha = 100;
	my.tilt = 90;
	my.pan = zcar.pan;
	while(1)
	{
		my.alpha -=1*time_step;
		wait(1);
		if(my.alpha <=0){
			ent_remove(me);
			break;
		}
	}
}

////////////////////////////standing and walking zombie dead scripts on impact//////////////////////////////////////////////////////////////////////////




function zombie_impact()
{
	snd_play(carhit_snd,40,0);
	score+=100;
	set(zombieh_pan,SHOW);
	zkills +=1;
	set(my,INVISIBLE | PASSABLE);
	reset(my,SHADOW);
	ent_create("hundred.png", vector(my.x,my.y,my.z+50), score_up);
	ent_create("blood.png", vector(my.x,my.y,my.z-18), blood_pool);
	ent_create("dzombie.mdl", vector(my.x,my.y,my.z-14), d_zombie);
	wait(-0.3);
	snd_play(blood_snd,50,0);
	ent_create("track.png", vector(zcar.x-50,zcar.y+10,zcar.z), track);
	ent_create("track.png", vector(zcar.x-50,zcar.y-15,zcar.z), track);
	wait(1);
	ent_remove(me);
	wait(-0.2);
	reset(zombieh_pan,SHOW);

}

function zombie_impact2()
{
	if (event_type == EVENT_ENTITY)
	{
		snd_play(carhit_snd,80,0);
		ent_create("hundredf.png", vector(my.x,my.y,my.z+50), score_up);
		score+=250;
		set(zombieh_pan,SHOW);
		zkills +=1;
		set(my,INVISIBLE | PASSABLE);
		reset(my,SHADOW);
		ent_create("blood.png", vector(my.x,my.y,my.z-18), blood_pool);
		ent_create("dzombie.mdl", vector(my.x,my.y,my.z-14), d_zombie);
		wait(-0.3);
		snd_play(blood_snd,50,0);
		ent_create("track.png", vector(zcar.x-50,zcar.y+10,zcar.z), track);
		ent_create("track.png", vector(zcar.x-50,zcar.y-15,zcar.z), track);
		wait(1);
		ent_remove(me);
		wait(-0.2);
		reset(zombieh_pan,SHOW);
	}
	if (event_type == EVENT_IMPACT)
	{
		snd_play(carhit_snd,80,0);
		ent_create("hundredf.png", vector(my.x,my.y,my.z+50), score_up);
		score+=250;
		set(zombieh_pan,SHOW);
		zkills +=1;
		set(my,INVISIBLE | PASSABLE);
		reset(my,SHADOW);
		ent_create("blood.png", vector(my.x,my.y,my.z-18), blood_pool);
		ent_create("dzombie.mdl", vector(my.x,my.y,my.z-14), d_zombie);
		wait(-0.3);
		snd_play(blood_snd,50,0);
		ent_create("track.png", vector(zcar.x-50,zcar.y+10,zcar.z), track);
		ent_create("track.png", vector(zcar.x-50,zcar.y-15,zcar.z), track);
		wait(1);
		ent_remove(me);
		wait(-0.2);
		reset(zombieh_pan,SHOW);
	}
	if (event_type == EVENT_BLOCK)
	{
		my.pan +=180;
		
	}
}	


/////////////////////////////Action standing zombie//////////////////////////////

action standing_zombie()
{
	set(my,SHADOW);
	var stand_percentage;
	c_setminmax(me);
	my.emask |= ENABLE_ENTITY | ENABLE_IMPACT; 
	my.event= zombie_impact;
	while(!zcar){wait(1);
	}
	while(1)
	{
		stand_percentage %= 100;
		stand_percentage += 1 * time_step;
		ent_animate(my, "stand", stand_percentage, ANM_CYCLE);
		wait(1);
		if (my.x < zcar.x-2000){
			ent_remove(me);
			break;
		}
	}
}


///////////////////////////Action walking zombie////////////////////////////////


action walking_zombie()
{
	set(my,SHADOW);
	var walking_percentage;
	c_setminmax(me);
	my.emask |= ENABLE_ENTITY | ENABLE_IMPACT | ENABLE_BLOCK; 
	my.event= zombie_impact2;
	while(!zcar){wait(1);
	}
	while(1)
	{
		walking_percentage %= 100;
		walking_percentage += 2 * time_step;
		ent_animate(my, "run", walking_percentage, ANM_CYCLE);
		c_move(my, vector(1* time_step, 0, 0), nullvector, GLIDE | IGNORE_SPRITES | IGNORE_PASSABLE);
		wait(1);
		if (my.x < zcar.x-2000){
			ent_remove(me);
			break;
		}
	}
}

///////////////////////action fire object that hurts player car//////////////////


action fire_object()
{
	set(my,INVISIBLE | PASSABLE);
	while(!zcar){wait(1);
	}
	while(1)
	{
		if (vec_dist (my.x, zcar.x) < 30){
			snd_play(explo2_snd,150,0);
			ent_create("Explosion+16.tga", vector(zcar.x,zcar.y,zcar.z+20), sprite_played);
			ent_create("damage.png", vector(my.x,my.y,my.z+50), score_up);
			damage -=10;
			break;
		}
		effect(effect_flame, 1, my.x, nullvector);
		wait(1);
		if (my.x < zcar.x-2000){
			ent_remove(me);
			break;
		}
		
	}
}


//////////////////////action picking up fuel///////////////////////////////////////

action gass_tank()
{
	set(my,PASSABLE | BRIGHT | METAL | SHADOW);
	while(!zcar){wait(1);
	}
	while(1)
	{
		if (my.x < zcar.x-2000){
			ent_remove(me);
			break;
		}
		my.pan +=2*time_step;
		my.tilt +=2*time_step;
		if (vec_dist (zcar.x, my.x) < 30){
			damage +=25;
			ent_create("hundred.png", vector(my.x,my.y,my.z+50), score_up);
			
			snd_play(excel_snd,50,0);
			ent_remove(me);
			score +=100;
			break;
		}
		wait(1);
	}
}


/////////////////////function wolf dead on impact//////////////////////////////////


function wolf_impact()
{
	snd_play(carhit_snd,40,0);
	damage -=10;
	snd_play(wolf_snd,100,0);
	set(my,INVISIBLE | PASSABLE);
	reset(my,SHADOW);
	ent_create("damage.png", vector(my.x,my.y,my.z+50), score_up);
	ent_create("blood.png", vector(my.x,my.y,my.z-18), blood_pool);
	ent_create("dwolf.mdl", vector(my.x,my.y-20,my.z-14), d_zombie);
	wait(-0.3);
	snd_play(blood_snd,50,0);
	ent_create("track.png", vector(zcar.x-50,zcar.y+10,zcar.z), track);
	ent_create("track.png", vector(zcar.x-50,zcar.y-15,zcar.z), track);
	wait(1);
	ent_remove(me);
}


////////////////////action walking wolves///////////////////////////////////////////

action wolf()
{
	set(my,SHADOW);
	my.emask |= ENABLE_ENTITY | ENABLE_IMPACT; 
	my.event= wolf_impact;
	var stand3_percentage;
	var run3_percentage;
	c_setminmax(me);
	while(!zcar){wait(1);
	}
	while(1)
	{
		
		if(vec_dist (zcar.x, my.x) > 500){
			stand3_percentage %= 100;
			stand3_percentage += 2 * time_step;
			ent_animate(my, "stand", stand3_percentage, ANM_CYCLE);
			wait(1);
		}
		else
		{
			run3_percentage %= 100;
			run3_percentage += 10 * time_step;
			ent_animate(my, "run", run3_percentage, ANM_CYCLE);
			c_move(my, vector(10* time_step, 0, 0), nullvector, GLIDE | IGNORE_SPRITES | IGNORE_PASSABLE);
			wait(1);
		}
		if (my.x < zcar.x-2000){
			ent_remove(me);
			break;
		}
	}
}

//////////////////////////////////////////////////////////////////////////////////////