#		              Welcome to WildCat's SpaceTool!
#
#     This script is designed as a tool that can be used to fine tune flight characteristics
# 	 for players and enemies in a zero gravity environment. It is to be made freely
#	available to all users of 3D Game Studio.
#
#     The panels on this workshop were designed to work in 640x480 screen resolution
#	and this tool was created as a companion to the impending Space Flight
#	workshop. Set the flags and move the sliders until you get the desired flight 
#	characteristics. Use different camera angles to inspect your ships performance.
#	When you are pleased with the flight profile, you can take the numbers and flag
#	settings directly from the screen and plug them in to the skills and flags of each
#	flying entity to customize their performance when using the Space Flight Workshop 
#	Script.
#
#     Contols are very simple:
#	Use Left and Right arrows to pan your ship
#	Use Up and Down arrows to control your ship's Tilt
#	Use the SPACE BAR to fire engines
#	Use mouse and Left-Click Flags in panels, or Drag sliders to new positions.
#	USE PF1 key to toggle panels On/Off
#     
///////////////////////////////////////////////////////////////////////////////////
// 	A4 main wdl
///////////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
PATH	"models";	// Path to model subdirectory - if any
PATH	"sounds";	// Path to sound subdirectory - if any
PATH	"bmaps";	// Path to graphics subdirectory - if any
PATH	"images";	// Path to images subdirectory
PATH	"..\\template";	// Path to WDL templates subdirectory


VAR VIDEO_MODE = 6;		// 640x480
VAR VIDEO_DEPTH = 16;		// D3D, 16 bit resolution
VAR FPS_MAX = 40;		// 40 fps max


// The MAIN function is called at game start and gets everything going

FUNCTION  MAIN()
{
 	LOAD_LEVEL <SPACELV2.WMB>;
	WAIT 16;
	MOUSE_TOGGLE();
}


//////////////////////////////////////////////////////////////////////////////
// 	SPACE SCRIPT BEGINS HERE
//////////////////////////////////////////////////////////////////////////////

// Sounds:
   VAR THRUST_HANDLE = 0;
   SOUND THRUSTERS,<THRUSTER.WAV>;
   VAR ENGINE_HANDLE = 0;
   SOUND MAIN_ENGINES,<ENGINE.WAV>;

// Synonyms:
  SYNONYM PLAYER_SHIP {TYPE ENTITY;}
  SYNONYM STAR_SPHERE {TYPE ENTITY;}

//Images go here:

  BMAP SMALL_WILDCAT,<WST.PCX>;
  BMAP CAMERA_SELECTIONS,<CAMSTAT.PCX>;
  BMAP CAMBUT_STAT_OFF,<STATBUTD.PCX>;
  BMAP CAMBUT_STAT_ON,<STATBUT.PCX>;
  BMAP CAMBUT_CHASE_OFF,<CHASED.PCX>;
  BMAP CAMBUT_CHASE_ON,<CHASE.PCX>;
  BMAP CAMBUT_COCKP_OFF,<COCKPITD.PCX>;
  BMAP CAMBUT_COCKP_ON,<COCKPIT.PCX>;
  BMAP CAMBUT_CHECK,<CHECK.PCX>;
  BMAP FLAG_SELECTIONS,<CONTFLAG2.PCX>;
  BMAP FLAG_SPIN_ON,<SPINC.PCX>;
  BMAP FLAG_SPIN_OFF,<SPINCD.PCX>;
  BMAP FLAG_DECEL_ON,<DECEL.PCX>;
  BMAP FLAG_DECEL_OFF,<DECELD.PCX>;
  BMAP FLAG_TURNLMT_ON,<TLIMIT.PCX>;
  BMAP FLAG_TURNLMT_OFF,<TLIMITD.PCX>;
  BMAP FLAG_SPEEDLMT_ON,<SLIMIT.PCX>;
  BMAP FLAG_SPEEDLMT_OFF,<SLIMITD.PCX>;
  BMAP FLAG_ON,<ON.PCX>;
  BMAP SLIDER,<SLIDER.PCX>;
  BMAP PROFILE_SELECTIONS,<FPROFILE.PCX>;
  BMAP QUIT_BUTTON_ON,<QUIT.PCX>;
  BMAP QUIT_BUTTON_OFF,<QUITD.PCX>;
  BMAP RESET_BUTTON_ON,<RESET.PCX>;
  BMAP RESET_BUTTON_OFF,<RESETD.PCX>;
  BMAP ARROW,<ARROW.PCX>;


FONT NUMBER_FONT,<BOOKMAN8.PCX>,8,14;	// Numeric font for screen display


// The ACCEL_VECTOR tells the ship in which direction the thrust from the engines
// is coming. Because the ship was built with it's front pointing down the "X" axis, the
// thrust from the engine will always act on the "X" component of the ACCEL_VECTOR,
// which I have renamed ENGINE_THRUST for clarity.

	DEFINE ACCEL_VECTOR,SKILL1;
	DEFINE ENGINE_THRUST,SKILL1;		


// While the ACCEL_VECTOR applies thrust relative to the SHIP'S orientation,
// the DRIFT_VECTOR applies the existing speed relative to the worlds orientation.
// Orientation for both ACCEL_VECTOR and DRIFT_VECTOR are set based on
// their usage in the MOVE command in the PLAYER_SPACESHIP action.

	DEFINE DRIFT_VECTOR,SKILL4;
	DEFINE DRIFT_VECTOR_X,SKILL4;
	DEFINE DRIFT_VECTOR_Y,SKILL5;
	DEFINE DRIFT_VECTOR_Z,SKILL6;

	DEFINE PAN_SPEED,SKILL7;	// How fast you are panning
	DEFINE TILT_SPEED,SKILL8;	// How fast you are tilting
	DEFINE SPIN_RATE,SKILL9;	// The acceleration of your spin


// *** Note: While the coefficient of friction in space is for all practical purposes **ZERO**, using a small value
//	  in DECEL_RATE or putting a cap on the ships speed and spin can make it much easier to handle 
//	  the ship or tune your game play. Think of it as the Navigation computer automatically taking the.
//	  appropriate actions when the ship is not under active control.These fields are used when their 
//	  corresponding flag is turned on.

	DEFINE DECEL_RATE,SKILL10;	   // How fast "Friction" (or retro-rockets!) will slow you down
	DEFINE MAX_SPIN_SPEED,SKILL11;     // Cap for  turn speed if LIMIT_TURN_SPEED flag is set
	DEFINE MAX_SHIP_SPEED,SKILL12;     // Cap for ship speed if LIMIT_TOP_SPEED flag is set
	

//*** Define Flags for space ship flight characteristics
	DEFINE AUTO_SPIN_STOP,FLAG1;	//    These flags should all be off for
	DEFINE AUTO_DECEL,FLAG2;	//    maximum realism, but can be
	DEFINE LIMIT_TURN_SPEED,FLAG3;	//    useful to make a ship "Handle"
	DEFINE LIMIT_TOP_SPEED,FLAG4;	//    better.


DEFINE STAR_SKY,<SKY.MDL>;		// SPHERE MODEL WITH STARFIELD




// ************ Working Variables start here *******************
VAR SHIP_ANGS[3];
VAR ENGINE_WORK_SPEED[3];

// Starting flight Characteristics for ship:
 VAR WORK_ENGINE_THRUST = .5;		// Strength of the main engines 
 VAR WORK_SPIN_RATE = .15;		// Srength of the steering thrusters
 VAR WORK_MAX_SPIN_SPEED = 15;		// Top speed for changes in ships orientation
 VAR WORK_MAX_SHIP_SPEED = 20;	// Top speed the ship can go
 VAR WORK_DECEL_RATE = .04;		// "Drift" deceleration rate

//String work areas for displaying decimal values on panels
 STRING ST_ENGINE_THRUST,"        ";
 STRING ST_DECEL_RATE,"        ";
 STRING ST_SPIN_RATE,"        ";
 STRING ST_MAX_SPIN_SPEED,"        ";
 STRING ST_MAX_SHIP_SPEED,"        ";

// Camera Variables
  VAR CAMERA_TYPE = 1;	// 1 = Chase Cam, 2 = Cockpit, 3 = Stationary
  VAR CAMERA_SPOT[3];
  VAR WORKANG[3];

VAR PANEL_STATUS = 1;		// 0 = hide panels, 1 = Display Panels 


//********************** TITLE PANEL *************************
	PANEL TITLE_PANEL{
		BMAP SMALL_WILDCAT;
		POS_X 0;
		POS_Y 0;
		LAYER 2;
		FLAGS = VISIBLE, TRANSPARENT, REFRESH;}


//********************** CAMERA PANEL *************************
	PANEL CAMERA_PANEL{
		BMAP CAMERA_SELECTIONS;
		POS_X 510;
		POS_Y 00;
		LAYER 2;
		BUTTON = 25,16,CAMBUT_CHASE_ON,CAMBUT_CHASE_OFF,CAMBUT_CHASE_ON,CAM_SEL,NULL,NULL;
		BUTTON = 25,34,CAMBUT_COCKP_ON,CAMBUT_COCKP_OFF,CAMBUT_COCKP_ON,CAM_SEL,NULL,NULL;
		BUTTON = 25,52,CAMBUT_STAT_ON,CAMBUT_STAT_OFF,CAMBUT_STAT_ON,CAM_SEL,NULL,NULL;
		FLAGS = VISIBLE, TRANSPARENT, REFRESH;}

//********************** CHECK PANEL *************************
	PANEL CHECK_PANEL{
		BMAP CAMBUT_CHECK;
		POS_X 515;
		POS_Y 20;
		LAYER 3;
		FLAGS = VISIBLE, TRANSPARENT, REFRESH;}

//********************** FLAG PANEL *************************
	PANEL FLAG_PANEL{
		BMAP FLAG_SELECTIONS;
		POS_X 510;
		POS_Y 130;
		LAYER 2;
		BUTTON = 10,20,FLAG_SPIN_ON,FLAG_SPIN_OFF,FLAG_SPIN_ON,FLAG_SEL,NULL,NULL;
		BUTTON = 10,35,FLAG_DECEL_ON,FLAG_DECEL_OFF,FLAG_DECEL_ON,FLAG_SEL,NULL,NULL;
		BUTTON = 09,50,FLAG_TURNLMT_ON,FLAG_TURNLMT_OFF,FLAG_TURNLMT_ON,FLAG_SEL,NULL,NULL;
		BUTTON = 10,65,FLAG_SPEEDLMT_ON,FLAG_SPEEDLMT_OFF,FLAG_SPEEDLMT_ON,FLAG_SEL,NULL,NULL;
		FLAGS = VISIBLE, TRANSPARENT, REFRESH;}

//********************** "ON" PANELS *************************
	PANEL ON1_PANEL{
		BMAP FLAG_ON;
		POS_X 610;
		POS_Y 155;
		LAYER 3;
		FLAGS = VISIBLE, TRANSPARENT, REFRESH;}

	PANEL ON2_PANEL{
		BMAP FLAG_ON;
		POS_X 610;
		POS_Y 170;
		LAYER 3;
		FLAGS = VISIBLE, TRANSPARENT, REFRESH;}

	PANEL ON3_PANEL{
		BMAP FLAG_ON;
		POS_X 610;
		POS_Y 185;
		LAYER 3;
		FLAGS = VISIBLE, TRANSPARENT, REFRESH;}

	PANEL ON4_PANEL{
		BMAP FLAG_ON;
		POS_X 610;
		POS_Y 200;
		LAYER 3;
		FLAGS = VISIBLE, TRANSPARENT, REFRESH;}


//********************** PROFILE PANEL *************************
	PANEL PROFILE_PANEL{
		BMAP PROFILE_SELECTIONS;
		POS_X 385;
		POS_Y 322;
		LAYER 2;
		HSLIDER = 140,27,50,SLIDER,0,2,WORK_ENGINE_THRUST;
		HSLIDER = 140,52,50,SLIDER,0,1,WORK_DECEL_RATE;
		HSLIDER = 140,77,50,SLIDER,0,.5,WORK_SPIN_RATE;
		HSLIDER = 140,102,50,SLIDER,0,50,WORK_MAX_SPIN_SPEED;
		HSLIDER = 140,127,50,SLIDER,0,50,WORK_MAX_SHIP_SPEED;
		FLAGS = VISIBLE, TRANSPARENT, REFRESH;}


//********************** QUIT PANEL *************************
	PANEL QUIT_PANEL{
		BMAP QUIT_BUTTON_OFF;
		POS_X 10;
		POS_Y 440;
		LAYER 2;
		BUTTON = 0,0,QUIT_BUTTON_ON,QUIT_BUTTON_OFF,QUIT_BUTTON_ON,EXIT_GAME,NULL,NULL;
		FLAGS = VISIBLE, TRANSPARENT, REFRESH;}


//********************** RESET PANEL *************************
	PANEL RESET_PANEL{
		BMAP RESET_BUTTON_OFF;
		POS_X 230;
		POS_Y 440;
		LAYER 2;
		BUTTON = 0,0,RESET_BUTTON_ON,RESET_BUTTON_OFF,RESET_BUTTON_ON,RESET_PLAYER,NULL,NULL;
		FLAGS = VISIBLE, TRANSPARENT, REFRESH;}


//********************** ENGINE TEXT STARTS HERE *************************
	TEXT TXT_ENG_THRUST
{
		POS_X 592;
		POS_Y 349;
		LAYER 3;
		FONT number_font;
		STRING ST_ENGINE_THRUST;
		FLAGS = VISIBLE;
}


//********************** ENGINE DECEL STARTS HERE *************************
	TEXT TXT_DECEL_RATE
{
		POS_X 592;
		POS_Y 375;
		LAYER 3;
		FONT NUMBER_FONT;
		STRING ST_DECEL_RATE;
		FLAGS = VISIBLE;
}


//********************** SPIN RATE STARTS HERE *************************
	TEXT TXT_SPIN_RATE
{
		POS_X 592;
		POS_Y 401;
		LAYER 3;
		FONT NUMBER_FONT;
		STRING ST_SPIN_RATE;
		FLAGS = VISIBLE;
}


//********************** SPIN LIMIT STARTS HERE *************************
	TEXT TXT_SPIN_LIMIT
{
		POS_X 592;
		POS_Y 426;
		LAYER 3;
		FONT NUMBER_FONT;
		STRING ST_MAX_SPIN_SPEED;
		FLAGS = VISIBLE;
}


//********************** SPEED LIMIT STARTS HERE *************************
	TEXT TXT_SPEED_LIMIT
{
		POS_X 592;
		POS_Y 452;
		LAYER 3;
		FONT NUMBER_FONT;
		STRING ST_MAX_SHIP_SPEED;
		FLAGS = VISIBLE;
}


ACTION EXIT_GAME
{
	EXIT	"3D GameStudio (c) conitec 1999\n";
}


ACTION mouse_toggle { 		// switches the mouse on and off
	MOUSE_MODE += 2;
	IF (MOUSE_MODE > 2) {	// was it already on?
		MOUSE_MODE = 0;		// mouse off
	} ELSE {
		BRANCH mouse_on;
	}
}

ACTION mouse_on { 		// switches the mouse on
	SET MOUSE_MAP,arrow;
	WHILE (MOUSE_MODE > 0) {
IFDEF ACKNEX_VERSION414;	// This version suports the true mouse cursor
		MOUSE_POS.X = POINTER.X;
		MOUSE_POS.Y = POINTER.Y;
IFELSE;
		MOUSE_POS.X += MICKEY.X;
		MOUSE_POS.Y += MICKEY.Y;
ENDIF;
		WAIT	1; 		      // now move it over the screen
	}
}


ACTION SPACE_SPHERE
{
	STAR_SPHERE = ME;
	MY.SCALE_X = 10;	// it's a BIG star Sphere
	MY.SCALE_Y = 10;
	MY.SCALE_Z = 10;
	
	WHILE (1)	// Constantly keep the player at the center of the universe
	{
		VEC_SET(MY.POS,PLAYER_SHIP.POS);
		WAIT 1;
	}
}


ACTION PLAYER_SPACESHIP
{ 

// Set Synonym for future use and Zero out all ship speeds
 	PLAYER_SHIP = ME;	
	MY.NARROW = ON;
	MY.SCALE_X = 5;
	MY.SCALE_Y = 2;
	MY.SCALE_Z = 2;
	VEC_SET(MY.ACCEL_VECTOR,NULLVECTOR);	// No starting speed
	VEC_SET(MY.DRIFT_VECTOR,NULLVECTOR);	// No starting momentum
	CREATE STAR_SKY,MY.POS,SPACE_SPHERE;	// Initialize background stars

// Turn all special flight characteristics on to start
	MY.AUTO_SPIN_STOP = 1;
	MY.AUTO_DECEL = 1;
	MY.LIMIT_TURN_SPEED = 1;
	MY.LIMIT_TOP_SPEED = 1;

	WHILE (1) {

// Update engine Characteristics for Ship from panel
	UPDATE_ENGINE_CHARACTERISTICS();

// Update the Panels with the decimal display of the numbers entered
	UPDATE_PANEL_DISPLAY();

//*****Turning thruster logic here:

#	If you fire a thruster and you are using LIMIT_TURN_SPEEDS then check
#	    to make sure you are still under the speed limit

		IF (KEY_CUL == 1) 
		    {IF ((MY.LIMIT_TURN_SPEED == 0) ||
		           (MY.LIMIT_TURN_SPEED == 1) &&
		           (MY.PAN_SPEED < MY.MAX_SPIN_SPEED))
			{MY.PAN_SPEED += MY.SPIN_RATE;
			  IF (THRUST_HANDLE == 0)	// no sound playing
			      {PLAY_LOOP THRUSTERS,15;
			        THRUST_HANDLE = RESULT;}}}

		IF (KEY_CUR == 1) 
		    {IF ((MY.LIMIT_TURN_SPEED == 0) ||
		           (MY.LIMIT_TURN_SPEED == 1) &&
		           (MY.PAN_SPEED > -MY.MAX_SPIN_SPEED))
			{MY.PAN_SPEED -= MY.SPIN_RATE;
			  IF (THRUST_HANDLE == 0)	// no sound playing
			      {PLAY_LOOP THRUSTERS,15;
			        THRUST_HANDLE = RESULT;}}}

		IF (KEY_CUU == 1) 
		    {IF ((MY.LIMIT_TURN_SPEED == 0) ||
		           (MY.LIMIT_TURN_SPEED == 1) &&
		           (MY.TILT_SPEED < MY.MAX_SPIN_SPEED))
			{MY.TILT_SPEED += MY.SPIN_RATE;
			  IF (THRUST_HANDLE == 0)	// no sound playing
			      {PLAY_LOOP THRUSTERS,15;
			        THRUST_HANDLE = RESULT;}}}

		IF (KEY_CUD == 1) 
		    {IF ((MY.LIMIT_TURN_SPEED == 0) ||
		           (MY.LIMIT_TURN_SPEED == 1) &&
		           (MY.TILT_SPEED > -MY.MAX_SPIN_SPEED))
			{MY.TILT_SPEED -= MY.SPIN_RATE;
			  IF (THRUST_HANDLE == 0)	// no sound playing
			      {PLAY_LOOP THRUSTERS,15;
			        THRUST_HANDLE = RESULT;}}}

		IF ((THRUST_HANDLE != 0)	&& // If sound is playing...
			(KEY_CUU == 0) &&	
			(KEY_CUD == 0) &&  //        ...and...
			(KEY_CUL == 0) &&	
			(KEY_CUR == 0))	  //  No arrow keys were pressed
				{STOP_SOUND THRUST_HANDLE ;// stop the sound
				 THRUST_HANDLE = 0;}

//******* If using Auto_Spin_Stop, Stop spinning when not actively stearing.

		IF (MY.AUTO_SPIN_STOP == 1)
			{STOP_ROTATION();}


//********Main Engine firing is here: 

		IF (KEY_SPACE == 1) 		// if the space bar is pressed
		       {IF (ENGINE_HANDLE == 0)	// If no sound playing, then play
			   {PLAY_LOOP MAIN_ENGINES,25;
			        ENGINE_HANDLE = RESULT;}

	// 1) Set ENGINE_WORK_SPEED to the current thrust
	// 2) Vec_rotate will convert the thrust relative to the ship's orientation (which is only the x axis)
	//         and convert it into the X,Y,& Z components relative to the world's orientation
	// 3) TIME correct all components of thrust using the VEC_SCALE command

			VEC_SET(ENGINE_WORK_SPEED,MY.ENGINE_THRUST);
			VEC_ROTATE(ENGINE_WORK_SPEED,MY.PAN);
			VEC_SCALE(ENGINE_WORK_SPEED,TIME);

	// If there is no speed limit, then apply the thrust, If there is a speed limit, apply only the 
	//    components of thrust that have not maxed out
			IF (MY.LIMIT_TOP_SPEED == 0)
				{VEC_ADD(MY.DRIFT_VECTOR,ENGINE_WORK_SPEED);}
			ELSE
				{IF (ABS(ENGINE_WORK_SPEED.X + MY.DRIFT_VECTOR_X) < MY.MAX_SHIP_SPEED)
				     {MY.DRIFT_VECTOR_X += ENGINE_WORK_SPEED.X;}

				 IF (ABS(ENGINE_WORK_SPEED.Y + MY.DRIFT_VECTOR_Y) < MY.MAX_SHIP_SPEED)
				     {MY.DRIFT_VECTOR_Y += ENGINE_WORK_SPEED.Y;}

				 IF (ABS(ENGINE_WORK_SPEED.Z + MY.DRIFT_VECTOR_Z) < MY.MAX_SHIP_SPEED)
	 			     {MY.DRIFT_VECTOR_Z += ENGINE_WORK_SPEED.Z;}}}
		ELSE
			{STOP_SOUND ENGINE_HANDLE ;// stop playing sound
			 ENGINE_HANDLE = 0;}

	//**** Set it all in motion
		SHIP_ANGS.PAN = MY.PAN_SPEED * TIME;	// Time correct pan rate
		SHIP_ANGS.TILT = MY.TILT_SPEED * TIME;	// Time correct tilt rate
		SHIP_ANGS.ROLL = 0;			// We don't use ROLL as an active control

		ROTATE ME,SHIP_ANGS,NULLVECTOR;	// Rotate the ship based on our pan and tilt rates

	// If you are not actively firing the engines, and Auto_decel is active, slow down the ship
		IF ((KEY_SPACE != 1) && (MY.AUTO_DECEL == 1))
			{CALL DECEL_SHIP;}

    		MOVE ME,NULLVECTOR,MY.DRIFT_VECTOR; // Then move the ship according to Acceleration and Drift
		
		POINT_CAMERA();				// Adjust the camera
 		WAIT 1;}
}


FUNCTION STOP_ROTATION()
{
//   **** If you are still rotating, apply a rotation in the opposite direction to slow down
//          It will be time corrected in the PLAYER_SPACESHIP routine.
//
	IF (PLAYER_SHIP.PAN_SPEED == 0)
	    {GOTO CHECKTILT;}
	ELSE
	    {IF ((KEY_CUL == 0) && (KEY_CUR == 0))	
		{IF (PLAYER_SHIP.PAN_SPEED > 0)
		    {PLAYER_SHIP.PAN_SPEED -= PLAYER_SHIP.SPIN_RATE;}
		 ELSE
		    {PLAYER_SHIP.PAN_SPEED += PLAYER_SHIP.SPIN_RATE;}}}

CHECKTILT:

	IF (PLAYER_SHIP.TILT_SPEED == 0)
	    {RETURN;}
	ELSE
	    {IF ((KEY_CUU == 0) && (KEY_CUD == 0))	
		{IF (PLAYER_SHIP.TILT_SPEED > 0)
		    {PLAYER_SHIP.TILT_SPEED -= PLAYER_SHIP.SPIN_RATE;}
		 ELSE
		    {PLAYER_SHIP.TILT_SPEED += PLAYER_SHIP.SPIN_RATE;}}}
}


FUNCTION UPDATE_ENGINE_CHARACTERISTICS()
{
//    **** Change the real values based on the slider values
	MY.ENGINE_THRUST = WORK_ENGINE_THRUST;	// Strength of the main engines
	MY.SPIN_RATE = WORK_SPIN_RATE;		// Srength of the steering thrusters
	MY.MAX_SPIN_SPEED = WORK_MAX_SPIN_SPEED;	// Top speed for changes in ships orientation
	MY.MAX_SHIP_SPEED = WORK_MAX_SHIP_SPEED;	// Top speed the ship can go
	MY.DECEL_RATE = WORK_DECEL_RATE;		// Set the deceleration rate
}


FUNCTION UPDATE_PANEL_DISPLAY()
{
//    *** Convert the Decimal numbers from the sliders into a string format for Display ***
	STR_FOR_NUM(ST_ENGINE_THRUST,WORK_ENGINE_THRUST);
	STR_FOR_NUM(ST_DECEL_RATE,WORK_DECEL_RATE);
	STR_FOR_NUM(ST_SPIN_RATE,WORK_SPIN_RATE);
	STR_FOR_NUM(ST_MAX_SPIN_SPEED,WORK_MAX_SPIN_SPEED);
	STR_FOR_NUM(ST_MAX_SHIP_SPEED,WORK_MAX_SHIP_SPEED);
}


ACTION DECEL_SHIP
{
// *** If you have momentum:
//   1) Set ENGINE_WORK_SPEED to have the decel rate as it's "X" component of thrust
//		(It's negative because we are counter-thrusting to slow down, not thrusting to speed up)
//   2) Figure out the pan and tilt angles that correspond to the existing drift vector using Vec_to_angle
//   3) Use Vec_Rotate to convert the thrust from the Ship's perspective to the real world's perspective
//   4) Use the Vec_Scale command to time correct these speeds based on frame rate
//   5) Add this new "Deceleration Vector of thrust" to the existing Drift Vector, so that you slow down

	IF (VEC_LENGTH(PLAYER_SHIP.DRIFT_VECTOR) != 0)
		{VEC_SET(ENGINE_WORK_SPEED,NULLVECTOR);
		 ENGINE_WORK_SPEED.X = -PLAYER_SHIP.DECEL_RATE;
		 VEC_TO_ANGLE(SHIP_ANGS.PAN,PLAYER_SHIP.DRIFT_VECTOR);
		 VEC_ROTATE(ENGINE_WORK_SPEED,SHIP_ANGS.PAN);
		 VEC_SCALE(ENGINE_WORK_SPEED,TIME);
		 VEC_ADD(MY.DRIFT_VECTOR,ENGINE_WORK_SPEED);}

// *** If DRIFT_VECTOR is close enough to zero, call it zero
	IF (VEC_LENGTH(PLAYER_SHIP.DRIFT_VECTOR) > -.02) &&
	    (VEC_LENGTH(PLAYER_SHIP.DRIFT_VECTOR) < .02)
	   	{VEC_SET(PLAYER_SHIP.DRIFT_VECTOR,NULLVECTOR);}
}


FUNCTION CAM_SEL(BUTTON_NUMBER)
{
	CAMERA_TYPE = BUTTON_NUMBER;	// Set the camera mode
}


FUNCTION FLAG_SEL(BUTTON_NUMBER)
{
//     *** This will toggle visible and status flags on the "ON" indicators
	IF (BUTTON_NUMBER == 1)
		{IF (PLAYER_SHIP.AUTO_SPIN_STOP == 1)
			{PLAYER_SHIP.AUTO_SPIN_STOP = 0;
			 ON1_PANEL.VISIBLE = 0;}
		 ELSE
			{PLAYER_SHIP.AUTO_SPIN_STOP = 1;
			 ON1_PANEL.VISIBLE = 1;}}

	IF (BUTTON_NUMBER == 2)
		{IF (PLAYER_SHIP.AUTO_DECEL == 1)
			{PLAYER_SHIP.AUTO_DECEL = 0;
			 ON2_PANEL.VISIBLE = 0;}
		 ELSE
			{PLAYER_SHIP.AUTO_DECEL = 1;
			 ON2_PANEL.VISIBLE = 1;}}

	IF (BUTTON_NUMBER == 3)
		{IF (PLAYER_SHIP.LIMIT_TURN_SPEED == 1)
			{PLAYER_SHIP.LIMIT_TURN_SPEED = 0;
			 ON3_PANEL.VISIBLE = 0;}
		 ELSE
			{PLAYER_SHIP.LIMIT_TURN_SPEED = 1;
			 ON3_PANEL.VISIBLE = 1;}}

	IF (BUTTON_NUMBER == 4)
		{IF (PLAYER_SHIP.LIMIT_TOP_SPEED == 1)
			{PLAYER_SHIP.LIMIT_TOP_SPEED = 0;
			 ON4_PANEL.VISIBLE = 0;}
		 ELSE
			{PLAYER_SHIP.LIMIT_TOP_SPEED = 1;
			 ON4_PANEL.VISIBLE = 1;}}
}


FUNCTION RESET_PLAYER()
{
	CAMERA_TYPE = 1;
	VEC_SET(PLAYER_SHIP.ACCEL_VECTOR,NULLVECTOR);		// No starting speed
	VEC_SET(PLAYER_SHIP.DRIFT_VECTOR,NULLVECTOR);		// No starting momentum
	VEC_SET(PLAYER_SHIP.X,NULLVECTOR);			// Start at 0,0,0
	VEC_SET(PLAYER_SHIP.PAN,NULLVECTOR);			// Point in original direction
}


ACTION TOGGLE_PANELS
{
	IF (PANEL_STATUS == 1)		// Then make all panels invisible
	       {	CAMERA_PANEL.VISIBLE = OFF;
		CHECK_PANEL.VISIBLE = OFF;
		FLAG_PANEL.VISIBLE = OFF;
		ON1_PANEL.VISIBLE = OFF;
		ON2_PANEL.VISIBLE = OFF;
		ON3_PANEL.VISIBLE = OFF;
		ON4_PANEL.VISIBLE = OFF;
		PROFILE_PANEL.VISIBLE = OFF;
		TXT_ENG_THRUST.VISIBLE = OFF;
		TXT_DECEL_RATE.VISIBLE = OFF;
		TXT_SPIN_RATE.VISIBLE = OFF;
		TXT_SPIN_LIMIT.VISIBLE = OFF;
		TXT_SPEED_LIMIT.VISIBLE = OFF;
		RESET_PANEL.POS_X = 570;
		PANEL_STATUS = 0;}
	ELSE
	       {	CAMERA_PANEL.VISIBLE = ON;
		CHECK_PANEL.VISIBLE = ON;
		FLAG_PANEL.VISIBLE = ON;

//	***Only turn the "ON" indicators on that are active ****
		IF (PLAYER_SHIP.AUTO_SPIN_STOP == 1) 
			{ON1_PANEL.VISIBLE = ON;}
		IF (PLAYER_SHIP.AUTO_DECEL == 1)
			{ON2_PANEL.VISIBLE = ON;}
		IF (PLAYER_SHIP.LIMIT_TURN_SPEED == 1)
			{ON3_PANEL.VISIBLE = ON;}
		IF (PLAYER_SHIP.LIMIT_TOP_SPEED == 1)
			{ON4_PANEL.VISIBLE = ON;}

		PROFILE_PANEL.VISIBLE = ON;
		TXT_ENG_THRUST.VISIBLE = ON;
		TXT_DECEL_RATE.VISIBLE = ON;
		TXT_SPIN_RATE.VISIBLE = ON;
		TXT_SPIN_LIMIT.VISIBLE = ON;
		TXT_SPEED_LIMIT.VISIBLE = ON;
		RESET_PANEL.POS_X = 230;
		PANEL_STATUS = 1;}
}

VAR C1[3];
VAR C2[3];
VAR TEMPA[3];
VAR CAMERA_WORK;

ACTION POINT_CAMERA
{
	IF (CAMERA_TYPE == 2)
		{GOTO COCKPIT;}

	IF (CAMERA_TYPE == 3)
		{GOTO STATIONARY;}

// Begin Chase Camera code:	(NOTE: The Chase Cam portion of this script was donated by JCL.
//				 It is currently somewhat rough, and I don't understand enough
//				 about how it works to attempt to explain it. Please direct questions 
//				 about this section of code to him.)

	CAMERA.GENIUS = NULL;			// Camera won't ignore anyone
	CHECK_PANEL.POS_Y = 18;		// Move Check Mark on panel to this camera mode
	VEC_SET(WORKANG.PAN,PLAYER_SHIP.PAN);
	CAMERA_SPOT.X = -200;			// Relative displacement of camera to
	CAMERA_SPOT.Y = 0;			//     ship when in chase mode
	CAMERA_SPOT.Z = 80;

	VEC_SET(CAMERA.X,CAMERA_SPOT.X);
	VEC_ROTATE(CAMERA.X,PLAYER_SHIP.PAN);
	VEC_ADD(CAMERA.X,PLAYER_SHIP.X);	

// SET CAMERA PAN AND TILT ANGLES
	VEC_SET (TEMPA.X,PLAYER_SHIP.X);
	VEC_SUB (TEMPA.X,CAMERA.X);
	VEC_TO_ANGLE(CAMERA.PAN,TEMPA);


// SET CAMERA ROLL ANGLES
	C1.X = TEMPA.Y;
	C1.Y = -TEMPA.X;
	C1.Z = 0;

	C2.X = -CAMERA_SPOT.Y;
	C2.Y = CAMERA_SPOT.X;
	C2.Z = 0;

	VEC_ROTATE(C2,PLAYER_SHIP.PAN);

// GET THE ANGLE DIFFERENCE BETWEEN BOTH VECTORS USING DOT PRODUCT
	TEMPA = C1.X*C2.X +C1.Y*C2.Y;
	tempa /= VEC_LENGTH(C1);
	tempa /= VEC_LENGTH(C2);

	IF (C2.Z < 0) 
		{CAMERA.ROLL = ACOS(TEMPA);}
	ELSE
		{CAMERA.ROLL = -ACOS(TEMPA);}
	
	RETURN;

//Cockpit Camera starts here
COCKPIT:
	CAMERA.GENIUS = PLAYER_SHIP;		// Camera won't see parts the ship
	CHECK_PANEL.POS_Y = 34;		// Move Check Mark to this camera mode
	VEC_SET(CAMERA.X,PLAYER_SHIP.X);	// Camera is where the ship is
	VEC_SET(CAMERA.PAN,PLAYER_SHIP.PAN);	// Camera looks in the same direction as ship
	RETURN;

//Stationary Camera Starts here
STATIONARY:
	CAMERA.GENIUS = NULL;			// Camera won't ignore anyone
	CHECK_PANEL.POS_Y = 52;		// Move Check Mark to this camera mode
	VEC_SET(CAMERA_WORK,PLAYER_SHIP.X);	// Point Camera at player
	VEC_SUB(CAMERA_WORK,CAMERA.X);
	VEC_TO_ANGLE(CAMERA.PAN,CAMERA_WORK); // now camera looks at the player
	RETURN;
}


//////////////////// Key Definitions /////////////////////////////////
ON_F1 = TOGGLE_PANELS; 	// Turn Panels Invisible or Visible
ON_ESC = NULL;			// Turn off prefab menu
/////////////  SPACE SCRIPT ENDSHERE //////////////////////