path "D:\\BIN\\GSTUDIO6\\template";	// Path to WDL templates subdirectory

include <movement.wdl>;

var video_mode = 6;	 // screen size 640x480
var video_depth = 16; // 16 bit colour D3D mode
var star_size=1;

string level_str=<galaxy.wmb>;

bmap star=<star.bmp>;
bmap star2=<star2.bmp>;

define r, skill1;
define s, skill2;
define w, skill3;
define arm_count,skill4;
define central_stars_radius,skill5;
define arm_number,skill6;
define stars_per_arm, skill7;
define arm_randomness, skill8;
define parameter,skill_a;
define extra,skill_b;
define tmp_variable, skill10;

function main()
{
	level_load(level_str);
}

function make_me_look_good()
{
	if(random(1)<0.1)
	{
		me.bmap=star;
	}
	else
	{
		me.bmap=star2;
	}
	me.transparent=on;
	me.alpha=60;
	me.size=star_size;
}

function glow()
{
	me.lifespan=10;
}

function central_star()
{
	//Make it look like a star
	make_me_look_good();
	//Give it a random position within the central area
	temp.x=random(1)-0.5;
	temp.y=random(1)-0.5;
	temp.z=random(1)-0.5;
	vec_normalize(temp,you.central_stars_radius);
	vec_scale(temp,random(1));
	vec_set(me.skill_a,temp);
	vec_add(me.x,temp);
	me.function=glow;
}

function rotate()
{
	me.x=fsin(me.extra+you.w*total_ticks, you.r*me.parameter)+you.x;
	me.y=fcos(me.extra+you.w*total_ticks, you.r*me.parameter)+you.y;
	me.lifespan=10;
}	

function arm()
{
	//Make it look like a star
	make_me_look_good();
	//Give it a random position within the arm
	me.parameter=random(10);
	me.extra=you.s*me.parameter + (you.arm_number*360)/you.arm_count + random(2*you.arm_randomness);
	me.x+=fsin(me.extra, you.r*me.parameter);
	me.y+=fcos(me.extra, you.r*me.parameter);
	me.z+=random(you.arm_randomness)-you.arm_randomness/2;
	me.function=rotate;
}
	
action galaxy_here()
{
	me.invisible=on;
	//Set parameters
	me.r=10;
	me.s=10;
	me.w=1;
	me.arm_count=5;
	me.stars_per_arm=500;
	me.central_stars_radius=30;
	me.arm_randomness=20;
	//Create fifty	central stars
	effect(central_star,100,me.x,nullvector);
	//Create stars for each of me.arm_count number of arms
	me.arm_number=0;
	while(me.arm_number<me.arm_count)
	{
		effect(arm,me.stars_per_arm,me.x,nullvector);
		me.arm_number+=1;
		wait(1);
	}
}