path "D:\\BIN\\GSTUDIO6\\template";	// Path to WDL templates subdirectory

include <movement.wdl>;

var video_mode = 6;	 // screen size 640x480
var video_depth = 16; // 16 bit colour D3D mode
var speed=2;
var fire_fade_speed=15;			//Use variables, because it is easier to change it

string level_str=<pentagram.wmb>;
string pentagram_picture=<pentagram.bmp>;
string mystic_symbol=<mystic_symbol.bmp>;

bmap fire_blue=<fire_blue.bmp>;	//Note: do not use string

function main()
{
	level_load(level_str);
}

function make_me_look_good()
{
	me.oriented=on;
	me.bright=on;
	me.transparent=on;
	me.unlit=on;
	me.ambient=100;
	me.alpha=100;
}

define pentagram_radius,skill1;
define mini_pentagram_number, skill1;
var tmp_pentagram_number;
var tmp_pentagram_scaling;

function follow()
{
	make_me_look_good();
	me.ambient=10;
	me.alpha=15;
	vec_scale(me.scale_x,0.4);
	me.oriented=off;
	me.z+=60;
	while(1)
	{
		me.x=you.x;
		me.y=you.y;
		wait(1);
	}
}

function sign()
{
	make_me_look_good();
	vec_set(me.scale_x,you.scale_x);		//Set the scaling the same
	vec_scale(me.scale_x,.7);
	me.z+=120;
	me.tilt=90;
	while(1)
	{
		me.x=you.x;
		me.y=you.y;
		me.roll+=time*speed;
		wait(1);
	}	
}

var random_size=10;

function randomize_my_position()
{
	me.x+=random(random_size)-random_size/2;
	me.y+=random(random_size)-random_size/2;
	me.vel_z=random(3)+3;
}

function fade_fire
{
	me.alpha-=fire_fade_speed*time*random(2);
	if(me.alpha<0) 
	{
		me.lifespan=0;
	}
}

function unholy_fire
{
	my.bmap=fire_blue;		//Set the picture --> defined above
	my.alpha=random(70)+20;	//Alpha=how transparent somehing is
	my.transparent=on;		//Transparent=whether to use the alpha value
	my.move=on;					//Important! if you dont set this, it stays in mid air
	my.flare=on;				//The particles will add up
	my.bright=on;				
	randomize_my_position();
	my.function=fade_fire;	//Allows you to change the function
	//This Function run every frame (i think)
	//Note: if you are going to give it no function, set my.function=null
}

function rotate_mini_pentagram()
{
	make_me_look_good();
	me.tilt=90;
	vec_set(me.scale_x,you.scale_x);		//Set the scaling the same
	vec_scale(me.scale_x,tmp_pentagram_scaling);		//shrink the scaling 
	me.mini_pentagram_number=tmp_pentagram_number;
	ent_create("pentagram.bmp",me.x,sign);
	me.parent=you;
	ent_create(mystic_symbol,me.x,follow);
	while(1)
	{
		me.x=fsin(you.roll+me.mini_pentagram_number*72+20,you.pentagram_radius)+you.x;
		me.y=fcos(you.roll+me.mini_pentagram_number*72+20,you.pentagram_radius)+you.y;
		effect(unholy_fire,20*time,me.x,vector(0,0,2));	
		me.roll+=time*speed;
		wait(1);

	}
}

function create_mini_pentagram()
{
	tmp_pentagram_scaling=.3;
	tmp_pentagram_number=1;
	while(tmp_pentagram_number<=5)
	{
		ent_create("pentagram.bmp",me.x,rotate_mini_pentagram);
		tmp_pentagram_number+=1;
	}
}

action pentagram()
{
	make_me_look_good();
	create_mini_pentagram();
	me.pentagram_radius=(me.max_x-me.min_x)*(me.scale_x)*2;
	while(1)
	{
		me.roll+=time*speed;
		wait(1);
	}
}