path "D:\\BIN\\GSTUDIO6\\template";	// Path to WDL templates subdirectory

include <movement.wdl>;

var video_mode = 6;	 // screen size 640x480
var video_depth = 16; // 16 bit colour D3D mode
var sun_particle_size=20;

string level_str=<star.wmb>;
string flare=<flare.bmp>;

bmap star=<star.bmp>;

define number_particles_for_sun, skill1;
define max_r, skill2;
define sun_drift_factor,skill3;
define sleep_between_prominences, skill8;
define length_of_prominence,skill14;
define current_prominence,skill15;
define prominence_a1, skill4;
define prominence_a2, skill5;
define prominence_b1, skill6;
define prominence_b2, skill7;
define c1_a,skill8;
define c2_a,skill9;
define c3_a,skill10;
define c1_b,skill11;
define c2_b,skill12;
define c3_b,skill13;

define a, skill_a;
define b, skill_b;
define r, skill_d;
define random_particle_drift, skill_c;
define particle_current_time, skill_c;
define max_prominence_r,skill_x;
define random_particle_a, skill_y;
define random_particle_b, skill_z;

function main()
{
	level_load(level_str);
}

function make_me_look_good()
{
	me.bmap=star;
	me.transparent=on;
	me.alpha=10;
	me.size=sun_particle_size;
}

function move_me()
{
	me.x=fsin(me.a, fcos(me.b, me.r))+you.x;
	me.y=fcos(me.a, fcos(me.b, me.r))+you.y;
	me.z=fsin(me.b, me.r)+you.z;
}

function sun2()
{
	me.a+=me.random_particle_drift;
	me.b+=me.random_particle_drift;
	move_me();
	me.lifespan=10;	
}

function sun()
{
	//Makes the particle look right
	make_me_look_good();
	//Randomly set the position parameters of the particle
	me.a=random(360);
	me.b=random(360);
	me.r=you.max_r;
	me.random_particle_drift=random(you.sun_drift_factor)+0.1;
	//Move the particle to the right position
	move_me();
	me.function=sun2;
}	

function sun_center()
{
	//Makes the particle look right
	make_me_look_good();
	//Randomly set the position parameters of the particle
	me.a=random(360);
	me.b=random(360);
	//Difference from the normal sun particle: it is given a 
	// random radius, instead of a fixed radius at the outside of
	// the sun.
	me.r=random(you.max_r);
	me.random_particle_drift=random(you.sun_drift_factor)+0.1;
	//Move the particle to the right position
	move_me();
	me.function=sun2;
}

function interpolate_position()
{
	me.a=fcos(you.c2_a*me.particle_current_time, you.c1_a)+you.c3_a+me.random_particle_a;
	me.b=fcos(you.c2_b*me.particle_current_time, you.c1_b)+you.c3_b+me.random_particle_b;
	me.r=fsin(you.c2_a*me.particle_current_time, me.max_prominence_r)+you.max_r;
}
	
function prominence2()
{
	me.particle_current_time+=time;
	interpolate_position();
	move_me();
	if(me.particle_current_time>you.current_prominence)
	{
		me.lifespan=0;
	}
	else
	{
		me.lifespan=10;
	}
}

function prominence()
{
	make_me_look_good();
	me.size=3;
	me.random_particle_a=random(20)-10;
	me.random_particle_b=random(20)-10;
	me.max_prominence_r=random(10)+20;
	me.particle_current_time=0;
	me.function=prominence2;
}

function generate_prominence_location()
{
	//Chose how long the prominence will last
	me.current_prominence=200;
	//me.current_prominence=random(me.length_of_prominence)+1;
	//Chose random position to start and end prominence
	//Starting position
	me.prominence_a1=random(360);
	me.prominence_a2=random(180);
	me.c1_a=(me.prominence_a1-me.prominence_a2)/2;
	me.c2_a=180/me.current_prominence;
	me.c3_a=(me.prominence_a1+me.prominence_a2)/2;
	
	//Ending position
	me.prominence_b1=random(360);
	me.prominence_b2=random(180);		
	me.c1_b=(me.prominence_b1-me.prominence_b2)/2;
	me.c2_b=me.c2_a;
	me.c3_b=(me.prominence_b1+me.prominence_b2)/2;
}

function sun_flare()
{
	me.transparent=on;
	me.alpha=20;
	vec_scale(me.scale_x,0.8);
	vec_set(me.x,you.x);
}

function sun_flare2()
{
	me.transparent=on;
	me.alpha=20;
	vec_scale(me.scale_x,1);
	vec_set(me.x,you.x);
}

action sun_here()
{
	me.invisible=on;
	randomize();
	//Set parameters
	me.number_particles_for_sun=300;
	me.max_r=20;
	me.sun_drift_factor=0.5;
	me.sleep_between_prominences=10;
	me.length_of_prominence=200;
	//Create the sun
	effect(sun_center,5,me.x,nullvector);
	effect(sun,me.number_particles_for_sun,me.x,nullvector);
	//Create a flare around the sun
	ent_create("flare.bmp",me.x,sun_flare);
	ent_create("flare.bmp",me.x,sun_flare2);
	while(1)
	{
		generate_prominence_location();
		//Create particles
		var number_prominence=400;
		//number_prominence+=random(100);
		while(number_prominence>0)
		{
			number_prominence-=1;
			effect(prominence,5,me.x,nullvector);
			wait(1);
		}
		//Sleep for a random period of time
		sleep(10);
	}
}